/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.cli;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.javascript.nodejs.CompletionModuleInfo;
import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.javascript.nodejs.interpreter.NodeCommandLineConfigurator;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.lang.javascript.service.JSLanguageServiceUtil;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.text.SemVer;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.angular2.cli.BlueprintParser;
import org.angular2.cli.Schematic;
import org.angular2.cli.SchematicsJsonParser;
import org.angular2.lang.expr.Angular2Language;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000@\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a,\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u0002\u001a \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0002\u001a \u0010\u0012\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0002\u001a\u001a\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u000fH\u0002\u001a\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u000fH\u0002\"\u0014\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0010\u0010\u0019\u001a\u00020\u000f8\u0006X\u0087T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"myLogErrors", "Ljava/lang/ThreadLocal;", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "doLoad", "", "Lorg/angular2/cli/Schematic;", "project", "Lcom/intellij/openapi/project/Project;", "cli", "Lcom/intellij/openapi/vfs/VirtualFile;", "includeHidden", "logErrors", "loadSchematicsInfoJson", "", "configurator", "Lcom/intellij/javascript/nodejs/interpreter/NodeCommandLineConfigurator;", "loadBlueprintHelpOutput", "grabCommandOutput", "commandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "workingDir", "shortenOutput", "output", "DEFAULT_OUTPUT", "intellij.angular"})
@SourceDebugExtension(value={"SMAP\nSchematicsLoader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SchematicsLoader.kt\norg/angular2/cli/SchematicsLoaderKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,237:1\n1056#2:238\n*S KotlinDebug\n*F\n+ 1 SchematicsLoader.kt\norg/angular2/cli/SchematicsLoaderKt\n*L\n65#1:238\n*E\n"})
public final class SchematicsLoaderKt {
    @NotNull
    private static ThreadLocal<Boolean> myLogErrors;
    @NotNull
    private static final Logger LOG;
    @ApiStatus.Internal
    @NotNull
    public static final String DEFAULT_OUTPUT = "\n\n  Available blueprints:\n    class <name> <options...>\n      --spec (Boolean) Specifies if a spec file is generated.\n        aliases: -spec\n      --app (String) Specifies app name to use.\n        aliases: -a <value>, -app <value>\n    component <name> <options...>\n      --flat (Boolean) Flag to indicate if a dir is created.\n        aliases: -flat\n      --inline-template (Boolean) Specifies if the template will be in the ts file.\n        aliases: -it, --inlineTemplate\n      --inline-style (Boolean) Specifies if the style will be in the ts file.\n        aliases: -is, --inlineStyle\n      --prefix (String) (Default: null) Specifies whether to use the prefix.\n        aliases: --prefix <value>\n      --spec (Boolean) Specifies if a spec file is generated.\n        aliases: -spec\n      --view-encapsulation (String) Specifies the view encapsulation strategy.\n        aliases: -ve <value>, --viewEncapsulation <value>\n      --change-detection (String) Specifies the change detection strategy.\n        aliases: -cd <value>, --changeDetection <value>\n      --skip-import (Boolean) (Default: false) Allows for skipping the module import.\n        aliases: --skipImport\n      --module (String) Allows specification of the declaring module.\n        aliases: -m <value>, --module <value>\n      --export (Boolean) (Default: false) Specifies if declaring module exports the component.\n        aliases: --export\n      --app (String) Specifies app name to use.\n        aliases: -a <value>, -app <value>\n    directive <name> <options...>\n      --flat (Boolean) Flag to indicate if a dir is created.\n        aliases: -flat\n      --prefix (String) (Default: null) Specifies whether to use the prefix.\n        aliases: --prefix <value>\n      --spec (Boolean) Specifies if a spec file is generated.\n        aliases: -spec\n      --skip-import (Boolean) (Default: false) Allows for skipping the module import.\n        aliases: --skipImport\n      --module (String) Allows specification of the declaring module.\n        aliases: -m <value>, --module <value>\n      --export (Boolean) (Default: false) Specifies if declaring module exports the component.\n        aliases: --export\n      --app (String) Specifies app name to use.\n        aliases: -a <value>, -app <value>\n    enum <name> <options...>\n      --app (String) Specifies app name to use.\n        aliases: -a <value>, -app <value>\n    guard <name> <options...>\n      --flat (Boolean) Indicate if a dir is created.\n        aliases: -flat\n      --spec (Boolean) Specifies if a spec file is generated.\n        aliases: -spec\n      --module (String) Allows specification of the declaring module.\n        aliases: -m <value>, --module <value>\n    interface <interface-type> <options...>\n      --app (String) Specifies app name to use.\n        aliases: -a <value>, -app <value>\n    module <name> <options...>\n      --spec (Boolean) Specifies if a spec file is generated.\n        aliases: -spec\n      --flat (Boolean) Flag to indicate if a dir is created.\n        aliases: -flat\n      --routing (Boolean) (Default: false) Specifies if a routing module file should be generated.\n        aliases: --routing\n      --app (String) Specifies app name to use.\n        aliases: -a <value>, -app <value>\n    pipe <name> <options...>\n      --flat (Boolean) Flag to indicate if a dir is created.\n        aliases: -flat\n      --spec (Boolean) Specifies if a spec file is generated.\n        aliases: -spec\n      --skip-import (Boolean) (Default: false) Allows for skipping the module import.\n        aliases: --skipImport\n      --module (String) Allows specification of the declaring module.\n        aliases: -m <value>, --module <value>\n      --export (Boolean) (Default: false) Specifies if declaring module exports the pipe.\n        aliases: --export\n      --app (String) Specifies app name to use.\n        aliases: -a <value>, -app <value>\n    service <name> <options...>\n      --flat (Boolean) Flag to indicate if a dir is created.\n        aliases: -flat\n      --spec (Boolean) Specifies if a spec file is generated.\n        aliases: -spec\n      --module (String) Allows specification of the declaring module.\n        aliases: -m <value>, --module <value>\n      --app (String) Specifies app name to use.\n        aliases: -a <value>, -app <value>\n\nng generate <blueprint> <options...>\n  Generates new code from blueprints.\n  aliases: g\n  --dry-run (Boolean) (Default: false) Run through without making any changes.\n    aliases: -d, --dryRun\n  --verbose (Boolean) (Default: false) Adds more details to output logging.\n    aliases: -v, --verbose\n\n    ";

    @NotNull
    public static final List<Schematic> doLoad(@NotNull Project project, @NotNull VirtualFile cli, boolean includeHidden, boolean logErrors) {
        String blueprintHelpOutput;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)cli, (String)"cli");
        myLogErrors.set(logErrors);
        NodeJsInterpreter nodeJsInterpreter = NodeJsInterpreterManager.getInstance((Project)project).getInterpreter();
        if (nodeJsInterpreter == null) {
            return CollectionsKt.emptyList();
        }
        NodeJsInterpreter interpreter = nodeJsInterpreter;
        NodeCommandLineConfigurator configurator = null;
        try {
            NodeCommandLineConfigurator nodeCommandLineConfigurator = NodeCommandLineConfigurator.find((NodeJsInterpreter)interpreter);
            Intrinsics.checkNotNullExpressionValue((Object)nodeCommandLineConfigurator, (String)"find(...)");
            configurator = nodeCommandLineConfigurator;
        }
        catch (Exception e) {
            LOG.error("Cannot load schematics", (Throwable)e);
            return CollectionsKt.emptyList();
        }
        Collection<Schematic> parse2 = CollectionsKt.emptyList();
        String schematicsInfoJson = SchematicsLoaderKt.loadSchematicsInfoJson(configurator, cli, includeHidden);
        if (((CharSequence)schematicsInfoJson).length() > 0 && !StringsKt.startsWith$default((String)schematicsInfoJson, (String)"No schematics", (boolean)false, (int)2, null)) {
            try {
                parse2 = (Collection<Schematic>)SchematicsJsonParser.INSTANCE.parse(schematicsInfoJson);
            }
            catch (Exception e) {
                Attachment[] attachmentArray = new Attachment[]{new Attachment("output", schematicsInfoJson)};
                LOG.error("Failed to parse schematics: " + e.getMessage(), (Throwable)e, attachmentArray);
            }
        }
        if (parse2.isEmpty() && ((CharSequence)(blueprintHelpOutput = SchematicsLoaderKt.loadBlueprintHelpOutput(project, configurator, cli))).length() > 0) {
            try {
                parse2 = new BlueprintParser().parse(blueprintHelpOutput);
            }
            catch (Exception e) {
                Attachment[] attachmentArray = new Attachment[]{new Attachment("output", blueprintHelpOutput)};
                LOG.error("Failed to parse blueprints: " + e.getMessage(), (Throwable)e, attachmentArray);
            }
        }
        if (parse2.isEmpty()) {
            parse2 = new BlueprintParser().parse(DEFAULT_OUTPUT);
        }
        Iterable $this$sortedBy$iv = parse2;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Schematic it = (Schematic)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getName());
                it = (Schematic)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
            }
        });
    }

    private static final String loadSchematicsInfoJson(NodeCommandLineConfigurator configurator, VirtualFile cli, boolean includeHidden) {
        File directory = JSLanguageServiceUtil.getPluginDirectory(Angular2Language.class, (String)"ngCli");
        String utilityExe = directory + File.separator + "runner.js";
        String[] stringArray = new String[]{"", utilityExe, cli.getPath(), "./schematicsInfoProvider.js"};
        GeneralCommandLine commandLine = new GeneralCommandLine(stringArray);
        if (includeHidden) {
            commandLine.addParameter("--includeHidden");
        }
        configurator.configure(commandLine);
        return SchematicsLoaderKt.grabCommandOutput(commandLine, cli.getPath());
    }

    private static final String loadBlueprintHelpOutput(Project project, NodeCommandLineConfigurator configurator, VirtualFile cli) {
        GeneralCommandLine generalCommandLine;
        boolean isGt14;
        List modules = new ArrayList();
        NodeModuleSearchUtil.findModulesWithName((List)modules, (String)"@angular/cli", (VirtualFile)cli, null);
        CompletionModuleInfo completionModuleInfo = (CompletionModuleInfo)CollectionsKt.firstOrNull((List)modules);
        if (completionModuleInfo == null) {
            return "";
        }
        CompletionModuleInfo module = completionModuleInfo;
        VirtualFile virtualFile = module.getVirtualFile();
        Intrinsics.checkNotNull((Object)virtualFile);
        String string = virtualFile.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        String modulePath = string;
        String moduleExe = modulePath + File.separator + "bin" + File.separator + "ng";
        SemVer semVer = new NodePackage(modulePath).getVersion(project);
        boolean bl = isGt14 = semVer != null ? semVer.isGreaterOrEqualThan(14, 0, 0) : false;
        if (isGt14) {
            var9_8 = new String[]{"", moduleExe, "generate", "--help"};
            GeneralCommandLine generalCommandLine2 = new GeneralCommandLine(var9_8);
            generalCommandLine = generalCommandLine2;
        } else {
            var9_8 = new String[]{"", moduleExe, "help", "generate"};
            GeneralCommandLine generalCommandLine3 = new GeneralCommandLine(var9_8);
            generalCommandLine = generalCommandLine3;
        }
        GeneralCommandLine commandLine = generalCommandLine;
        configurator.configure(commandLine);
        return SchematicsLoaderKt.grabCommandOutput(commandLine, cli.getPath());
    }

    private static final String grabCommandOutput(GeneralCommandLine commandLine, String workingDir) {
        if (workingDir != null) {
            commandLine.withWorkDirectory(workingDir);
        }
        CapturingProcessHandler handler = new CapturingProcessHandler(commandLine);
        ProcessOutput processOutput = handler.runProcess();
        Intrinsics.checkNotNullExpressionValue((Object)processOutput, (String)"runProcess(...)");
        ProcessOutput output = processOutput;
        if (output.getExitCode() == 0) {
            String string = output.getStderr();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStderr(...)");
            if (((CharSequence)((Object)StringsKt.trim((CharSequence)string)).toString()).length() > 0) {
                if (myLogErrors.get().booleanValue()) {
                    String string2 = output.getStderr();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getStderr(...)");
                    Attachment[] attachmentArray = new Attachment[]{new Attachment("err-output", output.getStderr())};
                    LOG.error("Error while loading schematics info.\n" + SchematicsLoaderKt.shortenOutput(string2), attachmentArray);
                } else {
                    String string3 = output.getStderr();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getStderr(...)");
                    LOG.info("Error while loading schematics info.\n" + SchematicsLoaderKt.shortenOutput(string3));
                }
            }
            String string4 = output.getStdout();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getStdout(...)");
            return string4;
        }
        if (myLogErrors.get().booleanValue()) {
            String string = output.getStderr();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStderr(...)");
            Attachment[] attachmentArray = new Attachment[]{new Attachment("err-output", output.getStderr()), new Attachment("std-output", output.getStdout())};
            LOG.error("Failed to load schematics info.\n" + SchematicsLoaderKt.shortenOutput(string), attachmentArray);
        } else {
            String string = output.getStderr();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStderr(...)");
            LOG.info("Error while loading schematics info.\n" + SchematicsLoaderKt.shortenOutput(string));
        }
        return "";
    }

    private static final String shortenOutput(String output) {
        CharSequence charSequence = StringsKt.replace$default((String)output, (char)'\\', (char)'/', (boolean)false, (int)4, null);
        Regex regex = new Regex("(/[^()/:]+)+(/[^()/:]+)(/[^()/:]+)");
        String string = "/...$1$2$3";
        String string2 = StringUtil.shortenTextWithEllipsis((String)regex.replace(charSequence, string), (int)750, (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"shortenTextWithEllipsis(...)");
        return string2;
    }

    private static final Boolean myLogErrors$lambda$0() {
        return true;
    }

    static {
        ThreadLocal<Boolean> threadLocal = ThreadLocal.withInitial(SchematicsLoaderKt::myLogErrors$lambda$0);
        Intrinsics.checkNotNullExpressionValue(threadLocal, (String)"withInitial(...)");
        myLogErrors = threadLocal;
        Logger logger = Logger.getInstance((String)"#org.angular2.cli.SchematicsLoader");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

