/*
 * Decompiled with CFR 0.152.
 */
package org.jrubyparser.ast;

import java.util.List;
import org.jrubyparser.NodeVisitor;
import org.jrubyparser.SourcePosition;
import org.jrubyparser.ast.ILocalVariable;
import org.jrubyparser.ast.IParameter;
import org.jrubyparser.ast.IScope;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgumentNode
extends Node
implements IParameter {
    private String identifier;
    private int location;

    public ArgumentNode(SourcePosition position, String identifier) {
        super(position);
        this.identifier = identifier;
    }

    public ArgumentNode(SourcePosition position, String identifier, int location) {
        super(position);
        this.identifier = identifier;
        this.location = location;
    }

    @Override
    public boolean isSame(Node other) {
        return super.isSame(other) && this.isNameMatch(((ArgumentNode)other).getName());
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.ARGUMENTNODE;
    }

    @Override
    public Object accept(NodeVisitor visitor) {
        return visitor.visitArgumentNode(this);
    }

    public int getDepth() {
        return this.location >> 16;
    }

    public int getIndex() {
        return this.location & 0xFFFF;
    }

    @Override
    public String getLexicalName() {
        return this.getName();
    }

    @Override
    public String getName() {
        return this.identifier;
    }

    @Override
    public void setName(String name) {
        this.identifier = name;
    }

    @Override
    public boolean isNameMatch(String name) {
        String thisName = this.getName();
        return thisName != null && thisName.equals(name);
    }

    @Override
    public IScope getDefinedScope() {
        return this.getClosestIScope();
    }

    @Override
    public List<ILocalVariable> getOccurrences() {
        return this.getDefinedScope().getVariableReferencesNamed(this.getName());
    }

    @Override
    public ILocalVariable getDeclaration() {
        return this;
    }

    @Override
    public SourcePosition getNamePosition() {
        return this.getPosition();
    }

    @Override
    public SourcePosition getLexicalNamePosition() {
        return this.getNamePosition();
    }
}

