/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.geom;

import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.plot.base.Aes;
import org.jetbrains.letsPlot.core.plot.base.Aesthetics;
import org.jetbrains.letsPlot.core.plot.base.CoordinateSystem;
import org.jetbrains.letsPlot.core.plot.base.DataPointAesthetics;
import org.jetbrains.letsPlot.core.plot.base.GeomContext;
import org.jetbrains.letsPlot.core.plot.base.PositionAdjustment;
import org.jetbrains.letsPlot.core.plot.base.geom.GeomBase;
import org.jetbrains.letsPlot.core.plot.base.geom.annotation.Annotation;
import org.jetbrains.letsPlot.core.plot.base.geom.annotation.BarAnnotation;
import org.jetbrains.letsPlot.core.plot.base.geom.util.RectangleTooltipHelper;
import org.jetbrains.letsPlot.core.plot.base.geom.util.RectanglesHelper;
import org.jetbrains.letsPlot.core.plot.base.render.SvgRoot;
import org.jetbrains.letsPlot.datamodel.svg.dom.SvgNode;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u0014\u0010\u000f\u001a\u00020\u00102\n\u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u0012H\u0016\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/BarGeom;", "Lorg/jetbrains/letsPlot/core/plot/base/geom/GeomBase;", "()V", "buildIntern", "", "root", "Lorg/jetbrains/letsPlot/core/plot/base/render/SvgRoot;", "aesthetics", "Lorg/jetbrains/letsPlot/core/plot/base/Aesthetics;", "pos", "Lorg/jetbrains/letsPlot/core/plot/base/PositionAdjustment;", "coord", "Lorg/jetbrains/letsPlot/core/plot/base/CoordinateSystem;", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;", "rangeIncludesZero", "", "aes", "Lorg/jetbrains/letsPlot/core/plot/base/Aes;", "Companion", "plot-base"})
@SourceDebugExtension(value={"SMAP\nBarGeom.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BarGeom.kt\norg/jetbrains/letsPlot/core/plot/base/geom/BarGeom\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,87:1\n1855#2,2:88\n1#3:90\n*S KotlinDebug\n*F\n+ 1 BarGeom.kt\norg/jetbrains/letsPlot/core/plot/base/geom/BarGeom\n*L\n44#1:88,2\n*E\n"})
public class BarGeom
extends GeomBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final boolean HANDLES_GROUPS = false;

    @Override
    public boolean rangeIncludesZero(@NotNull Aes<?> aes2) {
        Intrinsics.checkNotNullParameter(aes2, (String)"aes");
        return Intrinsics.areEqual(aes2, Aes.Companion.getY());
    }

    @Override
    protected void buildIntern(@NotNull SvgRoot root, @NotNull Aesthetics aesthetics2, @NotNull PositionAdjustment pos, @NotNull CoordinateSystem coord, @NotNull GeomContext ctx2) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            Intrinsics.checkNotNullParameter((Object)aesthetics2, (String)"aesthetics");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)coord, (String)"coord");
            Intrinsics.checkNotNullParameter((Object)ctx2, (String)"ctx");
            RectanglesHelper helper2 = new RectanglesHelper(aesthetics2, pos, coord, ctx2, (Function1<? super DataPointAesthetics, DoubleRectangle>)BarGeom.Companion.visualRectByDataPoint(ctx2));
            RectangleTooltipHelper tooltipHelper = new RectangleTooltipHelper(pos, coord, ctx2, null, null, null, null, 120, null);
            List rectangles = new ArrayList();
            if (coord.isLinear()) {
                helper2.createRectangles((Function3<? super DataPointAesthetics, ? super SvgNode, ? super DoubleRectangle, Unit>)((Function3)new Function3<DataPointAesthetics, SvgNode, DoubleRectangle, Unit>((List<SvgNode>)rectangles){
                    final /* synthetic */ List<SvgNode> $rectangles;
                    {
                        this.$rectangles = $rectangles;
                        super(3);
                    }

                    public final void invoke(@NotNull DataPointAesthetics dataPointAesthetics, @NotNull SvgNode svgNode, @NotNull DoubleRectangle doubleRectangle) {
                        Intrinsics.checkNotNullParameter((Object)dataPointAesthetics, (String)"<anonymous parameter 0>");
                        Intrinsics.checkNotNullParameter((Object)svgNode, (String)"svgNode");
                        Intrinsics.checkNotNullParameter((Object)doubleRectangle, (String)"<anonymous parameter 2>");
                        this.$rectangles.add(svgNode);
                    }
                }));
                RectanglesHelper hintHelper = new RectanglesHelper(aesthetics2, pos, coord, ctx2, (Function1<? super DataPointAesthetics, DoubleRectangle>)BarGeom.Companion.hintRectByDataPoint(ctx2));
                hintHelper.createRectangles((Function3<? super DataPointAesthetics, ? super SvgNode, ? super DoubleRectangle, Unit>)((Function3)new Function3<DataPointAesthetics, SvgNode, DoubleRectangle, Unit>(tooltipHelper){
                    final /* synthetic */ RectangleTooltipHelper $tooltipHelper;
                    {
                        this.$tooltipHelper = $tooltipHelper;
                        super(3);
                    }

                    public final void invoke(@NotNull DataPointAesthetics aes2, @NotNull SvgNode svgNode, @NotNull DoubleRectangle rect2) {
                        Intrinsics.checkNotNullParameter((Object)aes2, (String)"aes");
                        Intrinsics.checkNotNullParameter((Object)svgNode, (String)"<anonymous parameter 1>");
                        Intrinsics.checkNotNullParameter((Object)rect2, (String)"rect");
                        this.$tooltipHelper.addTarget(aes2, rect2);
                    }
                }));
            } else {
                helper2.createNonLinearRectangles((Function3<? super DataPointAesthetics, ? super SvgNode, ? super List<DoubleVector>, Unit>)((Function3)new Function3<DataPointAesthetics, SvgNode, List<? extends DoubleVector>, Unit>((List<SvgNode>)rectangles, tooltipHelper){
                    final /* synthetic */ List<SvgNode> $rectangles;
                    final /* synthetic */ RectangleTooltipHelper $tooltipHelper;
                    {
                        this.$rectangles = $rectangles;
                        this.$tooltipHelper = $tooltipHelper;
                        super(3);
                    }

                    public final void invoke(@NotNull DataPointAesthetics aes2, @NotNull SvgNode svgNode, @NotNull List<DoubleVector> polygon2) {
                        Intrinsics.checkNotNullParameter((Object)aes2, (String)"aes");
                        Intrinsics.checkNotNullParameter((Object)svgNode, (String)"svgNode");
                        Intrinsics.checkNotNullParameter(polygon2, (String)"polygon");
                        this.$rectangles.add(svgNode);
                        this.$tooltipHelper.addTarget(aes2, polygon2);
                    }
                }));
            }
            CollectionsKt.reverse((List)rectangles);
            Iterable $this$forEach$iv = rectangles;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SvgNode p0 = (SvgNode)element$iv;
                boolean bl = false;
                root.add(p0);
            }
            Annotation annotation = ctx2.getAnnotation();
            if (annotation == null) break block3;
            Annotation it = annotation;
            boolean bl = false;
            BarAnnotation.INSTANCE.build(root, helper2, coord, ctx2);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0005\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00062\u0006\u0010\t\u001a\u00020\nH\u0002J\u001e\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00062\u0006\u0010\t\u001a\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/geom/BarGeom$Companion;", "", "()V", "HANDLES_GROUPS", "", "hintRectByDataPoint", "Lkotlin/Function1;", "Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "ctx", "Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;", "visualRectByDataPoint", "plot-base"})
    public static final class Companion {
        private Companion() {
        }

        private final Function1<DataPointAesthetics, DoubleRectangle> hintRectByDataPoint(GeomContext ctx2) {
            return (Function1)new Function1<DataPointAesthetics, DoubleRectangle>(ctx2){
                final /* synthetic */ GeomContext $ctx;
                {
                    this.$ctx = $ctx;
                    super(1, Intrinsics.Kotlin.class, "factory", "hintRectByDataPoint$factory(Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;)Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", 0);
                }

                @Nullable
                public final DoubleRectangle invoke(@NotNull DataPointAesthetics p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return org.jetbrains.letsPlot.core.plot.base.geom.BarGeom$Companion.access$hintRectByDataPoint$factory(this.$ctx, p0);
                }
            };
        }

        private final Function1<DataPointAesthetics, DoubleRectangle> visualRectByDataPoint(GeomContext ctx2) {
            return (Function1)new Function1<DataPointAesthetics, DoubleRectangle>(ctx2){
                final /* synthetic */ GeomContext $ctx;
                {
                    this.$ctx = $ctx;
                    super(1, Intrinsics.Kotlin.class, "factory", "visualRectByDataPoint$factory$0(Lorg/jetbrains/letsPlot/core/plot/base/GeomContext;Lorg/jetbrains/letsPlot/core/plot/base/DataPointAesthetics;)Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", 0);
                }

                @Nullable
                public final DoubleRectangle invoke(@NotNull DataPointAesthetics p0) {
                    Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                    return org.jetbrains.letsPlot.core.plot.base.geom.BarGeom$Companion.access$visualRectByDataPoint$factory$0(this.$ctx, p0);
                }
            };
        }

        private static final DoubleRectangle hintRectByDataPoint$factory(GeomContext $ctx, DataPointAesthetics p) {
            Triple<Double, Double, Double> triple = p.finiteOrNull(Aes.Companion.getX(), Aes.Companion.getY(), Aes.Companion.getWIDTH());
            if (triple == null) {
                return null;
            }
            Triple<Double, Double, Double> triple2 = triple;
            double x2 = ((Number)triple2.component1()).doubleValue();
            double y2 = ((Number)triple2.component2()).doubleValue();
            double width2 = ((Number)triple2.component3()).doubleValue();
            double w = width2 * $ctx.getResolution(Aes.Companion.getX());
            DoubleVector origin = new DoubleVector(x2 - w / (double)2, y2);
            DoubleVector dimension = new DoubleVector(w, 0.0);
            return new DoubleRectangle(origin, dimension);
        }

        private static final DoubleRectangle visualRectByDataPoint$factory$0(GeomContext $ctx, DataPointAesthetics p) {
            Triple<Double, Double, Double> triple = p.finiteOrNull(Aes.Companion.getX(), Aes.Companion.getY(), Aes.Companion.getWIDTH());
            if (triple == null) {
                return null;
            }
            Triple<Double, Double, Double> triple2 = triple;
            double x2 = ((Number)triple2.component1()).doubleValue();
            double y2 = ((Number)triple2.component2()).doubleValue();
            double width2 = ((Number)triple2.component3()).doubleValue();
            double w = width2 * $ctx.getResolution(Aes.Companion.getX());
            DoubleVector origin = null;
            DoubleVector dimension = null;
            if (y2 >= 0.0) {
                origin = new DoubleVector(x2 - w / (double)2, 0.0);
                dimension = new DoubleVector(w, y2);
            } else {
                origin = new DoubleVector(x2 - w / (double)2, y2);
                dimension = new DoubleVector(w, -y2);
            }
            return new DoubleRectangle(origin, dimension);
        }

        public static final /* synthetic */ DoubleRectangle access$hintRectByDataPoint$factory(GeomContext $ctx, DataPointAesthetics p) {
            return org.jetbrains.letsPlot.core.plot.base.geom.BarGeom$Companion.hintRectByDataPoint$factory($ctx, p);
        }

        public static final /* synthetic */ DoubleRectangle access$visualRectByDataPoint$factory$0(GeomContext $ctx, DataPointAesthetics p) {
            return org.jetbrains.letsPlot.core.plot.base.geom.BarGeom$Companion.visualRectByDataPoint$factory$0($ctx, p);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

