/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.prettierjs;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageDescriptor;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.lang.javascript.linter.JSNpmLinterState;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.xmlb.annotations.OptionTag;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@com.intellij.openapi.components.State(name="PrettierConfiguration", storages={@Storage(value="prettier.xml")})
public final class PrettierConfiguration
implements JSNpmLinterState<PrettierConfiguration>,
PersistentStateComponent<State> {
    @NonNls
    private static final String PACKAGE_PROPERTY = "prettierjs.PrettierConfiguration.Package";
    private static final boolean PRETTIER_ON_SAVE_DEFAULT = false;
    private static final boolean PRETTIER_FORMAT_FILES_OUTSIDE_DEPENDENCY_SCOPE_DEFAULT = true;
    private static final boolean PRETTIER_ON_REFORMAT_DEFAULT = false;
    @NonNls
    private static final String PRETTIER_FILES_PATTERN_DEFAULT = "**/*.{js,ts,jsx,tsx,cjs,cts,mjs,mts,vue,astro}";
    private static final NodePackageDescriptor PKG_DESC = new NodePackageDescriptor("prettier");
    @NotNull
    private static final NodePackage EMPTY_PACKAGE = PKG_DESC.createPackage("");
    @NotNull
    private final Project myProject;
    @NotNull
    private State myState;

    public PrettierConfiguration(@NotNull Project project) {
        if (project == null) {
            PrettierConfiguration.$$$reportNull$$$0(0);
        }
        this.myState = new State();
        this.myProject = project;
    }

    @NotNull
    public static PrettierConfiguration getInstance(@NotNull Project project) {
        if (project == null) {
            PrettierConfiguration.$$$reportNull$$$0(1);
        }
        PrettierConfiguration prettierConfiguration = (PrettierConfiguration)project.getService(PrettierConfiguration.class);
        if (prettierConfiguration == null) {
            PrettierConfiguration.$$$reportNull$$$0(2);
        }
        return prettierConfiguration;
    }

    @NotNull
    public State getState() {
        State state = this.myState;
        if (state == null) {
            PrettierConfiguration.$$$reportNull$$$0(3);
        }
        return state;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            PrettierConfiguration.$$$reportNull$$$0(4);
        }
        this.myState = state;
    }

    @NotNull
    public NodePackageRef getNodePackageRef() {
        NodePackageRef nodePackageRef = NodePackageRef.create((NodePackage)this.getPackage(null));
        if (nodePackageRef == null) {
            PrettierConfiguration.$$$reportNull$$$0(5);
        }
        return nodePackageRef;
    }

    public PrettierConfiguration withLinterPackage(@NotNull NodePackageRef nodePackageRef) {
        if (nodePackageRef == null) {
            PrettierConfiguration.$$$reportNull$$$0(6);
        }
        NodePackage newPackage = nodePackageRef.getConstantPackage();
        assert (newPackage != null) : this.getClass().getSimpleName() + "does not support non-constant package";
        PropertiesComponent.getInstance((Project)this.myProject).setValue(PACKAGE_PROPERTY, newPackage.getSystemDependentPath());
        return this;
    }

    NodePackageRef getPackageRefForPackageFieldBindingInConfigurable() {
        String value = PropertiesComponent.getInstance((Project)this.myProject).getValue(PACKAGE_PROPERTY);
        if (value != null && !value.isBlank()) {
            return NodePackageRef.create((NodePackage)PKG_DESC.createPackage(value));
        }
        return NodePackageRef.create((NodePackage)EMPTY_PACKAGE);
    }

    @NotNull
    public NodePackage getPackage(@Nullable PsiElement context) {
        NodePackage pkg;
        String value;
        if (this.isDisabled()) {
            NodePackage nodePackage = EMPTY_PACKAGE;
            if (nodePackage == null) {
                PrettierConfiguration.$$$reportNull$$$0(7);
            }
            return nodePackage;
        }
        if (this.getConfigurationMode() == ConfigurationMode.MANUAL && (value = PropertiesComponent.getInstance((Project)this.myProject).getValue(PACKAGE_PROPERTY)) != null && !value.isBlank()) {
            NodePackage nodePackage = PKG_DESC.createPackage(value);
            if (nodePackage == null) {
                PrettierConfiguration.$$$reportNull$$$0(8);
            }
            return nodePackage;
        }
        if (context != null && context.getContainingFile() != null && this.isAutomatic()) {
            VirtualFile contextFile = context.getContainingFile().getOriginalFile().getVirtualFile();
            List available = new NodePackageDescriptor("prettier").listAvailable(this.myProject, NodeJsInterpreterManager.getInstance((Project)this.myProject).getInterpreter(), contextFile, false, true);
            if (!available.isEmpty()) {
                NodePackage nodePackage = (NodePackage)available.get(0);
                if (nodePackage == null) {
                    PrettierConfiguration.$$$reportNull$$$0(9);
                }
                return nodePackage;
            }
        }
        if (!((pkg = PKG_DESC.findUnambiguousDependencyPackage(this.myProject)) != null || context != null && this.isAutomatic())) {
            pkg = NodePackage.findDefaultPackage((Project)this.myProject, (String)"prettier", (NodeJsInterpreter)NodeJsInterpreterManager.getInstance((Project)this.myProject).getInterpreter());
        }
        if (pkg != null) {
            if (pkg.isValid(this.myProject)) {
                PropertiesComponent.getInstance((Project)this.myProject).setValue(PACKAGE_PROPERTY, pkg.getSystemDependentPath());
            }
            NodePackage nodePackage = pkg;
            if (nodePackage == null) {
                PrettierConfiguration.$$$reportNull$$$0(10);
            }
            return nodePackage;
        }
        NodePackage nodePackage = EMPTY_PACKAGE;
        if (nodePackage == null) {
            PrettierConfiguration.$$$reportNull$$$0(11);
        }
        return nodePackage;
    }

    public boolean isRunOnSave() {
        return !this.isDisabled() && this.myState.runOnSave;
    }

    public boolean isRunOnReformat() {
        return !this.isDisabled() && (this.isAutomatic() || this.myState.runOnReformat);
    }

    @NotNull
    public String getFilesPattern() {
        String string = this.myState.filesPattern;
        if (string == null) {
            PrettierConfiguration.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    public String getCustomIgnorePath() {
        String string = this.myState.customIgnorePath;
        if (string == null) {
            PrettierConfiguration.$$$reportNull$$$0(13);
        }
        return string;
    }

    public boolean getFormatFilesOutsideDependencyScope() {
        return this.isManual() && this.myState.formatFilesOutsideDependencyScope;
    }

    public boolean getCodeStyleSettingsModifierEnabled() {
        return !this.isDisabled() && this.myState.codeStyleSettingsModifierEnabled;
    }

    public ConfigurationMode getConfigurationMode() {
        ConfigurationMode mode = this.myState.configurationMode;
        if (mode == null) {
            String pkg = PropertiesComponent.getInstance((Project)this.myProject).getValue(PACKAGE_PROPERTY);
            return pkg != null && !pkg.isBlank() ? ConfigurationMode.MANUAL : ConfigurationMode.DISABLED;
        }
        return mode;
    }

    public boolean isDisabled() {
        return this.getConfigurationMode() == ConfigurationMode.DISABLED;
    }

    public boolean isDefaultConfigurationMode() {
        State defaultState = new State();
        return this.myState.configurationMode == defaultState.configurationMode;
    }

    public boolean isAutomatic() {
        return this.getConfigurationMode() == ConfigurationMode.AUTOMATIC;
    }

    private boolean isManual() {
        return this.getConfigurationMode() == ConfigurationMode.MANUAL;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 5, 7, 8, 9, 10, 11, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/prettierjs/PrettierConfiguration";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodePackageRef";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/prettierjs/PrettierConfiguration";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodePackageRef";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackage";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesPattern";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomIgnorePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "withLinterPackage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 5, 7, 8, 9, 10, 11, 12, 13 -> new IllegalStateException(string);
        };
    }

    @ApiStatus.Internal
    public static class State {
        @OptionTag(value="myConfigurationMode")
        @Nullable
        public ConfigurationMode configurationMode = null;
        @OptionTag(value="myRunOnSave")
        public boolean runOnSave = false;
        @OptionTag(value="myRunOnReformat")
        public boolean runOnReformat = false;
        @OptionTag(value="myFilesPattern")
        @NotNull
        public String filesPattern = "**/*.{js,ts,jsx,tsx,cjs,cts,mjs,mts,vue,astro}";
        @NotNull
        public String customIgnorePath = "";
        public boolean formatFilesOutsideDependencyScope = true;
        public boolean codeStyleSettingsModifierEnabled = true;
    }

    @ApiStatus.Internal
    public static enum ConfigurationMode {
        DISABLED,
        AUTOMATIC,
        MANUAL;

    }
}

