/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.spark.generator;

import com.intellij.database.Dbms;
import com.intellij.database.dialects.base.generator.ScriptingContext;
import com.intellij.database.dialects.base.generator.producers.AlterProducerBase;
import com.intellij.database.dialects.base.generator.producers.BaseProducersKt;
import com.intellij.database.dialects.base.generator.producers.CreateProducer;
import com.intellij.database.dialects.base.generator.producers.DropProducer;
import com.intellij.database.dialects.hivebase.generator.HiveBaseScriptGeneratorHelper;
import com.intellij.database.dialects.spark.generator.producers.DatabricksAlterDatabase;
import com.intellij.database.dialects.spark.generator.producers.DatabricksCreateFunction;
import com.intellij.database.dialects.spark.generator.producers.DatabricksDropFunction;
import com.intellij.database.dialects.spark.model.DatabricksDatabase;
import com.intellij.database.dialects.spark.model.DatabricksFunction;
import com.intellij.database.model.ElementAlteration;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001c\u0010\u000f\u001a\u0006\u0012\u0002\b\u00030\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u0011\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u000b\u001a\u00020\f2\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0015"}, d2={"Lcom/intellij/database/dialects/spark/generator/DatabricksScriptGeneratorHelper;", "Lcom/intellij/database/dialects/hivebase/generator/HiveBaseScriptGeneratorHelper;", "<init>", "()V", "supportsCreateIfNotExists", "", "Lcom/intellij/database/model/ObjectKind;", "getSupportsCreateIfNotExists", "()Ljava/util/Set;", "createProducerImpl", "Lcom/intellij/database/dialects/base/generator/producers/CreateProducer;", "context", "Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "element", "Lcom/intellij/database/model/basic/BasicElement;", "createDropProducerImpl", "Lcom/intellij/database/dialects/base/generator/producers/DropProducer;", "createAlterProducerImpl", "Lcom/intellij/database/dialects/base/generator/producers/AlterProducerBase;", "elements", "Lcom/intellij/database/model/ElementAlteration;", "intellij.database.dialects.spark"})
public final class DatabricksScriptGeneratorHelper
extends HiveBaseScriptGeneratorHelper {
    @NotNull
    public static final DatabricksScriptGeneratorHelper INSTANCE = new DatabricksScriptGeneratorHelper();

    private DatabricksScriptGeneratorHelper() {
        Dbms dbms = Dbms.DATABRICKS;
        Intrinsics.checkNotNullExpressionValue((Object)dbms, (String)"DATABRICKS");
        super(dbms);
    }

    @NotNull
    protected Set<ObjectKind> getSupportsCreateIfNotExists() {
        Object[] objectArray = new ObjectKind[]{ObjectKind.SCHEMA, ObjectKind.TABLE, ObjectKind.VIEW, ObjectKind.ROUTINE};
        return SetsKt.setOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public CreateProducer<?> createProducerImpl(@NotNull ScriptingContext context, @NotNull BasicElement element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element instanceof DatabricksFunction ? (CreateProducer)new DatabricksCreateFunction(context, (DatabricksFunction)element) : super.createProducerImpl(context, element);
    }

    @Override
    @NotNull
    public DropProducer<?> createDropProducerImpl(@NotNull ScriptingContext context, @NotNull BasicElement element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return element instanceof DatabricksFunction ? (DropProducer)new DatabricksDropFunction(context, (DatabricksFunction)element) : super.createDropProducerImpl(context, element);
    }

    @Override
    @NotNull
    public AlterProducerBase<?> createAlterProducerImpl(@NotNull ScriptingContext context, @NotNull ElementAlteration<?> elements) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        BasicElement it = elements.getSourceElement();
        boolean bl = false;
        return it instanceof DatabricksDatabase ? (AlterProducerBase)new DatabricksAlterDatabase(context, (ElementAlteration<? extends DatabricksDatabase>)BaseProducersKt.cast(elements, (BasicElement)it)) : super.createAlterProducerImpl(context, elements);
    }
}

