/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.hsql;

import com.intellij.database.console.ExecutionEnvironmentHelper;
import com.intellij.database.dataSource.DatabaseConnectionCore;
import com.intellij.database.dataSource.connection.statements.Configuration;
import com.intellij.database.dataSource.connection.statements.SmartStatementFactoryService;
import com.intellij.database.dataSource.connection.statements.SmartStatementSource;
import com.intellij.database.dialects.base.BaseExecutionEnvironmentHelper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.psi.SqlElement;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public final class HsqlExecutionEnvironmentHelper
extends BaseExecutionEnvironmentHelper {
    @NotNull
    protected String generateSelectStatement(@NotNull String text, @NotNull SqlElement sqlElement) {
        if (text == null) {
            HsqlExecutionEnvironmentHelper.$$$reportNull$$$0(0);
        }
        if (sqlElement == null) {
            HsqlExecutionEnvironmentHelper.$$$reportNull$$$0(1);
        }
        String string = String.format("VALUES %s", text);
        if (string == null) {
            HsqlExecutionEnvironmentHelper.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public ExecutionEnvironmentHelper.TimeZoneManager getTimeZoneManager() {
        ExecutionEnvironmentHelper.TimeZoneManager timeZoneManager = HsqlTimeZoneManager.INSTANCE;
        if (timeZoneManager == null) {
            HsqlExecutionEnvironmentHelper.$$$reportNull$$$0(3);
        }
        return timeZoneManager;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqlElement";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dialects/hsql/HsqlExecutionEnvironmentHelper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dialects/hsql/HsqlExecutionEnvironmentHelper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "generateSelectStatement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getTimeZoneManager";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "generateSelectStatement";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3 -> new IllegalStateException(string);
        };
    }

    private static class HsqlTimeZoneManager
    implements ExecutionEnvironmentHelper.TimeZoneManager {
        static final ExecutionEnvironmentHelper.TimeZoneManager INSTANCE = new HsqlTimeZoneManager();
        private static final String INTERVAL_STATEMENT = "set time zone interval '%s' hour to minute;";
        private static final String LOCAL_STATEMENT = "set time zone local";

        private HsqlTimeZoneManager() {
        }

        public boolean canChange() {
            return true;
        }

        public Collection<String> getAvailableTimeZones() {
            return Arrays.asList("UTC", "Local");
        }

        public void changeTimeZone(@NotNull DatabaseConnectionCore connection2, @NotNull String timeZone) {
            String converted;
            if (connection2 == null) {
                HsqlTimeZoneManager.$$$reportNull$$$0(0);
            }
            if (timeZone == null) {
                HsqlTimeZoneManager.$$$reportNull$$$0(1);
            }
            String input = StringUtil.equalsIgnoreCase((CharSequence)(converted = HsqlTimeZoneManager.convertTimeZone(timeZone)), (CharSequence)"local") ? LOCAL_STATEMENT : String.format(INTERVAL_STATEMENT, timeZone);
            SmartStatementFactoryService.getInstance().poweredBy(connection2).simple(Configuration.sourced((SmartStatementSource)SmartStatementSource.SYSTEM)).barren().quiet().execute((Object)input);
        }

        @NotNull
        private static String convertTimeZone(@NotNull String timeZone) {
            String trimmed;
            if (timeZone == null) {
                HsqlTimeZoneManager.$$$reportNull$$$0(2);
            }
            String string = StringUtil.equalsIgnoreCase((CharSequence)(trimmed = timeZone.trim()), (CharSequence)"UTC") ? "+00:00" : trimmed;
            if (string == null) {
                HsqlTimeZoneManager.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "connection";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "timeZone";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/dialects/hsql/HsqlExecutionEnvironmentHelper$HsqlTimeZoneManager";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/dialects/hsql/HsqlExecutionEnvironmentHelper$HsqlTimeZoneManager";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "convertTimeZone";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "changeTimeZone";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "convertTimeZone";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3 -> new IllegalStateException(string);
            };
        }
    }
}

