/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport.editor.editor;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.url.FieldSize;
import com.intellij.database.dbimport.editor.data.CsvSourceData;
import com.intellij.database.dbimport.editor.data.DataSourceData;
import com.intellij.database.dbimport.editor.data.DbTableSourceData;
import com.intellij.database.dbimport.editor.data.DetectedColumnsData;
import com.intellij.database.dbimport.editor.editor.DbTreeSelectorPopup;
import com.intellij.database.dbimport.editor.editor.HoverColoredRenderer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.RawDataSource;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.meta.BasicMetaId;
import com.intellij.database.model.meta.BasicMetaObject;
import com.intellij.database.schemaEditor.ElementIdentity;
import com.intellij.database.schemaEditor.ElementOwner;
import com.intellij.database.schemaEditor.MultiElementIdentity;
import com.intellij.database.schemaEditor.model.DbEditorModel;
import com.intellij.database.schemaEditor.model.DbEditorModelController;
import com.intellij.database.schemaEditor.model.DbModelRef;
import com.intellij.database.schemaEditor.model.applier.DbDirectReferenceModelApplier;
import com.intellij.database.schemaEditor.model.applier.DbReferenceModelApplier;
import com.intellij.database.schemaEditor.model.state.DbDirectReferenceModelState;
import com.intellij.database.schemaEditor.model.state.DbStructureObjectModelState;
import com.intellij.database.schemaEditor.ui.DbEditor;
import com.intellij.database.schemaEditor.ui.DbEditorController;
import com.intellij.database.schemaEditor.ui.DbEditorListener;
import com.intellij.database.schemaEditor.ui.DbStructureEditor;
import com.intellij.database.schemaEditor.ui.DbVisualEditorBase;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.awt.RelativePoint;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbCrossDsReferenceEditor<E extends BasicElement, T extends BasicElement, S extends DbDirectReferenceModelState<T>>
extends DbVisualEditorBase<E, S> {
    protected final JComponent myComponent;
    protected final HoverColoredRenderer myRenderer;
    @Nullable
    protected ElementIdentity<T> mySelected;
    protected boolean myInconsistent;

    public DbCrossDsReferenceEditor(@NotNull DbEditorController controller, @NotNull DbModelRef<E, S> model) {
        if (controller == null) {
            DbCrossDsReferenceEditor.$$$reportNull$$$0(0);
        }
        if (model == null) {
            DbCrossDsReferenceEditor.$$$reportNull$$$0(1);
        }
        super(controller, model);
        this.myComponent = new JPanel(new BorderLayout());
        this.myRenderer = new HoverColoredRenderer();
        this.myRenderer.getComponent().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DbCrossDsReferenceEditor.this.createChooser().show(new RelativePoint(e));
            }
        });
        this.myComponent.add((Component)this.myRenderer.getComponent(), "Center");
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("toolbar", (ActionGroup)this.getToolbarAction(), true);
        toolbar.setTargetComponent(this.myComponent);
        toolbar.setReservePlaceAutoPopupIcon(false);
        this.myComponent.add((Component)toolbar.getComponent(), "East");
        this.onTableUpdated();
    }

    @Override
    @Nullable
    protected DbEditorListener createEditorListener() {
        return new DbEditorListener(){

            @Override
            public void created(@NotNull DbEditor<?, ?> editor2) {
                if (editor2 == null) {
                    2.$$$reportNull$$$0(0);
                }
                DbCrossDsReferenceEditor.this.tableCheckedUpdate(editor2);
            }

            @Override
            public void removed(@NotNull DbEditor<?, ?> editor2) {
                if (editor2 == null) {
                    2.$$$reportNull$$$0(1);
                }
                DbCrossDsReferenceEditor.this.tableCheckedUpdate(editor2);
            }

            @Override
            public void modified(@NotNull DbEditor<?, ?> editor2) {
                if (editor2 == null) {
                    2.$$$reportNull$$$0(2);
                }
                DbCrossDsReferenceEditor.this.tableCheckedUpdate(editor2);
                BasicMetaId key = editor2.getModelInternalKey();
                if (key != DetectedColumnsData.COLUMNS && key != CsvSourceData.PATH && key != DbTableSourceData.TABLE_REF) {
                    return;
                }
                if (editor2.getIdentity() != DbCrossDsReferenceEditor.this.getController().getParent(DbCrossDsReferenceEditor.this.getIdentity())) {
                    return;
                }
                DbCrossDsReferenceEditor.this.modified();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "editor";
                objectArray2[1] = "com/intellij/database/dbimport/editor/editor/DbCrossDsReferenceEditor$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "created";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "removed";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "modified";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @NotNull
    protected DefaultActionGroup getToolbarAction() {
        return new DefaultActionGroup(new AnAction[]{new DumbAwareAction(DatabaseBundle.message((String)"action.choose.text", (Object[])new Object[0]), null, AllIcons.General.OpenDisk){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                DbCrossDsReferenceEditor.this.createChooser().showInBestPositionFor(e.getDataContext());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/dbimport/editor/editor/DbCrossDsReferenceEditor$3", "actionPerformed"));
            }
        }});
    }

    private void tableCheckedUpdate(@NotNull DbEditor<?, ?> editor2) {
        if (editor2 == null) {
            DbCrossDsReferenceEditor.$$$reportNull$$$0(2);
        }
        if (editor2.getIdentity() == this.mySelected && editor2.getModelInternalKey() == BasicModNamedElement.NAME) {
            this.onTableUpdated();
        }
    }

    protected void onTableUpdated() {
        this.updateRenderer();
    }

    @NotNull
    private JBPopup createChooser() {
        ElementOwner oOwner = this.getController().getModelController().getMatcher().getOriginalOwner();
        BasicElement selected = oOwner == null || this.mySelected == null ? null : oOwner.find(this.mySelected);
        JBPopup jBPopup = DbTreeSelectorPopup.createPopup(this.getController().getProject(), (BasicNode)selected, ((DbReferenceModelApplier)this.getApplier()).getReference().getReferenceDesc().targets, (ds, e) -> this.manualSelect((RawDataSource)ds, (BasicElement)e));
        if (jBPopup == null) {
            DbCrossDsReferenceEditor.$$$reportNull$$$0(3);
        }
        return jBPopup;
    }

    public void manualSelect(RawDataSource dataSource, BasicElement element) {
        ElementIdentity id = this.getController().accessModel(controller -> controller.accessActualOwner(owner -> {
            ElementOwner oOwner;
            ElementOwner elementOwner = oOwner = owner == null ? null : owner.getOriginal();
            if (oOwner == null) {
                return null;
            }
            DataSourceData.registerDataSourceRoot(oOwner, this.getIdentity(), dataSource);
            if (element == null) {
                return null;
            }
            return oOwner.identify(element);
        }));
        if (id != null) {
            this.manualSelect(id);
        }
    }

    @NotNull
    protected Set<ObjectKind> getTargetKinds() {
        LinkedHashSet<ObjectKind> res2 = new LinkedHashSet<ObjectKind>();
        for (BasicMetaObject target : ((DbReferenceModelApplier)this.getApplier()).getReference().getReferenceDesc().targets) {
            res2.add(target.kind);
        }
        LinkedHashSet<ObjectKind> linkedHashSet = res2;
        if (linkedHashSet == null) {
            DbCrossDsReferenceEditor.$$$reportNull$$$0(4);
        }
        return linkedHashSet;
    }

    protected void manualSelect(@NotNull ElementIdentity<?> identity) {
        BasicMetaObject tgt;
        ElementIdentity targetId;
        if (identity == null) {
            DbCrossDsReferenceEditor.$$$reportNull$$$0(5);
        }
        ElementIdentity elementIdentity = targetId = (tgt = ((DbReferenceModelApplier)this.getApplier()).getReference().getReferenceDesc().tryCastAsTarget(identity.getMetaObject())) == null ? null : ElementIdentity.tryCast(identity, (BasicMetaObject)tgt);
        if (targetId != null) {
            this.setSelected(targetId);
            return;
        }
        this.setSelected(null);
    }

    @NotNull
    public DbDirectReferenceModelApplier<E, T, S> getApplier() {
        DbDirectReferenceModelApplier dbDirectReferenceModelApplier = (DbDirectReferenceModelApplier)super.getApplier();
        if (dbDirectReferenceModelApplier == null) {
            DbCrossDsReferenceEditor.$$$reportNull$$$0(6);
        }
        return dbDirectReferenceModelApplier;
    }

    @Override
    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this.myComponent;
        if (jComponent == null) {
            DbCrossDsReferenceEditor.$$$reportNull$$$0(7);
        }
        return jComponent;
    }

    @Override
    @NotNull
    public FieldSize getFieldSize() {
        FieldSize fieldSize = FieldSize.LARGE;
        if (fieldSize == null) {
            DbCrossDsReferenceEditor.$$$reportNull$$$0(8);
        }
        return fieldSize;
    }

    @Override
    public boolean isEmpty() {
        return this.mySelected != null;
    }

    @Override
    protected void applyImpl() {
        ((DbDirectReferenceModelState)this.getState()).setTargetId(this.getController().getModelController(), this.mySelected, ((DbDirectReferenceModelState)this.getState()).getActualRef());
        ((DbDirectReferenceModelState)this.getState()).setInconsistent(this.myInconsistent);
    }

    @Override
    protected void resetImpl() {
        this.setSelected(((DbDirectReferenceModelState)this.getState()).getTargetId(), ((DbDirectReferenceModelState)this.getState()).isInconsistent());
    }

    protected void setSelected(ElementIdentity<T> id) {
        this.setSelected(id, false);
    }

    private void setSelected(ElementIdentity<T> id, boolean inconsistent) {
        if (this.mySelected == id && inconsistent == this.myInconsistent) {
            return;
        }
        this.mySelected = id;
        this.myInconsistent = inconsistent;
        this.onTableUpdated();
        this.modified();
    }

    protected void updateRenderer() {
        HoverColoredRenderer.SimpleColoredTextEx text = new HoverColoredRenderer.SimpleColoredTextEx();
        if (this.myInconsistent) {
            text.append(DatabaseBundle.message((String)"status.text.different.values", (Object[])new Object[0]), SimpleTextAttributes.GRAYED_ATTRIBUTES);
        } else if (this.mySelected == null) {
            text.append(DatabaseBundle.message((String)"not.specified", (Object[])new Object[0]), SimpleTextAttributes.ERROR_ATTRIBUTES);
        } else {
            List<ElementIdentity<T>> identities = MultiElementIdentity.getIdentities(this.mySelected);
            ElementIdentity<T> targetId = identities == null ? this.mySelected : identities.get(0);
            T properties = DbStructureEditor.StructureRenderer.getObjectToRender(this.getController(), targetId);
            this.renderIcon((ColoredTextContainer)text, this.getController().getBuilder().getIcon((BasicElement)properties));
            this.renderName((ColoredTextContainer)text, properties.getName());
            DbCrossDsReferenceEditor.renderLocationString((ColoredTextContainer)text, DbCrossDsReferenceEditor.getLocationString(this.getController(), targetId));
        }
        this.myRenderer.setText(text);
    }

    protected static void renderLocationString(@NotNull ColoredTextContainer renderer2, @Nls String locationString) {
        if (renderer2 == null) {
            DbCrossDsReferenceEditor.$$$reportNull$$$0(9);
        }
        if (StringUtil.isNotEmpty((String)locationString)) {
            if (DbCrossDsReferenceEditor.isNotEmpty(renderer2)) {
                renderer2.append(" ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
            renderer2.append(locationString, SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }
    }

    private static boolean isNotEmpty(@NotNull ColoredTextContainer renderer2) {
        if (renderer2 == null) {
            DbCrossDsReferenceEditor.$$$reportNull$$$0(10);
        }
        if (renderer2 instanceof SimpleColoredText) {
            SimpleColoredText t = (SimpleColoredText)renderer2;
            return !t.getTexts().isEmpty();
        }
        if (renderer2 instanceof SimpleColoredComponent) {
            SimpleColoredComponent c2 = (SimpleColoredComponent)renderer2;
            return c2.getFragmentCount() != 0;
        }
        return true;
    }

    protected void renderName(@NotNull ColoredTextContainer renderer2, @Nls String name2) {
        if (renderer2 == null) {
            DbCrossDsReferenceEditor.$$$reportNull$$$0(11);
        }
        DbEditorModelController controller = this.getController().getModelController();
        DbEditorModel<T, DbStructureObjectModelState<T>> sm = this.mySelected == null ? null : controller.getStructureNodeModel(this.mySelected);
        FileStatus status = sm == null ? FileStatus.NOT_CHANGED : DbCrossDsReferenceEditor.getStatus(sm);
        SimpleTextAttributes attributes = status == FileStatus.NOT_CHANGED ? SimpleTextAttributes.REGULAR_ATTRIBUTES : new SimpleTextAttributes(0, status.getColor());
        renderer2.append(name2, attributes);
    }

    protected void renderIcon(@NotNull ColoredTextContainer renderer2, @Nullable Icon icon) {
        if (renderer2 == null) {
            DbCrossDsReferenceEditor.$$$reportNull$$$0(12);
        }
        renderer2.setIcon(icon);
    }

    @NlsSafe
    @NotNull
    private static String getLocationString(DbEditorController controller, ElementIdentity<?> id) {
        StringBuilder builder = new StringBuilder();
        DbCrossDsReferenceEditor.append(controller, builder, controller.getParent(id));
        RawDataSource ds = DataSourceData.getDataSource(controller.getModelController(), id);
        if (ds != null) {
            builder.append(" [").append(ds.getName()).append("]");
        }
        String string = builder.toString();
        if (string == null) {
            DbCrossDsReferenceEditor.$$$reportNull$$$0(13);
        }
        return string;
    }

    private static void append(DbEditorController controller, StringBuilder builder, @Nullable ElementIdentity<?> id) {
        if (id == null || id.getMetaObject().kindOf(BasicRoot.class)) {
            return;
        }
        DbCrossDsReferenceEditor.append(controller, builder, controller.getParent(id));
        Object obj = DbStructureEditor.StructureRenderer.getObjectToRender(controller, id);
        if (!builder.isEmpty()) {
            builder.append(".");
        }
        builder.append(obj.getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 6, 7, 8, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "controller";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/dbimport/editor/editor/DbCrossDsReferenceEditor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identity";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/dbimport/editor/editor/DbCrossDsReferenceEditor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createChooser";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetKinds";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplier";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFieldSize";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocationString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "tableCheckedUpdate";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 8: 
            case 13: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "manualSelect";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "renderLocationString";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isNotEmpty";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "renderName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "renderIcon";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 6, 7, 8, 13 -> new IllegalStateException(string);
        };
    }
}

