/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.searchEverywhereMl.ranking.core;

import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.searchEverywhereMl.SearchEverywhereTab;
import com.intellij.searchEverywhereMl.SearchEverywhereTabKt;
import java.util.Map;
import java.util.Random;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\t\u001a\u00020\nH\u0002J\u000e\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/searchEverywhereMl/ranking/core/FeaturesLoggingRandomisation;", "", "<init>", "()V", "thresholdsByTab", "", "Lcom/intellij/searchEverywhereMl/SearchEverywhereTab$TabWithLogging;", "", "seed", "isInTestMode", "", "shouldLogFeatures", "tab", "Lcom/intellij/searchEverywhereMl/SearchEverywhereTab;", "intellij.searchEverywhereMl.ranking.core"})
public final class FeaturesLoggingRandomisation {
    @NotNull
    private final Map<SearchEverywhereTab.TabWithLogging, Double> thresholdsByTab;
    private final double seed;

    public FeaturesLoggingRandomisation() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)SearchEverywhereTab.Actions.INSTANCE, (Object)1.0), TuplesKt.to((Object)SearchEverywhereTab.Files.INSTANCE, (Object)0.5), TuplesKt.to((Object)SearchEverywhereTab.Classes.INSTANCE, (Object)0.5), TuplesKt.to((Object)SearchEverywhereTab.Symbols.INSTANCE, (Object)1.0), TuplesKt.to((Object)SearchEverywhereTab.All.INSTANCE, (Object)0.5)};
        this.thresholdsByTab = MapsKt.hashMapOf((Pair[])pairArray);
        this.seed = new Random().nextDouble();
    }

    private final boolean isInTestMode() {
        return ApplicationManagerEx.isInIntegrationTest() || ApplicationManagerEx.getApplication().isUnitTestMode();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean shouldLogFeatures(@NotNull SearchEverywhereTab tab) {
        Intrinsics.checkNotNullParameter((Object)tab, (String)"tab");
        if (!SearchEverywhereTabKt.isLoggingEnabled((SearchEverywhereTab)tab)) {
            return false;
        }
        if (this.isInTestMode()) return true;
        Double d = this.thresholdsByTab.get(tab);
        double d2 = d != null ? d : 1.0;
        if (!(this.seed < d2)) return false;
        return true;
    }
}

