/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyStringLiteralUtil;
import org.jetbrains.annotations.NotNull;

public class ConvertDocstringQuickFix
extends PsiUpdateModCommandQuickFix {
    @NotNull
    public String getFamilyName() {
        String string = PyPsiBundle.message("QFIX.convert.single.quoted.docstring", new Object[0]);
        if (string == null) {
            ConvertDocstringQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        if (project == null) {
            ConvertDocstringQuickFix.$$$reportNull$$$0(1);
        }
        if (element == null) {
            ConvertDocstringQuickFix.$$$reportNull$$$0(2);
        }
        if (updater == null) {
            ConvertDocstringQuickFix.$$$reportNull$$$0(3);
        }
        if (element instanceof PyStringLiteralExpression && element.isWritable()) {
            PyElementGenerator elementGenerator = PyElementGenerator.getInstance(project);
            String stringText = element.getText();
            int prefixLength = PyStringLiteralUtil.getPrefixLength((String)stringText);
            String prefix = stringText.substring(0, prefixLength);
            String content = stringText.substring(prefixLength);
            if (content.startsWith("'''")) {
                content = content.substring(3, content.length() - 3);
            } else {
                if (content.startsWith("\"\"\"")) {
                    return;
                }
                String string = content = content.length() == 1 ? "" : content.substring(1, content.length() - 1);
            }
            if (content.endsWith("\"")) {
                content = StringUtil.replaceSubstring((String)content, (TextRange)TextRange.create((int)(content.length() - 1), (int)content.length()), (String)"\\\"");
            }
            PyExpression newString = elementGenerator.createDocstring(prefix + "\"\"\"" + content + "\"\"\"").getExpression();
            element.replace((PsiElement)newString);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/inspections/quickfix/ConvertDocstringQuickFix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/inspections/quickfix/ConvertDocstringQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

