/*
 * Decompiled with CFR 0.152.
 */
package dev.langchain4j.model.chat.response;

import dev.langchain4j.Experimental;
import dev.langchain4j.data.message.AiMessage;
import dev.langchain4j.internal.ValidationUtils;
import dev.langchain4j.model.chat.response.ChatResponseMetadata;
import dev.langchain4j.model.output.FinishReason;
import dev.langchain4j.model.output.TokenUsage;
import java.util.Objects;
import org.jspecify.annotations.NonNull;

@Experimental
public class ChatResponse {
    private final AiMessage aiMessage;
    private final ChatResponseMetadata metadata;

    protected ChatResponse(@NonNull Builder builder) {
        this.aiMessage = ValidationUtils.ensureNotNull(builder.aiMessage, "aiMessage");
        ChatResponseMetadata.Builder<?> metadataBuilder = ChatResponseMetadata.builder();
        if (builder.tokenUsage != null) {
            if (builder.metadata != null) {
                throw new IllegalArgumentException("Cannot set both 'metadata' and 'tokenUsage' on ChatResponse");
            }
            metadataBuilder.tokenUsage(builder.tokenUsage);
        }
        if (builder.finishReason != null) {
            if (builder.metadata != null) {
                throw new IllegalArgumentException("Cannot set both 'metadata' and 'finishReason' on ChatResponse");
            }
            metadataBuilder.finishReason(builder.finishReason);
        }
        this.metadata = builder.metadata != null ? builder.metadata : metadataBuilder.build();
    }

    public AiMessage aiMessage() {
        return this.aiMessage;
    }

    @Experimental
    public ChatResponseMetadata metadata() {
        return this.metadata;
    }

    public TokenUsage tokenUsage() {
        return this.metadata.tokenUsage();
    }

    public FinishReason finishReason() {
        return this.metadata.finishReason();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChatResponse that = (ChatResponse)o;
        return Objects.equals(this.aiMessage, that.aiMessage) && Objects.equals(this.metadata, that.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.aiMessage, this.metadata);
    }

    public String toString() {
        return "ChatResponse { aiMessage = " + String.valueOf(this.aiMessage) + ", metadata = " + String.valueOf(this.metadata) + " }";
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private AiMessage aiMessage;
        private ChatResponseMetadata metadata;
        private TokenUsage tokenUsage;
        private FinishReason finishReason;

        public Builder aiMessage(AiMessage aiMessage) {
            this.aiMessage = aiMessage;
            return this;
        }

        public Builder metadata(ChatResponseMetadata metadata) {
            this.metadata = metadata;
            return this;
        }

        public Builder tokenUsage(TokenUsage tokenUsage) {
            this.tokenUsage = tokenUsage;
            return this;
        }

        public Builder finishReason(FinishReason finishReason) {
            this.finishReason = finishReason;
            return this;
        }

        public ChatResponse build() {
            return new ChatResponse(this);
        }
    }
}

