/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.google.common.base.Stopwatch;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.actions.VcsContextFactory;
import com.intellij.openapi.vcs.changes.ChangeList;
import com.intellij.openapi.vcs.changes.ChangeListManagerGate;
import com.intellij.openapi.vcs.changes.ChangeProvider;
import com.intellij.openapi.vcs.changes.ChangelistBuilder;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.idea.perforce.application.ChangeCreator;
import org.jetbrains.idea.perforce.application.ConnectionKey;
import org.jetbrains.idea.perforce.application.FileGrouper;
import org.jetbrains.idea.perforce.application.LastSuccessfulUpdateTracker;
import org.jetbrains.idea.perforce.application.LocalPathsSet;
import org.jetbrains.idea.perforce.application.OpenedResultProcessor;
import org.jetbrains.idea.perforce.application.PerforceChangeListCalculator;
import org.jetbrains.idea.perforce.application.PerforceDirtyFilesHandler;
import org.jetbrains.idea.perforce.application.PerforceManager;
import org.jetbrains.idea.perforce.application.PerforceNumberNameSynchronizer;
import org.jetbrains.idea.perforce.application.PerforceReadOnlyFileStateManager;
import org.jetbrains.idea.perforce.application.PerforceShelf;
import org.jetbrains.idea.perforce.application.PerforceUnversionedTracker;
import org.jetbrains.idea.perforce.application.PerforceVcs;
import org.jetbrains.idea.perforce.application.ResolvedFilesWrapper;
import org.jetbrains.idea.perforce.perforce.P4Command;
import org.jetbrains.idea.perforce.perforce.P4File;
import org.jetbrains.idea.perforce.perforce.PerforceChange;
import org.jetbrains.idea.perforce.perforce.PerforceChangeCache;
import org.jetbrains.idea.perforce.perforce.PerforceChangeList;
import org.jetbrains.idea.perforce.perforce.PerforceChangeListHelper;
import org.jetbrains.idea.perforce.perforce.PerforceRunner;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManager;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManagerI;

public class PerforceChangeProvider
implements ChangeProvider {
    private static final Logger LOG = Logger.getInstance(PerforceChangeProvider.class);
    private static final Logger REFRESH_LOG = Logger.getInstance((String)"#PerforceRefresh");
    private final Project myProject;
    private final PerforceRunner myRunner;
    private final LastSuccessfulUpdateTracker myLastSuccessfulUpdateTracker;
    private final PerforceNumberNameSynchronizer mySynchronizer;
    private final PerforceReadOnlyFileStateManager myReadOnlyFileStateManager;
    private final PerforceDirtyFilesHandler myDirtyFilesHandler;
    private final PerforceUnversionedTracker myUnversionedTracker;
    private final Map<VirtualFile, Boolean> myAlwaysWritable = new ConcurrentHashMap<VirtualFile, Boolean>();
    private final PerforceShelf myShelf;
    private final PerforceVcs myVcs;

    public PerforceUnversionedTracker getUnversionedTracker() {
        return this.myUnversionedTracker;
    }

    public PerforceReadOnlyFileStateManager getReadOnlyFileStateManager() {
        return this.myReadOnlyFileStateManager;
    }

    public PerforceChangeProvider(PerforceVcs vcs) {
        this.myVcs = vcs;
        this.myProject = vcs.getProject();
        this.myRunner = PerforceRunner.getInstance(this.myProject);
        this.myLastSuccessfulUpdateTracker = LastSuccessfulUpdateTracker.getInstance(this.myProject);
        this.mySynchronizer = PerforceNumberNameSynchronizer.getInstance(this.myProject);
        this.myUnversionedTracker = new PerforceUnversionedTracker(this.myProject);
        this.myDirtyFilesHandler = new PerforceDirtyFilesHandler(this.myProject, this.myUnversionedTracker);
        this.myReadOnlyFileStateManager = new PerforceReadOnlyFileStateManager(this.myProject, this.myDirtyFilesHandler);
        this.myShelf = PerforceManager.getInstance(this.myProject).getShelf();
    }

    public void activate(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            PerforceChangeProvider.$$$reportNull$$$0(0);
        }
        this.myReadOnlyFileStateManager.activate(parentDisposable);
        this.myDirtyFilesHandler.activate(parentDisposable);
        this.myUnversionedTracker.activate(parentDisposable);
    }

    public void getChanges(@NotNull VcsDirtyScope dirtyScope, @NotNull ChangelistBuilder builder, @NotNull ProgressIndicator progress, @NotNull ChangeListManagerGate addGate) throws VcsException {
        if (dirtyScope == null) {
            PerforceChangeProvider.$$$reportNull$$$0(1);
        }
        if (builder == null) {
            PerforceChangeProvider.$$$reportNull$$$0(2);
        }
        if (progress == null) {
            PerforceChangeProvider.$$$reportNull$$$0(3);
        }
        if (addGate == null) {
            PerforceChangeProvider.$$$reportNull$$$0(4);
        }
        Stopwatch sw = Stopwatch.createStarted();
        try (AccessToken ignored = this.myVcs.readLockP4();){
            this.doGetChanges(dirtyScope, builder, progress, addGate);
        }
        sw.stop();
        REFRESH_LOG.info("getChanges took %d s".formatted(sw.elapsed().toSeconds()));
    }

    private void doGetChanges(@NotNull VcsDirtyScope dirtyScope, @NotNull ChangelistBuilder builder, @NotNull ProgressIndicator progress, @NotNull ChangeListManagerGate addGate) throws VcsException {
        if (dirtyScope == null) {
            PerforceChangeProvider.$$$reportNull$$$0(5);
        }
        if (builder == null) {
            PerforceChangeProvider.$$$reportNull$$$0(6);
        }
        if (progress == null) {
            PerforceChangeProvider.$$$reportNull$$$0(7);
        }
        if (addGate == null) {
            PerforceChangeProvider.$$$reportNull$$$0(8);
        }
        PerforceChangeProvider.logRefreshDebug("getting changes for scope " + String.valueOf(dirtyScope));
        this.myLastSuccessfulUpdateTracker.updateStarted();
        this.myShelf.clearShelf();
        PerforceManager.getInstance(this.myProject).clearInfoClientCache();
        PerforceChangeCache changeCache = new PerforceChangeCache(this.myProject);
        MultiMap<ConnectionKey, PerforceChangeList> allLists = this.calcChangeListMap(changeCache);
        PerforceSettings settings = PerforceSettings.getSettings(this.myProject);
        HashSet<String> ideaLists = new HashSet<String>();
        this.refreshSynchronizer(settings, addGate, allLists, ideaLists);
        if (settings.FORCE_SYNC_CHANGELISTS) {
            PerforceChangeProvider.removeUnsyncedIdeaChangelists(addGate, ideaLists);
        }
        ChangeCreator creator = new ChangeCreator(this.myProject);
        Map<ConnectionKey, P4Connection> key2connection = settings.getConnectionsByKeys();
        MultiMap<ConnectionKey, VirtualFile> roots = this.getAffectedRoots(dirtyScope);
        for (ConnectionKey key : roots.keySet()) {
            P4Connection connection = key2connection.get(key);
            if (connection == null) continue;
            this.processConnection(connection, builder, roots.get((Object)key), progress, addGate, allLists.get((Object)key), dirtyScope, changeCache, creator);
        }
        Stopwatch sw = Stopwatch.createStarted();
        this.myReadOnlyFileStateManager.getChanges(dirtyScope, builder, progress, addGate);
        sw.stop();
        PerforceChangeProvider.logRefreshDebug("readOnlyFileStateManager.getChanges took %d s".formatted(sw.elapsed().toSeconds()));
        Set<VirtualFile> writableFiles = PerforceChangeProvider.collectWritableFiles(this.myReadOnlyFileStateManager, dirtyScope, false);
        for (VirtualFile file : PerforceVcs.getInstance(this.myProject).getAsyncEditedFiles()) {
            if (!writableFiles.contains(file)) continue;
            this.processAsyncEdit(file, builder, creator);
            writableFiles.remove(file);
        }
        this.reportModifiedWithoutCheckout(builder, creator, writableFiles);
        this.myLastSuccessfulUpdateTracker.updateSuccessful();
    }

    private static void removeUnsyncedIdeaChangelists(@NotNull ChangeListManagerGate addGate, HashSet<String> ideaLists) {
        if (addGate == null) {
            PerforceChangeProvider.$$$reportNull$$$0(9);
        }
        Set ideaOnlyChangelists = addGate.getListsCopy().stream().filter(it -> !it.hasDefaultName() && !ideaLists.contains(it.getName())).map(it -> it.getName()).collect(Collectors.toSet());
        addGate.setListsToDisappear(ideaOnlyChangelists);
    }

    private void reportModifiedWithoutCheckout(ChangelistBuilder builder, ChangeCreator creator, Set<VirtualFile> writableFiles) throws VcsException {
        Stopwatch sw = Stopwatch.createStarted();
        ArrayList<VirtualFile> unknown = new ArrayList<VirtualFile>();
        for (VirtualFile file : writableFiles) {
            if (this.myUnversionedTracker.isLocalOnly(file) || creator.reportedChanges.contains(file)) continue;
            Boolean alwaysWritable = this.myAlwaysWritable.get(file);
            if (alwaysWritable == Boolean.FALSE) {
                PerforceChangeProvider.logDebug("reportModifiedWithoutCheckout, hijacked file = " + String.valueOf(file));
                builder.processModifiedWithoutCheckout(file);
                continue;
            }
            if (alwaysWritable != null) continue;
            PerforceChangeProvider.logDebug("reportModifiedWithoutCheckout, unknown file = " + String.valueOf(file));
            unknown.add(file);
        }
        if (!unknown.isEmpty() && SystemProperties.getBooleanProperty((String)"perforce.always.writable.check.enabled", (boolean)true)) {
            MultiMap<P4Connection, VirtualFile> map = FileGrouper.distributeFilesByConnection(unknown, this.myProject);
            for (P4Connection connection : map.keySet()) {
                for (VirtualFile file : this.getHijackedFiles(map, connection)) {
                    builder.processModifiedWithoutCheckout(file);
                }
            }
        }
        sw.stop();
        PerforceChangeProvider.logRefreshDebug("reportModifiedWithoutCheckout took %d".formatted(sw.elapsed().toSeconds()));
    }

    private List<VirtualFile> getHijackedFiles(MultiMap<P4Connection, VirtualFile> map, P4Connection connection) throws VcsException {
        if (PerforceChangeProvider.isAllWriteWorkspace(connection, this.myProject)) {
            return Collections.emptyList();
        }
        ArrayList files = new ArrayList(map.get((Object)connection));
        List paths = ContainerUtil.map(files, file -> P4File.escapeWildcards(file.getPath()));
        List<String> output = this.myRunner.files(paths, connection);
        ArrayList<VirtualFile> hijacked = new ArrayList<VirtualFile>();
        int fileIndex = 0;
        for (String line : output) {
            if (StringUtil.isEmptyOrSpaces((String)line)) continue;
            if (fileIndex >= files.size()) break;
            int lParen = line.lastIndexOf(40);
            if (lParen < 0) continue;
            VirtualFile file2 = (VirtualFile)files.get(fileIndex);
            PerforceChangeProvider.logDebug("getHijackedFiles, checking file = " + String.valueOf(file2) + "; line = " + line);
            boolean expectedWritable = line.substring(lParen).contains("+w");
            this.myAlwaysWritable.put(file2, expectedWritable);
            if (!expectedWritable) {
                hijacked.add(file2);
            }
            ++fileIndex;
        }
        return hijacked;
    }

    public static boolean isAllWriteWorkspace(@NotNull P4Connection connection, @NotNull Project project) {
        List<String> options;
        if (connection == null) {
            PerforceChangeProvider.$$$reportNull$$$0(10);
        }
        if (project == null) {
            PerforceChangeProvider.$$$reportNull$$$0(11);
        }
        return (options = PerforceManager.getInstance(project).getClient(connection).getCachedOptions()) != null && options.contains("allwrite");
    }

    private static void logDebug(String message) {
        LOG.debug(message);
    }

    private static void logRefreshDebug(String message) {
        REFRESH_LOG.debug(message);
    }

    private MultiMap<ConnectionKey, VirtualFile> getAffectedRoots(VcsDirtyScope dirtyScope) throws VcsException {
        PerforceConnectionManagerI connectionManager = PerforceConnectionManager.getInstance(this.myProject);
        MultiMap roots = new MultiMap();
        for (VirtualFile root : dirtyScope.getAffectedContentRoots()) {
            P4Connection connection = connectionManager.getConnectionForFile(root);
            if (connection == null) continue;
            PerforceManager.ensureValidClient(this.myProject, connection);
            ConnectionKey key = connection.getConnectionKey();
            roots.putValue((Object)key, (Object)root);
        }
        return roots;
    }

    private boolean shouldShowChangeList(PerforceChangeList pcl, Collection<VirtualFile> allRoots, P4Connection connection) {
        if (pcl.getChanges().isEmpty()) {
            return !this.mySynchronizer.isHidden(pcl.getNumber());
        }
        if (this.myShelf.hasLocalChanges(connection.getConnectionKey(), pcl.getNumber())) {
            return true;
        }
        return ContainerUtil.or(allRoots, root -> !pcl.getChangesUnder((VirtualFile)root).isEmpty());
    }

    private MultiMap<ConnectionKey, PerforceChangeList> calcChangeListMap(PerforceChangeCache changeCache) throws VcsException {
        MultiMap allLists = MultiMap.create();
        for (Pair<P4Connection, Collection<VirtualFile>> pair : PerforceVcs.getInstance(this.myProject).getRootsByConnections()) {
            P4Connection connection = (P4Connection)pair.first;
            PerforceManager.ensureValidClient(this.myProject, connection);
            allLists.putValues((Object)connection.getConnectionKey(), this.getPendingChangeListsUnderRoots(changeCache, connection, (Collection)pair.second));
        }
        return allLists;
    }

    private List<PerforceChangeList> getPendingChangeListsUnderRoots(PerforceChangeCache changeCache, P4Connection connection, Collection<VirtualFile> allRoots) throws VcsException {
        List<PerforceChangeList> perforceLists = this.myRunner.getPendingChangeLists(connection, changeCache);
        if (perforceLists.isEmpty()) {
            return perforceLists;
        }
        this.myRunner.fillChangeCache(connection, changeCache, this.myShelf, perforceLists);
        ArrayList<PerforceChangeList> filtered = new ArrayList<PerforceChangeList>();
        for (PerforceChangeList pcl : perforceLists) {
            if (!this.shouldShowChangeList(pcl, allRoots, connection)) continue;
            this.mySynchronizer.setHidden(pcl.getNumber(), false);
            filtered.add(pcl);
        }
        return filtered;
    }

    public static Set<VirtualFile> collectWritableFiles(PerforceReadOnlyFileStateManager readOnlyFileStateManager, VcsDirtyScope dirtyScope, boolean withIgnored) {
        Stopwatch sw = Stopwatch.createStarted();
        Collection dirtyRoots = dirtyScope.getAffectedContentRoots();
        HashSet<VirtualFile> writableFiles = new HashSet<VirtualFile>();
        for (VirtualFile root : dirtyRoots) {
            readOnlyFileStateManager.addWritableFiles(root, writableFiles, withIgnored);
        }
        sw.stop();
        PerforceChangeProvider.logRefreshDebug("collected %d writable files in %d seconds".formatted(writableFiles.size(), sw.elapsed().toSeconds()));
        return writableFiles;
    }

    private void processAsyncEdit(VirtualFile file, ChangelistBuilder builder, ChangeCreator changeCreator) throws VcsException {
        long revision = this.myRunner.haveRevision(P4File.create(file));
        if (revision > 0L) {
            FilePath filePath = VcsContextFactory.getInstance().createFilePathOn(file);
            builder.processChange(changeCreator.createEditedFileChange(filePath, revision, false), PerforceVcs.getKey());
        }
    }

    private void refreshSynchronizer(PerforceSettings settings, ChangeListManagerGate addGate, MultiMap<ConnectionKey, PerforceChangeList> allLists, Set<String> ideaLists) {
        for (ConnectionKey key : allLists.keySet()) {
            Collection lists = allLists.get((Object)key);
            Set<String> disappearedLists = this.mySynchronizer.acceptInfo(key, lists, addGate, ideaLists);
            if (settings.FORCE_SYNC_CHANGELISTS) {
                PerforceChangeProvider.tryRestoreDefaultChangelist(addGate, disappearedLists);
            }
            addGate.setListsToDisappear(disappearedLists);
        }
        this.mySynchronizer.removeNonexistentKeys(allLists.keySet());
    }

    private static void tryRestoreDefaultChangelist(ChangeListManagerGate addGate, Set<String> disappearedLists) {
        for (String changeListName : disappearedLists) {
            LocalChangeList changeList = addGate.findChangeList(changeListName);
            if (changeList == null || !changeList.isDefault()) continue;
            ChangeList defaultChangeList = PerforceChangeListHelper.findOrCreateDefaultList(addGate);
            addGate.setDefaultChangeList(defaultChangeList.getName());
            break;
        }
    }

    private void processConnection(@NotNull P4Connection connection, ChangelistBuilder builder, Collection<VirtualFile> roots, ProgressIndicator progress, ChangeListManagerGate addGate, Collection<PerforceChangeList> allLists, VcsDirtyScope dirtyScope, PerforceChangeCache changeCache, ChangeCreator changeCreator) throws VcsException {
        if (connection == null) {
            PerforceChangeProvider.$$$reportNull$$$0(12);
        }
        progress.checkCanceled();
        Stopwatch sw = Stopwatch.createStarted();
        LocalPathsSet resolvedWithConflictsMap = this.myRunner.getResolvedWithConflictsMap(connection, roots);
        ResolvedFilesWrapper resolvedFilesWrapper = new ResolvedFilesWrapper(this.myRunner.getResolvedFiles(connection, roots));
        ArrayList<PerforceChange> changes = new ArrayList<PerforceChange>();
        for (VirtualFile root : roots) {
            changes.addAll(this.getChangesUnder(connection, root, dirtyScope, allLists, changeCache));
        }
        PerforceChangeListCalculator changeListCalculator = new PerforceChangeListCalculator(this.myProject, connection, addGate);
        OpenedResultProcessor processor = new OpenedResultProcessor(connection, changeCreator, builder, resolvedWithConflictsMap, resolvedFilesWrapper, changeListCalculator);
        processor.process(changes);
        sw.stop();
        PerforceChangeProvider.logRefreshDebug("processConnection %s took %d s".formatted(connection.getConnectionKey(), sw.elapsed().toSeconds()));
    }

    public boolean isModifiedDocumentTrackingRequired() {
        return false;
    }

    public void discardCache() {
        this.myReadOnlyFileStateManager.discardUnversioned();
        this.myAlwaysWritable.clear();
    }

    @TestOnly
    public void imitateLostFocus() {
        this.myReadOnlyFileStateManager.processFocusLost();
    }

    @NotNull
    private List<PerforceChange> getChangesUnder(@NotNull P4Connection connection, @NotNull VirtualFile root, @NotNull VcsDirtyScope dirtyScope, @NotNull Collection<PerforceChangeList> allLists, @NotNull PerforceChangeCache changeCache) throws VcsException {
        if (connection == null) {
            PerforceChangeProvider.$$$reportNull$$$0(13);
        }
        if (root == null) {
            PerforceChangeProvider.$$$reportNull$$$0(14);
        }
        if (dirtyScope == null) {
            PerforceChangeProvider.$$$reportNull$$$0(15);
        }
        if (allLists == null) {
            PerforceChangeProvider.$$$reportNull$$$0(16);
        }
        if (changeCache == null) {
            PerforceChangeProvider.$$$reportNull$$$0(17);
        }
        ArrayList<PerforceChange> perforceChanges = new ArrayList<PerforceChange>();
        List<PerforceChange> defChanges = PerforceChangeProvider.filterByRoot(root, dirtyScope, changeCache.getChanges(connection, -1L, root));
        if (!defChanges.isEmpty()) {
            perforceChanges.addAll(defChanges);
        }
        for (PerforceChangeList changeList : allLists) {
            perforceChanges.addAll(PerforceChangeProvider.filterByRoot(root, dirtyScope, changeCache.getChanges(connection, changeList.getNumber(), root)));
        }
        if (!perforceChanges.isEmpty()) {
            this.myRunner.setChangeRevisions(P4Command.opened, connection, defChanges);
        }
        ArrayList<PerforceChange> arrayList = perforceChanges;
        if (arrayList == null) {
            PerforceChangeProvider.$$$reportNull$$$0(18);
        }
        return arrayList;
    }

    private static List<PerforceChange> filterByRoot(VirtualFile root, VcsDirtyScope dirtyScope, List<PerforceChange> perforceChanges) {
        File ioRoot = new File(root.getPath());
        ArrayList<PerforceChange> result = new ArrayList<PerforceChange>();
        for (PerforceChange perforceChange : perforceChanges) {
            File file = perforceChange.getFile();
            if (file == null || !FileUtil.isAncestor((File)ioRoot, (File)file, (boolean)false) || !dirtyScope.belongsTo(VcsUtil.getFilePath((File)file))) continue;
            result.add(perforceChange);
        }
        return result;
    }

    public void clearUnversionedStatus(@NotNull FilePath file) {
        if (file == null) {
            PerforceChangeProvider.$$$reportNull$$$0(19);
        }
        this.myDirtyFilesHandler.reportRecheck(file);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 1: 
            case 5: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirtyScope";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 4: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addGate";
                break;
            }
            case 10: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allLists";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeCache";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/perforce/application/PerforceChangeProvider";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/perforce/application/PerforceChangeProvider";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangesUnder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "activate";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getChanges";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doGetChanges";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeUnsyncedIdeaChangelists";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isAllWriteWorkspace";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processConnection";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getChangesUnder";
                break;
            }
            case 18: {
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "clearUnversionedStatus";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 18 -> new IllegalStateException(string);
        };
    }
}

