/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript;

import com.intellij.codeInsight.editorActions.JavaLikeQuoteHandler;
import com.intellij.codeInsight.editorActions.SimpleTokenSetQuoteHandler;
import com.intellij.lang.javascript.JSDocTokenTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.xml.XmlTokenType;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 \u001c2\u00020\u00012\u00020\u0002:\u0001\u001cB\t\b\u0016\u00a2\u0006\u0004\b\u0003\u0010\u0004B\u0011\b\u0014\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0003\u0010\u0007J\b\u0010\b\u001a\u00020\u0006H\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\u0006H\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J \u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u001b\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016\u00a8\u0006\u001d"}, d2={"Lcom/intellij/javascript/JSQuoteHandler;", "Lcom/intellij/codeInsight/editorActions/SimpleTokenSetQuoteHandler;", "Lcom/intellij/codeInsight/editorActions/JavaLikeQuoteHandler;", "<init>", "()V", "tokenSet", "Lcom/intellij/psi/tree/TokenSet;", "(Lcom/intellij/psi/tree/TokenSet;)V", "getConcatenatableStringTokenTypes", "getStringConcatenationOperatorRepresentation", "", "getStringTokenTypes", "isAppropriateElementTypeForLiteral", "", "tokenType", "Lcom/intellij/psi/tree/IElementType;", "needParenthesesAroundConcatenation", "element", "Lcom/intellij/psi/PsiElement;", "isOpeningQuote", "iterator", "Lcom/intellij/openapi/editor/highlighter/HighlighterIterator;", "offset", "", "hasNonClosedLiteral", "editor", "Lcom/intellij/openapi/editor/Editor;", "isClosingQuote", "Companion", "intellij.javascript.frontback.impl"})
public class JSQuoteHandler
extends SimpleTokenSetQuoteHandler
implements JavaLikeQuoteHandler {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private static final TokenSet QUOTE_TOKENS;

    public JSQuoteHandler() {
        super(QUOTE_TOKENS);
    }

    protected JSQuoteHandler(@NotNull TokenSet tokenSet) {
        Intrinsics.checkNotNullParameter((Object)tokenSet, (String)"tokenSet");
        super(tokenSet);
    }

    @NotNull
    public TokenSet getConcatenatableStringTokenTypes() {
        TokenSet tokenSet = TokenSet.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"EMPTY");
        return tokenSet;
    }

    @NotNull
    public String getStringConcatenationOperatorRepresentation() {
        return "";
    }

    @NotNull
    public TokenSet getStringTokenTypes() {
        TokenSet tokenSet = this.myLiteralTokenSet;
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"myLiteralTokenSet");
        return tokenSet;
    }

    public boolean isAppropriateElementTypeForLiteral(@NotNull IElementType tokenType) {
        Intrinsics.checkNotNullParameter((Object)tokenType, (String)"tokenType");
        return JSTokenTypes.WHITE_SPACE == tokenType || JSTokenTypes.COMMENTS.contains(tokenType) || tokenType == JSTokenTypes.SEMICOLON || tokenType == JSTokenTypes.COMMA || tokenType == JSTokenTypes.RPAR || tokenType == JSDocTokenTypes.DOC_RPAR || tokenType == JSTokenTypes.RBRACKET || tokenType == JSTokenTypes.RBRACE || tokenType == JSTokenTypes.GT || tokenType == JSTokenTypes.STRING_LITERAL || JSTokenTypes.XML_TOKENS.contains(tokenType) || tokenType == JSTokenTypes.SINGLE_QUOTE_STRING_LITERAL;
    }

    public boolean needParenthesesAroundConcatenation(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        return false;
    }

    public boolean isOpeningQuote(@NotNull HighlighterIterator iterator2, int offset) {
        Intrinsics.checkNotNullParameter((Object)iterator2, (String)"iterator");
        if (iterator2.getTokenType() == XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER) {
            return true;
        }
        return super.isOpeningQuote(iterator2, offset);
    }

    public boolean hasNonClosedLiteral(@NotNull Editor editor, @NotNull HighlighterIterator iterator2, int offset) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)iterator2, (String)"iterator");
        if (iterator2.getTokenType() == XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER) {
            return true;
        }
        return super.hasNonClosedLiteral(editor, iterator2, offset);
    }

    public boolean isClosingQuote(@NotNull HighlighterIterator iterator2, int offset) {
        Intrinsics.checkNotNullParameter((Object)iterator2, (String)"iterator");
        if (iterator2.getTokenType() == XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER) {
            return true;
        }
        if (iterator2.getTokenType() == JSTokenTypes.BACKQUOTE && !iterator2.atEnd()) {
            iterator2.advance();
            boolean result = iterator2.atEnd() || iterator2.getTokenType() != JSTokenTypes.BACKQUOTE;
            iterator2.retreat();
            return result;
        }
        return super.isClosingQuote(iterator2, offset);
    }

    static {
        TokenSet[] tokenSetArray = new TokenSet[2];
        tokenSetArray[0] = JSTokenTypes.STRING_LITERALS;
        IElementType[] iElementTypeArray = new IElementType[]{JSTokenTypes.BACKQUOTE, JSTokenTypes.STRING_TEMPLATE_PART, JSDocTokenTypes.STRING_LITERAL_HIGHLIGHTING};
        tokenSetArray[1] = TokenSet.create((IElementType[])iElementTypeArray);
        TokenSet tokenSet = TokenSet.orSet((TokenSet[])tokenSetArray);
        Intrinsics.checkNotNullExpressionValue((Object)tokenSet, (String)"orSet(...)");
        QUOTE_TOKENS = tokenSet;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/javascript/JSQuoteHandler$Companion;", "", "<init>", "()V", "QUOTE_TOKENS", "Lcom/intellij/psi/tree/TokenSet;", "Lorg/jetbrains/annotations/NotNull;", "intellij.javascript.frontback.impl"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

