/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.pro.cython.types;

import com.intellij.psi.PsiElement;
import com.intellij.python.pro.cython.CythonNames;
import com.intellij.python.pro.cython.types.CythonType;
import com.intellij.python.pro.cython.types.CythonTypeChecker;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ProcessingContext;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.types.PyType;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CythonBuiltinType
implements CythonType {
    @NonNls
    protected static final String UNSIGNED_NAME = "unsigned";
    @NonNls
    protected static final String INT_NAME = "int";
    @NonNls
    protected static final String SIGNED_NAME = "signed";
    @NonNls
    protected static final String SHORT_NAME = "short";
    @NonNls
    protected static final String LONG_NAME = "long";
    private final String myBaseName;
    private final boolean myIsDefaultName;
    private final Sign mySign;
    private final Longness myLongness;
    private final boolean myIsPointer;

    public CythonBuiltinType(List<String> tokens) {
        String baseName = INT_NAME;
        boolean isDefaultName = true;
        Sign sign = Sign.DEFAULT;
        Longness longness = Longness.DEFAULT;
        boolean isPointer = false;
        for (String token : tokens) {
            if (UNSIGNED_NAME.equals(token)) {
                sign = Sign.UNSIGNED;
                continue;
            }
            if (SIGNED_NAME.equals(token)) {
                sign = Sign.SIGNED;
                continue;
            }
            if (SHORT_NAME.equals(token)) {
                longness = Longness.SHORT;
                continue;
            }
            if (LONG_NAME.equals(token)) {
                longness = Longness.LONG;
                continue;
            }
            if ("*".equals(token)) {
                isPointer = true;
                continue;
            }
            if (!CythonNames.BASE_C_TYPES.contains((Object)token) && !CythonNames.BASE_CYTHON_TYPES.contains((Object)token)) continue;
            isDefaultName = false;
            baseName = token;
        }
        this.myBaseName = baseName;
        this.myIsDefaultName = isDefaultName;
        this.mySign = sign;
        this.myLongness = longness;
        this.myIsPointer = isPointer;
    }

    public List<? extends RatedResolveResult> resolveMember(@NotNull String name, @Nullable PyExpression location, @NotNull AccessDirection direction, @NotNull PyResolveContext resolveContext) {
        PyType type;
        if (name == null) {
            CythonBuiltinType.$$$reportNull$$$0(0);
        }
        if (direction == null) {
            CythonBuiltinType.$$$reportNull$$$0(1);
        }
        if (resolveContext == null) {
            CythonBuiltinType.$$$reportNull$$$0(2);
        }
        return (type = CythonTypeChecker.convertType(this, resolveContext.getTypeEvalContext())) != this && type != null ? type.resolveMember(name, location, direction, resolveContext) : Collections.emptyList();
    }

    public Object[] getCompletionVariants(String completionPrefix, PsiElement location, ProcessingContext context) {
        return ArrayUtilRt.EMPTY_OBJECT_ARRAY;
    }

    @NonNls
    public String getName() {
        String sign = switch (this.mySign) {
            case Sign.UNSIGNED -> "unsigned ";
            case Sign.SIGNED -> "signed ";
            default -> "";
        };
        String longness = switch (this.myLongness) {
            case Longness.SHORT -> "short ";
            case Longness.LONG -> "long ";
            default -> "";
        };
        String pointer = this.myIsPointer ? "*" : "";
        return (sign + longness + (this.myIsDefaultName ? "" : this.myBaseName)).trim() + pointer;
    }

    public boolean isBuiltin() {
        return true;
    }

    public void assertValid(String message) {
    }

    public String getBaseName() {
        return this.myBaseName;
    }

    public Longness getLongness() {
        return this.myLongness;
    }

    public Sign getSign() {
        return this.mySign;
    }

    public boolean isPointer() {
        return this.myIsPointer;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "name";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "direction";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "resolveContext";
                break;
            }
        }
        objectArray[1] = "com/intellij/python/pro/cython/types/CythonBuiltinType";
        objectArray[2] = "resolveMember";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum Sign {
        DEFAULT,
        UNSIGNED,
        SIGNED;

    }

    public static enum Longness {
        DEFAULT,
        SHORT,
        LONG;

    }
}

