/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jinja.model;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JinjaClosingTagTools {
    private static final Pattern END_TAG_PATTERN = Pattern.compile("^end_?(.+)$");

    private JinjaClosingTagTools() {
    }

    @Nullable
    public static String getOpeningByClosing(@NotNull String closingTagName) {
        Matcher matcher;
        if (closingTagName == null) {
            JinjaClosingTagTools.$$$reportNull$$$0(0);
        }
        if ((matcher = END_TAG_PATTERN.matcher(closingTagName)).find()) {
            return matcher.group(1);
        }
        return null;
    }

    @NotNull
    public static String getOpeningByClosingIfPossible(@NotNull String closingTagName) {
        String result;
        if (closingTagName == null) {
            JinjaClosingTagTools.$$$reportNull$$$0(1);
        }
        String string = (result = JinjaClosingTagTools.getOpeningByClosing(closingTagName)) != null ? result : closingTagName;
        if (string == null) {
            JinjaClosingTagTools.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public static String suggestClosingTag(@NotNull String openingTagName) {
        if (openingTagName == null) {
            JinjaClosingTagTools.$$$reportNull$$$0(3);
        }
        String string = openingTagName.contains("_") ? String.format("end_%s", openingTagName) : String.format("end%s", openingTagName);
        if (string == null) {
            JinjaClosingTagTools.$$$reportNull$$$0(4);
        }
        return string;
    }

    public static boolean isStartsWithEndPrefix(@NotNull String tagName) {
        if (tagName == null) {
            JinjaClosingTagTools.$$$reportNull$$$0(5);
        }
        return END_TAG_PATTERN.matcher(tagName).matches();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "closingTagName";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jinja/model/JinjaClosingTagTools";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "openingTagName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tagName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jinja/model/JinjaClosingTagTools";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOpeningByClosingIfPossible";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "suggestClosingTag";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getOpeningByClosing";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getOpeningByClosingIfPossible";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "suggestClosingTag";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isStartsWithEndPrefix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4 -> new IllegalStateException(string);
        };
    }
}

