/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.util;

import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.flow.psi.impl.FlowJSTypePredicateImpl;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBinaryExpression;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSConditionalExpression;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSParenthesizedExpression;
import com.intellij.lang.javascript.psi.JSPostfixExpression;
import com.intellij.lang.javascript.psi.JSPrefixExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSThisExpression;
import com.intellij.lang.javascript.psi.JSYieldExpression;
import com.intellij.lang.javascript.psi.ecma6.ES6TaggedTemplateExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptAsExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptCastExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JSParenthesesUtils {
    private static final int PARENTHESIZED_PRECEDENCE = 0;
    public static final int LITERAL_PRECEDENCE = 0;
    public static final int METHOD_CALL_PRECEDENCE = 1;
    public static final int POSTFIX_PRECEDENCE = 2;
    public static final int PREFIX_PRECEDENCE = 3;
    public static final int TYPE_CAST_PRECEDENCE = 4;
    public static final int EXPONENTIATION_PRECEDENCE = 5;
    public static final int MULTIPLICATIVE_PRECEDENCE = 6;
    private static final int ADDITIVE_PRECEDENCE = 7;
    public static final int SHIFT_PRECEDENCE = 8;
    private static final int RELATIONAL_PRECEDENCE = 9;
    private static final int EQUALITY_PRECEDENCE = 10;
    private static final int BINARY_AND_PRECEDENCE = 11;
    private static final int BINARY_XOR_PRECEDENCE = 12;
    private static final int BINARY_OR_PRECEDENCE = 13;
    public static final int AND_PRECEDENCE = 14;
    public static final int OR_PRECEDENCE = 15;
    public static final int CONDITIONAL_PRECEDENCE = 16;
    private static final int ASSIGNMENT_PRECEDENCE = 17;
    private static final int NUM_PRECEDENCES = 18;
    private static final Map<IElementType, Integer> s_binaryOperatorPrecedence = new HashMap<IElementType, Integer>(18);

    private JSParenthesesUtils() {
    }

    public static int getPrecedence(JSExpression exp) {
        if (exp instanceof JSThisExpression || exp instanceof JSLiteralExpression || exp instanceof JSObjectLiteralExpression || exp instanceof JSArrayLiteralExpression || exp instanceof JSIndexedPropertyAccessExpression) {
            return 0;
        }
        if (exp instanceof JSReferenceExpression) {
            return ((JSReferenceExpression)exp).getQualifier() != null ? 1 : 0;
        }
        if (exp instanceof JSCallExpression || exp instanceof ES6TaggedTemplateExpression) {
            return 1;
        }
        if (exp instanceof JSPrefixExpression || exp instanceof JSYieldExpression) {
            return 3;
        }
        if (exp instanceof JSPostfixExpression) {
            return 2;
        }
        if (exp instanceof TypeScriptCastExpression) {
            return exp instanceof TypeScriptAsExpression ? 9 : 4;
        }
        if (exp instanceof JSAssignmentExpression) {
            return 17;
        }
        if (exp instanceof JSBinaryExpression) {
            return JSParenthesesUtils.precedenceForBinaryOperator(((JSBinaryExpression)exp).getOperationSign());
        }
        if (exp instanceof JSConditionalExpression) {
            return 16;
        }
        if (exp instanceof JSParenthesizedExpression) {
            return 0;
        }
        return -1;
    }

    public static boolean needsParenthesesAsQualifier(@NotNull JSExpression expression) {
        if (expression == null) {
            JSParenthesesUtils.$$$reportNull$$$0(0);
        }
        return JSParenthesesUtils.getPrecedence(expression) > 1 || expression instanceof JSLiteralExpression && ((JSLiteralExpression)expression).isNumericLiteral();
    }

    private static int precedenceForBinaryOperator(IElementType sign) {
        if (s_binaryOperatorPrecedence.containsKey(sign)) {
            return s_binaryOperatorPrecedence.get(sign);
        }
        return 17;
    }

    @Nullable
    public static JSExpression stripParentheses(@Nullable JSExpression exp) {
        return JSUtils.unparenthesize(exp);
    }

    public static String getParenthesized(@NotNull JSExpression expression, int precedence) {
        if (expression == null) {
            JSParenthesesUtils.$$$reportNull$$$0(1);
        }
        return JSParenthesesUtils.getPrecedence(expression) > precedence ? "(" + expression.getText() + ")" : expression.getText();
    }

    public static boolean canRemoveParentheses(@NotNull JSParenthesizedExpression expression) {
        int childPrecedence;
        JSElement parent;
        block14: {
            block13: {
                PsiElement expressionParent;
                if (expression == null) {
                    JSParenthesesUtils.$$$reportNull$$$0(2);
                }
                if (!((expressionParent = expression.getParent()) instanceof JSElement)) break block13;
                parent = (JSElement)expressionParent;
                if (!(expressionParent instanceof FlowJSTypePredicateImpl)) break block14;
            }
            return false;
        }
        JSExpression body = expression.getInnerExpression();
        if (body == null) {
            return false;
        }
        if (!(parent instanceof JSExpression)) {
            for (PsiElement child = body.getFirstChild(); child != null; child = child.getFirstChild()) {
                if (child instanceof JSFunctionExpression) {
                    return false;
                }
                if (!(child instanceof JSObjectLiteralExpression)) continue;
                return false;
            }
            return true;
        }
        if (body instanceof JSParenthesizedExpression) {
            return true;
        }
        if (parent instanceof JSFunctionExpression) {
            return !JSPsiImplUtils.parensAroundArrowFunctionBodyRequired(body);
        }
        int parentPrecedence = JSParenthesesUtils.getPrecedence((JSExpression)parent);
        if (parentPrecedence > (childPrecedence = JSParenthesesUtils.getPrecedence(body))) {
            return !(body instanceof JSFunctionExpression);
        }
        if (parentPrecedence == childPrecedence && parent instanceof JSBinaryExpression) {
            JSBinaryExpression binaryExpression = (JSBinaryExpression)parent;
            if (body instanceof JSBinaryExpression) {
                IElementType parentOperator = binaryExpression.getOperationSign();
                IElementType childOperator = ((JSBinaryExpression)body).getOperationSign();
                JSExpression lhs = binaryExpression.getLOperand();
                return lhs != null && lhs.equals(expression) && Objects.equals(parentOperator, childOperator);
            }
        }
        return false;
    }

    public static boolean needsParenthesis(@NotNull JSExpression oldExpr, @NotNull JSExpression newExpr) {
        if (oldExpr == null) {
            JSParenthesesUtils.$$$reportNull$$$0(3);
        }
        if (newExpr == null) {
            JSParenthesesUtils.$$$reportNull$$$0(4);
        }
        return JSParenthesesUtils.needsParenthesis(oldExpr, newExpr, false);
    }

    public static boolean needsParenthesis(@NotNull JSExpression oldExpr, @NotNull JSExpression newExpr, boolean relaxForMinus) {
        int parentPrecedence;
        if (oldExpr == null) {
            JSParenthesesUtils.$$$reportNull$$$0(5);
        }
        if (newExpr == null) {
            JSParenthesesUtils.$$$reportNull$$$0(6);
        }
        int precedence = JSParenthesesUtils.getPrecedence(newExpr);
        PsiElement parent = oldExpr.getParent();
        if (!(parent instanceof JSExpression)) {
            return false;
        }
        if (parent instanceof JSFunctionExpression) {
            return newExpr instanceof JSObjectLiteralExpression && ((JSFunctionExpression)parent).isShorthandArrowFunction() && JSPsiImplUtils.tryGetArrowFunctionReturnExpression((JSFunction)parent) == oldExpr;
        }
        if (parent instanceof JSArrayLiteralExpression || parent instanceof JSIndexedPropertyAccessExpression && ((JSIndexedPropertyAccessExpression)parent).getIndexExpression() == oldExpr) {
            return false;
        }
        if (parent instanceof JSParenthesizedExpression) {
            return false;
        }
        if (newExpr instanceof JSFunctionExpression && (parent instanceof JSCallExpression || parent instanceof JSReferenceExpression)) {
            return true;
        }
        if (parent instanceof JSDefinitionExpression) {
            parent = parent.getParent();
        }
        if (precedence > (parentPrecedence = JSParenthesesUtils.getPrecedence((JSExpression)parent))) {
            return true;
        }
        if (precedence == parentPrecedence && parent instanceof JSBinaryExpression) {
            IElementType operationSign = ((JSBinaryExpression)parent).getOperationSign();
            if (oldExpr != ((JSBinaryExpression)parent).getROperand()) {
                return false;
            }
            if (!JSTokenTypes.ASSOC_OPERATIONS.contains(operationSign)) {
                return true;
            }
            IElementType newOperationSign = ((JSBinaryExpression)newExpr).getOperationSign();
            if (relaxForMinus && operationSign == JSTokenTypes.PLUS && newOperationSign == JSTokenTypes.MINUS) {
                return false;
            }
            return newOperationSign != operationSign;
        }
        return false;
    }

    static {
        s_binaryOperatorPrecedence.put(JSTokenTypes.PLUS, 7);
        s_binaryOperatorPrecedence.put(JSTokenTypes.MINUS, 7);
        s_binaryOperatorPrecedence.put(JSTokenTypes.MULT, 6);
        s_binaryOperatorPrecedence.put(JSTokenTypes.DIV, 6);
        s_binaryOperatorPrecedence.put(JSTokenTypes.PERC, 6);
        s_binaryOperatorPrecedence.put(JSTokenTypes.MULTMULT, 5);
        s_binaryOperatorPrecedence.put(JSTokenTypes.ANDAND, 14);
        s_binaryOperatorPrecedence.put(JSTokenTypes.OROR, 15);
        s_binaryOperatorPrecedence.put(JSTokenTypes.QUEST_QUEST, 15);
        s_binaryOperatorPrecedence.put(JSTokenTypes.AND, 11);
        s_binaryOperatorPrecedence.put(JSTokenTypes.OR, 13);
        s_binaryOperatorPrecedence.put(JSTokenTypes.XOR, 12);
        s_binaryOperatorPrecedence.put(JSTokenTypes.LTLT, 8);
        s_binaryOperatorPrecedence.put(JSTokenTypes.GTGT, 8);
        s_binaryOperatorPrecedence.put(JSTokenTypes.GTGTGT, 8);
        s_binaryOperatorPrecedence.put(JSTokenTypes.GT, 9);
        s_binaryOperatorPrecedence.put(JSTokenTypes.GE, 9);
        s_binaryOperatorPrecedence.put(JSTokenTypes.LT, 9);
        s_binaryOperatorPrecedence.put(JSTokenTypes.LE, 9);
        s_binaryOperatorPrecedence.put(JSTokenTypes.INSTANCEOF_KEYWORD, 9);
        s_binaryOperatorPrecedence.put(JSTokenTypes.IN_KEYWORD, 9);
        s_binaryOperatorPrecedence.put(JSTokenTypes.EQEQ, 10);
        s_binaryOperatorPrecedence.put(JSTokenTypes.EQEQEQ, 10);
        s_binaryOperatorPrecedence.put(JSTokenTypes.NE, 10);
        s_binaryOperatorPrecedence.put(JSTokenTypes.NEQEQ, 10);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldExpr";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newExpr";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/psi/util/JSParenthesesUtils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "needsParenthesesAsQualifier";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getParenthesized";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "canRemoveParentheses";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "needsParenthesis";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

