/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.psi.types;

import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeTextBuilder;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.JSTypeWithIncompleteSubstitution;
import com.intellij.lang.javascript.psi.types.JSNamedTypeFactory;
import com.intellij.lang.javascript.psi.types.JSRecursiveTypeVisitor;
import com.intellij.lang.javascript.psi.types.JSTypeBaseImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSerializer;
import com.intellij.lang.javascript.psi.types.JSTypeSource;
import com.intellij.lang.javascript.psi.types.primitives.JSBooleanType;
import com.intellij.util.Function;
import com.intellij.util.ProcessingContext;
import java.text.CharacterIterator;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TypeScriptTypePredicateTypeImpl
extends JSTypeBaseImpl
implements JSNamespace,
JSTypeWithIncompleteSubstitution {
    private final int myParameterIndex;
    private final boolean myIsAssertion;
    @Nullable
    private final JSType myType;
    @Nullable
    private final String myParameterName;

    public TypeScriptTypePredicateTypeImpl(@Nullable JSType guardType, @NotNull JSTypeSource source, @Nullable String parameterName, int parameterIndex, boolean isAssertion) {
        if (source == null) {
            TypeScriptTypePredicateTypeImpl.$$$reportNull$$$0(0);
        }
        super(source);
        this.myType = guardType;
        this.myParameterName = parameterName;
        this.myParameterIndex = parameterIndex;
        this.myIsAssertion = isAssertion;
    }

    public TypeScriptTypePredicateTypeImpl(@NotNull JSTypeSource source, @NotNull CharacterIterator inputStream) {
        if (source == null) {
            TypeScriptTypePredicateTypeImpl.$$$reportNull$$$0(1);
        }
        if (inputStream == null) {
            TypeScriptTypePredicateTypeImpl.$$$reportNull$$$0(2);
        }
        super(source);
        this.myType = JSTypeSerializer.NULLABLE_TYPE_SERIALIZER.read(source, inputStream);
        boolean hasParameterName = JSTypeSerializer.readBoolean(inputStream);
        this.myParameterName = hasParameterName ? JSTypeSerializer.readString(inputStream) : null;
        this.myParameterIndex = JSTypeSerializer.readInt(inputStream);
        this.myIsAssertion = JSTypeSerializer.readBoolean(inputStream);
    }

    @Override
    public void serialize(@NotNull StringBuilder outputStream) {
        if (outputStream == null) {
            TypeScriptTypePredicateTypeImpl.$$$reportNull$$$0(3);
        }
        super.serialize(outputStream);
        JSTypeSerializer.NULLABLE_TYPE_SERIALIZER.write(this.myType, outputStream);
        boolean hasParameterName = this.myParameterName != null;
        JSTypeSerializer.writeBoolean(hasParameterName, outputStream);
        if (hasParameterName) {
            JSTypeSerializer.writeString(this.myParameterName, outputStream);
        }
        JSTypeSerializer.writeInt(this.myParameterIndex, outputStream);
        JSTypeSerializer.writeBoolean(this.myIsAssertion, outputStream);
    }

    @Nullable
    public JSType getGuardType() {
        return this.myType;
    }

    @Nullable
    public String getParameterName() {
        return this.myParameterName;
    }

    public boolean isThisParameter() {
        return "this".equals(this.myParameterName);
    }

    public boolean isAssertion() {
        return this.myIsAssertion;
    }

    public int getParameterIndex() {
        return this.myParameterIndex;
    }

    @Override
    protected void buildTypeTextImpl(@NotNull JSType.TypeTextFormat format, @NotNull JSTypeTextBuilder builder2) {
        if (format == null) {
            TypeScriptTypePredicateTypeImpl.$$$reportNull$$$0(4);
        }
        if (builder2 == null) {
            TypeScriptTypePredicateTypeImpl.$$$reportNull$$$0(5);
        }
        if (format == JSType.TypeTextFormat.PRESENTABLE) {
            builder2.append(this.myIsAssertion ? "void" : "boolean");
            return;
        }
        if (this.myIsAssertion) {
            builder2.append("asserts ");
        }
        String paramName = this.myParameterName == null ? "param" : this.myParameterName;
        builder2.append(paramName);
        if (this.myType != null) {
            builder2.append(" is ");
            this.myType.buildTypeText(format, builder2);
        }
    }

    @Override
    protected int hashCodeImpl() {
        return Objects.hash(this.myType, this.myParameterName, this.myParameterIndex, this.myIsAssertion);
    }

    @Override
    protected boolean isDirectlyAssignableTypeImpl(@NotNull JSType elementType, @NotNull ProcessingContext processingContext) {
        if (elementType == null) {
            TypeScriptTypePredicateTypeImpl.$$$reportNull$$$0(6);
        }
        if (processingContext == null) {
            TypeScriptTypePredicateTypeImpl.$$$reportNull$$$0(7);
        }
        if (elementType instanceof TypeScriptTypePredicateTypeImpl && this.isDirectlyAssignableTypeForPredicate((TypeScriptTypePredicateTypeImpl)elementType, processingContext)) {
            return true;
        }
        if (elementType instanceof JSBooleanType && (this.isJavaScript() || elementType.isJavaScript() || !this.isSourceStrict() || !elementType.isSourceStrict())) {
            return true;
        }
        return super.isDirectlyAssignableTypeImpl(elementType, processingContext);
    }

    private boolean isDirectlyAssignableTypeForPredicate(@NotNull TypeScriptTypePredicateTypeImpl typePredicateType, @Nullable ProcessingContext processingContext) {
        if (typePredicateType == null) {
            TypeScriptTypePredicateTypeImpl.$$$reportNull$$$0(8);
        }
        if (typePredicateType.myIsAssertion != this.myIsAssertion) {
            return false;
        }
        JSType rGuardType = typePredicateType.getGuardType();
        JSType lGuardType = this.getGuardType();
        if (typePredicateType.getParameterIndex() != this.getParameterIndex()) {
            return false;
        }
        if (rGuardType == null || lGuardType == null) {
            return rGuardType == lGuardType;
        }
        return lGuardType.isDirectlyAssignableType(rGuardType, processingContext);
    }

    @Override
    public boolean isEquivalentToWithSameClass(@NotNull JSType type2, @Nullable ProcessingContext processingContext, boolean allowResolve) {
        if (type2 == null) {
            TypeScriptTypePredicateTypeImpl.$$$reportNull$$$0(9);
        }
        TypeScriptTypePredicateTypeImpl typePredicateType = (TypeScriptTypePredicateTypeImpl)type2;
        if (typePredicateType.myIsAssertion != this.myIsAssertion) {
            return false;
        }
        JSType lGuardType = this.getGuardType();
        JSType rGuardType = typePredicateType.getGuardType();
        if (typePredicateType.getParameterIndex() == this.getParameterIndex()) {
            if (lGuardType == null || rGuardType == null) {
                return lGuardType == typePredicateType;
            }
            return lGuardType.isEquivalentTo(rGuardType, processingContext, allowResolve);
        }
        return false;
    }

    @Override
    public void acceptChildren(@NotNull JSRecursiveTypeVisitor visitor) {
        if (visitor == null) {
            TypeScriptTypePredicateTypeImpl.$$$reportNull$$$0(10);
        }
        if (this.myType != null) {
            this.myType.accept(visitor);
        }
    }

    @Override
    @NotNull
    protected JSType copyTypeHierarchy(@NotNull Function<? super JSType, ? extends JSType> childTransform, @NotNull JSTypeSource newSource) {
        JSType newGuardType;
        JSType oldGuard;
        if (childTransform == null) {
            TypeScriptTypePredicateTypeImpl.$$$reportNull$$$0(11);
        }
        if (newSource == null) {
            TypeScriptTypePredicateTypeImpl.$$$reportNull$$$0(12);
        }
        if ((oldGuard = this.getGuardType()) == (newGuardType = JSTypeUtils.transformTypeHierarchySafe(oldGuard, childTransform))) {
            TypeScriptTypePredicateTypeImpl typeScriptTypePredicateTypeImpl = this;
            if (typeScriptTypePredicateTypeImpl == null) {
                TypeScriptTypePredicateTypeImpl.$$$reportNull$$$0(13);
            }
            return typeScriptTypePredicateTypeImpl;
        }
        return new TypeScriptTypePredicateTypeImpl(newGuardType, newSource, this.getParameterName(), this.getParameterIndex(), this.isAssertion());
    }

    @NotNull
    public JSType asSimpleType() {
        JSTypeBaseImpl jSTypeBaseImpl = this.myIsAssertion ? JSNamedTypeFactory.createVoidType(this.getSource()) : JSNamedTypeFactory.createBooleanPrimitiveType(this.getSource());
        if (jSTypeBaseImpl == null) {
            TypeScriptTypePredicateTypeImpl.$$$reportNull$$$0(14);
        }
        return jSTypeBaseImpl;
    }

    @Override
    @NotNull
    protected JSType copyWithNewSource(@NotNull JSTypeSource source) {
        if (source == null) {
            TypeScriptTypePredicateTypeImpl.$$$reportNull$$$0(15);
        }
        return new TypeScriptTypePredicateTypeImpl(this.getGuardType(), source, this.getParameterName(), this.getParameterIndex(), this.isAssertion());
    }

    @Override
    @Nullable
    public JSQualifiedName getQualifiedName() {
        return JSQualifiedNameImpl.create(this.myIsAssertion ? "void" : "Boolean", null);
    }

    @Override
    public boolean hasQualifiedName() {
        return true;
    }

    @Override
    @NotNull
    public JSType substituteCompletely() {
        JSType jSType = this.asSimpleType();
        if (jSType == null) {
            TypeScriptTypePredicateTypeImpl.$$$reportNull$$$0(16);
        }
        return jSType;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 13, 14, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inputStream";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processingContext";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typePredicateType";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childTransform";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newSource";
                break;
            }
            case 13: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/psi/types/TypeScriptTypePredicateTypeImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/psi/types/TypeScriptTypePredicateTypeImpl";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "copyTypeHierarchy";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "asSimpleType";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "substituteCompletely";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "buildTypeTextImpl";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeImpl";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isDirectlyAssignableTypeForPredicate";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isEquivalentToWithSameClass";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "acceptChildren";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "copyTypeHierarchy";
                break;
            }
            case 13: 
            case 14: 
            case 16: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "copyWithNewSource";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 13, 14, 16 -> new IllegalStateException(string);
        };
    }
}

