/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.flow;

import com.intellij.codeInsight.highlighting.TooltipLinkHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LogicalNavigationLinkHandler
extends TooltipLinkHandler {
    public static final String NAVIGATION_PREFIX = "#navigation_logical/";
    private static final Logger LOG = Logger.getInstance(LogicalNavigationLinkHandler.class);
    private static final Pattern PATTERN = Pattern.compile("^(.+):(\\d+):(\\d+)$");

    public boolean handleLink(@NotNull String refSuffix, @NotNull Editor editor) {
        Project project;
        if (refSuffix == null) {
            LogicalNavigationLinkHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            LogicalNavigationLinkHandler.$$$reportNull$$$0(1);
        }
        if ((project = editor.getProject()) == null) {
            return true;
        }
        OpenFileDescriptor descriptor = LogicalNavigationLinkHandler.createDescriptorFromLink(refSuffix, project);
        if (descriptor != null) {
            descriptor.navigate(true);
        }
        return true;
    }

    public static void navigate(@NotNull String link, @NotNull Project project) {
        if (link == null) {
            LogicalNavigationLinkHandler.$$$reportNull$$$0(2);
        }
        if (project == null) {
            LogicalNavigationLinkHandler.$$$reportNull$$$0(3);
        }
        if (!link.startsWith(NAVIGATION_PREFIX)) {
            throw new IllegalArgumentException(link);
        }
        OpenFileDescriptor descriptor = LogicalNavigationLinkHandler.createDescriptorFromLink(link.substring(NAVIGATION_PREFIX.length()), project);
        if (descriptor != null) {
            descriptor.navigate(true);
        }
    }

    @Nullable
    private static OpenFileDescriptor createDescriptorFromLink(@NotNull String refSuffix, @NotNull Project project) {
        int column;
        int line;
        Matcher matcher;
        if (refSuffix == null) {
            LogicalNavigationLinkHandler.$$$reportNull$$$0(4);
        }
        if (project == null) {
            LogicalNavigationLinkHandler.$$$reportNull$$$0(5);
        }
        if (!(matcher = PATTERN.matcher(refSuffix)).matches() || matcher.groupCount() != 3) {
            LOG.error("Malformed suffix: " + refSuffix);
            return null;
        }
        String path2 = matcher.group(1);
        VirtualFile vFile = LocalFileSystem.getInstance().findFileByPath(path2);
        if (vFile == null) {
            LOG.error("Unknown file: " + path2);
            return null;
        }
        try {
            line = Integer.parseInt(matcher.group(2));
            column = Integer.parseInt(matcher.group(3));
        }
        catch (NumberFormatException e) {
            LOG.error("Malformed suffix: " + refSuffix);
            return null;
        }
        if (line <= 0 || column <= 0) {
            return null;
        }
        return new OpenFileDescriptor(project, vFile, line - 1, column - 1);
    }

    @NotNull
    public static String buildUri(String path2, int line, int column) {
        String string = NAVIGATION_PREFIX + path2 + ":" + line + ":" + column;
        if (string == null) {
            LogicalNavigationLinkHandler.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refSuffix";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "link";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/flow/LogicalNavigationLinkHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/flow/LogicalNavigationLinkHandler";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "buildUri";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "handleLink";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "navigate";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createDescriptorFromLink";
                break;
            }
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }
}

