/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.packageJson.documentation;

import com.intellij.javascript.nodejs.documentation.NodeJsPackageDocumentation;
import com.intellij.javascript.nodejs.packageJson.InstalledPackageVersion;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.text.SemVer;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VersionRangeDocBuilder {
    @NotNull
    private final Project myProject;
    @Nullable
    private final VirtualFile myPackageJson;
    private final String myPackageName;
    private final InstalledPackageVersion myPkg;
    private final SemVer myFromInclusiveVersion;
    private final SemVer myToExclusiveVersion;

    public VersionRangeDocBuilder(@NotNull Project project, @Nullable VirtualFile packageJson, @NotNull String packageName, @Nullable InstalledPackageVersion pkg, @NotNull String versionRange) {
        if (project == null) {
            VersionRangeDocBuilder.$$$reportNull$$$0(0);
        }
        if (packageName == null) {
            VersionRangeDocBuilder.$$$reportNull$$$0(1);
        }
        if (versionRange == null) {
            VersionRangeDocBuilder.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.myPackageJson = packageJson;
        this.myPackageName = packageName;
        this.myPkg = pkg;
        Pair<SemVer, SemVer> range = VersionRangeDocBuilder.findTildeRange(versionRange);
        if (range == null) {
            range = VersionRangeDocBuilder.findCaretRange(versionRange);
        }
        this.myFromInclusiveVersion = range != null ? (SemVer)range.first : null;
        this.myToExclusiveVersion = range != null ? (SemVer)range.second : null;
    }

    @Nullable
    private static Pair<SemVer, SemVer> findTildeRange(@NotNull String versionRange) {
        if (versionRange == null) {
            VersionRangeDocBuilder.$$$reportNull$$$0(3);
        }
        if (!versionRange.startsWith("~")) {
            return null;
        }
        Pair<SemVer, Integer> pair = VersionRangeDocBuilder.normalize(versionRange.substring(1));
        return pair == null ? null : VersionRangeDocBuilder.findTildeRange((SemVer)pair.first, (Integer)pair.second);
    }

    private static Pair<SemVer, SemVer> findTildeRange(@NotNull SemVer fromVersion, int components) {
        if (fromVersion == null) {
            VersionRangeDocBuilder.$$$reportNull$$$0(4);
        }
        if (fromVersion.getParsedVersion().equals(fromVersion.getRawVersion())) {
            return new Pair((Object)fromVersion, (Object)VersionRangeDocBuilder.version(fromVersion.getMajor() + (components == 1 ? 1 : 0), fromVersion.getMinor() + (components != 1 ? 1 : 0), 0));
        }
        return new Pair((Object)fromVersion, (Object)VersionRangeDocBuilder.version(fromVersion.getMajor(), fromVersion.getMinor() + 1, 0));
    }

    @Nullable
    private static Pair<SemVer, SemVer> findCaretRange(@NotNull String versionRange) {
        if (versionRange == null) {
            VersionRangeDocBuilder.$$$reportNull$$$0(5);
        }
        if (!versionRange.startsWith("^")) {
            return null;
        }
        Pair<SemVer, Integer> pair = VersionRangeDocBuilder.normalize(versionRange.substring(1));
        return pair == null ? null : VersionRangeDocBuilder.findCaretRange((SemVer)pair.first, (Integer)pair.second);
    }

    @NotNull
    private static Pair<SemVer, SemVer> findCaretRange(SemVer fromVersion, int components) {
        SemVer toVersion = fromVersion.getMajor() != 0 || components == 1 ? VersionRangeDocBuilder.version(fromVersion.getMajor() + 1, 0, 0) : (fromVersion.getMinor() != 0 || components == 2 ? VersionRangeDocBuilder.version(0, fromVersion.getMinor() + 1, 0) : VersionRangeDocBuilder.version(0, 0, fromVersion.getPatch() + 1));
        return new Pair((Object)fromVersion, (Object)toVersion);
    }

    @Nullable
    private static Pair<SemVer, Integer> normalize(@NotNull String versionStr) {
        int components;
        SemVer ver;
        if (versionStr == null) {
            VersionRangeDocBuilder.$$$reportNull$$$0(6);
        }
        return (ver = SemVer.parseFromText((String)(versionStr = (String)versionStr + StringUtil.repeat((String)".0", (int)(3 - (components = Math.min(3, StringUtil.countChars((CharSequence)versionStr, (char)'.') + 1))))))) == null ? null : new Pair((Object)ver, (Object)components);
    }

    @NotNull
    private static SemVer version(int major, int minor, int patch) {
        SemVer semVer = Objects.requireNonNull(SemVer.parseFromText((String)(major + "." + minor + "." + patch)));
        if (semVer == null) {
            VersionRangeDocBuilder.$$$reportNull$$$0(7);
        }
        return semVer;
    }

    @Nullable
    @Nls
    public String buildQuickNavigateInfo() {
        String versionRangeHint = this.buildVersionRangeHint();
        Ref<SemVer> latestRef = NodeJsPackageDocumentation.getLatest(this.myProject, this.myPackageJson, this.myPackageName, null);
        Object[] objectArray = new Object[4];
        objectArray[0] = this.myPkg == null ? 0 : (this.myPkg.getVersion() == null ? 1 : 2);
        Object object = objectArray[1] = this.myPkg != null && this.myPkg.getVersion() != null ? this.myPkg.getVersion().getRawVersion() : null;
        objectArray[2] = latestRef == null ? 0 : (latestRef.isNull() ? 1 : 2);
        objectArray[3] = latestRef != null && latestRef.get() != null ? ((SemVer)latestRef.get()).getRawVersion() : null;
        String installedAndLatest = JavaScriptBundle.message("package.version.range.info", objectArray);
        if (versionRangeHint != null) {
            return versionRangeHint + " (" + installedAndLatest + ")";
        }
        return installedAndLatest;
    }

    @Nullable
    @Nls
    private String buildVersionRangeHint() {
        if (this.myFromInclusiveVersion != null && this.myToExclusiveVersion != null) {
            int choice = 0;
            if (this.myToExclusiveVersion.getMajor() == this.myFromInclusiveVersion.getMajor() + 1 && this.myToExclusiveVersion.getMinor() == 0 && this.myToExclusiveVersion.getPatch() == 0) {
                choice = 1;
            } else if (this.myToExclusiveVersion.getMajor() == this.myFromInclusiveVersion.getMajor() && this.myToExclusiveVersion.getMinor() == this.myFromInclusiveVersion.getMinor() + 1 && this.myToExclusiveVersion.getPatch() == 0) {
                choice = 2;
            }
            return JavaScriptBundle.message("package.version.range.hint", choice, this.myFromInclusiveVersion.getRawVersion(), this.myToExclusiveVersion.getRawVersion());
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionRange";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromVersion";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionStr";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/packageJson/documentation/VersionRangeDocBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/packageJson/documentation/VersionRangeDocBuilder";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "version";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findTildeRange";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findCaretRange";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "normalize";
                break;
            }
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7 -> new IllegalStateException(string);
        };
    }
}

