/*
 * Decompiled with CFR 0.152.
 */
package ru.adelf.idea.dotenv.kotlin;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import ru.adelf.idea.dotenv.java.JavaEnvironmentClasses;
import ru.adelf.idea.dotenv.models.KeyUsagePsiElement;

final class KotlinPsiHelper {
    KotlinPsiHelper() {
    }

    static boolean isEnvStringLiteral(KtLiteralStringTemplateEntry literal) {
        if (!(literal.getParent() instanceof KtStringTemplateExpression)) {
            return false;
        }
        PsiElement parent = literal.getParent().getParent();
        if (parent instanceof KtValueArgument) {
            return KotlinPsiHelper.isMethodCallLiteral((KtValueArgument)parent);
        }
        if (parent instanceof KtContainerNode) {
            return KotlinPsiHelper.isArrayAccessLiteral((KtContainerNode)parent);
        }
        return false;
    }

    private static boolean isMethodCallLiteral(KtValueArgument valueArgument) {
        PsiElement valueArgumentList = valueArgument.getParent();
        if (!(valueArgumentList instanceof KtValueArgumentList)) {
            return false;
        }
        if (((KtValueArgumentList)valueArgumentList).getArguments().get(0) != valueArgument) {
            return false;
        }
        PsiElement methodCall = valueArgumentList.getParent();
        if (!(methodCall instanceof KtCallExpression)) {
            return false;
        }
        return KotlinPsiHelper.isEnvMethodCall((KtCallExpression)methodCall);
    }

    private static boolean isArrayAccessLiteral(KtContainerNode containerNode) {
        if (!(containerNode.getParent() instanceof KtArrayAccessExpression)) {
            return false;
        }
        return KotlinPsiHelper.isEnvArrayAccess((KtArrayAccessExpression)containerNode.getParent());
    }

    static boolean isEnvMethodCall(KtCallExpression methodCallExpression) {
        KtExpression nameElement = methodCallExpression.getCalleeExpression();
        if (!(nameElement instanceof KtNameReferenceExpression)) {
            return false;
        }
        String methodName = ((KtNameReferenceExpression)nameElement).getReferencedName();
        if (JavaEnvironmentClasses.isDirectMethodCall(methodName)) {
            return true;
        }
        List<String> classNames = JavaEnvironmentClasses.getClassNames(methodName);
        if (classNames == null) {
            return false;
        }
        return KotlinPsiHelper.checkReferences((PsiElement)methodCallExpression.getCalleeExpression(), classNames);
    }

    @Nullable
    static KeyUsagePsiElement getKeyUsageFromCall(@NotNull KtCallExpression expression) {
        if (expression == null) {
            KotlinPsiHelper.$$$reportNull$$$0(0);
        }
        if (!KotlinPsiHelper.isEnvMethodCall(expression)) {
            return null;
        }
        KtValueArgumentList valueArgumentList = expression.getValueArgumentList();
        if (valueArgumentList == null || valueArgumentList.getArguments().isEmpty()) {
            return null;
        }
        KtValueArgument valueArgument = (KtValueArgument)valueArgumentList.getArguments().get(0);
        if (valueArgument == null) {
            return null;
        }
        return KotlinPsiHelper.getKeyUsageFromStringTemplate(valueArgument.getFirstChild());
    }

    static boolean isEnvArrayAccess(KtArrayAccessExpression arrayAccess) {
        List<String> classNames = JavaEnvironmentClasses.getClassNames("get");
        if (classNames == null) {
            return false;
        }
        return KotlinPsiHelper.checkReferences((PsiElement)arrayAccess, classNames);
    }

    @Nullable
    static KeyUsagePsiElement getKeyUsageFromArrayAccess(@NotNull KtArrayAccessExpression expression) {
        if (expression == null) {
            KotlinPsiHelper.$$$reportNull$$$0(1);
        }
        if (!KotlinPsiHelper.isEnvArrayAccess(expression)) {
            return null;
        }
        List indexExpressions = expression.getIndexExpressions();
        if (indexExpressions.isEmpty()) {
            return null;
        }
        return KotlinPsiHelper.getKeyUsageFromStringTemplate((PsiElement)indexExpressions.get(0));
    }

    @Nullable
    private static KeyUsagePsiElement getKeyUsageFromStringTemplate(PsiElement element) {
        if (!(element instanceof KtStringTemplateExpression)) {
            return null;
        }
        KtLiteralStringTemplateEntry literal = (KtLiteralStringTemplateEntry)PsiTreeUtil.findChildOfType((PsiElement)element, KtLiteralStringTemplateEntry.class);
        if (literal == null) {
            return null;
        }
        return new KeyUsagePsiElement(literal.getText(), (PsiElement)literal);
    }

    private static boolean checkReferences(PsiElement element, List<String> classNames) {
        return Arrays.stream(element.getReferences()).anyMatch(psiReference -> {
            PsiElement method = psiReference.resolve();
            if (method instanceof KtNamedFunction) {
                KtClass ktClass = (KtClass)PsiTreeUtil.getParentOfType((PsiElement)method, KtClass.class);
                return ktClass != null && classNames.contains(ktClass.getName());
            }
            if (method instanceof PsiMethod) {
                PsiClass psiClass = ((PsiMethod)method).getContainingClass();
                return psiClass != null && classNames.contains(psiClass.getName());
            }
            return false;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "expression";
        objectArray2[1] = "ru/adelf/idea/dotenv/kotlin/KotlinPsiHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getKeyUsageFromCall";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getKeyUsageFromArrayAccess";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

