/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.bridge;

import java.awt.geom.Dimension2D;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.batik.anim.dom.AnimatedAttributeListener;
import org.apache.batik.anim.dom.SVGDOMImplementation;
import org.apache.batik.anim.dom.SVGOMDocument;
import org.apache.batik.anim.dom.SVGOMElement;
import org.apache.batik.anim.dom.SVGStylableElement;
import org.apache.batik.bridge.AbstractGraphicsNodeBridge;
import org.apache.batik.bridge.Bridge;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.BridgeExtension;
import org.apache.batik.bridge.DocumentBridge;
import org.apache.batik.bridge.DocumentLoader;
import org.apache.batik.bridge.ErrorConstants;
import org.apache.batik.bridge.FocusManager;
import org.apache.batik.bridge.FontFamilyResolver;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.InterruptedBridgeException;
import org.apache.batik.bridge.SVGBridgeExtension;
import org.apache.batik.bridge.SVGDocumentBridge;
import org.apache.batik.bridge.SVGUtilities;
import org.apache.batik.bridge.TextPainter;
import org.apache.batik.bridge.URIResolver;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentViewport;
import org.apache.batik.bridge.Viewport;
import org.apache.batik.bridge.svg12.SVG12BridgeContext;
import org.apache.batik.bridge.svg12.SVG12BridgeExtension;
import org.apache.batik.css.engine.CSSContext;
import org.apache.batik.css.engine.CSSEngine;
import org.apache.batik.css.engine.CSSEngineListener;
import org.apache.batik.css.engine.CSSEngineUserAgent;
import org.apache.batik.css.engine.SystemColorSupport;
import org.apache.batik.css.engine.value.Value;
import org.apache.batik.dom.events.NodeEventTarget;
import org.apache.batik.dom.svg.SVGContext;
import org.apache.batik.gvt.GraphicsNode;
import org.apache.batik.util.CleanerThread;
import org.apache.batik.util.ParsedURL;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;
import org.w3c.dom.svg.SVGDocument;

public class BridgeContext
implements ErrorConstants,
CSSContext {
    protected Document document;
    private boolean isSVG12;
    private GVTBuilder gvtBuilder;
    private Map fontFamilyMap;
    private final Map<Object, Viewport> viewportMap = new WeakHashMap<Object, Viewport>();
    private List viewportStack = new LinkedList();
    protected UserAgent userAgent;
    private Map elementNodeMap;
    private Map nodeElementMap;
    private Map namespaceURIMap;
    private Bridge defaultBridge;
    private Set reservedNamespaceSet;
    private Map elementDataMap;
    private DocumentLoader documentLoader;
    private Dimension2D documentSize;
    private TextPainter textPainter;
    private static final int STATIC = 0;
    public static final int DYNAMIC = 2;
    private int dynamicStatus = 0;
    private BridgeContext primaryContext;
    protected Set eventListenerSet = new HashSet();
    private EventListener domCharacterDataModifiedEventListener;
    private EventListener domAttrModifiedEventListener;
    private EventListener domNodeInsertedEventListener;
    private EventListener domNodeRemovedEventListener;
    private CSSEngineListener cssPropertiesChangedListener;
    private AnimatedAttributeListener animatedAttributeListener;
    protected FocusManager focusManager;
    protected List<BridgeExtension> extensions = null;

    protected BridgeContext() {
    }

    public final FontFamilyResolver getFontFamilyResolver() {
        return this.userAgent.getFontFamilyResolver();
    }

    public BridgeContext(UserAgent userAgent) {
        this(userAgent, new DocumentLoader(userAgent));
    }

    public BridgeContext(UserAgent userAgent, DocumentLoader documentLoader) {
        this.userAgent = userAgent;
        this.viewportMap.put(userAgent, new UserAgentViewport(userAgent));
        this.documentLoader = documentLoader;
    }

    protected void finalize() {
        if (this.primaryContext != null) {
            this.dispose();
        }
    }

    public BridgeContext createSubBridgeContext(SVGOMDocument newDoc) {
        CSSEngine eng = newDoc.getCSSEngine();
        if (eng != null) {
            BridgeContext subCtx = (BridgeContext)newDoc.getCSSEngine().getCSSContext();
            return subCtx;
        }
        BridgeContext subCtx = this.createBridgeContext(newDoc);
        subCtx.primaryContext = this.primaryContext != null ? this.primaryContext : this;
        subCtx.dynamicStatus = this.dynamicStatus;
        subCtx.setGVTBuilder(this.getGVTBuilder());
        subCtx.setTextPainter(this.getTextPainter());
        subCtx.setDocument(newDoc);
        subCtx.initializeDocument(newDoc);
        return subCtx;
    }

    private BridgeContext createBridgeContext(SVGOMDocument doc) {
        if (doc.isSVG12()) {
            return new SVG12BridgeContext(this.getUserAgent(), this.getDocumentLoader());
        }
        return new BridgeContext(this.getUserAgent(), this.getDocumentLoader());
    }

    protected void initializeDocument(Document document) {
        SVGOMDocument doc = (SVGOMDocument)document;
        CSSEngine eng = doc.getCSSEngine();
        if (eng == null) {
            SVGDOMImplementation impl = (SVGDOMImplementation)doc.getImplementation();
            eng = impl.createCSSEngine(doc, this);
            eng.setCSSEngineUserAgent(new CSSEngineUserAgentWrapper(this.userAgent));
            doc.setCSSEngine(eng);
            eng.setMedia(this.userAgent.getMedia());
            String uri = this.userAgent.getUserStyleSheetURI();
            if (uri != null) {
                try {
                    ParsedURL url = new ParsedURL(uri);
                    eng.setUserAgentStyleSheet(eng.parseStyleSheet(url, "all"));
                }
                catch (Exception e) {
                    this.userAgent.displayError(e);
                }
            }
            eng.setAlternateStyleSheet(this.userAgent.getAlternateStyleSheet());
        }
    }

    @Override
    public CSSEngine getCSSEngineForElement(Element e) {
        SVGOMDocument doc = (SVGOMDocument)e.getOwnerDocument();
        return doc.getCSSEngine();
    }

    private void setTextPainter(TextPainter textPainter) {
        this.textPainter = textPainter;
    }

    public TextPainter getTextPainter() {
        return this.textPainter;
    }

    public Document getDocument() {
        return this.document;
    }

    protected void setDocument(Document document) {
        if (this.document != document) {
            this.fontFamilyMap = null;
        }
        this.document = document;
        this.isSVG12 = ((SVGOMDocument)document).isSVG12();
        this.registerSVGBridges();
    }

    public Map getFontFamilyMap() {
        if (this.fontFamilyMap == null) {
            this.fontFamilyMap = new HashMap();
        }
        return this.fontFamilyMap;
    }

    public void setElementData(Node n, Object data) {
        if (this.elementDataMap == null) {
            this.elementDataMap = new WeakHashMap();
        }
        this.elementDataMap.put(n, new SoftReference<Object>(data));
    }

    public Object getElementData(Node n) {
        if (this.elementDataMap == null) {
            return null;
        }
        Object o = this.elementDataMap.get(n);
        if (o == null) {
            return null;
        }
        SoftReference sr = (SoftReference)o;
        if ((o = sr.get()) == null) {
            this.elementDataMap.remove(n);
        }
        return o;
    }

    public UserAgent getUserAgent() {
        return this.userAgent;
    }

    public GVTBuilder getGVTBuilder() {
        return this.gvtBuilder;
    }

    protected void setGVTBuilder(GVTBuilder gvtBuilder) {
        this.gvtBuilder = gvtBuilder;
    }

    public FocusManager getFocusManager() {
        return this.focusManager;
    }

    public DocumentLoader getDocumentLoader() {
        return this.documentLoader;
    }

    public Dimension2D getDocumentSize() {
        return this.documentSize;
    }

    protected void setDocumentSize(Dimension2D d) {
        this.documentSize = d;
    }

    @Override
    public boolean isDynamic() {
        return this.dynamicStatus == 2;
    }

    @Override
    public boolean isInteractive() {
        return this.dynamicStatus != 0;
    }

    public void setDynamicState(int status) {
        this.dynamicStatus = status;
    }

    public void setDynamic(boolean dynamic) {
        if (dynamic) {
            this.setDynamicState(2);
        } else {
            this.setDynamicState(0);
        }
    }

    public boolean isSVG12() {
        return this.isSVG12;
    }

    public BridgeContext getPrimaryBridgeContext() {
        if (this.primaryContext != null) {
            return this.primaryContext;
        }
        return this;
    }

    public URIResolver createURIResolver(SVGDocument doc, DocumentLoader dl) {
        return new URIResolver(doc, dl);
    }

    public Node getReferencedNode(Element e, String uri) {
        try {
            SVGDocument document = (SVGDocument)e.getOwnerDocument();
            URIResolver ur = this.createURIResolver(document, this.documentLoader);
            Node ref = ur.getNode(uri, e);
            if (ref == null) {
                throw new BridgeException(this, e, "uri.badTarget", new Object[]{uri});
            }
            SVGOMDocument refDoc = (SVGOMDocument)(ref.getNodeType() == 9 ? ref : ref.getOwnerDocument());
            if (refDoc != document) {
                this.createSubBridgeContext(refDoc);
            }
            return ref;
        }
        catch (MalformedURLException ex) {
            throw new BridgeException(this, e, ex, "uri.malformed", new Object[]{uri});
        }
        catch (InterruptedIOException ex) {
            throw new InterruptedBridgeException();
        }
        catch (IOException ex) {
            throw new BridgeException(this, e, ex, "uri.io", new Object[]{uri});
        }
        catch (SecurityException ex) {
            throw new BridgeException(this, e, ex, "uri.unsecure", new Object[]{uri});
        }
    }

    public Element getReferencedElement(Element e, String uri) {
        Node ref = this.getReferencedNode(e, uri);
        if (ref != null && ref.getNodeType() != 1) {
            throw new BridgeException(this, e, "uri.referenceDocument", new Object[]{uri});
        }
        return (Element)ref;
    }

    public Viewport getViewport(Element e) {
        if (this.viewportStack != null) {
            if (this.viewportStack.size() == 0) {
                return this.viewportMap.get(this.userAgent);
            }
            return (Viewport)this.viewportStack.get(0);
        }
        e = SVGUtilities.getParentElement(e);
        while (e != null) {
            Viewport viewport = this.viewportMap.get(e);
            if (viewport != null) {
                return viewport;
            }
            e = SVGUtilities.getParentElement(e);
        }
        return this.viewportMap.get(this.userAgent);
    }

    public void openViewport(Element e, Viewport viewport) {
        this.viewportMap.put(e, viewport);
        if (this.viewportStack == null) {
            this.viewportStack = new LinkedList();
        }
        this.viewportStack.add(0, viewport);
    }

    public void removeViewport(Element e) {
        this.viewportMap.remove(e);
    }

    public void closeViewport(Element e) {
        this.viewportStack.remove(0);
        if (this.viewportStack.size() == 0) {
            this.viewportStack = null;
        }
    }

    public void bind(Node node, GraphicsNode gn) {
        if (this.elementNodeMap == null) {
            this.elementNodeMap = new WeakHashMap();
            this.nodeElementMap = new WeakHashMap();
        }
        this.elementNodeMap.put(node, new SoftReference<GraphicsNode>(gn));
        this.nodeElementMap.put(gn, new SoftReference<Node>(node));
    }

    public void unbind(Node node) {
        if (this.elementNodeMap == null) {
            return;
        }
        GraphicsNode gn = null;
        SoftReference sr = (SoftReference)this.elementNodeMap.get(node);
        if (sr != null) {
            gn = (GraphicsNode)sr.get();
        }
        this.elementNodeMap.remove(node);
        if (gn != null) {
            this.nodeElementMap.remove(gn);
        }
    }

    public GraphicsNode getGraphicsNode(Node node) {
        SoftReference sr;
        if (this.elementNodeMap != null && (sr = (SoftReference)this.elementNodeMap.get(node)) != null) {
            return (GraphicsNode)sr.get();
        }
        return null;
    }

    public Element getElement(GraphicsNode gn) {
        Node n;
        SoftReference sr;
        if (this.nodeElementMap != null && (sr = (SoftReference)this.nodeElementMap.get(gn)) != null && (n = (Node)sr.get()).getNodeType() == 1) {
            return (Element)n;
        }
        return null;
    }

    public DocumentBridge getDocumentBridge() {
        return new SVGDocumentBridge();
    }

    public Bridge getBridge(Element element) {
        if (this.namespaceURIMap == null || element == null) {
            return null;
        }
        String localName = element.getLocalName();
        String namespaceURI = element.getNamespaceURI();
        namespaceURI = namespaceURI == null ? "" : namespaceURI;
        return this.getBridge(namespaceURI, localName);
    }

    public Bridge getBridge(String namespaceURI, String localName) {
        HashMap localNameMap;
        Bridge bridge = null;
        if (this.namespaceURIMap != null && (localNameMap = (HashMap)this.namespaceURIMap.get(namespaceURI)) != null) {
            bridge = (Bridge)localNameMap.get(localName);
        }
        if (!(bridge != null || this.reservedNamespaceSet != null && this.reservedNamespaceSet.contains(namespaceURI))) {
            bridge = this.defaultBridge;
        }
        if (this.isDynamic()) {
            return bridge == null ? null : bridge.getInstance();
        }
        return bridge;
    }

    private void putBridge(String namespaceURI, String localName, Bridge bridge) {
        HashMap<String, Bridge> localNameMap;
        if (!namespaceURI.equals(bridge.getNamespaceURI()) || !localName.equals(bridge.getLocalName())) {
            throw new RuntimeException("Invalid Bridge: " + namespaceURI + "/" + bridge.getNamespaceURI() + " " + localName + "/" + bridge.getLocalName() + " " + bridge.getClass());
        }
        if (this.namespaceURIMap == null) {
            this.namespaceURIMap = new HashMap();
        }
        if ((localNameMap = (HashMap<String, Bridge>)this.namespaceURIMap.get(namespaceURI)) == null) {
            localNameMap = new HashMap<String, Bridge>();
            this.namespaceURIMap.put(namespaceURI, localNameMap);
        }
        localNameMap.put(localName, bridge);
    }

    public void putBridge(Bridge bridge) {
        this.putBridge(bridge.getNamespaceURI(), bridge.getLocalName(), bridge);
    }

    public void setDefaultBridge(Bridge bridge) {
        this.defaultBridge = bridge;
    }

    public void putReservedNamespaceURI(String namespaceURI) {
        if (namespaceURI == null) {
            namespaceURI = "";
        }
        if (this.reservedNamespaceSet == null) {
            this.reservedNamespaceSet = new HashSet();
        }
        this.reservedNamespaceSet.add(namespaceURI);
    }

    protected void removeDOMListeners() {
        SVGOMDocument doc = (SVGOMDocument)this.document;
        doc.removeEventListenerNS("http://www.w3.org/2001/xml-events", "DOMAttrModified", this.domAttrModifiedEventListener, true);
        doc.removeEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeInserted", this.domNodeInsertedEventListener, true);
        doc.removeEventListenerNS("http://www.w3.org/2001/xml-events", "DOMNodeRemoved", this.domNodeRemovedEventListener, true);
        doc.removeEventListenerNS("http://www.w3.org/2001/xml-events", "DOMCharacterDataModified", this.domCharacterDataModifiedEventListener, true);
        doc.removeAnimatedAttributeListener(this.animatedAttributeListener);
        CSSEngine cssEngine = doc.getCSSEngine();
        if (cssEngine != null) {
            cssEngine.removeCSSEngineListener(this.cssPropertiesChangedListener);
            cssEngine.dispose();
            doc.setCSSEngine(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storeEventListener(EventTarget t, String s, EventListener l, boolean b) {
        Set set = this.eventListenerSet;
        synchronized (set) {
            this.eventListenerSet.add(new EventListenerMememto(t, s, l, b, this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void storeEventListenerNS(EventTarget t, String n, String s, EventListener l, boolean b) {
        Set set = this.eventListenerSet;
        synchronized (set) {
            this.eventListenerSet.add(new EventListenerMememto(t, n, s, l, b, this));
        }
    }

    protected void clearChildContexts() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.clearChildContexts();
        Set set = this.eventListenerSet;
        synchronized (set) {
            for (Object anEventListenerSet : this.eventListenerSet) {
                EventListenerMememto m = (EventListenerMememto)anEventListenerSet;
                NodeEventTarget et = m.getTarget();
                EventListener el = m.getListener();
                boolean uc = m.getUseCapture();
                String t = m.getEventType();
                boolean n = m.getNamespaced();
                if (et == null || el == null || t == null) continue;
                if (n) {
                    String ns = m.getNamespaceURI();
                    et.removeEventListenerNS(ns, t, el, uc);
                    continue;
                }
                et.removeEventListener(t, el, uc);
            }
        }
        if (this.document != null) {
            this.removeDOMListeners();
            AbstractGraphicsNodeBridge.disposeTree(this.document);
        }
        if (this.focusManager != null) {
            this.focusManager.dispose();
        }
        if (this.elementDataMap != null) {
            this.elementDataMap.clear();
        }
        if (this.nodeElementMap != null) {
            this.nodeElementMap.clear();
        }
        if (this.elementNodeMap != null) {
            this.elementNodeMap.clear();
        }
    }

    protected static SVGContext getSVGContext(Node node) {
        if (node instanceof SVGOMElement) {
            return ((SVGOMElement)node).getSVGContext();
        }
        if (node instanceof SVGOMDocument) {
            return ((SVGOMDocument)node).getSVGContext();
        }
        return null;
    }

    @Override
    public Value getSystemColor(String ident) {
        return SystemColorSupport.getSystemColor(ident);
    }

    @Override
    public Value getDefaultFontFamily() {
        SVGOMDocument doc = (SVGOMDocument)this.document;
        SVGStylableElement root = (SVGStylableElement)((Object)doc.getRootElement());
        String str = this.userAgent.getDefaultFontFamily();
        return doc.getCSSEngine().parsePropertyValue(root, "font-family", str);
    }

    @Override
    public float getLighterFontWeight(float f) {
        return this.userAgent.getLighterFontWeight(f);
    }

    @Override
    public float getBolderFontWeight(float f) {
        return this.userAgent.getBolderFontWeight(f);
    }

    @Override
    public float getPixelUnitToMillimeter() {
        return this.userAgent.getPixelUnitToMillimeter();
    }

    @Override
    public float getPixelToMillimeter() {
        return this.getPixelUnitToMillimeter();
    }

    @Override
    public float getMediumFontSize() {
        return this.userAgent.getMediumFontSize();
    }

    @Override
    public float getBlockWidth(Element elt) {
        return this.getViewport(elt).getWidth();
    }

    @Override
    public float getBlockHeight(Element elt) {
        return this.getViewport(elt).getHeight();
    }

    @Override
    public void checkLoadExternalResource(ParsedURL resourceURL, ParsedURL docURL) throws SecurityException {
        this.userAgent.checkLoadExternalResource(resourceURL, docURL);
    }

    private boolean checkInteractiveElement(Element e) {
        return this.checkInteractiveElement((SVGDocument)e.getOwnerDocument(), e);
    }

    private boolean checkInteractiveElement(SVGDocument doc, Element e) {
        String tag = e.getLocalName();
        if ("a".equals(tag)) {
            return true;
        }
        if ("title".equals(tag)) {
            return e.getParentNode() != doc.getRootElement();
        }
        if ("desc".equals(tag)) {
            return e.getParentNode() != doc.getRootElement();
        }
        if ("cursor".equals(tag)) {
            return true;
        }
        if (e.getAttribute("cursor").length() > 0) {
            return true;
        }
        String svg_ns = "http://www.w3.org/2000/svg";
        for (Node n = e.getFirstChild(); n != null; n = n.getNextSibling()) {
            Element child;
            if (n.getNodeType() != 1 || !"http://www.w3.org/2000/svg".equals((child = (Element)n).getNamespaceURI()) || !this.checkInteractiveElement(child)) continue;
            return true;
        }
        return false;
    }

    private void registerSVGBridges() {
        String version = ((SVGOMDocument)this.document).getRootElement().getAttributeNS(null, "version");
        SVGBridgeExtension svgBE = version.isEmpty() || version.equals("1.0") || version.equals("1.1") ? new SVGBridgeExtension() : new SVG12BridgeExtension();
        svgBE.registerTags(this);
    }

    public static final class CSSEngineUserAgentWrapper
    implements CSSEngineUserAgent {
        UserAgent ua;

        CSSEngineUserAgentWrapper(UserAgent ua) {
            this.ua = ua;
        }

        @Override
        public void displayError(Exception ex) {
            this.ua.displayError(ex);
        }

        @Override
        public void displayMessage(String message) {
            this.ua.displayMessage(message);
        }
    }

    protected static class EventListenerMememto {
        public SoftReference target;
        public SoftReference listener;
        public boolean useCapture;
        public String namespaceURI;
        public String eventType;
        public boolean namespaced;

        public EventListenerMememto(EventTarget t, String s, EventListener l, boolean b, BridgeContext ctx) {
            Set set = ctx.eventListenerSet;
            this.target = new SoftReferenceMememto(t, this, set);
            this.listener = new SoftReferenceMememto(l, this, set);
            this.eventType = s;
            this.useCapture = b;
        }

        public EventListenerMememto(EventTarget t, String n, String s, EventListener l, boolean b, BridgeContext ctx) {
            this(t, s, l, b, ctx);
            this.namespaceURI = n;
            this.namespaced = true;
        }

        public EventListener getListener() {
            return (EventListener)this.listener.get();
        }

        public NodeEventTarget getTarget() {
            return (NodeEventTarget)this.target.get();
        }

        public boolean getUseCapture() {
            return this.useCapture;
        }

        public String getNamespaceURI() {
            return this.namespaceURI;
        }

        public String getEventType() {
            return this.eventType;
        }

        public boolean getNamespaced() {
            return this.namespaced;
        }
    }

    public static class SoftReferenceMememto
    extends CleanerThread.SoftReferenceCleared {
        Object mememto;
        Set set;

        SoftReferenceMememto(Object ref, Object mememto, Set set) {
            super(ref);
            this.mememto = mememto;
            this.set = set;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cleared() {
            Set set = this.set;
            synchronized (set) {
                this.set.remove(this.mememto);
                this.mememto = null;
                this.set = null;
            }
        }
    }
}

