/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.completion;

import com.intellij.codeInsight.completion.AddSpaceInsertHandler;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.PlainPrefixMatcher;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.execution.common.RequestExecutionSupport;
import com.intellij.httpClient.http.request.HttpRequestPsiUtils;
import com.intellij.httpClient.http.request.HttpRequestVariableSubstitutor;
import com.intellij.httpClient.http.request.completion.HttpIncludeCompletionProvider;
import com.intellij.httpClient.http.request.completion.HttpRunOverrideCompletionProvider;
import com.intellij.httpClient.http.request.completion.HttpRunRequestNameCompletionProvider;
import com.intellij.httpClient.http.request.completion.HttpSuffixInsertHandler;
import com.intellij.httpClient.http.request.completion.provider.HttpVariableCompletionProviderKt;
import com.intellij.httpClient.http.request.completion.provider.HttpVariableInMessageBodyCompletionProvider;
import com.intellij.httpClient.http.request.completion.provider.ProviderType;
import com.intellij.httpClient.http.request.documentation.comments.HttpDocCommentElementTypes;
import com.intellij.httpClient.http.request.documentation.comments.psi.HttpDocComment;
import com.intellij.httpClient.http.request.documentation.comments.psi.HttpDocCommentTag;
import com.intellij.httpClient.http.request.documentation.comments.psi.HttpDocCommentTagDescriptor;
import com.intellij.httpClient.http.request.documentation.comments.psi.HttpDocCommentTags;
import com.intellij.httpClient.http.request.dynamicVariables.AuthDynamicVariables;
import com.intellij.httpClient.http.request.environment.HttpClientEnvironmentsProvider;
import com.intellij.httpClient.http.request.environment.HttpClientSelectedEnvironments;
import com.intellij.httpClient.http.request.index.HttpRequestHeaderIndex;
import com.intellij.httpClient.http.request.lexer.HttpClientExtensionLexemesDefaultManager;
import com.intellij.httpClient.http.request.psi.HttpDynamicVariable;
import com.intellij.httpClient.http.request.psi.HttpDynamicVariableExpr;
import com.intellij.httpClient.http.request.psi.HttpDynamicVariableReference;
import com.intellij.httpClient.http.request.psi.HttpHeaderField;
import com.intellij.httpClient.http.request.psi.HttpHeaderFieldName;
import com.intellij.httpClient.http.request.psi.HttpHeaderFieldValue;
import com.intellij.httpClient.http.request.psi.HttpHost;
import com.intellij.httpClient.http.request.psi.HttpPathAbsolute;
import com.intellij.httpClient.http.request.psi.HttpPreRequestHandler;
import com.intellij.httpClient.http.request.psi.HttpQueryParameter;
import com.intellij.httpClient.http.request.psi.HttpRequest;
import com.intellij.httpClient.http.request.psi.HttpRequestBlock;
import com.intellij.httpClient.http.request.psi.HttpRequestElementTypes;
import com.intellij.httpClient.http.request.psi.HttpRequestTarget;
import com.intellij.httpClient.http.request.psi.HttpRunBlock;
import com.intellij.httpClient.http.request.psi.HttpScheme;
import com.intellij.httpClient.http.request.psi.HttpVariable;
import com.intellij.json.JsonUtil;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.microservices.http.HttpHeaderDocumentation;
import com.intellij.microservices.http.HttpHeadersDictionary;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.CollectionFactory;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpRequestCompletionContributor
extends CompletionContributor {
    private static final TokenSet IDENTIFIER_PREDECESSOR = TokenSet.create((IElementType[])new IElementType[]{HttpRequestElementTypes.IDENTIFIER, HttpRequestElementTypes.LBRACES, HttpRequestElementTypes.DYNAMIC_SIGN, HttpDocCommentElementTypes.UNKNOWN});
    private static final IsLastChildCondition isLastChild = new IsLastChildCondition();

    public HttpRequestCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent(HttpHeaderFieldName.class), new HttpHeaderFieldNamesProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent(HttpHeaderFieldValue.class), new HttpHeaderFieldValuesProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement((IElementType)HttpRequestElementTypes.HOST_VALUE).withParent(HttpHost.class), new HttpMethodsProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement((IElementType)HttpRequestElementTypes.HOST_VALUE).withParent(HttpHost.class), new HttpIncludeCompletionProvider());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().withParent(HttpDynamicVariableReference.class), HttpVariableCompletionProviderKt.getProvider(ProviderType.DYNAMIC_VARIABLE));
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement((IElementType)HttpRequestElementTypes.MESSAGE_TEXT), new HttpVariableInMessageBodyCompletionProvider());
        this.extend(CompletionType.BASIC, StandardPatterns.or((ElementPattern[])new ElementPattern[]{PlatformPatterns.psiElement((IElementType)HttpRequestElementTypes.HTTP_REQUEST_NAME), PlatformPatterns.psiElement((IElementType)HttpRequestElementTypes.INCLUDE_HTTP_FILE_PATH)}), new HttpRunRequestNameCompletionProvider());
        PatternCondition<PsiElement> runOverrideCompletionCondition = new PatternCondition<PsiElement>("Run override completion condition"){

            public boolean accepts(@NotNull PsiElement o, ProcessingContext context2) {
                HttpRunBlock runParent;
                if (o == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((runParent = (HttpRunBlock)PsiTreeUtil.getParentOfType((PsiElement)o, HttpRunBlock.class)) == null) {
                    return false;
                }
                IElementType type = o.getNode().getElementType();
                PsiElement elementToCheck = type == HttpRequestElementTypes.IDENTIFIER ? o : o.getParent();
                PsiElement leftBrace = PsiTreeUtil.findSiblingBackward((PsiElement)elementToCheck, (IElementType)HttpRequestElementTypes.LPAR, null);
                return leftBrace != null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/httpClient/http/request/completion/HttpRequestCompletionContributor$1", "accepts"));
            }
        };
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().with((PatternCondition)runOverrideCompletionCondition), new HttpRunOverrideCompletionProvider());
        PsiElementPattern.Capture inTag = (PsiElementPattern.Capture)PlatformPatterns.psiElement((IElementType)HttpDocCommentElementTypes.UNKNOWN).withParent(HttpDocCommentTag.class);
        PsiElementPattern.Capture inComment = (PsiElementPattern.Capture)PlatformPatterns.psiElement((IElementType)HttpDocCommentElementTypes.COMMENT_TEXT).withParent(HttpDocComment.class);
        this.extend(CompletionType.BASIC, StandardPatterns.or((ElementPattern[])new ElementPattern[]{inComment, inTag}), new HttpDocCommentsCompletionProvider());
        this.extend(CompletionType.BASIC, StandardPatterns.or((ElementPattern[])new ElementPattern[]{PlatformPatterns.psiElement((IElementType)HttpRequestElementTypes.MESSAGE_TEXT), PlatformPatterns.psiElement((IElementType)TokenType.WHITE_SPACE).afterLeaf((ElementPattern)PlatformPatterns.psiElement((IElementType)HttpRequestElementTypes.MESSAGE_TEXT))}), new HttpMessageBodySeparatorCompletion());
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().afterLeafSkipping(StandardPatterns.or((ElementPattern[])new ElementPattern[]{PlatformPatterns.psiElement(PsiErrorElement.class), PlatformPatterns.psiElement((IElementType)TokenType.BAD_CHARACTER)}), (ElementPattern)PlatformPatterns.psiElement((IElementType)HttpRequestElementTypes.MESSAGE_SEPARATOR)), new HttpMessageBodySeparatorOptionsCompletion());
        this.extend(CompletionType.BASIC, StandardPatterns.or((ElementPattern[])new ElementPattern[]{PlatformPatterns.psiElement((IElementType)HttpRequestElementTypes.DYNAMIC_VARIABLE_IDENTIFIER).with((PatternCondition)new PatternCondition<PsiElement>("Not Dynamic Variable Reference"){

            public boolean accepts(@NotNull PsiElement element, ProcessingContext context2) {
                PsiElement prev1;
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((prev1 = PsiTreeUtil.prevLeaf((PsiElement)element)) == null) {
                    return false;
                }
                PsiElement prev2 = PsiTreeUtil.prevLeaf((PsiElement)prev1);
                if (prev2 == null) {
                    return false;
                }
                PsiElement prev3 = PsiTreeUtil.prevLeaf((PsiElement)prev2);
                if (prev3 == null || prev3.getNode().getElementType() != HttpRequestElementTypes.DYNAMIC_VARIABLE_IDENTIFIER) {
                    return false;
                }
                if (!AuthDynamicVariables.isAuthVariable(prev3.getText())) {
                    return false;
                }
                return !(element.getParent() instanceof HttpDynamicVariableReference);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/httpClient/http/request/completion/HttpRequestCompletionContributor$2", "accepts"));
            }
        }), PlatformPatterns.psiElement((IElementType)HttpRequestElementTypes.STRING).withSuperParent(4, (ElementPattern)PlatformPatterns.psiElement(HttpDynamicVariable.class).withName(AuthDynamicVariables.AUTH_VARIABLES))}), new HttpDynamicVariablesAuthArgumentCompletion());
        PsiElementPattern.Capture requestWithHttpMethod = (PsiElementPattern.Capture)PlatformPatterns.psiElement(HttpRequest.class).with((PatternCondition)new PatternCondition<HttpRequest>("With HTTP method and no HTTP protocol"){

            public boolean accepts(@NotNull HttpRequest request, ProcessingContext context2) {
                if (request == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (HttpRequestPsiUtils.getProtocol(request) != null) {
                    return false;
                }
                return HttpClientExtensionLexemesDefaultManager.getMethods().contains(request.getHttpMethod());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/httpClient/http/request/completion/HttpRequestCompletionContributor$3", "accepts"));
            }
        });
        PsiElementPattern.Capture lastElementInQuery = (PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withParent((ElementPattern)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withElementType(TokenSet.create((IElementType[])new IElementType[]{HttpRequestElementTypes.QUERY_PARAMETER_KEY, HttpRequestElementTypes.QUERY_PARAMETER_VALUE}))).with((PatternCondition)isLastChild)).withParent((ElementPattern)PlatformPatterns.psiElement(HttpQueryParameter.class).with((PatternCondition)isLastChild)))).inside((ElementPattern)requestWithHttpMethod);
        PsiElementPattern.Capture lastSegment = (PsiElementPattern.Capture)((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement((IElementType)HttpRequestElementTypes.SEGMENT).with((PatternCondition)isLastChild)).withParent((ElementPattern)PlatformPatterns.psiElement(HttpPathAbsolute.class).with((PatternCondition)isLastChild))).inside((ElementPattern)requestWithHttpMethod);
        this.extend(CompletionType.BASIC, StandardPatterns.or((ElementPattern[])new ElementPattern[]{lastSegment, lastElementInQuery}), new HttpProtocolsCompletion());
    }

    public void beforeCompletion(@NotNull CompletionInitializationContext context2) {
        if (context2 == null) {
            HttpRequestCompletionContributor.$$$reportNull$$$0(0);
        }
        super.beforeCompletion(context2);
        PsiElement psiElement = context2.getFile().findElementAt(context2.getStartOffset());
        if (psiElement != null && HttpRequestPsiUtils.isOfType(psiElement, HttpRequestElementTypes.FIELD_VALUE)) {
            int startOffset = psiElement.getTextRange().getStartOffset();
            int separator = psiElement.getText().indexOf(",", context2.getStartOffset() - startOffset);
            context2.setReplacementOffset(separator < 0 ? psiElement.getTextRange().getEndOffset() : startOffset + separator);
        } else if (HttpRequestCompletionContributor.isDummyIdentifierCanExtendMessageBody(psiElement, context2) || HttpRequestCompletionContributor.isBeforePossiblePreRequestHandler(context2)) {
            context2.setDummyIdentifier("");
        } else {
            PsiElement parent;
            PsiElement psiElement2 = parent = psiElement != null ? psiElement.getParent() : null;
            if (parent instanceof HttpScheme) {
                context2.setReplacementOffset(HttpRequestCompletionContributor.getSchemeReplacementOffset(parent));
            }
            if (parent instanceof HttpHeaderFieldName || parent instanceof HttpHost) {
                context2.setReplacementOffset(parent.getTextRange().getEndOffset());
            }
            if (parent instanceof HttpRequestTarget) {
                context2.setReplacementOffset(parent.getTextRange().getStartOffset());
                if (context2.getStartOffset() > 0) {
                    PsiElement previousElementParent;
                    PsiElement previousElement = context2.getFile().findElementAt(context2.getStartOffset() - 1);
                    PsiElement psiElement3 = previousElementParent = previousElement != null ? previousElement.getParent() : null;
                    if (previousElementParent instanceof HttpScheme) {
                        context2.setReplacementOffset(HttpRequestCompletionContributor.getSchemeReplacementOffset(previousElementParent));
                    }
                }
            } else {
                PsiElement toReplace = HttpRequestCompletionContributor.getReplacedIdentifier(context2, psiElement, parent);
                if (toReplace != null) {
                    context2.setReplacementOffset(toReplace.getTextRange().getEndOffset());
                }
            }
        }
    }

    private static boolean isDummyIdentifierCanExtendMessageBody(@Nullable PsiElement element, @NotNull CompletionInitializationContext context2) {
        PsiElement prevLeaf;
        if (context2 == null) {
            HttpRequestCompletionContributor.$$$reportNull$$$0(1);
        }
        if (element instanceof PsiWhiteSpace && (prevLeaf = PsiTreeUtil.prevLeaf((PsiElement)element)) != null && HttpRequestPsiUtils.isOfType(prevLeaf, HttpRequestElementTypes.MESSAGE_TEXT)) {
            Document document = context2.getEditor().getDocument();
            return document.getLineNumber(prevLeaf.getTextRange().getEndOffset()) != document.getLineNumber(context2.getStartOffset());
        }
        return false;
    }

    private static boolean isBeforePossiblePreRequestHandler(@NotNull CompletionInitializationContext context2) {
        int currentIndex;
        HttpPreRequestHandler preHandler;
        if (context2 == null) {
            HttpRequestCompletionContributor.$$$reportNull$$$0(2);
        }
        if ((preHandler = (HttpPreRequestHandler)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)context2.getFile(), (int)context2.getStartOffset(), HttpPreRequestHandler.class, (boolean)false)) != null && preHandler.getTextRange().getStartOffset() == context2.getStartOffset()) {
            return true;
        }
        Document document = context2.getEditor().getDocument();
        CharSequence sequence = document.getCharsSequence();
        for (currentIndex = context2.getStartOffset(); currentIndex < sequence.length() && !StringUtil.isLineBreak((char)sequence.charAt(currentIndex)) && sequence.charAt(currentIndex) != '<'; ++currentIndex) {
        }
        if (currentIndex > sequence.length() - 1 || sequence.charAt(currentIndex) != '<') {
            return false;
        }
        int possibleOpenBracePosition = StringUtil.skipWhitespaceForward((CharSequence)sequence, (int)(currentIndex + 1));
        return possibleOpenBracePosition != sequence.length() && StringUtil.startsWith((CharSequence)sequence, (int)possibleOpenBracePosition, (CharSequence)"{%");
    }

    private static int getSchemeReplacementOffset(@NotNull PsiElement scheme) {
        PsiElement possibleSeparator;
        if (scheme == null) {
            HttpRequestCompletionContributor.$$$reportNull$$$0(3);
        }
        if ((possibleSeparator = scheme.getNextSibling()) != null && HttpRequestPsiUtils.isOfType(possibleSeparator, HttpRequestElementTypes.SCHEME_SEPARATOR)) {
            PsiElement possibleHost = possibleSeparator.getNextSibling();
            if (possibleHost != null && HttpRequestPsiUtils.isOfType(possibleHost, HttpRequestElementTypes.HOST)) {
                return possibleHost.getTextRange().getEndOffset();
            }
            return possibleSeparator.getTextRange().getEndOffset();
        }
        return scheme.getTextRange().getEndOffset();
    }

    @Nullable
    private static PsiElement getReplacedIdentifier(@NotNull CompletionInitializationContext context2, @Nullable PsiElement element, @Nullable PsiElement parent) {
        PsiElement prevElement;
        if (context2 == null) {
            HttpRequestCompletionContributor.$$$reportNull$$$0(4);
        }
        if (parent instanceof HttpVariable) {
            HttpVariable variable = (HttpVariable)parent;
            PsiElement toReplace = variable.getNameIdentifier();
            return toReplace != null ? toReplace : parent.getFirstChild();
        }
        if (parent instanceof HttpDynamicVariable) {
            HttpDynamicVariable variable = (HttpDynamicVariable)parent;
            HttpDynamicVariableExpr toReplace = variable.getDynamicVariableExpr();
            return toReplace != null ? toReplace : parent.getFirstChild().getNextSibling();
        }
        if (parent instanceof HttpDynamicVariableReference) {
            HttpDynamicVariableReference reference = (HttpDynamicVariableReference)parent;
            PsiElement toReplace = reference.getNameIdentifier();
            return toReplace != null ? toReplace : parent.getFirstChild();
        }
        if (element != null && HttpRequestPsiUtils.isOfTypes(element, TokenSet.create((IElementType[])new IElementType[]{HttpRequestElementTypes.IDENTIFIER, HttpRequestElementTypes.DYNAMIC_SIGN}))) {
            return element;
        }
        if (context2.getStartOffset() > 0 && (prevElement = context2.getFile().findElementAt(context2.getStartOffset() - 1)) != null && HttpRequestPsiUtils.isOfTypes(prevElement, IDENTIFIER_PREDECESSOR)) {
            return prevElement;
        }
        return null;
    }

    private static boolean isRequestStart(@NotNull CompletionParameters parameters) {
        if (parameters == null) {
            HttpRequestCompletionContributor.$$$reportNull$$$0(5);
        }
        HttpRequest request = (HttpRequest)PsiTreeUtil.getParentOfType((PsiElement)parameters.getPosition(), HttpRequest.class);
        HttpRequestTarget target = (HttpRequestTarget)PsiTreeUtil.getParentOfType((PsiElement)parameters.getPosition(), HttpRequestTarget.class);
        if (request == null || target == null) {
            return false;
        }
        int currentStartOffset = parameters.getPosition().getTextRange().getStartOffset();
        return request.getTextRange().getStartOffset() == currentStartOffset || request.getMethod() == null && target.getTextRange().getStartOffset() == currentStartOffset;
    }

    @NotNull
    private static CompletionResultSet updatePrefixMatcherByElement(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result2, @NotNull PsiElement element) {
        int endOffset;
        int startOffset;
        if (parameters == null) {
            HttpRequestCompletionContributor.$$$reportNull$$$0(6);
        }
        if (result2 == null) {
            HttpRequestCompletionContributor.$$$reportNull$$$0(7);
        }
        if (element == null) {
            HttpRequestCompletionContributor.$$$reportNull$$$0(8);
        }
        if ((startOffset = element.getTextRange().getStartOffset()) < (endOffset = parameters.getOffset())) {
            result2 = result2.withPrefixMatcher(parameters.getOriginalFile().getText().substring(startOffset, endOffset));
        }
        CompletionResultSet completionResultSet = result2;
        if (completionResultSet == null) {
            HttpRequestCompletionContributor.$$$reportNull$$$0(9);
        }
        return completionResultSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scheme";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/http/request/completion/HttpRequestCompletionContributor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/http/request/completion/HttpRequestCompletionContributor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "updatePrefixMatcherByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "beforeCompletion";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isDummyIdentifierCanExtendMessageBody";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isBeforePossiblePreRequestHandler";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSchemeReplacementOffset";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getReplacedIdentifier";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isRequestStart";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "updatePrefixMatcherByElement";
                break;
            }
            case 9: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 9 -> new IllegalStateException(string);
        };
    }

    private static class HttpHeaderFieldNamesProvider
    extends CompletionProvider<CompletionParameters> {
        private HttpHeaderFieldNamesProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context2, @NotNull CompletionResultSet result2) {
            if (parameters == null) {
                HttpHeaderFieldNamesProvider.$$$reportNull$$$0(0);
            }
            if (context2 == null) {
                HttpHeaderFieldNamesProvider.$$$reportNull$$$0(1);
            }
            if (result2 == null) {
                HttpHeaderFieldNamesProvider.$$$reportNull$$$0(2);
            }
            Set alreadyAdded = CollectionFactory.createCaseInsensitiveStringSet();
            for (HttpHeaderDocumentation header : HttpHeadersDictionary.getHeaders().values()) {
                result2.addElement(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((Object)header, (String)header.getName()).withStrikeoutness(header.isDeprecated()).withInsertHandler((InsertHandler)HttpSuffixInsertHandler.FIELD_SEPARATOR), (double)(header.isDeprecated() ? 100.0 : 200.0)));
                alreadyAdded.add(header.getName());
            }
            Project project = parameters.getOriginalFile().getProject();
            HttpHeaderField currentHeader = (HttpHeaderField)PsiTreeUtil.getParentOfType((PsiElement)CompletionUtil.getOriginalOrSelf((PsiElement)parameters.getPosition()), HttpHeaderField.class);
            String currentHeaderValue = currentHeader != null ? currentHeader.getName() : "";
            for (String header : HttpRequestHeaderIndex.getAllHeaders(project, currentHeaderValue)) {
                if (alreadyAdded.contains(header)) continue;
                result2.addElement(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((Object)header, (String)header).withInsertHandler((InsertHandler)HttpSuffixInsertHandler.FIELD_SEPARATOR), (double)100.0));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/intellij/httpClient/http/request/completion/HttpRequestCompletionContributor$HttpHeaderFieldNamesProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class HttpHeaderFieldValuesProvider
    extends CompletionProvider<CompletionParameters> {
        private static final List<String> myWebSocketProtocols = List.of("graphql-ws", "subscriptions-transport-ws", "aws-app-sync");

        private HttpHeaderFieldValuesProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context2, @NotNull CompletionResultSet result2) {
            HttpHeaderField header;
            String headerName;
            if (parameters == null) {
                HttpHeaderFieldValuesProvider.$$$reportNull$$$0(0);
            }
            if (context2 == null) {
                HttpHeaderFieldValuesProvider.$$$reportNull$$$0(1);
            }
            if (result2 == null) {
                HttpHeaderFieldValuesProvider.$$$reportNull$$$0(2);
            }
            String string = headerName = (header = (HttpHeaderField)PsiTreeUtil.getParentOfType((PsiElement)CompletionUtil.getOriginalOrSelf((PsiElement)parameters.getPosition()), HttpHeaderField.class)) != null ? header.getName() : null;
            if (StringUtil.isNotEmpty((String)headerName)) {
                Set alreadyAdded = CollectionFactory.createCaseInsensitiveStringSet();
                if (headerName.equalsIgnoreCase("Sec-WebSocket-Protocol")) {
                    for (String protocol : myWebSocketProtocols) {
                        alreadyAdded.add(protocol);
                        result2.addElement(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)protocol), (double)200.0));
                    }
                }
                for (String value2 : HttpHeadersDictionary.getHeaderValues((Project)header.getProject(), (String)headerName)) {
                    alreadyAdded.add(value2);
                    result2.addElement(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)value2), (double)200.0));
                }
                String currentHeaderValue = header.getValue(HttpRequestVariableSubstitutor.empty());
                for (String value3 : HttpRequestHeaderIndex.getAllHeaderValues(header.getProject(), headerName, currentHeaderValue)) {
                    if (alreadyAdded.contains(value3)) continue;
                    result2.addElement(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)value3), (double)100.0));
                }
                for (String option : HttpHeadersDictionary.getHeaderOptionNames((String)headerName)) {
                    result2.addElement((LookupElement)LookupElementBuilder.create((String)option).withInsertHandler((InsertHandler)HttpSuffixInsertHandler.HEADER_OPTION));
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/intellij/httpClient/http/request/completion/HttpRequestCompletionContributor$HttpHeaderFieldValuesProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class HttpMethodsProvider
    extends CompletionProvider<CompletionParameters> {
        private HttpMethodsProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context2, @NotNull CompletionResultSet result2) {
            if (parameters == null) {
                HttpMethodsProvider.$$$reportNull$$$0(0);
            }
            if (context2 == null) {
                HttpMethodsProvider.$$$reportNull$$$0(1);
            }
            if (result2 == null) {
                HttpMethodsProvider.$$$reportNull$$$0(2);
            }
            if (HttpRequestCompletionContributor.isRequestStart(parameters)) {
                CompletionResultSet properPrefixResult = result2.withPrefixMatcher((PrefixMatcher)new PlainPrefixMatcher(result2.getPrefixMatcher().getPrefix()));
                Project project = parameters.getOriginalFile().getProject();
                for (String method : RequestExecutionSupport.All.allSupportedMethods(project)) {
                    properPrefixResult.addElement(PrioritizedLookupElement.withPriority((LookupElement)LookupElementBuilder.create((String)method).withBoldness(true).withInsertHandler(AddSpaceInsertHandler.INSTANCE_WITH_AUTO_POPUP), (double)100.0));
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/intellij/httpClient/http/request/completion/HttpRequestCompletionContributor$HttpMethodsProvider";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class HttpDocCommentsCompletionProvider
    extends CompletionProvider<CompletionParameters> {
        private HttpDocCommentsCompletionProvider() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context2, @NotNull CompletionResultSet result2) {
            PsiElement position;
            HttpDocComment comment;
            if (parameters == null) {
                HttpDocCommentsCompletionProvider.$$$reportNull$$$0(0);
            }
            if (context2 == null) {
                HttpDocCommentsCompletionProvider.$$$reportNull$$$0(1);
            }
            if (result2 == null) {
                HttpDocCommentsCompletionProvider.$$$reportNull$$$0(2);
            }
            if ((comment = HttpDocCommentsCompletionProvider.getParentComment(position = parameters.getPosition())) == null || !HttpDocCommentsCompletionProvider.hasCorrespondingRequest((PsiElement)comment)) {
                return;
            }
            if (HttpRequestPsiUtils.isOfType(position, HttpDocCommentElementTypes.UNKNOWN)) {
                result2 = HttpRequestCompletionContributor.updatePrefixMatcherByElement(parameters, result2, position);
            }
            for (HttpDocCommentTagDescriptor tag : HttpDocCommentTags.TAGS) {
                LookupElementBuilder elementBuilder = LookupElementBuilder.create((Object)tag, (String)tag.getText());
                if ("@name".equals(tag.getText())) {
                    result2.addElement((LookupElement)elementBuilder.withInsertHandler(AddSpaceInsertHandler.INSTANCE));
                    continue;
                }
                result2.addElement((LookupElement)elementBuilder);
            }
        }

        @Nullable
        private static HttpDocComment getParentComment(@NotNull PsiElement element) {
            PsiElement parent;
            if (element == null) {
                HttpDocCommentsCompletionProvider.$$$reportNull$$$0(3);
            }
            if (!((parent = element.getParent()) instanceof HttpDocComment)) {
                parent = parent.getParent();
            }
            return parent instanceof HttpDocComment ? (HttpDocComment)parent : null;
        }

        private static boolean hasCorrespondingRequest(@NotNull PsiElement comment) {
            PsiElement next;
            if (comment == null) {
                HttpDocCommentsCompletionProvider.$$$reportNull$$$0(4);
            }
            if ((next = HttpRequestPsiUtils.getNextSiblingIgnoreWhitespace(comment, true)) instanceof HttpRequestBlock) {
                next = next.getFirstChild();
            }
            if (next instanceof HttpRequest) {
                return true;
            }
            PsiElement prev = HttpRequestPsiUtils.getPrevSiblingIgnoreWhitespace(comment);
            if (prev instanceof HttpRequestBlock) {
                prev = prev.getLastChild();
            }
            return prev == null || HttpRequestPsiUtils.isOfType(prev, HttpRequestElementTypes.REQUEST_SEPARATOR);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "comment";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/httpClient/http/request/completion/HttpRequestCompletionContributor$HttpDocCommentsCompletionProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addCompletions";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getParentComment";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "hasCorrespondingRequest";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class HttpMessageBodySeparatorCompletion
    extends CompletionProvider<CompletionParameters> {
        private HttpMessageBodySeparatorCompletion() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context2, @NotNull CompletionResultSet result2) {
            if (parameters == null) {
                HttpMessageBodySeparatorCompletion.$$$reportNull$$$0(0);
            }
            if (context2 == null) {
                HttpMessageBodySeparatorCompletion.$$$reportNull$$$0(1);
            }
            if (result2 == null) {
                HttpMessageBodySeparatorCompletion.$$$reportNull$$$0(2);
            }
            int offset = parameters.getOffset();
            int currentLine = parameters.getEditor().getDocument().getLineNumber(offset);
            int lineStartOffset = parameters.getEditor().getDocument().getLineStartOffset(currentLine);
            int lineEndOffset = parameters.getEditor().getDocument().getLineEndOffset(currentLine);
            String text2 = parameters.getEditor().getDocument().getText(TextRange.create((int)lineStartOffset, (int)lineEndOffset));
            if (!text2.chars().allMatch(i -> Character.isWhitespace((char)i) || i == 61)) {
                return;
            }
            InsertHandler insertHandler = (insertionContext, item) -> {
                Document document = insertionContext.getDocument();
                int line = document.getLineNumber(insertionContext.getStartOffset());
                int newStartOffset = document.getLineStartOffset(line);
                document.replaceString(newStartOffset, insertionContext.getTailOffset(), (CharSequence)item.getLookupString());
                insertionContext.getEditor().getCaretModel().moveToOffset(newStartOffset + item.getLookupString().length());
            };
            result2.addElement((LookupElement)LookupElementBuilder.create((String)"=== ").withInsertHandler(insertHandler));
            result2.addElement((LookupElement)LookupElementBuilder.create((String)"=== wait-for-server").withInsertHandler(insertHandler));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/intellij/httpClient/http/request/completion/HttpRequestCompletionContributor$HttpMessageBodySeparatorCompletion";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class HttpMessageBodySeparatorOptionsCompletion
    extends CompletionProvider<CompletionParameters> {
        private HttpMessageBodySeparatorOptionsCompletion() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context2, @NotNull CompletionResultSet result2) {
            if (parameters == null) {
                HttpMessageBodySeparatorOptionsCompletion.$$$reportNull$$$0(0);
            }
            if (context2 == null) {
                HttpMessageBodySeparatorOptionsCompletion.$$$reportNull$$$0(1);
            }
            if (result2 == null) {
                HttpMessageBodySeparatorOptionsCompletion.$$$reportNull$$$0(2);
            }
            result2.addElement((LookupElement)LookupElementBuilder.create((String)"wait-for-server").withInsertHandler((insertionContext, item) -> {
                Document document = insertionContext.getEditor().getDocument();
                int line = document.getLineNumber(insertionContext.getStartOffset());
                int lastEqualSign = StringUtil.lastIndexOf((CharSequence)document.getCharsSequence(), (char)'=', (int)document.getLineStartOffset(line), (int)insertionContext.getStartOffset());
                if (lastEqualSign != -1) {
                    document.replaceString(lastEqualSign + 1, insertionContext.getTailOffset(), (CharSequence)" wait-for-server");
                }
            }));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "context";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "result";
                    break;
                }
            }
            objectArray[1] = "com/intellij/httpClient/http/request/completion/HttpRequestCompletionContributor$HttpMessageBodySeparatorOptionsCompletion";
            objectArray[2] = "addCompletions";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class HttpDynamicVariablesAuthArgumentCompletion
    extends CompletionProvider<CompletionParameters> {
        private HttpDynamicVariablesAuthArgumentCompletion() {
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context2, @NotNull CompletionResultSet result2) {
            PsiFile file;
            String environment;
            if (parameters == null) {
                HttpDynamicVariablesAuthArgumentCompletion.$$$reportNull$$$0(0);
            }
            if (context2 == null) {
                HttpDynamicVariablesAuthArgumentCompletion.$$$reportNull$$$0(1);
            }
            if (result2 == null) {
                HttpDynamicVariablesAuthArgumentCompletion.$$$reportNull$$$0(2);
            }
            if ((environment = HttpClientSelectedEnvironments.getInstance((file = parameters.getOriginalFile()).getProject()).get(file.getVirtualFile())) != null && !environment.equals("")) {
                HttpClientEnvironmentsProvider.EnvironmentDescriptor env = HttpClientEnvironmentsProvider.INSTANCE.getByName(file, environment);
                if (env == null) {
                    return;
                }
                HttpDynamicVariablesAuthArgumentCompletion.fillResultFromDescriptors(result2, List.of(env));
            } else {
                HttpDynamicVariablesAuthArgumentCompletion.fillResultFromDescriptors(result2, HttpClientEnvironmentsProvider.INSTANCE.provideEnvironments(file).asList());
            }
        }

        @NotNull
        private static Map<String, String> getAuthIdsFromFile(@NotNull JsonFile file, @NotNull String environment) {
            if (file == null) {
                HttpDynamicVariablesAuthArgumentCompletion.$$$reportNull$$$0(3);
            }
            if (environment == null) {
                HttpDynamicVariablesAuthArgumentCompletion.$$$reportNull$$$0(4);
            }
            LinkedHashMap<String, String> result2 = new LinkedHashMap<String, String>();
            JsonObject object = JsonUtil.getTopLevelObject((JsonFile)file);
            if (object == null) {
                LinkedHashMap<String, String> linkedHashMap = result2;
                if (linkedHashMap == null) {
                    HttpDynamicVariablesAuthArgumentCompletion.$$$reportNull$$$0(5);
                }
                return linkedHashMap;
            }
            for (JsonProperty property : object.getPropertyList()) {
                Object object2;
                JsonObject securityObj;
                JsonProperty authProperty;
                JsonValue jsonValue;
                JsonObject envObj;
                JsonProperty securityProperty;
                JsonValue jsonValue2;
                if (!environment.equals(property.getName()) || !((jsonValue2 = property.getValue()) instanceof JsonObject) || (securityProperty = (envObj = (JsonObject)jsonValue2).findProperty("Security")) == null || !((jsonValue = securityProperty.getValue()) instanceof JsonObject) || (authProperty = (securityObj = (JsonObject)jsonValue).findProperty("Auth")) == null || !((object2 = authProperty.getValue()) instanceof JsonObject)) continue;
                JsonObject authObj = (JsonObject)object2;
                object2 = authObj.getPropertyList().iterator();
                while (object2.hasNext()) {
                    JsonProperty authIdProperty = (JsonProperty)object2.next();
                    String name = authIdProperty.getName();
                    Object type = "";
                    JsonValue jsonValue3 = authIdProperty.getValue();
                    if (jsonValue3 instanceof JsonObject) {
                        JsonValue jsonValue4;
                        JsonValue jsonValue5;
                        JsonObject authConfig = (JsonObject)jsonValue3;
                        JsonProperty typeProperty = authConfig.findProperty("Type");
                        if (typeProperty != null && (jsonValue5 = typeProperty.getValue()) instanceof JsonStringLiteral) {
                            JsonStringLiteral typeLiteral = (JsonStringLiteral)jsonValue5;
                            type = typeLiteral.getValue();
                        } else {
                            JsonValue jsonValue6;
                            JsonProperty deprecatedTypeProperty = authConfig.findProperty("type");
                            if (deprecatedTypeProperty != null && (jsonValue6 = deprecatedTypeProperty.getValue()) instanceof JsonStringLiteral) {
                                JsonStringLiteral typeLiteral = (JsonStringLiteral)jsonValue6;
                                type = typeLiteral.getValue();
                            }
                        }
                        JsonProperty grantTypeProperty = authConfig.findProperty("Grant Type");
                        if (grantTypeProperty != null && (jsonValue4 = grantTypeProperty.getValue()) instanceof JsonStringLiteral) {
                            JsonStringLiteral grantTypeLiteral = (JsonStringLiteral)jsonValue4;
                            if (!((String)type).isEmpty()) {
                                type = (String)type + "/";
                            }
                            type = (String)type + grantTypeLiteral.getValue();
                        }
                    }
                    result2.put(name, (String)type);
                }
            }
            LinkedHashMap<String, String> linkedHashMap = result2;
            if (linkedHashMap == null) {
                HttpDynamicVariablesAuthArgumentCompletion.$$$reportNull$$$0(6);
            }
            return linkedHashMap;
        }

        private static void fillResultFromDescriptors(@NotNull CompletionResultSet result2, @NotNull List<HttpClientEnvironmentsProvider.EnvironmentDescriptor> descriptors) {
            if (result2 == null) {
                HttpDynamicVariablesAuthArgumentCompletion.$$$reportNull$$$0(7);
            }
            if (descriptors == null) {
                HttpDynamicVariablesAuthArgumentCompletion.$$$reportNull$$$0(8);
            }
            LinkedHashMap<String, String> allIds = new LinkedHashMap<String, String>();
            for (HttpClientEnvironmentsProvider.EnvironmentDescriptor environmentDescriptor : descriptors) {
                PsiFile psiFile = environmentDescriptor.getPublicEnvFile();
                if (!(psiFile instanceof JsonFile)) continue;
                JsonFile envFile = (JsonFile)psiFile;
                allIds.putAll(HttpDynamicVariablesAuthArgumentCompletion.getAuthIdsFromFile(envFile, environmentDescriptor.getName()));
            }
            for (Map.Entry entry : allIds.entrySet()) {
                result2.addElement((LookupElement)LookupElementBuilder.create((String)((String)entry.getKey())).withInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

                    public void handleInsert(@NotNull InsertionContext context2, @NotNull LookupElement item) {
                        if (context2 == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        if (item == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        Document document = context2.getDocument();
                        if (context2.getStartOffset() == 0 || document.getCharsSequence().charAt(context2.getStartOffset() - 1) != '\"') {
                            document.insertString(context2.getStartOffset(), (CharSequence)"\"");
                        }
                        if (document.getCharsSequence().charAt(context2.getTailOffset()) != '\"') {
                            document.insertString(context2.getTailOffset(), (CharSequence)"\"");
                        }
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        Object[] objectArray;
                        Object[] objectArray2 = new Object[3];
                        switch (n) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[0] = "context";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[0] = "item";
                                break;
                            }
                        }
                        objectArray[1] = "com/intellij/httpClient/http/request/completion/HttpRequestCompletionContributor$HttpDynamicVariablesAuthArgumentCompletion$1";
                        objectArray[2] = "handleInsert";
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                }).withTypeText((String)entry.getValue()));
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "environment";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/httpClient/http/request/completion/HttpRequestCompletionContributor$HttpDynamicVariablesAuthArgumentCompletion";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "descriptors";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/httpClient/http/request/completion/HttpRequestCompletionContributor$HttpDynamicVariablesAuthArgumentCompletion";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAuthIdsFromFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "addCompletions";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getAuthIdsFromFile";
                    break;
                }
                case 5: 
                case 6: {
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "fillResultFromDescriptors";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5, 6 -> new IllegalStateException(string);
            };
        }
    }

    private static class IsLastChildCondition
    extends PatternCondition<PsiElement> {
        IsLastChildCondition() {
            super("Is last child");
        }

        public boolean accepts(@NotNull PsiElement element, ProcessingContext context2) {
            PsiElement parent;
            if (element == null) {
                IsLastChildCondition.$$$reportNull$$$0(0);
            }
            if ((parent = element.getParent()) == null) {
                return false;
            }
            return parent.getLastChild() == element;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/httpClient/http/request/completion/HttpRequestCompletionContributor$IsLastChildCondition", "accepts"));
        }
    }

    private static class HttpProtocolsCompletion
    extends CompletionProvider<CompletionParameters> {
        private HttpProtocolsCompletion() {
        }

        private static boolean previousEndsWithHttp(@NotNull PsiElement element) {
            PsiElement previous;
            if (element == null) {
                HttpProtocolsCompletion.$$$reportNull$$$0(0);
            }
            if (PsiUtilCore.getElementType((PsiElement)(previous = element.getPrevSibling())) != HttpRequestElementTypes.SEPARATOR) {
                return false;
            }
            PsiElement prevSegment = previous.getPrevSibling();
            if (PsiUtilCore.getElementType((PsiElement)prevSegment) != HttpRequestElementTypes.SEGMENT) {
                return false;
            }
            return StringUtil.endsWithIgnoreCase((String)prevSegment.getText(), (String)"HTTP");
        }

        @Nullable
        private static String getTextBetweenSpaceAndPosition(@NotNull PsiElement element, int offsetInFile) {
            int charIndex;
            if (element == null) {
                HttpProtocolsCompletion.$$$reportNull$$$0(1);
            }
            String text2 = element.getText();
            boolean foundSpace = false;
            int offsetInElement = offsetInFile - element.getTextOffset();
            for (charIndex = offsetInElement - 1; charIndex >= 0; --charIndex) {
                if (!Character.isWhitespace(text2.charAt(charIndex))) continue;
                foundSpace = true;
                break;
            }
            if (!foundSpace) {
                if (element.getPrevSibling() instanceof PsiWhiteSpace) {
                    charIndex = -1;
                } else {
                    if (HttpProtocolsCompletion.previousEndsWithHttp(element)) {
                        return "HTTP/";
                    }
                    return null;
                }
            }
            return text2.substring(charIndex + 1, offsetInElement);
        }

        protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context2, @NotNull CompletionResultSet result2) {
            String prefix;
            if (parameters == null) {
                HttpProtocolsCompletion.$$$reportNull$$$0(2);
            }
            if (context2 == null) {
                HttpProtocolsCompletion.$$$reportNull$$$0(3);
            }
            if (result2 == null) {
                HttpProtocolsCompletion.$$$reportNull$$$0(4);
            }
            if ((prefix = HttpProtocolsCompletion.getTextBetweenSpaceAndPosition(parameters.getPosition(), parameters.getOffset())) == null) {
                return;
            }
            HttpRequestTarget requestTarget = (HttpRequestTarget)PsiTreeUtil.getParentOfType((PsiElement)parameters.getPosition(), HttpRequestTarget.class);
            if (requestTarget == null) {
                return;
            }
            boolean isHttps = requestTarget.getScheme() != null && requestTarget.getScheme().textMatches("https");
            CompletionResultSet newResult = result2.withPrefixMatcher((PrefixMatcher)new PlainPrefixMatcher(prefix));
            newResult.addElement((LookupElement)LookupElementBuilder.create((String)"HTTP/2").withTailText(HttpProtocolsCompletion.wrap(isHttps ? RestClientBundle.message("http.client.h2.lookup.element.description", new Object[0]) : RestClientBundle.message("http.client.h2c.lookup.element.description", new Object[0]))));
            newResult.addElement((LookupElement)LookupElementBuilder.create((String)"HTTP/1.1").withTailText(HttpProtocolsCompletion.wrap(RestClientBundle.message("http.client.http11.lookup.element.description", new Object[0]))));
            newResult.addElement((LookupElement)LookupElementBuilder.create((String)"HTTP/2 (Prior Knowledge)").withTailText(HttpProtocolsCompletion.wrap(isHttps ? RestClientBundle.message("http.client.h2.pk.lookup.element.description", new Object[0]) : RestClientBundle.message("http.client.h2c.pk.lookup.element.description", new Object[0]))));
        }

        private static String wrap(@NotNull String s) {
            if (s == null) {
                HttpProtocolsCompletion.$$$reportNull$$$0(5);
            }
            return " (" + s + ")";
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "parameters";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "s";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/httpClient/http/request/completion/HttpRequestCompletionContributor$HttpProtocolsCompletion";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "previousEndsWithHttp";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getTextBetweenSpaceAndPosition";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addCompletions";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "wrap";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

