/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbt.console;

import com.intellij.dbt.DbtUtils;
import com.intellij.dbt.console.commands.DbtCommand;
import com.intellij.dbt.run.DbtCommandLinePatcher;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0006\u0010\u0000\u001a\u00020\u0001\u001a \u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0001\u00a8\u0006\t"}, d2={"getDbtExecutableName", "", "getDbtCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "command", "Lcom/intellij/dbt/console/commands/DbtCommand;", "module", "Lcom/intellij/openapi/module/Module;", "workingDirectory", "intellij.dbt"})
@SourceDebugExtension(value={"SMAP\nDbtCliUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbtCliUtil.kt\ncom/intellij/dbt/console/DbtCliUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,19:1\n1869#2,2:20\n*S KotlinDebug\n*F\n+ 1 DbtCliUtil.kt\ncom/intellij/dbt/console/DbtCliUtilKt\n*L\n14#1:20,2\n*E\n"})
public final class DbtCliUtilKt {
    @NotNull
    public static final String getDbtExecutableName() {
        return SystemInfo.isWindows ? "dbt.exe" : "dbt";
    }

    @NotNull
    public static final GeneralCommandLine getDbtCommandLine(@NotNull DbtCommand command, @NotNull Module module, @Nullable String workingDirectory) {
        Intrinsics.checkNotNullParameter((Object)((Object)command), (String)"command");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Object object = DbtUtils.Companion.getDbtSettings(module);
        if (object == null || (object = object.getDbtExecutablePath()) == null) {
            object = DbtCliUtilKt.getDbtExecutableName();
        }
        Object dbtExecutableFile = object;
        GeneralCommandLine result = null;
        GeneralCommandLine generalCommandLine = new GeneralCommandLine(CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)dbtExecutableFile), (Iterable)command.getCommand())).withWorkDirectory(workingDirectory);
        Intrinsics.checkNotNullExpressionValue((Object)generalCommandLine, (String)"withWorkDirectory(...)");
        result = generalCommandLine;
        Iterable $this$forEach$iv = DbtCommandLinePatcher.EP_NAME.getExtensionList();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DbtCommandLinePatcher it = (DbtCommandLinePatcher)element$iv;
            boolean bl = false;
            Project project = module.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            result = it.patchCommandLine(result, project);
        }
        return result;
    }
}

