/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects;

import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbSqlUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.sql.psi.impl.DataSourceProvider;
import com.intellij.sql.psi.impl.SqlImplUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SqlDataSourceMappings {
    public static SqlDataSourceMappings getInstance(Project project) {
        return (SqlDataSourceMappings)project.getService(SqlDataSourceMappings.class);
    }

    public List<DbDataSource> getDataSources(@NotNull PsiFile file) {
        if (file == null) {
            SqlDataSourceMappings.$$$reportNull$$$0(0);
        }
        PsiFile sqlFile = SqlImplUtil.getTopLevelSqlFile(file.getOriginalFile());
        DbDataSource element = DbImplUtilCore.getForcedDataSource(sqlFile);
        ArrayList<DbDataSource> dataSources = new ArrayList<DbDataSource>(this.getProvidedDataSources(file));
        if (dataSources.isEmpty()) {
            dataSources.addAll(SqlDataSourceMappings.getDataSourcesForResolve(sqlFile));
        }
        if (element != null) {
            VirtualFile vFile = SqlImplUtil.getTopLevelSqlFile(sqlFile).getVirtualFile();
            return JBIterable.from(dataSources).filter(ds -> {
                SqlDataSource sqlDataSource = (SqlDataSource)ObjectUtils.tryCast((Object)ds.getDelegate(), SqlDataSource.class);
                return sqlDataSource != null && sqlDataSource.containsFile(vFile);
            }).append((Object)(element.isValid() ? element : null)).unique().toList();
        }
        return dataSources;
    }

    public List<DbDataSource> getProvidedDataSources(@NotNull PsiFile element) {
        if (element == null) {
            SqlDataSourceMappings.$$$reportNull$$$0(1);
        }
        ArrayList<DbDataSource> providedDataSources = new ArrayList<DbDataSource>();
        for (DataSourceProvider provider : DataSourceProvider.EP_NAME.getExtensionList()) {
            List<DbDataSource> dataSource = provider.getDataSources(element);
            providedDataSources.addAll(dataSource);
        }
        return providedDataSources;
    }

    private static List<DbDataSource> getDataSourcesForResolve(PsiFile sqlFile) {
        return (List)CachedValuesManager.getCachedValue((PsiElement)sqlFile, () -> {
            List result2 = DbSqlUtilCore.getDataSourcesForResolve(sqlFile).toList();
            return new CachedValueProvider.Result((Object)result2, new Object[]{DbPsiFacade.getInstance(sqlFile.getProject())});
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/sql/dialects/SqlDataSourceMappings";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getDataSources";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getProvidedDataSources";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

