/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.remote;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.intellij.docker.agent.settings.DockerEnvVar;
import com.intellij.docker.agent.settings.DockerEnvVarImpl;
import com.intellij.docker.agent.settings.DockerLink;
import com.intellij.docker.agent.settings.DockerLinkImpl;
import com.intellij.docker.agent.settings.DockerPortBinding;
import com.intellij.docker.agent.settings.DockerPortBindingImpl;
import com.intellij.docker.agent.settings.DockerVolumeBinding;
import com.intellij.docker.agent.settings.DockerVolumeBindingImpl;
import com.intellij.docker.remote.DockerCliPresentationUtil;
import com.intellij.docker.remote.settings.DockerExtraHost;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public final class DockerContainerSettings
implements PersistentStateComponent<DockerContainerSettings>,
Cloneable {
    public static final Key<DockerContainerSettings> KEY = Key.create((String)"DOCKER_RUN_CONTAINER_SETTINGS");
    public static final String BRIDGE_NETWORK_MODE = "bridge";
    public static final String DEFAULT_NETWORK_MODE = "bridge";
    public static final int VERSION_0 = 0;
    public static final int VERSION_1 = 1;
    public static final int VERSION_2 = 2;
    private int myVersion = 0;
    private List<DockerPortBindingImpl> myPortBindings = new ArrayList<DockerPortBindingImpl>();
    private boolean myPublishAllPorts;
    private List<DockerLinkImpl> myLinks = new ArrayList<DockerLinkImpl>();
    private List<DockerVolumeBindingImpl> myVolumeBindings = new ArrayList<DockerVolumeBindingImpl>();
    private List<DockerEnvVarImpl> myEnvVars = new ArrayList<DockerEnvVarImpl>();
    private List<DockerExtraHost> myExtraHosts = new ArrayList<DockerExtraHost>();
    private String myNetworkMode = "bridge";
    private boolean myNetworkDisabled;
    @Nullable
    private String myRunCliOptions;

    @NotNull
    public List<DockerPortBindingImpl> getPortBindings() {
        if (this.myPortBindings == null) {
            this.myPortBindings = new ArrayList<DockerPortBindingImpl>();
        }
        List<DockerPortBindingImpl> list = this.myPortBindings;
        if (list == null) {
            DockerContainerSettings.$$$reportNull$$$0(0);
        }
        return list;
    }

    public void setPortBindings(List<DockerPortBindingImpl> portBindings) {
        this.myPortBindings = portBindings;
    }

    public boolean isPublishAllPorts() {
        return this.myPublishAllPorts;
    }

    public void setPublishAllPorts(boolean publishAllPorts) {
        this.myPublishAllPorts = publishAllPorts;
    }

    @NotNull
    public List<DockerLinkImpl> getLinks() {
        if (this.myLinks == null) {
            this.myLinks = new ArrayList<DockerLinkImpl>();
        }
        List<DockerLinkImpl> list = this.myLinks;
        if (list == null) {
            DockerContainerSettings.$$$reportNull$$$0(1);
        }
        return list;
    }

    public void setLinks(List<DockerLinkImpl> links) {
        this.myLinks = links;
    }

    @NotNull
    public List<DockerVolumeBindingImpl> getVolumeBindings() {
        if (this.myVolumeBindings == null) {
            this.myVolumeBindings = new ArrayList<DockerVolumeBindingImpl>();
        }
        List<DockerVolumeBindingImpl> list = this.myVolumeBindings;
        if (list == null) {
            DockerContainerSettings.$$$reportNull$$$0(2);
        }
        return list;
    }

    public void setVolumeBindings(List<DockerVolumeBindingImpl> volumeBindings2) {
        this.myVolumeBindings = volumeBindings2;
    }

    @NotNull
    public List<DockerEnvVarImpl> getEnvVars() {
        if (this.myEnvVars == null) {
            this.myEnvVars = new ArrayList<DockerEnvVarImpl>();
        }
        List<DockerEnvVarImpl> list = this.myEnvVars;
        if (list == null) {
            DockerContainerSettings.$$$reportNull$$$0(3);
        }
        return list;
    }

    public void setEnvVars(List<DockerEnvVarImpl> envVars) {
        this.myEnvVars = envVars;
    }

    public List<DockerExtraHost> getExtraHosts() {
        if (this.myExtraHosts == null) {
            this.myExtraHosts = new ArrayList<DockerExtraHost>();
        }
        return this.myExtraHosts;
    }

    public void setExtraHosts(List<DockerExtraHost> extraHosts) {
        this.myExtraHosts = extraHosts;
    }

    @Nullable
    public String getNetworkMode() {
        return this.myNetworkMode;
    }

    public void setNetworkMode(@Nullable String networkMode) {
        this.myNetworkMode = networkMode;
    }

    public boolean isNetworkDisabled() {
        return this.myNetworkDisabled;
    }

    public void setNetworkDisabled(boolean networkDisabled) {
        this.myNetworkDisabled = networkDisabled;
    }

    @Nullable
    public String getRunCliOptions() {
        return this.myRunCliOptions;
    }

    public void setRunCliOptions(@Nullable String runCliOptions) {
        this.myRunCliOptions = runCliOptions;
    }

    public int getVersion() {
        return this.myVersion;
    }

    public void setVersion(int version2) {
        this.myVersion = version2;
    }

    public void copyTo(@NotNull DockerContainerSettings other) {
        if (other == null) {
            DockerContainerSettings.$$$reportNull$$$0(4);
        }
        other.setPortBindings(ContainerUtil.map(this.getPortBindings(), binding -> new DockerPortBindingImpl((DockerPortBinding)binding)));
        other.setPublishAllPorts(this.isPublishAllPorts());
        other.setLinks(ContainerUtil.map(this.getLinks(), link2 -> new DockerLinkImpl((DockerLink)link2)));
        List mapped = ContainerUtil.map(this.getVolumeBindings(), binding -> new DockerVolumeBindingImpl((DockerVolumeBinding)binding));
        other.setVolumeBindings(mapped.isEmpty() ? new ArrayList() : mapped);
        other.setNetworkMode(this.getNetworkMode());
        other.setNetworkDisabled(this.isNetworkDisabled());
        other.setEnvVars(ContainerUtil.map(this.getEnvVars(), var -> new DockerEnvVarImpl((DockerEnvVar)var)));
        other.setExtraHosts(ContainerUtil.map(this.getExtraHosts(), host -> new DockerExtraHost((DockerExtraHost)host)));
        other.setRunCliOptions(this.getRunCliOptions());
        other.setVersion(this.getVersion());
    }

    public DockerContainerSettings clone() {
        DockerContainerSettings copy = new DockerContainerSettings();
        this.copyTo(copy);
        return copy;
    }

    @NotNull
    public DockerContainerSettings getState() {
        DockerContainerSettings dockerContainerSettings = this;
        if (dockerContainerSettings == null) {
            DockerContainerSettings.$$$reportNull$$$0(5);
        }
        return dockerContainerSettings;
    }

    public void loadState(@NotNull DockerContainerSettings state) {
        if (state == null) {
            DockerContainerSettings.$$$reportNull$$$0(6);
        }
        state.copyTo(this);
    }

    @NotNull
    @NlsSafe
    public static String settingsToCli(@Nullable DockerContainerSettings settings) {
        if (settings == null) {
            return "";
        }
        ImmutableList.Builder args = ImmutableList.builder();
        if (settings.isNetworkDisabled()) {
            args.add((Object)"--net=\"none\"");
        } else if (!"bridge".equals(settings.getNetworkMode())) {
            args.add((Object)("--net=\"" + settings.getNetworkMode() + "\""));
        }
        if (settings.isPublishAllPorts()) {
            args.add((Object)"--publish-all");
        } else {
            for (DockerPortBindingImpl binding : settings.getPortBindings()) {
                Object qualifiedContainerPort = StringUtil.isNotEmpty((String)binding.getProtocol()) && !"tcp".equals(binding.getProtocol()) ? String.valueOf(binding.getContainerPort()) : binding.getContainerPort() + "/" + binding.getProtocol();
                args.add((Object)String.format("-p %s:%s:%s", StringUtil.defaultIfEmpty((String)binding.getHostIp(), (String)""), binding.getHostPort() == null ? "" : String.valueOf(binding.getHostPort()), qualifiedContainerPort));
            }
        }
        for (DockerLinkImpl link2 : settings.getLinks()) {
            if (StringUtil.isNotEmpty((String)link2.getAlias())) {
                args.add((Object)String.format("--link %s:%s", link2.getName(), link2.getAlias()));
                continue;
            }
            args.add((Object)String.format("--link %s", link2.getName()));
        }
        for (DockerExtraHost extraHost : settings.getExtraHosts()) {
            args.add((Object)String.format("--add-host %s:%s", extraHost.getHostname(), extraHost.getIP()));
        }
        for (DockerVolumeBindingImpl volumeBinding : settings.getVolumeBindings()) {
            if (StringUtil.isNotEmpty((String)volumeBinding.getHostPath())) {
                String accessQualifier = volumeBinding.isReadOnly() ? ":ro" : "";
                args.add((Object)String.format("-v %s:%s%s", volumeBinding.getHostPath(), volumeBinding.getContainerPath(), accessQualifier));
                continue;
            }
            args.add((Object)String.format("-v %s", volumeBinding.getContainerPath()));
        }
        for (DockerEnvVarImpl envVar : settings.getEnvVars()) {
            if (envVar.getValue() != null) {
                args.add((Object)String.format("-e %s=%s", envVar.getName(), envVar.getValue()));
                continue;
            }
            args.add((Object)String.format("-e %s", envVar.getName()));
        }
        String string = Joiner.on((String)" ").join((Iterable)args.build());
        if (string == null) {
            DockerContainerSettings.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public static DockerContainerSettings defaultSettings(@NotNull Project project) {
        if (project == null) {
            DockerContainerSettings.$$$reportNull$$$0(8);
        }
        return DockerContainerSettings.defaultSettings(project, 1);
    }

    @NotNull
    public static DockerContainerSettings defaultSettings(int version2) {
        DockerContainerSettings settings = new DockerContainerSettings();
        DockerContainerSettings.upgradeSettings(null, settings, version2);
        DockerContainerSettings dockerContainerSettings = settings;
        if (dockerContainerSettings == null) {
            DockerContainerSettings.$$$reportNull$$$0(9);
        }
        return dockerContainerSettings;
    }

    @NotNull
    public static DockerContainerSettings defaultSettings(@NotNull Project project, int version2) {
        if (project == null) {
            DockerContainerSettings.$$$reportNull$$$0(10);
        }
        DockerContainerSettings settings = new DockerContainerSettings();
        DockerContainerSettings.upgradeSettings(project, settings, version2);
        DockerContainerSettings dockerContainerSettings = settings;
        if (dockerContainerSettings == null) {
            DockerContainerSettings.$$$reportNull$$$0(11);
        }
        return dockerContainerSettings;
    }

    public static void upgradeSettings(@NotNull Project project, @NotNull DockerContainerSettings settings) {
        if (project == null) {
            DockerContainerSettings.$$$reportNull$$$0(12);
        }
        if (settings == null) {
            DockerContainerSettings.$$$reportNull$$$0(13);
        }
        DockerContainerSettings.upgradeSettings(project, settings, 1);
    }

    public static void upgradeSettings(@Nullable Project project, @NotNull DockerContainerSettings settings, int targetVersion) {
        if (settings == null) {
            DockerContainerSettings.$$$reportNull$$$0(14);
        }
        if (targetVersion > 0 && settings.getVersion() == 0) {
            ArrayList<DockerVolumeBindingImpl> bindings = new ArrayList<DockerVolumeBindingImpl>(settings.getVolumeBindings());
            if (project != null) {
                bindings.add(0, DockerContainerSettings.createDefaultBinding(project, "/opt/project"));
            }
            settings.setVolumeBindings(bindings);
            settings.setVersion(1);
        }
        if (targetVersion > 1 && settings.getVersion() == 1) {
            ArrayList<String> runCliOptionsBuilder = new ArrayList<String>();
            runCliOptionsBuilder.add("--entrypoint=");
            runCliOptionsBuilder.add("--rm");
            if (settings.isNetworkDisabled()) {
                runCliOptionsBuilder.add("--network=none");
            } else if (settings.getNetworkMode() != null && !"bridge".equals(settings.getNetworkMode())) {
                runCliOptionsBuilder.add(MessageFormat.format("--network={0}", settings.getNetworkMode()));
            }
            runCliOptionsBuilder.addAll(ContainerUtil.map(settings.getLinks(), link2 -> DockerCliPresentationUtil.toCliPresentation(link2)));
            runCliOptionsBuilder.addAll(ContainerUtil.map(settings.getExtraHosts(), host -> DockerCliPresentationUtil.toCliPresentation(host)));
            settings.myRunCliOptions = StringUtil.join(runCliOptionsBuilder, (String)" ");
            settings.setVersion(2);
        }
    }

    @VisibleForTesting
    @NotNull
    public static DockerVolumeBindingImpl createDefaultBinding(@NotNull Project project) {
        if (project == null) {
            DockerContainerSettings.$$$reportNull$$$0(15);
        }
        return DockerContainerSettings.createDefaultBinding(project, "/opt/project");
    }

    @NotNull
    static DockerVolumeBindingImpl createDefaultBinding(@NotNull Project project, @NotNull String projectPathInContainer) {
        if (project == null) {
            DockerContainerSettings.$$$reportNull$$$0(16);
        }
        if (projectPathInContainer == null) {
            DockerContainerSettings.$$$reportNull$$$0(17);
        }
        DockerVolumeBindingImpl binding = new DockerVolumeBindingImpl();
        binding.setHostPath(project.getBasePath());
        binding.setContainerPath(projectPathInContainer);
        DockerVolumeBindingImpl dockerVolumeBindingImpl = binding;
        if (dockerVolumeBindingImpl == null) {
            DockerContainerSettings.$$$reportNull$$$0(18);
        }
        return dockerVolumeBindingImpl;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DockerContainerSettings settings = (DockerContainerSettings)o;
        return this.myVersion == settings.myVersion && this.myPublishAllPorts == settings.myPublishAllPorts && this.myNetworkDisabled == settings.myNetworkDisabled && Objects.equals(this.myPortBindings, settings.myPortBindings) && Objects.equals(this.myLinks, settings.myLinks) && Objects.equals(this.myVolumeBindings, settings.myVolumeBindings) && Objects.equals(this.myEnvVars, settings.myEnvVars) && Objects.equals(this.myExtraHosts, settings.myExtraHosts) && Objects.equals(this.myNetworkMode, settings.myNetworkMode) && Objects.equals(this.myRunCliOptions, settings.myRunCliOptions);
    }

    public int hashCode() {
        return Objects.hash(this.myVersion, this.myPortBindings, this.myPublishAllPorts, this.myLinks, this.myVolumeBindings, this.myEnvVars, this.myExtraHosts, this.myNetworkMode, this.myNetworkDisabled, this.myRunCliOptions);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 4, 6, 8, 10, 12, 13, 14, 15, 16, 17 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/docker/remote/DockerContainerSettings";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectPathInContainer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPortBindings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLinks";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVolumeBindings";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvVars";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/docker/remote/DockerContainerSettings";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "settingsToCli";
                break;
            }
            case 9: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "defaultSettings";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createDefaultBinding";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "copyTo";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "defaultSettings";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "upgradeSettings";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createDefaultBinding";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 4, 6, 8, 10, 12, 13, 14, 15, 16, 17 -> new IllegalArgumentException(string);
        };
    }
}

