package vcs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BindCorpGroup invokes the vcs.BindCorpGroup API synchronously
func (client *Client) BindCorpGroup(request *BindCorpGroupRequest) (response *BindCorpGroupResponse, err error) {
	response = CreateBindCorpGroupResponse()
	err = client.DoAction(request, response)
	return
}

// BindCorpGroupWithChan invokes the vcs.BindCorpGroup API asynchronously
func (client *Client) BindCorpGroupWithChan(request *BindCorpGroupRequest) (<-chan *BindCorpGroupResponse, <-chan error) {
	responseChan := make(chan *BindCorpGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BindCorpGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BindCorpGroupWithCallback invokes the vcs.BindCorpGroup API asynchronously
func (client *Client) BindCorpGroupWithCallback(request *BindCorpGroupRequest, callback func(response *BindCorpGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BindCorpGroupResponse
		var err error
		defer close(result)
		response, err = client.BindCorpGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BindCorpGroupRequest is the request struct for api BindCorpGroup
type BindCorpGroupRequest struct {
	*requests.RpcRequest
	CorpId      string `position:"Body" name:"CorpId"`
	CorpGroupId string `position:"Body" name:"CorpGroupId"`
}

// BindCorpGroupResponse is the response struct for api BindCorpGroup
type BindCorpGroupResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateBindCorpGroupRequest creates a request to invoke BindCorpGroup API
func CreateBindCorpGroupRequest() (request *BindCorpGroupRequest) {
	request = &BindCorpGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vcs", "2020-05-15", "BindCorpGroup", "", "")
	request.Method = requests.POST
	return
}

// CreateBindCorpGroupResponse creates a response to parse from BindCorpGroup response
func CreateBindCorpGroupResponse() (response *BindCorpGroupResponse) {
	response = &BindCorpGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
