package servicemesh

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetVmMeta invokes the servicemesh.GetVmMeta API synchronously
func (client *Client) GetVmMeta(request *GetVmMetaRequest) (response *GetVmMetaResponse, err error) {
	response = CreateGetVmMetaResponse()
	err = client.DoAction(request, response)
	return
}

// GetVmMetaWithChan invokes the servicemesh.GetVmMeta API asynchronously
func (client *Client) GetVmMetaWithChan(request *GetVmMetaRequest) (<-chan *GetVmMetaResponse, <-chan error) {
	responseChan := make(chan *GetVmMetaResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetVmMeta(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetVmMetaWithCallback invokes the servicemesh.GetVmMeta API asynchronously
func (client *Client) GetVmMetaWithCallback(request *GetVmMetaRequest, callback func(response *GetVmMetaResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetVmMetaResponse
		var err error
		defer close(result)
		response, err = client.GetVmMeta(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetVmMetaRequest is the request struct for api GetVmMeta
type GetVmMetaRequest struct {
	*requests.RpcRequest
	ServiceAccount string `position:"Query" name:"ServiceAccount"`
	TrustDomain    string `position:"Query" name:"TrustDomain"`
	Namespace      string `position:"Query" name:"Namespace"`
	ServiceMeshId  string `position:"Query" name:"ServiceMeshId"`
}

// GetVmMetaResponse is the response struct for api GetVmMeta
type GetVmMetaResponse struct {
	*responses.BaseResponse
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	VmMetaInfo VmMetaInfo `json:"VmMetaInfo" xml:"VmMetaInfo"`
}

// CreateGetVmMetaRequest creates a request to invoke GetVmMeta API
func CreateGetVmMetaRequest() (request *GetVmMetaRequest) {
	request = &GetVmMetaRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("servicemesh", "2020-01-11", "GetVmMeta", "servicemesh", "openAPI")
	request.Method = requests.GET
	return
}

// CreateGetVmMetaResponse creates a response to parse from GetVmMeta response
func CreateGetVmMetaResponse() (response *GetVmMetaResponse) {
	response = &GetVmMetaResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
