package ons

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// OnsDLQMessageGetById invokes the ons.OnsDLQMessageGetById API synchronously
func (client *Client) OnsDLQMessageGetById(request *OnsDLQMessageGetByIdRequest) (response *OnsDLQMessageGetByIdResponse, err error) {
	response = CreateOnsDLQMessageGetByIdResponse()
	err = client.DoAction(request, response)
	return
}

// OnsDLQMessageGetByIdWithChan invokes the ons.OnsDLQMessageGetById API asynchronously
func (client *Client) OnsDLQMessageGetByIdWithChan(request *OnsDLQMessageGetByIdRequest) (<-chan *OnsDLQMessageGetByIdResponse, <-chan error) {
	responseChan := make(chan *OnsDLQMessageGetByIdResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.OnsDLQMessageGetById(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// OnsDLQMessageGetByIdWithCallback invokes the ons.OnsDLQMessageGetById API asynchronously
func (client *Client) OnsDLQMessageGetByIdWithCallback(request *OnsDLQMessageGetByIdRequest, callback func(response *OnsDLQMessageGetByIdResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *OnsDLQMessageGetByIdResponse
		var err error
		defer close(result)
		response, err = client.OnsDLQMessageGetById(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// OnsDLQMessageGetByIdRequest is the request struct for api OnsDLQMessageGetById
type OnsDLQMessageGetByIdRequest struct {
	*requests.RpcRequest
	GroupId    string `position:"Query" name:"GroupId"`
	MsgId      string `position:"Query" name:"MsgId"`
	InstanceId string `position:"Query" name:"InstanceId"`
}

// OnsDLQMessageGetByIdResponse is the response struct for api OnsDLQMessageGetById
type OnsDLQMessageGetByIdResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	HelpUrl   string `json:"HelpUrl" xml:"HelpUrl"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateOnsDLQMessageGetByIdRequest creates a request to invoke OnsDLQMessageGetById API
func CreateOnsDLQMessageGetByIdRequest() (request *OnsDLQMessageGetByIdRequest) {
	request = &OnsDLQMessageGetByIdRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ons", "2019-02-14", "OnsDLQMessageGetById", "ons", "openAPI")
	request.Method = requests.POST
	return
}

// CreateOnsDLQMessageGetByIdResponse creates a response to parse from OnsDLQMessageGetById response
func CreateOnsDLQMessageGetByIdResponse() (response *OnsDLQMessageGetByIdResponse) {
	response = &OnsDLQMessageGetByIdResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
