package idaas_doraemon

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetAuthenticator invokes the idaas_doraemon.GetAuthenticator API synchronously
func (client *Client) GetAuthenticator(request *GetAuthenticatorRequest) (response *GetAuthenticatorResponse, err error) {
	response = CreateGetAuthenticatorResponse()
	err = client.DoAction(request, response)
	return
}

// GetAuthenticatorWithChan invokes the idaas_doraemon.GetAuthenticator API asynchronously
func (client *Client) GetAuthenticatorWithChan(request *GetAuthenticatorRequest) (<-chan *GetAuthenticatorResponse, <-chan error) {
	responseChan := make(chan *GetAuthenticatorResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetAuthenticator(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetAuthenticatorWithCallback invokes the idaas_doraemon.GetAuthenticator API asynchronously
func (client *Client) GetAuthenticatorWithCallback(request *GetAuthenticatorRequest, callback func(response *GetAuthenticatorResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetAuthenticatorResponse
		var err error
		defer close(result)
		response, err = client.GetAuthenticator(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetAuthenticatorRequest is the request struct for api GetAuthenticator
type GetAuthenticatorRequest struct {
	*requests.RpcRequest
	UserId                string `position:"Query" name:"UserId"`
	AuthenticatorUuid     string `position:"Query" name:"AuthenticatorUuid"`
	ApplicationExternalId string `position:"Query" name:"ApplicationExternalId"`
}

// GetAuthenticatorResponse is the response struct for api GetAuthenticator
type GetAuthenticatorResponse struct {
	*responses.BaseResponse
	RequestId     string        `json:"RequestId" xml:"RequestId"`
	Authenticator Authenticator `json:"Authenticator" xml:"Authenticator"`
}

// CreateGetAuthenticatorRequest creates a request to invoke GetAuthenticator API
func CreateGetAuthenticatorRequest() (request *GetAuthenticatorRequest) {
	request = &GetAuthenticatorRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("idaas-doraemon", "2021-05-20", "GetAuthenticator", "", "")
	request.Method = requests.POST
	return
}

// CreateGetAuthenticatorResponse creates a response to parse from GetAuthenticator response
func CreateGetAuthenticatorResponse() (response *GetAuthenticatorResponse) {
	response = &GetAuthenticatorResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
