package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeFlowProject invokes the emr.DescribeFlowProject API synchronously
func (client *Client) DescribeFlowProject(request *DescribeFlowProjectRequest) (response *DescribeFlowProjectResponse, err error) {
	response = CreateDescribeFlowProjectResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeFlowProjectWithChan invokes the emr.DescribeFlowProject API asynchronously
func (client *Client) DescribeFlowProjectWithChan(request *DescribeFlowProjectRequest) (<-chan *DescribeFlowProjectResponse, <-chan error) {
	responseChan := make(chan *DescribeFlowProjectResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeFlowProject(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeFlowProjectWithCallback invokes the emr.DescribeFlowProject API asynchronously
func (client *Client) DescribeFlowProjectWithCallback(request *DescribeFlowProjectRequest, callback func(response *DescribeFlowProjectResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeFlowProjectResponse
		var err error
		defer close(result)
		response, err = client.DescribeFlowProject(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeFlowProjectRequest is the request struct for api DescribeFlowProject
type DescribeFlowProjectRequest struct {
	*requests.RpcRequest
	ProjectId string `position:"Query" name:"ProjectId"`
}

// DescribeFlowProjectResponse is the response struct for api DescribeFlowProject
type DescribeFlowProjectResponse struct {
	*responses.BaseResponse
	RequestId   string `json:"RequestId" xml:"RequestId"`
	Id          string `json:"Id" xml:"Id"`
	GmtCreate   int64  `json:"GmtCreate" xml:"GmtCreate"`
	GmtModified int64  `json:"GmtModified" xml:"GmtModified"`
	UserId      string `json:"UserId" xml:"UserId"`
	Name        string `json:"Name" xml:"Name"`
	Description string `json:"Description" xml:"Description"`
}

// CreateDescribeFlowProjectRequest creates a request to invoke DescribeFlowProject API
func CreateDescribeFlowProjectRequest() (request *DescribeFlowProjectRequest) {
	request = &DescribeFlowProjectRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "DescribeFlowProject", "emr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeFlowProjectResponse creates a response to parse from DescribeFlowProject response
func CreateDescribeFlowProjectResponse() (response *DescribeFlowProjectResponse) {
	response = &DescribeFlowProjectResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
