package ddospro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeOplog invokes the ddospro.DescribeOplog API synchronously
// api document: https://help.aliyun.com/api/ddospro/describeoplog.html
func (client *Client) DescribeOplog(request *DescribeOplogRequest) (response *DescribeOplogResponse, err error) {
	response = CreateDescribeOplogResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeOplogWithChan invokes the ddospro.DescribeOplog API asynchronously
// api document: https://help.aliyun.com/api/ddospro/describeoplog.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeOplogWithChan(request *DescribeOplogRequest) (<-chan *DescribeOplogResponse, <-chan error) {
	responseChan := make(chan *DescribeOplogResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeOplog(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeOplogWithCallback invokes the ddospro.DescribeOplog API asynchronously
// api document: https://help.aliyun.com/api/ddospro/describeoplog.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeOplogWithCallback(request *DescribeOplogRequest, callback func(response *DescribeOplogResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeOplogResponse
		var err error
		defer close(result)
		response, err = client.DescribeOplog(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeOplogRequest is the request struct for api DescribeOplog
type DescribeOplogRequest struct {
	*requests.RpcRequest
	SourceIp        string           `position:"Query" name:"SourceIp"`
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceId      string           `position:"Query" name:"ResourceId"`
	Result          requests.Integer `position:"Query" name:"Result"`
	StartTime       requests.Integer `position:"Query" name:"StartTime"`
	EndTime         requests.Integer `position:"Query" name:"EndTime"`
	CurrentPage     requests.Integer `position:"Query" name:"CurrentPage"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
}

// DescribeOplogResponse is the response struct for api DescribeOplog
type DescribeOplogResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Total     int    `json:"Total" xml:"Total"`
	OplogList []Data `json:"OplogList" xml:"OplogList"`
}

// CreateDescribeOplogRequest creates a request to invoke DescribeOplog API
func CreateDescribeOplogRequest() (request *DescribeOplogRequest) {
	request = &DescribeOplogRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DDoSPro", "2017-07-25", "DescribeOplog", "", "")
	return
}

// CreateDescribeOplogResponse creates a response to parse from DescribeOplog response
func CreateDescribeOplogResponse() (response *DescribeOplogResponse) {
	response = &DescribeOplogResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
