package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ResetAntChainCertificate invokes the baas.ResetAntChainCertificate API synchronously
// api document: https://help.aliyun.com/api/baas/resetantchaincertificate.html
func (client *Client) ResetAntChainCertificate(request *ResetAntChainCertificateRequest) (response *ResetAntChainCertificateResponse, err error) {
	response = CreateResetAntChainCertificateResponse()
	err = client.DoAction(request, response)
	return
}

// ResetAntChainCertificateWithChan invokes the baas.ResetAntChainCertificate API asynchronously
// api document: https://help.aliyun.com/api/baas/resetantchaincertificate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ResetAntChainCertificateWithChan(request *ResetAntChainCertificateRequest) (<-chan *ResetAntChainCertificateResponse, <-chan error) {
	responseChan := make(chan *ResetAntChainCertificateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ResetAntChainCertificate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ResetAntChainCertificateWithCallback invokes the baas.ResetAntChainCertificate API asynchronously
// api document: https://help.aliyun.com/api/baas/resetantchaincertificate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ResetAntChainCertificateWithCallback(request *ResetAntChainCertificateRequest, callback func(response *ResetAntChainCertificateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ResetAntChainCertificateResponse
		var err error
		defer close(result)
		response, err = client.ResetAntChainCertificate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ResetAntChainCertificateRequest is the request struct for api ResetAntChainCertificate
type ResetAntChainCertificateRequest struct {
	*requests.RpcRequest
	AntChainId string `position:"Body" name:"AntChainId"`
}

// ResetAntChainCertificateResponse is the response struct for api ResetAntChainCertificate
type ResetAntChainCertificateResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    string `json:"Result" xml:"Result"`
}

// CreateResetAntChainCertificateRequest creates a request to invoke ResetAntChainCertificate API
func CreateResetAntChainCertificateRequest() (request *ResetAntChainCertificateRequest) {
	request = &ResetAntChainCertificateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-12-21", "ResetAntChainCertificate", "baas", "openAPI")
	return
}

// CreateResetAntChainCertificateResponse creates a response to parse from ResetAntChainCertificate response
func CreateResetAntChainCertificateResponse() (response *ResetAntChainCertificateResponse) {
	response = &ResetAntChainCertificateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
