/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.text;

import org.eclipse.draw2d.text.FlowBox;
import org.eclipse.draw2d.text.FlowUtilities;
import org.eclipse.draw2d.text.InlineFlow;
import org.eclipse.draw2d.text.LineBox;
import org.eclipse.draw2d.text.LineRoot;

public class NestedLine
extends LineBox {
    InlineFlow owner;
    private LineRoot root;

    NestedLine(InlineFlow owner) {
        this.owner = owner;
    }

    @Override
    public boolean containsPoint(int x, int y) {
        return x >= this.getX() && x < this.getX() + this.getWidth() && y >= this.getBaseline() - this.getAscentWithBorder() && y < this.getBaseline() + this.getDescentWithBorder();
    }

    @Override
    int getAscentWithBorder() {
        return this.contentAscent + FlowUtilities.getBorderAscent(this.owner);
    }

    @Override
    int getDescentWithBorder() {
        return this.contentDescent + FlowUtilities.getBorderDescent(this.owner);
    }

    @Override
    public int getBaseline() {
        return this.root.getBaseline();
    }

    @Override
    LineRoot getLineRoot() {
        return this.root;
    }

    @Override
    public int getOuterAscent() {
        return this.contentAscent + FlowUtilities.getBorderAscentWithMargin(this.owner);
    }

    @Override
    public int getOuterDescent() {
        return this.contentDescent + FlowUtilities.getBorderDescentWithMargin(this.owner);
    }

    @Override
    void setLineRoot(LineRoot root) {
        this.root = root;
        for (Object fragment : this.fragments) {
            ((FlowBox)fragment).setLineRoot(root);
        }
    }

    @Override
    public void setLineTop(int top) {
        throw new RuntimeException("not supported");
    }
}

