# Plotting

Rivet provides two mechanisms for comparing and plotting data files. The first one is 
based on PSTricks and comes with three commands --- `rivet-mkhtml`, `compare-histos` 
and `make-plots`. The second one, introduced in Rivet 3.1.8, uses Matplotlib and is 
activated with `rivet-mkhtml-mpl`. 

Both mechanisms produce nice comparison plots of publication quality from the YODA 
format text files and are described in more detail on this page. The Matplotlib-based
version of will become the default from Rivet 4.0 onwards. 

## PSTricks based plotting
The high-level program `rivet-mkhtml` will automatically create a plot
webpage from the given YODA files. It searches for reference data automatically
and uses the other two commands internally. Example:

```
rivet-mkhtml withUE.yoda:'Title=With UE' withoutUE.yoda:'LineColor=blue'
```

Run `rivet-mkhtml --help` to find out about all features and options.

Plotting options will be taken from `*.plot` files installed in Rivet's share directory.
These contain plotting instructions according to the `make-plots` syntax as documented in this
[make-plots section](customizeplots.md#customize-make-plots).
Such files can also be written for any plugin analysis and will be found if they are in the `RIVET_ANALYSIS_PATH`.

You can also run the other two commands separately:

`compare-histos` will accept a number of YODA files as input (ending in
`.yoda`, identify which plots are available in them, and combine the MC
and reference plots appropriately into a set of plot data files ending with
`.dat`. More options are described by running `compare-histos --help`.

Incidentally, the reference files for each Rivet analysis are to be found
in the installed Rivet shared data directory, `installdir/share/Rivet`.
You can find the location of this by using the `rivet-config` command:

```
rivet-config --datadir
```

You can plot the created data files using the `make-plots` command:

```
make-plots --pdf *.dat
```

The `--pdf` flag makes the output plots in PDF format: by default the output
is in postscript (`.ps`), and flags for conversion to EPS and PNG are also
available.

Note that the plotting tools internally use LaTeX for drawing, and for very
complex plots it might sometimes fail with an error message like
"TeX memory exceeded" (or "DVI file can't be opened"). In such
a case it is recommended to increase the allowed TeX memory size as described
e.g. in the [pgfplots manual](http://pgfplots.sourceforge.net/pgfplots.pdf)
in Section 6.2.

Furthermore, imagemagick's `convert` is used to convert .pdf files into .png
files for the plot website. Some versions of imagemagick might cause error
messages like `not authorized @ error/constitute.c/ReadImage/412`, which can
[be fixed](https://stackoverflow.com/q/52998331/3094872) by giving 
`rights="read|write"` for both PS and PDF formats in
`/etc/ImageMagick-7/policy.xml`.

## Matplotlib based plotting
Similar to `rivet-mkhtml`, the program `rivet-mkhtml-mpl` creates a HTML booklet
with plots from input YODA files. An example is:
```
rivet-mkhtml-mpl mc1.yoda:"Variations=^MUR1_MUF1_PDF303[0-9][0-9][0-9]$" --no-errs 
```
For all the available options on the command line, run `rivet-mkhtml-mpl --help`. 

The main `rivet-mkhtml-mpl` program first generates a set of standalone, executable
Python scripts that use Matplotlib to draw the plot canvas. The scripts are written
to the output directory and then executed to provide the plots. For each observable
in the input YODA file, such a Python script is generated. These are designed to be
highly customisable human-readable. 

Access to the executable Python scripts provides you the flexibility to tweak the 
plot exactly to your liking, for example specifying the output format (by default
PDF and PNG), writing extra text on the canvas or changing the font and size of the labels.

At the top of the Python script, you can find several parameters you might want
to change. For example, you can change the labels in the legend to any LaTeX-based
string by updating the items in the `labels` list:

```
# TeX-friendly labels for the legend
labels = [ r"Data", r"mc1", r"mc2" ]
```

Refer to the documentation on 
[custom plots with Matplotlib](customizeplots.md#customize-matplotlib-plots) for
more details and references to modify the plots.

In th Python script, you will also find the reference to a style sheet:
```
plt.style.use(os.path.join(plotDir, '../default.mplstyle'))
```
This loads a sheet with pre-defined Matplotlib settings, for example the font
and the font sizes. You can modify this sheet directly or swap it out with your
own style sheet completely.


An example of the generated script together with the default Rivet
style file is available in [this directory](mpl-output).