# 預設樣式

這裡蒐集了社群提交的 Starship 預設樣式。 如果你也想要分享你的樣式，請[提交一個 PR](https://github.com/starship/starship/edit/master/docs/presets/README.md) 來更新這個檔案！ 😊

To get details on how to use a preset, simply click on the image.

## [Nerd Font 符號](./nerd-font.md)

This preset changes the symbols for each module to use Nerd Font symbols.

[![Nerd Font 預設樣式的截圖](/presets/img/nerd-font-symbols.png "Click to view Nerd Font Symbols preset")](./nerd-font)

## [No Nerd Fonts](./no-nerd-font.md)

This preset changes the symbols for several modules so that no Nerd Font symbols are used anywhere in the prompt.

::: tip

This preset will become the default preset [in a future release of starship](https://github.com/starship/starship/pull/3544).

:::

[Click to view No Nerd Font preset](./no-nerd-font)

## [括號片段](./bracketed-segments.md)

這個預設樣式使所有模組使用括號片段內的格式顯示，而非使用 Starship 預設（"via", "on", etc.）。

[![括號片段預設樣式的截圖](/presets/img/bracketed-segments.png "Click to view Bracketed Segments preset")](./bracketed-segments)

## [純文字符號](./plain-text.md)

This preset changes the symbols for each module into plain text. Great if you don't have access to Unicode.

[![純文字符號預設樣式的截圖](/presets/img/plain-text-symbols.png "Click to view Plain Text Symbols preset")](./plain-text)

## [No Runtime Versions](./no-runtimes.md)

這個預設樣式隱藏了各個語言的執行環境版本。 如果你在容器或者虛擬環境中工作，那麼這個樣式是為你設計的！

[![隱藏運行版本預設樣式的截圖](/presets/img/no-runtime-versions.png "Click to view No Runtime Versions preset")](./no-runtimes)

## [No Empty Icons](./no-empty-icons.md)

This preset does not show icons if the toolset is not found.

[![Screenshot of No Empty Icons preset](/presets/img/no-empty-icons.png "Click to view No Runtime Versions preset")](./no-empty-icons.md)

## [Pure Prompt](./pure-preset.md)

This preset emulates the look and behavior of [Pure](https://github.com/sindresorhus/pure).

[![Screenshot of Pure preset](/presets/img/pure-preset.png "Click to view Pure Prompt preset")](./pure-preset)

## [Pastel Powerline](./pastel-powerline.md)

This preset is inspired by [M365Princess](https://github.com/JanDeDobbeleer/oh-my-posh/blob/main/themes/M365Princess.omp.json). It also shows how path substitution works in starship.

[![Screenshot of Pastel Powerline preset](/presets/img/pastel-powerline.png "Click to view Pure Prompt preset")](./pastel-powerline)

## [Tokyo Night](./tokyo-night.md)

This preset is inspired by [tokyo-night-vscode-theme](https://github.com/enkia/tokyo-night-vscode-theme).

[![Screenshot of Tokyo Night preset](/presets/img/tokyo-night.png "Click to view Tokyo Night preset")](./tokyo-night)

## [Gruvbox Rainbow](./gruvbox-rainbow.md)

This preset is heavily inspired by [Pastel Powerline](./pastel-powerline.md), and [Tokyo Night](./tokyo-night.md).

[![Screenshot of Gruvbox Rainbow preset](/presets/img/gruvbox-rainbow.png "Click to view Gruvbox Rainbow preset")](./gruvbox-rainbow)

## [Jetpack](./jetpack.md)

This is a pseudo minimalist preset inspired by the [geometry](https://github.com/geometry-zsh/geometry) and [spaceship](https://github.com/spaceship-prompt/spaceship-prompt) prompts.

[![Screenshot of Jetpack preset](/presets/img/jetpack.png "Click to view Jetpack preset")](./jetpack)

## [Catppuccin Powerline](./catppuccin-powerline.md)

This preset is a minimally modified version of [Gruvbox Rainbow](./gruvbox-rainbow.md) using the [Catppuccin](https://github.com/catppuccin/catppuccin) theme palette.

[![Screenshot of Catppuccin Powerline preset](/presets/img/catppuccin-powerline.png "Click to view Catppuccin Powerline preset")](./catppuccin-powerline)
