/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.workgroup.packet;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.TimeZone;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.IqData;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.provider.IqProvider;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;
import org.jxmpp.JxmppContext;

public class OccupantsInfo
extends IQ {
    private static final SimpleDateFormat UTC_FORMAT = new SimpleDateFormat("yyyyMMdd'T'HH:mm:ss");
    public static final String ELEMENT_NAME = "occupants-info";
    public static final String NAMESPACE = "http://jivesoftware.com/protocol/workgroup";
    private final String roomID;
    private final Set<OccupantInfo> occupants;

    public OccupantsInfo(String roomID) {
        super(ELEMENT_NAME, NAMESPACE);
        this.roomID = roomID;
        this.occupants = new HashSet<OccupantInfo>();
    }

    public String getRoomID() {
        return this.roomID;
    }

    public int getOccupantsCount() {
        return this.occupants.size();
    }

    public Set<OccupantInfo> getOccupants() {
        return Collections.unmodifiableSet(this.occupants);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected IQ.IQChildElementXmlStringBuilder getIQChildElementBuilder(IQ.IQChildElementXmlStringBuilder buf) {
        buf.append(" roomID=\"").append(this.roomID).append("\">");
        Set<OccupantInfo> set = this.occupants;
        synchronized (set) {
            for (OccupantInfo occupant : this.occupants) {
                buf.append("<occupant>");
                buf.append("<jid>");
                buf.append(occupant.getJID());
                buf.append("</jid>");
                buf.append("<name>");
                buf.append(occupant.getNickname());
                buf.append("</name>");
                buf.append("<joined>");
                SimpleDateFormat simpleDateFormat = UTC_FORMAT;
                synchronized (simpleDateFormat) {
                    buf.append(UTC_FORMAT.format(occupant.getJoined()));
                }
                buf.append("</joined>");
                buf.append("</occupant>");
            }
        }
        return buf;
    }

    static {
        UTC_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT+0"));
    }

    public static class OccupantInfo {
        private final String jid;
        private final String nickname;
        private final Date joined;

        public OccupantInfo(String jid, String nickname, Date joined) {
            this.jid = jid;
            this.nickname = nickname;
            this.joined = joined;
        }

        public String getJID() {
            return this.jid;
        }

        public String getNickname() {
            return this.nickname;
        }

        public Date getJoined() {
            return this.joined;
        }
    }

    public static class Provider
    extends IqProvider<OccupantsInfo> {
        @Override
        public OccupantsInfo parse(XmlPullParser parser, int initialDepth, IqData iqData, XmlEnvironment xmlEnvironment, JxmppContext jxmppContext) throws XmlPullParserException, IOException, ParseException {
            OccupantsInfo occupantsInfo = new OccupantsInfo(parser.getAttributeValue("", "roomID"));
            boolean done = false;
            while (!done) {
                XmlPullParser.Event eventType = parser.next();
                if (eventType == XmlPullParser.Event.START_ELEMENT && "occupant".equals(parser.getName())) {
                    occupantsInfo.occupants.add(Provider.parseOccupantInfo(parser));
                    continue;
                }
                if (eventType != XmlPullParser.Event.END_ELEMENT || !OccupantsInfo.ELEMENT_NAME.equals(parser.getName())) continue;
                done = true;
            }
            return occupantsInfo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static OccupantInfo parseOccupantInfo(XmlPullParser parser) throws XmlPullParserException, IOException, ParseException {
            boolean done = false;
            String jid = null;
            String nickname = null;
            Date joined = null;
            while (!done) {
                XmlPullParser.Event eventType = parser.next();
                if (eventType == XmlPullParser.Event.START_ELEMENT && "jid".equals(parser.getName())) {
                    jid = parser.nextText();
                    continue;
                }
                if (eventType == XmlPullParser.Event.START_ELEMENT && "nickname".equals(parser.getName())) {
                    nickname = parser.nextText();
                    continue;
                }
                if (eventType == XmlPullParser.Event.START_ELEMENT && "joined".equals(parser.getName())) {
                    SimpleDateFormat simpleDateFormat = UTC_FORMAT;
                    synchronized (simpleDateFormat) {
                        joined = UTC_FORMAT.parse(parser.nextText());
                        continue;
                    }
                }
                if (eventType != XmlPullParser.Event.END_ELEMENT || !"occupant".equals(parser.getName())) continue;
                done = true;
            }
            return new OccupantInfo(jid, nickname, joined);
        }
    }
}

