/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.stanza_content_encryption.element;

import java.security.SecureRandom;
import org.jivesoftware.smack.packet.NamedElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.EqualsUtil;
import org.jivesoftware.smack.util.RandomUtil;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.util.XmlStringBuilder;
import org.jivesoftware.smackx.stanza_content_encryption.element.AffixElement;

public class RandomPaddingAffixElement
implements NamedElement,
AffixElement {
    private static final int minPaddingLength = 1;
    private static final int maxPaddingLength = 200;
    public static final String ELEMENT = "rpad";
    private final String padding;

    public RandomPaddingAffixElement(String padding) {
        this.padding = StringUtils.escapeForXmlText(StringUtils.requireNotNullNorEmpty(padding, "Value of 'rpad' MUST NOT be null nor empty.")).toString();
    }

    public RandomPaddingAffixElement() {
        this(StringUtils.randomString(RandomPaddingAffixElement.randomPaddingLength(), new SecureRandom()));
    }

    private static int randomPaddingLength() {
        return 1 + RandomUtil.nextSecureRandomInt(199);
    }

    public String getPadding() {
        return this.padding;
    }

    @Override
    public String getElementName() {
        return ELEMENT;
    }

    @Override
    public XmlStringBuilder toXML(XmlEnvironment xmlEnvironment) {
        return new XmlStringBuilder(this).rightAngleBracket().append(this.getPadding()).closeElement(this);
    }

    public boolean equals(Object obj) {
        return EqualsUtil.equals(this, obj, (e, o) -> e.append(this.getPadding(), o.getPadding()));
    }

    public int hashCode() {
        return this.getPadding().hashCode();
    }
}

