/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.pubsub;

import java.io.IOException;
import javax.xml.namespace.QName;
import org.jivesoftware.smack.packet.XmlElement;
import org.jivesoftware.smack.packet.XmlEnvironment;
import org.jivesoftware.smack.util.PacketParserUtils;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;

public class SimplePayload
implements XmlElement {
    private final String elemName;
    private final String ns;
    private final String payload;

    public SimplePayload(String xmlPayload) {
        XmlPullParser parser;
        try {
            parser = PacketParserUtils.getParserFor(xmlPayload);
        }
        catch (IOException | XmlPullParserException e) {
            throw new AssertionError((Object)e);
        }
        QName qname = parser.getQName();
        this.payload = xmlPayload;
        this.elemName = StringUtils.requireNotNullNorEmpty(qname.getLocalPart(), "Could not determine element name from XML payload");
        this.ns = StringUtils.requireNotNullNorEmpty(qname.getNamespaceURI(), "Could not determine namespace from XML payload");
    }

    @Override
    public String getElementName() {
        return this.elemName;
    }

    @Override
    public String getNamespace() {
        return this.ns;
    }

    @Override
    public String toXML(XmlEnvironment enclosingNamespace) {
        return this.payload;
    }

    public String toString() {
        return this.getClass().getName() + "payload [" + String.valueOf(this.toXML()) + "]";
    }
}

