/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.message_retraction;

import java.util.Map;
import java.util.WeakHashMap;
import org.jivesoftware.smack.ConnectionCreationListener;
import org.jivesoftware.smack.Manager;
import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPConnectionRegistry;
import org.jivesoftware.smack.packet.MessageBuilder;
import org.jivesoftware.smackx.disco.ServiceDiscoveryManager;
import org.jivesoftware.smackx.message_fastening.element.FasteningElement;
import org.jivesoftware.smackx.message_retraction.element.RetractElement;
import org.jivesoftware.smackx.sid.element.OriginIdElement;

public final class MessageRetractionManager
extends Manager {
    private static final Map<XMPPConnection, MessageRetractionManager> INSTANCES = new WeakHashMap<XMPPConnection, MessageRetractionManager>();
    private static boolean ENABLED_BY_DEFAULT = false;

    private MessageRetractionManager(XMPPConnection connection) {
        super(connection);
    }

    public static synchronized MessageRetractionManager getInstanceFor(XMPPConnection connection) {
        MessageRetractionManager manager = INSTANCES.get(connection);
        if (manager == null) {
            manager = new MessageRetractionManager(connection);
            INSTANCES.put(connection, manager);
        }
        return manager;
    }

    public static synchronized void setEnabledByDefault(boolean enabled) {
        ENABLED_BY_DEFAULT = enabled;
    }

    public void announceSupport() {
        ServiceDiscoveryManager.getInstanceFor(this.connection()).addFeature("urn:xmpp:message-retract:0");
    }

    public void stopAnnouncingSupport() {
        ServiceDiscoveryManager.getInstanceFor(this.connection()).removeFeature("urn:xmpp:message-retract:0");
    }

    public static void addRetractionElementToMessage(OriginIdElement retractedMessageId, MessageBuilder carrierMessageBuilder) {
        FasteningElement fasteningElement = FasteningElement.builder().setOriginId(retractedMessageId).addWrappedPayload(new RetractElement()).build();
        fasteningElement.applyTo(carrierMessageBuilder);
    }

    public void retractMessage(OriginIdElement retractedMessageId) throws SmackException.NotConnectedException, InterruptedException {
        MessageBuilder message = this.connection().getStanzaFactory().buildMessageStanza();
        MessageRetractionManager.addRetractionElementToMessage(retractedMessageId, message);
        this.connection().sendStanza(message.build());
    }

    static {
        XMPPConnectionRegistry.addConnectionCreationListener(new ConnectionCreationListener(){

            @Override
            public void connectionCreated(XMPPConnection connection) {
                if (ENABLED_BY_DEFAULT) {
                    MessageRetractionManager.getInstanceFor(connection).announceSupport();
                }
            }
        });
    }
}

