# Philosophy

Before settling for Material for MkDocs, it's a good idea to understand the
philosophy behind the project, in order to make sure it aligns with your goals.
This page explains the design principles anchored in Material for MkDocs, and
discusses the [conventions] used in this documentation.

  [conventions]: conventions.md

## Design principles

- **It's just Markdown**: Focus on the content of your documentation and create a professional static site in minutes. No need to know HTML, CSS or JavaScript – let Material for MkDocs do the heavy lifting for you.

- **Works on all devices**: Serve your documentation with confidence – Material for MkDocs automatically adapts to perfectly fit the available screen estate, no matter the type or size of the viewing device. Desktop. Tablet. Mobile. All great.

- **Made to measure**: Make it yours – change the colors, fonts, language, icons, logo, and more with a few lines of configuration. Material for MkDocs can be easily extended and provides many options to alter appearance and behavior.

- **Fast and lightweight**: Don't let your users wait – get incredible value with a small footprint by using one of the fastest themes available with excellent performance, yielding optimal search engine rankings and happy users that return.

- **Maintain ownership**: Make accessibility a priority – users can navigate your
  documentation with touch devices, keyboard, and screen readers. Semantic
  markup ensures that your documentation works for everyone.

- **Open Source**: You're in good company – choose a mature and actively maintained solution built with state-of-the-art Open Source technologies, trusted by more than 50.000 individuals and organizations. Licensed under MIT.
