// Flags: --permission --allow-fs-read=* --allow-child-process

'use strict';

const { skip, isWindows, isIBMi } = require('../common');
const { deepStrictEqual } = require('assert');
const { isMainThread } = require('worker_threads');

if (!isMainThread) {
  skip('process.execve is not available in Workers');
} else if (isWindows || isIBMi) {
  skip('process.execve is not available in Windows or IBM i');
}

if (process.argv[2] === 'replaced') {
  deepStrictEqual(process.argv, [process.execPath, __filename, 'replaced']);
} else {
  process.execve(process.execPath, [process.execPath, __filename, 'replaced'], process.env);
}
