// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/contentwarehouse/v1/document_schema_service.proto

package contentwarehouse

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Request message for DocumentSchemaService.CreateDocumentSchema.
type CreateDocumentSchemaRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent name.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The document schema to create.
	DocumentSchema *DocumentSchema `protobuf:"bytes,2,opt,name=document_schema,json=documentSchema,proto3" json:"document_schema,omitempty"`
}

func (x *CreateDocumentSchemaRequest) Reset() {
	*x = CreateDocumentSchemaRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_document_schema_service_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateDocumentSchemaRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateDocumentSchemaRequest) ProtoMessage() {}

func (x *CreateDocumentSchemaRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_document_schema_service_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateDocumentSchemaRequest.ProtoReflect.Descriptor instead.
func (*CreateDocumentSchemaRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_document_schema_service_proto_rawDescGZIP(), []int{0}
}

func (x *CreateDocumentSchemaRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateDocumentSchemaRequest) GetDocumentSchema() *DocumentSchema {
	if x != nil {
		return x.DocumentSchema
	}
	return nil
}

// Request message for DocumentSchemaService.GetDocumentSchema.
type GetDocumentSchemaRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the document schema to retrieve.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetDocumentSchemaRequest) Reset() {
	*x = GetDocumentSchemaRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_document_schema_service_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetDocumentSchemaRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetDocumentSchemaRequest) ProtoMessage() {}

func (x *GetDocumentSchemaRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_document_schema_service_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetDocumentSchemaRequest.ProtoReflect.Descriptor instead.
func (*GetDocumentSchemaRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_document_schema_service_proto_rawDescGZIP(), []int{1}
}

func (x *GetDocumentSchemaRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for DocumentSchemaService.UpdateDocumentSchema.
type UpdateDocumentSchemaRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the document schema to update.
	// Format:
	// projects/{project_number}/locations/{location}/documentSchemas/{document_schema_id}.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The document schema to update with.
	DocumentSchema *DocumentSchema `protobuf:"bytes,2,opt,name=document_schema,json=documentSchema,proto3" json:"document_schema,omitempty"`
}

func (x *UpdateDocumentSchemaRequest) Reset() {
	*x = UpdateDocumentSchemaRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_document_schema_service_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateDocumentSchemaRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateDocumentSchemaRequest) ProtoMessage() {}

func (x *UpdateDocumentSchemaRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_document_schema_service_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateDocumentSchemaRequest.ProtoReflect.Descriptor instead.
func (*UpdateDocumentSchemaRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_document_schema_service_proto_rawDescGZIP(), []int{2}
}

func (x *UpdateDocumentSchemaRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *UpdateDocumentSchemaRequest) GetDocumentSchema() *DocumentSchema {
	if x != nil {
		return x.DocumentSchema
	}
	return nil
}

// Request message for DocumentSchemaService.DeleteDocumentSchema.
type DeleteDocumentSchemaRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the document schema to delete.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteDocumentSchemaRequest) Reset() {
	*x = DeleteDocumentSchemaRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_document_schema_service_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteDocumentSchemaRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteDocumentSchemaRequest) ProtoMessage() {}

func (x *DeleteDocumentSchemaRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_document_schema_service_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteDocumentSchemaRequest.ProtoReflect.Descriptor instead.
func (*DeleteDocumentSchemaRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_document_schema_service_proto_rawDescGZIP(), []int{3}
}

func (x *DeleteDocumentSchemaRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for DocumentSchemaService.ListDocumentSchemas.
type ListDocumentSchemasRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent, which owns this collection of document schemas.
	// Format: projects/{project_number}/locations/{location}.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of document schemas to return. The service may return
	// fewer than this value.
	// If unspecified, at most 50 document schemas will be returned.
	// The maximum value is 1000; values above 1000 will be coerced to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListDocumentSchemas` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListDocumentSchemas`
	// must match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListDocumentSchemasRequest) Reset() {
	*x = ListDocumentSchemasRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_document_schema_service_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDocumentSchemasRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDocumentSchemasRequest) ProtoMessage() {}

func (x *ListDocumentSchemasRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_document_schema_service_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDocumentSchemasRequest.ProtoReflect.Descriptor instead.
func (*ListDocumentSchemasRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_document_schema_service_proto_rawDescGZIP(), []int{4}
}

func (x *ListDocumentSchemasRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListDocumentSchemasRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListDocumentSchemasRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for DocumentSchemaService.ListDocumentSchemas.
type ListDocumentSchemasResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The document schemas from the specified parent.
	DocumentSchemas []*DocumentSchema `protobuf:"bytes,1,rep,name=document_schemas,json=documentSchemas,proto3" json:"document_schemas,omitempty"`
	// A token, which can be sent as `page_token` to retrieve the next page.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListDocumentSchemasResponse) Reset() {
	*x = ListDocumentSchemasResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_document_schema_service_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListDocumentSchemasResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListDocumentSchemasResponse) ProtoMessage() {}

func (x *ListDocumentSchemasResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_document_schema_service_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListDocumentSchemasResponse.ProtoReflect.Descriptor instead.
func (*ListDocumentSchemasResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_document_schema_service_proto_rawDescGZIP(), []int{5}
}

func (x *ListDocumentSchemasResponse) GetDocumentSchemas() []*DocumentSchema {
	if x != nil {
		return x.DocumentSchemas
	}
	return nil
}

func (x *ListDocumentSchemasResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

var File_google_cloud_contentwarehouse_v1_document_schema_service_proto protoreflect.FileDescriptor

var file_google_cloud_contentwarehouse_v1_document_schema_service_proto_rawDesc = []byte{
	0x0a, 0x3e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2f,
	0x76, 0x31, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x63, 0x68, 0x65,
	0x6d, 0x61, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e,
	0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61,
	0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69,
	0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61,
	0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x36, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68,
	0x6f, 0x75, 0x73, 0x65, 0x2f, 0x76, 0x31, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65,
	0x6d, 0x70, 0x74, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xc7, 0x01, 0x0a, 0x1b, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x63, 0x68,
	0x65, 0x6d, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x2a, 0x0a, 0x28, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68,
	0x6f, 0x75, 0x73, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x12, 0x5e, 0x0a, 0x0f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x63,
	0x68, 0x65, 0x6d, 0x61, 0x22, 0x66, 0x0a, 0x18, 0x47, 0x65, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x4a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x36,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x30, 0x0a, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77,
	0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xc9, 0x01, 0x0a,
	0x1b, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x53,
	0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x36, 0xe0, 0x41, 0x02, 0xfa,
	0x41, 0x30, 0x0a, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68,
	0x6f, 0x75, 0x73, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x63, 0x68, 0x65,
	0x6d, 0x61, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x5e, 0x0a, 0x0f, 0x64, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x63, 0x68,
	0x65, 0x6d, 0x61, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x22, 0x69, 0x0a, 0x1b, 0x44, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4a, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x36, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x30, 0x0a, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x22, 0xa2, 0x01, 0x0a, 0x1a, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x48, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x63, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52,
	0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xa2, 0x01, 0x0a, 0x1b, 0x4c, 0x69, 0x73,
	0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x5b, 0x0a, 0x10, 0x64, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75,
	0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x63,
	0x68, 0x65, 0x6d, 0x61, 0x52, 0x0f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x63,
	0x68, 0x65, 0x6d, 0x61, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x32, 0x95, 0x09,
	0x0a, 0x15, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12, 0xee, 0x01, 0x0a, 0x14, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61,
	0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x63, 0x68, 0x65, 0x6d,
	0x61, 0x22, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x46, 0x22, 0x33, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x64,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x73, 0x3a, 0x0f,
	0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0xda,
	0x41, 0x16, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
	0x74, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0xde, 0x01, 0x0a, 0x14, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x63, 0x68, 0x65, 0x6d,
	0x61, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x63, 0x68, 0x65,
	0x6d, 0x61, 0x22, 0x55, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x38, 0x32, 0x33, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x73, 0x2f, 0x2a, 0x7d, 0x3a,
	0x01, 0x2a, 0xda, 0x41, 0x14, 0x6e, 0x61, 0x6d, 0x65, 0x2c, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0xc5, 0x01, 0x0a, 0x11, 0x47, 0x65,
	0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12,
	0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x63,
	0x68, 0x65, 0x6d, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x30, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x22, 0x42, 0x82,
	0xd3, 0xe4, 0x93, 0x02, 0x35, 0x12, 0x33, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0xb1, 0x01, 0x0a, 0x14, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x44, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x3d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65,
	0x6c, 0x65, 0x74, 0x65, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x63, 0x68, 0x65,
	0x6d, 0x61, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74,
	0x79, 0x22, 0x42, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x35, 0x2a, 0x33, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x73, 0x2f, 0x2a, 0x7d, 0xda, 0x41,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0xd8, 0x01, 0x0a, 0x13, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x73, 0x12, 0x3c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x63, 0x68,
	0x65, 0x6d, 0x61, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x4c,
	0x69, 0x73, 0x74, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x63, 0x68, 0x65, 0x6d,
	0x61, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x44, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x35, 0x12, 0x33, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
	0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x73, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x1a, 0x53, 0xca, 0x41, 0x1f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65,
	0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77,
	0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0x96, 0x01, 0x0a, 0x24, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x42, 0x1a,
	0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x53, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x50, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f,
	0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2f, 0x76, 0x31, 0x3b, 0x63, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x62, 0x06,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_contentwarehouse_v1_document_schema_service_proto_rawDescOnce sync.Once
	file_google_cloud_contentwarehouse_v1_document_schema_service_proto_rawDescData = file_google_cloud_contentwarehouse_v1_document_schema_service_proto_rawDesc
)

func file_google_cloud_contentwarehouse_v1_document_schema_service_proto_rawDescGZIP() []byte {
	file_google_cloud_contentwarehouse_v1_document_schema_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_contentwarehouse_v1_document_schema_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_contentwarehouse_v1_document_schema_service_proto_rawDescData)
	})
	return file_google_cloud_contentwarehouse_v1_document_schema_service_proto_rawDescData
}

var file_google_cloud_contentwarehouse_v1_document_schema_service_proto_msgTypes = make([]protoimpl.MessageInfo, 6)
var file_google_cloud_contentwarehouse_v1_document_schema_service_proto_goTypes = []interface{}{
	(*CreateDocumentSchemaRequest)(nil), // 0: google.cloud.contentwarehouse.v1.CreateDocumentSchemaRequest
	(*GetDocumentSchemaRequest)(nil),    // 1: google.cloud.contentwarehouse.v1.GetDocumentSchemaRequest
	(*UpdateDocumentSchemaRequest)(nil), // 2: google.cloud.contentwarehouse.v1.UpdateDocumentSchemaRequest
	(*DeleteDocumentSchemaRequest)(nil), // 3: google.cloud.contentwarehouse.v1.DeleteDocumentSchemaRequest
	(*ListDocumentSchemasRequest)(nil),  // 4: google.cloud.contentwarehouse.v1.ListDocumentSchemasRequest
	(*ListDocumentSchemasResponse)(nil), // 5: google.cloud.contentwarehouse.v1.ListDocumentSchemasResponse
	(*DocumentSchema)(nil),              // 6: google.cloud.contentwarehouse.v1.DocumentSchema
	(*emptypb.Empty)(nil),               // 7: google.protobuf.Empty
}
var file_google_cloud_contentwarehouse_v1_document_schema_service_proto_depIdxs = []int32{
	6, // 0: google.cloud.contentwarehouse.v1.CreateDocumentSchemaRequest.document_schema:type_name -> google.cloud.contentwarehouse.v1.DocumentSchema
	6, // 1: google.cloud.contentwarehouse.v1.UpdateDocumentSchemaRequest.document_schema:type_name -> google.cloud.contentwarehouse.v1.DocumentSchema
	6, // 2: google.cloud.contentwarehouse.v1.ListDocumentSchemasResponse.document_schemas:type_name -> google.cloud.contentwarehouse.v1.DocumentSchema
	0, // 3: google.cloud.contentwarehouse.v1.DocumentSchemaService.CreateDocumentSchema:input_type -> google.cloud.contentwarehouse.v1.CreateDocumentSchemaRequest
	2, // 4: google.cloud.contentwarehouse.v1.DocumentSchemaService.UpdateDocumentSchema:input_type -> google.cloud.contentwarehouse.v1.UpdateDocumentSchemaRequest
	1, // 5: google.cloud.contentwarehouse.v1.DocumentSchemaService.GetDocumentSchema:input_type -> google.cloud.contentwarehouse.v1.GetDocumentSchemaRequest
	3, // 6: google.cloud.contentwarehouse.v1.DocumentSchemaService.DeleteDocumentSchema:input_type -> google.cloud.contentwarehouse.v1.DeleteDocumentSchemaRequest
	4, // 7: google.cloud.contentwarehouse.v1.DocumentSchemaService.ListDocumentSchemas:input_type -> google.cloud.contentwarehouse.v1.ListDocumentSchemasRequest
	6, // 8: google.cloud.contentwarehouse.v1.DocumentSchemaService.CreateDocumentSchema:output_type -> google.cloud.contentwarehouse.v1.DocumentSchema
	6, // 9: google.cloud.contentwarehouse.v1.DocumentSchemaService.UpdateDocumentSchema:output_type -> google.cloud.contentwarehouse.v1.DocumentSchema
	6, // 10: google.cloud.contentwarehouse.v1.DocumentSchemaService.GetDocumentSchema:output_type -> google.cloud.contentwarehouse.v1.DocumentSchema
	7, // 11: google.cloud.contentwarehouse.v1.DocumentSchemaService.DeleteDocumentSchema:output_type -> google.protobuf.Empty
	5, // 12: google.cloud.contentwarehouse.v1.DocumentSchemaService.ListDocumentSchemas:output_type -> google.cloud.contentwarehouse.v1.ListDocumentSchemasResponse
	8, // [8:13] is the sub-list for method output_type
	3, // [3:8] is the sub-list for method input_type
	3, // [3:3] is the sub-list for extension type_name
	3, // [3:3] is the sub-list for extension extendee
	0, // [0:3] is the sub-list for field type_name
}

func init() { file_google_cloud_contentwarehouse_v1_document_schema_service_proto_init() }
func file_google_cloud_contentwarehouse_v1_document_schema_service_proto_init() {
	if File_google_cloud_contentwarehouse_v1_document_schema_service_proto != nil {
		return
	}
	file_google_cloud_contentwarehouse_v1_document_schema_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_contentwarehouse_v1_document_schema_service_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateDocumentSchemaRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contentwarehouse_v1_document_schema_service_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetDocumentSchemaRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contentwarehouse_v1_document_schema_service_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateDocumentSchemaRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contentwarehouse_v1_document_schema_service_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteDocumentSchemaRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contentwarehouse_v1_document_schema_service_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListDocumentSchemasRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contentwarehouse_v1_document_schema_service_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListDocumentSchemasResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_contentwarehouse_v1_document_schema_service_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   6,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_contentwarehouse_v1_document_schema_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_contentwarehouse_v1_document_schema_service_proto_depIdxs,
		MessageInfos:      file_google_cloud_contentwarehouse_v1_document_schema_service_proto_msgTypes,
	}.Build()
	File_google_cloud_contentwarehouse_v1_document_schema_service_proto = out.File
	file_google_cloud_contentwarehouse_v1_document_schema_service_proto_rawDesc = nil
	file_google_cloud_contentwarehouse_v1_document_schema_service_proto_goTypes = nil
	file_google_cloud_contentwarehouse_v1_document_schema_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// DocumentSchemaServiceClient is the client API for DocumentSchemaService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type DocumentSchemaServiceClient interface {
	// Creates a document schema.
	CreateDocumentSchema(ctx context.Context, in *CreateDocumentSchemaRequest, opts ...grpc.CallOption) (*DocumentSchema, error)
	// Updates a Document Schema. Returns INVALID_ARGUMENT if the name of the
	// Document Schema is non-empty and does not equal the existing name.
	// Supports only appending new properties, adding new ENUM possible values,
	// and updating the [EnumTypeOptions.validation_check_disabled][google.cloud.contentwarehouse.v1.EnumTypeOptions.validation_check_disabled] flag for
	// ENUM possible values. Updating existing properties will result into
	// INVALID_ARGUMENT.
	UpdateDocumentSchema(ctx context.Context, in *UpdateDocumentSchemaRequest, opts ...grpc.CallOption) (*DocumentSchema, error)
	// Gets a document schema. Returns NOT_FOUND if the document schema does not
	// exist.
	GetDocumentSchema(ctx context.Context, in *GetDocumentSchemaRequest, opts ...grpc.CallOption) (*DocumentSchema, error)
	// Deletes a document schema. Returns NOT_FOUND if the document schema does
	// not exist. Returns BAD_REQUEST if the document schema has documents
	// depending on it.
	DeleteDocumentSchema(ctx context.Context, in *DeleteDocumentSchemaRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Lists document schemas.
	ListDocumentSchemas(ctx context.Context, in *ListDocumentSchemasRequest, opts ...grpc.CallOption) (*ListDocumentSchemasResponse, error)
}

type documentSchemaServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewDocumentSchemaServiceClient(cc grpc.ClientConnInterface) DocumentSchemaServiceClient {
	return &documentSchemaServiceClient{cc}
}

func (c *documentSchemaServiceClient) CreateDocumentSchema(ctx context.Context, in *CreateDocumentSchemaRequest, opts ...grpc.CallOption) (*DocumentSchema, error) {
	out := new(DocumentSchema)
	err := c.cc.Invoke(ctx, "/google.cloud.contentwarehouse.v1.DocumentSchemaService/CreateDocumentSchema", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentSchemaServiceClient) UpdateDocumentSchema(ctx context.Context, in *UpdateDocumentSchemaRequest, opts ...grpc.CallOption) (*DocumentSchema, error) {
	out := new(DocumentSchema)
	err := c.cc.Invoke(ctx, "/google.cloud.contentwarehouse.v1.DocumentSchemaService/UpdateDocumentSchema", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentSchemaServiceClient) GetDocumentSchema(ctx context.Context, in *GetDocumentSchemaRequest, opts ...grpc.CallOption) (*DocumentSchema, error) {
	out := new(DocumentSchema)
	err := c.cc.Invoke(ctx, "/google.cloud.contentwarehouse.v1.DocumentSchemaService/GetDocumentSchema", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentSchemaServiceClient) DeleteDocumentSchema(ctx context.Context, in *DeleteDocumentSchemaRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.contentwarehouse.v1.DocumentSchemaService/DeleteDocumentSchema", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *documentSchemaServiceClient) ListDocumentSchemas(ctx context.Context, in *ListDocumentSchemasRequest, opts ...grpc.CallOption) (*ListDocumentSchemasResponse, error) {
	out := new(ListDocumentSchemasResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.contentwarehouse.v1.DocumentSchemaService/ListDocumentSchemas", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DocumentSchemaServiceServer is the server API for DocumentSchemaService service.
type DocumentSchemaServiceServer interface {
	// Creates a document schema.
	CreateDocumentSchema(context.Context, *CreateDocumentSchemaRequest) (*DocumentSchema, error)
	// Updates a Document Schema. Returns INVALID_ARGUMENT if the name of the
	// Document Schema is non-empty and does not equal the existing name.
	// Supports only appending new properties, adding new ENUM possible values,
	// and updating the [EnumTypeOptions.validation_check_disabled][google.cloud.contentwarehouse.v1.EnumTypeOptions.validation_check_disabled] flag for
	// ENUM possible values. Updating existing properties will result into
	// INVALID_ARGUMENT.
	UpdateDocumentSchema(context.Context, *UpdateDocumentSchemaRequest) (*DocumentSchema, error)
	// Gets a document schema. Returns NOT_FOUND if the document schema does not
	// exist.
	GetDocumentSchema(context.Context, *GetDocumentSchemaRequest) (*DocumentSchema, error)
	// Deletes a document schema. Returns NOT_FOUND if the document schema does
	// not exist. Returns BAD_REQUEST if the document schema has documents
	// depending on it.
	DeleteDocumentSchema(context.Context, *DeleteDocumentSchemaRequest) (*emptypb.Empty, error)
	// Lists document schemas.
	ListDocumentSchemas(context.Context, *ListDocumentSchemasRequest) (*ListDocumentSchemasResponse, error)
}

// UnimplementedDocumentSchemaServiceServer can be embedded to have forward compatible implementations.
type UnimplementedDocumentSchemaServiceServer struct {
}

func (*UnimplementedDocumentSchemaServiceServer) CreateDocumentSchema(context.Context, *CreateDocumentSchemaRequest) (*DocumentSchema, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateDocumentSchema not implemented")
}
func (*UnimplementedDocumentSchemaServiceServer) UpdateDocumentSchema(context.Context, *UpdateDocumentSchemaRequest) (*DocumentSchema, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateDocumentSchema not implemented")
}
func (*UnimplementedDocumentSchemaServiceServer) GetDocumentSchema(context.Context, *GetDocumentSchemaRequest) (*DocumentSchema, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDocumentSchema not implemented")
}
func (*UnimplementedDocumentSchemaServiceServer) DeleteDocumentSchema(context.Context, *DeleteDocumentSchemaRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteDocumentSchema not implemented")
}
func (*UnimplementedDocumentSchemaServiceServer) ListDocumentSchemas(context.Context, *ListDocumentSchemasRequest) (*ListDocumentSchemasResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListDocumentSchemas not implemented")
}

func RegisterDocumentSchemaServiceServer(s *grpc.Server, srv DocumentSchemaServiceServer) {
	s.RegisterService(&_DocumentSchemaService_serviceDesc, srv)
}

func _DocumentSchemaService_CreateDocumentSchema_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateDocumentSchemaRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentSchemaServiceServer).CreateDocumentSchema(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.contentwarehouse.v1.DocumentSchemaService/CreateDocumentSchema",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentSchemaServiceServer).CreateDocumentSchema(ctx, req.(*CreateDocumentSchemaRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentSchemaService_UpdateDocumentSchema_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDocumentSchemaRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentSchemaServiceServer).UpdateDocumentSchema(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.contentwarehouse.v1.DocumentSchemaService/UpdateDocumentSchema",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentSchemaServiceServer).UpdateDocumentSchema(ctx, req.(*UpdateDocumentSchemaRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentSchemaService_GetDocumentSchema_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDocumentSchemaRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentSchemaServiceServer).GetDocumentSchema(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.contentwarehouse.v1.DocumentSchemaService/GetDocumentSchema",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentSchemaServiceServer).GetDocumentSchema(ctx, req.(*GetDocumentSchemaRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentSchemaService_DeleteDocumentSchema_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDocumentSchemaRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentSchemaServiceServer).DeleteDocumentSchema(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.contentwarehouse.v1.DocumentSchemaService/DeleteDocumentSchema",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentSchemaServiceServer).DeleteDocumentSchema(ctx, req.(*DeleteDocumentSchemaRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DocumentSchemaService_ListDocumentSchemas_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDocumentSchemasRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DocumentSchemaServiceServer).ListDocumentSchemas(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.contentwarehouse.v1.DocumentSchemaService/ListDocumentSchemas",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DocumentSchemaServiceServer).ListDocumentSchemas(ctx, req.(*ListDocumentSchemasRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _DocumentSchemaService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.contentwarehouse.v1.DocumentSchemaService",
	HandlerType: (*DocumentSchemaServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateDocumentSchema",
			Handler:    _DocumentSchemaService_CreateDocumentSchema_Handler,
		},
		{
			MethodName: "UpdateDocumentSchema",
			Handler:    _DocumentSchemaService_UpdateDocumentSchema_Handler,
		},
		{
			MethodName: "GetDocumentSchema",
			Handler:    _DocumentSchemaService_GetDocumentSchema_Handler,
		},
		{
			MethodName: "DeleteDocumentSchema",
			Handler:    _DocumentSchemaService_DeleteDocumentSchema_Handler,
		},
		{
			MethodName: "ListDocumentSchemas",
			Handler:    _DocumentSchemaService_ListDocumentSchemas_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/contentwarehouse/v1/document_schema_service.proto",
}
