// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/networkservices/v1/tls_route.proto

package networkservices

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// TlsRoute defines how traffic should be routed based on SNI and other matching
// L3 attributes.
type TlsRoute struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the TlsRoute resource. It matches pattern
	// `projects/*/locations/global/tlsRoutes/tls_route_name>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Server-defined URL of this resource
	SelfLink string `protobuf:"bytes,8,opt,name=self_link,json=selfLink,proto3" json:"self_link,omitempty"`
	// Output only. The timestamp when the resource was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The timestamp when the resource was updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional. A free-text description of the resource. Max length 1024 characters.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Required. Rules that define how traffic is routed and handled. At least one RouteRule
	// must be supplied. If there are multiple rules then the action taken will be
	// the first rule to match.
	Rules []*TlsRoute_RouteRule `protobuf:"bytes,5,rep,name=rules,proto3" json:"rules,omitempty"`
	// Optional. Meshes defines a list of meshes this TlsRoute is attached to, as one of the
	// routing rules to route the requests served by the mesh.
	//
	// Each mesh reference should match the pattern:
	// `projects/*/locations/global/meshes/<mesh_name>`
	//
	// The attached Mesh should be of a type SIDECAR
	Meshes []string `protobuf:"bytes,6,rep,name=meshes,proto3" json:"meshes,omitempty"`
	// Optional. Gateways defines a list of gateways this TlsRoute is attached to, as one of
	// the routing rules to route the requests served by the gateway.
	//
	// Each gateway reference should match the pattern:
	// `projects/*/locations/global/gateways/<gateway_name>`
	Gateways []string `protobuf:"bytes,7,rep,name=gateways,proto3" json:"gateways,omitempty"`
}

func (x *TlsRoute) Reset() {
	*x = TlsRoute{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networkservices_v1_tls_route_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TlsRoute) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TlsRoute) ProtoMessage() {}

func (x *TlsRoute) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkservices_v1_tls_route_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TlsRoute.ProtoReflect.Descriptor instead.
func (*TlsRoute) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_tls_route_proto_rawDescGZIP(), []int{0}
}

func (x *TlsRoute) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *TlsRoute) GetSelfLink() string {
	if x != nil {
		return x.SelfLink
	}
	return ""
}

func (x *TlsRoute) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *TlsRoute) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *TlsRoute) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *TlsRoute) GetRules() []*TlsRoute_RouteRule {
	if x != nil {
		return x.Rules
	}
	return nil
}

func (x *TlsRoute) GetMeshes() []string {
	if x != nil {
		return x.Meshes
	}
	return nil
}

func (x *TlsRoute) GetGateways() []string {
	if x != nil {
		return x.Gateways
	}
	return nil
}

// Request used with the ListTlsRoutes method.
type ListTlsRoutesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project and location from which the TlsRoutes should be
	// listed, specified in the format `projects/*/locations/global`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Maximum number of TlsRoutes to return per call.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The value returned by the last `ListTlsRoutesResponse`
	// Indicates that this is a continuation of a prior `ListTlsRoutes` call,
	// and that the system should return the next page of data.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListTlsRoutesRequest) Reset() {
	*x = ListTlsRoutesRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networkservices_v1_tls_route_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListTlsRoutesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTlsRoutesRequest) ProtoMessage() {}

func (x *ListTlsRoutesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkservices_v1_tls_route_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTlsRoutesRequest.ProtoReflect.Descriptor instead.
func (*ListTlsRoutesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_tls_route_proto_rawDescGZIP(), []int{1}
}

func (x *ListTlsRoutesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListTlsRoutesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListTlsRoutesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response returned by the ListTlsRoutes method.
type ListTlsRoutesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of TlsRoute resources.
	TlsRoutes []*TlsRoute `protobuf:"bytes,1,rep,name=tls_routes,json=tlsRoutes,proto3" json:"tls_routes,omitempty"`
	// If there might be more results than those appearing in this response, then
	// `next_page_token` is included. To get the next set of results, call this
	// method again using the value of `next_page_token` as `page_token`.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListTlsRoutesResponse) Reset() {
	*x = ListTlsRoutesResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networkservices_v1_tls_route_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListTlsRoutesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTlsRoutesResponse) ProtoMessage() {}

func (x *ListTlsRoutesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkservices_v1_tls_route_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTlsRoutesResponse.ProtoReflect.Descriptor instead.
func (*ListTlsRoutesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_tls_route_proto_rawDescGZIP(), []int{2}
}

func (x *ListTlsRoutesResponse) GetTlsRoutes() []*TlsRoute {
	if x != nil {
		return x.TlsRoutes
	}
	return nil
}

func (x *ListTlsRoutesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request used by the GetTlsRoute method.
type GetTlsRouteRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A name of the TlsRoute to get. Must be in the format
	// `projects/*/locations/global/tlsRoutes/*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetTlsRouteRequest) Reset() {
	*x = GetTlsRouteRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networkservices_v1_tls_route_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetTlsRouteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetTlsRouteRequest) ProtoMessage() {}

func (x *GetTlsRouteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkservices_v1_tls_route_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetTlsRouteRequest.ProtoReflect.Descriptor instead.
func (*GetTlsRouteRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_tls_route_proto_rawDescGZIP(), []int{3}
}

func (x *GetTlsRouteRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request used by the TlsRoute method.
type CreateTlsRouteRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource of the TlsRoute. Must be in the
	// format `projects/*/locations/global`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Short name of the TlsRoute resource to be created. E.g. TODO(Add an
	// example).
	TlsRouteId string `protobuf:"bytes,2,opt,name=tls_route_id,json=tlsRouteId,proto3" json:"tls_route_id,omitempty"`
	// Required. TlsRoute resource to be created.
	TlsRoute *TlsRoute `protobuf:"bytes,3,opt,name=tls_route,json=tlsRoute,proto3" json:"tls_route,omitempty"`
}

func (x *CreateTlsRouteRequest) Reset() {
	*x = CreateTlsRouteRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networkservices_v1_tls_route_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateTlsRouteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateTlsRouteRequest) ProtoMessage() {}

func (x *CreateTlsRouteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkservices_v1_tls_route_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateTlsRouteRequest.ProtoReflect.Descriptor instead.
func (*CreateTlsRouteRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_tls_route_proto_rawDescGZIP(), []int{4}
}

func (x *CreateTlsRouteRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateTlsRouteRequest) GetTlsRouteId() string {
	if x != nil {
		return x.TlsRouteId
	}
	return ""
}

func (x *CreateTlsRouteRequest) GetTlsRoute() *TlsRoute {
	if x != nil {
		return x.TlsRoute
	}
	return nil
}

// Request used by the UpdateTlsRoute method.
type UpdateTlsRouteRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Field mask is used to specify the fields to be overwritten in the
	// TlsRoute resource by the update.
	// The fields specified in the update_mask are relative to the resource, not
	// the full request. A field will be overwritten if it is in the mask. If the
	// user does not provide a mask then all fields will be overwritten.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. Updated TlsRoute resource.
	TlsRoute *TlsRoute `protobuf:"bytes,2,opt,name=tls_route,json=tlsRoute,proto3" json:"tls_route,omitempty"`
}

func (x *UpdateTlsRouteRequest) Reset() {
	*x = UpdateTlsRouteRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networkservices_v1_tls_route_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateTlsRouteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateTlsRouteRequest) ProtoMessage() {}

func (x *UpdateTlsRouteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkservices_v1_tls_route_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateTlsRouteRequest.ProtoReflect.Descriptor instead.
func (*UpdateTlsRouteRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_tls_route_proto_rawDescGZIP(), []int{5}
}

func (x *UpdateTlsRouteRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateTlsRouteRequest) GetTlsRoute() *TlsRoute {
	if x != nil {
		return x.TlsRoute
	}
	return nil
}

// Request used by the DeleteTlsRoute method.
type DeleteTlsRouteRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A name of the TlsRoute to delete. Must be in the format
	// `projects/*/locations/global/tlsRoutes/*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteTlsRouteRequest) Reset() {
	*x = DeleteTlsRouteRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networkservices_v1_tls_route_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteTlsRouteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteTlsRouteRequest) ProtoMessage() {}

func (x *DeleteTlsRouteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkservices_v1_tls_route_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteTlsRouteRequest.ProtoReflect.Descriptor instead.
func (*DeleteTlsRouteRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_tls_route_proto_rawDescGZIP(), []int{6}
}

func (x *DeleteTlsRouteRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Specifies how to match traffic and how to route traffic when traffic is
// matched.
type TlsRoute_RouteRule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. RouteMatch defines the predicate used to match requests to a given
	// action. Multiple match types are "OR"ed for evaluation.
	Matches []*TlsRoute_RouteMatch `protobuf:"bytes,1,rep,name=matches,proto3" json:"matches,omitempty"`
	// Required. The detailed rule defining how to route matched traffic.
	Action *TlsRoute_RouteAction `protobuf:"bytes,2,opt,name=action,proto3" json:"action,omitempty"`
}

func (x *TlsRoute_RouteRule) Reset() {
	*x = TlsRoute_RouteRule{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networkservices_v1_tls_route_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TlsRoute_RouteRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TlsRoute_RouteRule) ProtoMessage() {}

func (x *TlsRoute_RouteRule) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkservices_v1_tls_route_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TlsRoute_RouteRule.ProtoReflect.Descriptor instead.
func (*TlsRoute_RouteRule) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_tls_route_proto_rawDescGZIP(), []int{0, 0}
}

func (x *TlsRoute_RouteRule) GetMatches() []*TlsRoute_RouteMatch {
	if x != nil {
		return x.Matches
	}
	return nil
}

func (x *TlsRoute_RouteRule) GetAction() *TlsRoute_RouteAction {
	if x != nil {
		return x.Action
	}
	return nil
}

// RouteMatch defines the predicate used to match requests to a given action.
// Multiple match types are "AND"ed for evaluation.
// If no routeMatch field is specified, this rule will unconditionally match
// traffic.
type TlsRoute_RouteMatch struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. SNI (server name indicator) to match against.
	// SNI will be matched against all wildcard domains, i.e. www.example.com
	// will be first matched against www.example.com, then *.example.com, then
	// *.com.
	// Partial wildcards are not supported, and values like *w.example.com are
	// invalid.
	// At least one of sni_host and alpn is required.
	// Up to 5 sni hosts across all matches can be set.
	SniHost []string `protobuf:"bytes,1,rep,name=sni_host,json=sniHost,proto3" json:"sni_host,omitempty"`
	// Optional. ALPN (Application-Layer Protocol Negotiation) to match against.
	// Examples: "http/1.1", "h2".
	// At least one of sni_host and alpn is required.
	// Up to 5 alpns across all matches can be set.
	Alpn []string `protobuf:"bytes,2,rep,name=alpn,proto3" json:"alpn,omitempty"`
}

func (x *TlsRoute_RouteMatch) Reset() {
	*x = TlsRoute_RouteMatch{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networkservices_v1_tls_route_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TlsRoute_RouteMatch) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TlsRoute_RouteMatch) ProtoMessage() {}

func (x *TlsRoute_RouteMatch) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkservices_v1_tls_route_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TlsRoute_RouteMatch.ProtoReflect.Descriptor instead.
func (*TlsRoute_RouteMatch) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_tls_route_proto_rawDescGZIP(), []int{0, 1}
}

func (x *TlsRoute_RouteMatch) GetSniHost() []string {
	if x != nil {
		return x.SniHost
	}
	return nil
}

func (x *TlsRoute_RouteMatch) GetAlpn() []string {
	if x != nil {
		return x.Alpn
	}
	return nil
}

// The specifications for routing traffic and applying associated policies.
type TlsRoute_RouteAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The destination services to which traffic should be forwarded. At least
	// one destination service is required.
	Destinations []*TlsRoute_RouteDestination `protobuf:"bytes,1,rep,name=destinations,proto3" json:"destinations,omitempty"`
}

func (x *TlsRoute_RouteAction) Reset() {
	*x = TlsRoute_RouteAction{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networkservices_v1_tls_route_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TlsRoute_RouteAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TlsRoute_RouteAction) ProtoMessage() {}

func (x *TlsRoute_RouteAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkservices_v1_tls_route_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TlsRoute_RouteAction.ProtoReflect.Descriptor instead.
func (*TlsRoute_RouteAction) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_tls_route_proto_rawDescGZIP(), []int{0, 2}
}

func (x *TlsRoute_RouteAction) GetDestinations() []*TlsRoute_RouteDestination {
	if x != nil {
		return x.Destinations
	}
	return nil
}

// Describe the destination for traffic to be routed to.
type TlsRoute_RouteDestination struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The URL of a BackendService to route traffic to.
	ServiceName string `protobuf:"bytes,1,opt,name=service_name,json=serviceName,proto3" json:"service_name,omitempty"`
	// Optional. Specifies the proportion of requests forwareded to the backend referenced
	// by the service_name field. This is computed as:
	//         weight/Sum(weights in destinations)
	// Weights in all destinations does not need to sum up to 100.
	Weight int32 `protobuf:"varint,2,opt,name=weight,proto3" json:"weight,omitempty"`
}

func (x *TlsRoute_RouteDestination) Reset() {
	*x = TlsRoute_RouteDestination{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_networkservices_v1_tls_route_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *TlsRoute_RouteDestination) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TlsRoute_RouteDestination) ProtoMessage() {}

func (x *TlsRoute_RouteDestination) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkservices_v1_tls_route_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TlsRoute_RouteDestination.ProtoReflect.Descriptor instead.
func (*TlsRoute_RouteDestination) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_tls_route_proto_rawDescGZIP(), []int{0, 3}
}

func (x *TlsRoute_RouteDestination) GetServiceName() string {
	if x != nil {
		return x.ServiceName
	}
	return ""
}

func (x *TlsRoute_RouteDestination) GetWeight() int32 {
	if x != nil {
		return x.Weight
	}
	return 0
}

var File_google_cloud_networkservices_v1_tls_route_proto protoreflect.FileDescriptor

var file_google_cloud_networkservices_v1_tls_route_proto_rawDesc = []byte{
	0x0a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x76,
	0x31, 0x2f, 0x74, 0x6c, 0x73, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e,
	0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x22, 0xb4, 0x08, 0x0a, 0x08, 0x54, 0x6c, 0x73, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x12, 0x17,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x09, 0x73, 0x65, 0x6c, 0x66, 0x5f,
	0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x08, 0x73, 0x65, 0x6c, 0x66, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x25, 0x0a,
	0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4e, 0x0a, 0x05, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x18, 0x05, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x6c, 0x73, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x2e, 0x52,
	0x6f, 0x75, 0x74, 0x65, 0x52, 0x75, 0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x12, 0x43, 0x0a, 0x06, 0x6d, 0x65, 0x73, 0x68, 0x65, 0x73, 0x18, 0x06,
	0x20, 0x03, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x25, 0x0a, 0x23, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x65, 0x73,
	0x68, 0x52, 0x06, 0x6d, 0x65, 0x73, 0x68, 0x65, 0x73, 0x12, 0x4a, 0x0a, 0x08, 0x67, 0x61, 0x74,
	0x65, 0x77, 0x61, 0x79, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x01,
	0xfa, 0x41, 0x28, 0x0a, 0x26, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x52, 0x08, 0x67, 0x61, 0x74,
	0x65, 0x77, 0x61, 0x79, 0x73, 0x1a, 0xb4, 0x01, 0x0a, 0x09, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x52,
	0x75, 0x6c, 0x65, 0x12, 0x53, 0x0a, 0x07, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x6c, 0x73, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x2e,
	0x52, 0x6f, 0x75, 0x74, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x07, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x12, 0x52, 0x0a, 0x06, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x6c, 0x73, 0x52, 0x6f,
	0x75, 0x74, 0x65, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x45, 0x0a, 0x0a,
	0x52, 0x6f, 0x75, 0x74, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x1e, 0x0a, 0x08, 0x73, 0x6e,
	0x69, 0x5f, 0x68, 0x6f, 0x73, 0x74, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x07, 0x73, 0x6e, 0x69, 0x48, 0x6f, 0x73, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x61, 0x6c,
	0x70, 0x6e, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x61,
	0x6c, 0x70, 0x6e, 0x1a, 0x72, 0x0a, 0x0b, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x41, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x63, 0x0a, 0x0c, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x6c, 0x73, 0x52, 0x6f,
	0x75, 0x74, 0x65, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x64, 0x65, 0x73, 0x74, 0x69,
	0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x81, 0x01, 0x0a, 0x10, 0x52, 0x6f, 0x75, 0x74,
	0x65, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x50, 0x0a, 0x0c,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x2d, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x63, 0x6f, 0x6d, 0x70,
	0x75, 0x74, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x42, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x52, 0x0b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1b,
	0x0a, 0x06, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x06, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x3a, 0x6b, 0xea, 0x41, 0x68,
	0x0a, 0x27, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x54, 0x6c, 0x73, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x12, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x7d, 0x2f, 0x74, 0x6c, 0x73, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x2f, 0x7b, 0x74, 0x6c,
	0x73, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x7d, 0x22, 0x9b, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73,
	0x74, 0x54, 0x6c, 0x73, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x47, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x12, 0x27, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x6c, 0x73, 0x52, 0x6f, 0x75,
	0x74, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70,
	0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x89, 0x01, 0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x54,
	0x6c, 0x73, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x48, 0x0a, 0x0a, 0x74, 0x6c, 0x73, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x6c, 0x73, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x52,
	0x09, 0x74, 0x6c, 0x73, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65,
	0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x22, 0x59, 0x0a, 0x12, 0x47, 0x65, 0x74, 0x54, 0x6c, 0x73, 0x52, 0x6f, 0x75, 0x74,
	0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x0a, 0x27,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54,
	0x6c, 0x73, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xd4, 0x01,
	0x0a, 0x15, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x6c, 0x73, 0x52, 0x6f, 0x75, 0x74, 0x65,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x12,
	0x27, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x54, 0x6c, 0x73, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x25, 0x0a, 0x0c, 0x74, 0x6c, 0x73, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x5f, 0x69, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0a, 0x74, 0x6c, 0x73,
	0x52, 0x6f, 0x75, 0x74, 0x65, 0x49, 0x64, 0x12, 0x4b, 0x0a, 0x09, 0x74, 0x6c, 0x73, 0x5f, 0x72,
	0x6f, 0x75, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x6c, 0x73,
	0x52, 0x6f, 0x75, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x74, 0x6c, 0x73, 0x52,
	0x6f, 0x75, 0x74, 0x65, 0x22, 0xa6, 0x01, 0x0a, 0x15, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54,
	0x6c, 0x73, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40,
	0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b,
	0x12, 0x4b, 0x0a, 0x09, 0x74, 0x6c, 0x73, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x6c, 0x73, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x08, 0x74, 0x6c, 0x73, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x22, 0x5c, 0x0a,
	0x15, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x6c, 0x73, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x6c, 0x73,
	0x52, 0x6f, 0x75, 0x74, 0x65, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x42, 0xef, 0x01, 0x0a, 0x23,
	0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73,
	0x2e, 0x76, 0x31, 0x42, 0x0d, 0x54, 0x6c, 0x73, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x50, 0x01, 0x5a, 0x4e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c,
	0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x73, 0x2f, 0x76, 0x31, 0x3b, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x73, 0xaa, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x53, 0x65, 0x72, 0x76, 0x69,
	0x63, 0x65, 0x73, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x73, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_networkservices_v1_tls_route_proto_rawDescOnce sync.Once
	file_google_cloud_networkservices_v1_tls_route_proto_rawDescData = file_google_cloud_networkservices_v1_tls_route_proto_rawDesc
)

func file_google_cloud_networkservices_v1_tls_route_proto_rawDescGZIP() []byte {
	file_google_cloud_networkservices_v1_tls_route_proto_rawDescOnce.Do(func() {
		file_google_cloud_networkservices_v1_tls_route_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_networkservices_v1_tls_route_proto_rawDescData)
	})
	return file_google_cloud_networkservices_v1_tls_route_proto_rawDescData
}

var file_google_cloud_networkservices_v1_tls_route_proto_msgTypes = make([]protoimpl.MessageInfo, 11)
var file_google_cloud_networkservices_v1_tls_route_proto_goTypes = []interface{}{
	(*TlsRoute)(nil),                  // 0: google.cloud.networkservices.v1.TlsRoute
	(*ListTlsRoutesRequest)(nil),      // 1: google.cloud.networkservices.v1.ListTlsRoutesRequest
	(*ListTlsRoutesResponse)(nil),     // 2: google.cloud.networkservices.v1.ListTlsRoutesResponse
	(*GetTlsRouteRequest)(nil),        // 3: google.cloud.networkservices.v1.GetTlsRouteRequest
	(*CreateTlsRouteRequest)(nil),     // 4: google.cloud.networkservices.v1.CreateTlsRouteRequest
	(*UpdateTlsRouteRequest)(nil),     // 5: google.cloud.networkservices.v1.UpdateTlsRouteRequest
	(*DeleteTlsRouteRequest)(nil),     // 6: google.cloud.networkservices.v1.DeleteTlsRouteRequest
	(*TlsRoute_RouteRule)(nil),        // 7: google.cloud.networkservices.v1.TlsRoute.RouteRule
	(*TlsRoute_RouteMatch)(nil),       // 8: google.cloud.networkservices.v1.TlsRoute.RouteMatch
	(*TlsRoute_RouteAction)(nil),      // 9: google.cloud.networkservices.v1.TlsRoute.RouteAction
	(*TlsRoute_RouteDestination)(nil), // 10: google.cloud.networkservices.v1.TlsRoute.RouteDestination
	(*timestamppb.Timestamp)(nil),     // 11: google.protobuf.Timestamp
	(*fieldmaskpb.FieldMask)(nil),     // 12: google.protobuf.FieldMask
}
var file_google_cloud_networkservices_v1_tls_route_proto_depIdxs = []int32{
	11, // 0: google.cloud.networkservices.v1.TlsRoute.create_time:type_name -> google.protobuf.Timestamp
	11, // 1: google.cloud.networkservices.v1.TlsRoute.update_time:type_name -> google.protobuf.Timestamp
	7,  // 2: google.cloud.networkservices.v1.TlsRoute.rules:type_name -> google.cloud.networkservices.v1.TlsRoute.RouteRule
	0,  // 3: google.cloud.networkservices.v1.ListTlsRoutesResponse.tls_routes:type_name -> google.cloud.networkservices.v1.TlsRoute
	0,  // 4: google.cloud.networkservices.v1.CreateTlsRouteRequest.tls_route:type_name -> google.cloud.networkservices.v1.TlsRoute
	12, // 5: google.cloud.networkservices.v1.UpdateTlsRouteRequest.update_mask:type_name -> google.protobuf.FieldMask
	0,  // 6: google.cloud.networkservices.v1.UpdateTlsRouteRequest.tls_route:type_name -> google.cloud.networkservices.v1.TlsRoute
	8,  // 7: google.cloud.networkservices.v1.TlsRoute.RouteRule.matches:type_name -> google.cloud.networkservices.v1.TlsRoute.RouteMatch
	9,  // 8: google.cloud.networkservices.v1.TlsRoute.RouteRule.action:type_name -> google.cloud.networkservices.v1.TlsRoute.RouteAction
	10, // 9: google.cloud.networkservices.v1.TlsRoute.RouteAction.destinations:type_name -> google.cloud.networkservices.v1.TlsRoute.RouteDestination
	10, // [10:10] is the sub-list for method output_type
	10, // [10:10] is the sub-list for method input_type
	10, // [10:10] is the sub-list for extension type_name
	10, // [10:10] is the sub-list for extension extendee
	0,  // [0:10] is the sub-list for field type_name
}

func init() { file_google_cloud_networkservices_v1_tls_route_proto_init() }
func file_google_cloud_networkservices_v1_tls_route_proto_init() {
	if File_google_cloud_networkservices_v1_tls_route_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_networkservices_v1_tls_route_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TlsRoute); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networkservices_v1_tls_route_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListTlsRoutesRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networkservices_v1_tls_route_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListTlsRoutesResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networkservices_v1_tls_route_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetTlsRouteRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networkservices_v1_tls_route_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateTlsRouteRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networkservices_v1_tls_route_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateTlsRouteRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networkservices_v1_tls_route_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteTlsRouteRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networkservices_v1_tls_route_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TlsRoute_RouteRule); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networkservices_v1_tls_route_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TlsRoute_RouteMatch); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networkservices_v1_tls_route_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TlsRoute_RouteAction); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_networkservices_v1_tls_route_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*TlsRoute_RouteDestination); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_networkservices_v1_tls_route_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   11,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_networkservices_v1_tls_route_proto_goTypes,
		DependencyIndexes: file_google_cloud_networkservices_v1_tls_route_proto_depIdxs,
		MessageInfos:      file_google_cloud_networkservices_v1_tls_route_proto_msgTypes,
	}.Build()
	File_google_cloud_networkservices_v1_tls_route_proto = out.File
	file_google_cloud_networkservices_v1_tls_route_proto_rawDesc = nil
	file_google_cloud_networkservices_v1_tls_route_proto_goTypes = nil
	file_google_cloud_networkservices_v1_tls_route_proto_depIdxs = nil
}
