/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cwm.plugin.common.carets;

import com.intellij.codeWithMe.ClientId;
import com.intellij.cwm.plugin.common.carets.RemoteCaret;
import com.intellij.cwm.plugin.common.carets.RemoteCaretHighlighterRenderer;
import com.intellij.cwm.plugin.common.carets.RemoteCaretHighlighterServiceKt;
import com.intellij.cwm.plugin.common.carets.RemoteCaretModel;
import com.intellij.cwm.plugin.common.carets.RemoteCaretTooltipManager;
import com.intellij.cwm.plugin.common.control.CodeWithMeColors;
import com.intellij.cwm.plugin.common.users.CWMUserFocusHost;
import com.intellij.cwm.plugin.common.users.UserManagerKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.CaretModelImpl;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.impl.RangeMarkerImpl;
import com.intellij.openapi.editor.impl.event.MarkupModelListener;
import com.intellij.openapi.editor.markup.CustomHighlighterRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.SingleEdtTaskScheduler;
import com.jetbrains.codeWithMe.model.RdUserModel;
import com.jetbrains.codeWithMe.model.RemoteCaretData;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.reactive.IPropertyView;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000  2\u00020\u0001:\u0001 B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ \u0010\b\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\rJ\u001e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0016\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\u0010J\u0018\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/intellij/cwm/plugin/common/carets/RemoteCaretHighlighterService;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "tooltipAlarm", "Lcom/intellij/util/SingleEdtTaskScheduler;", "addRemoteCaret", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "editor", "Lcom/intellij/openapi/editor/Editor;", "remoteCaretModel", "Lcom/intellij/cwm/plugin/common/carets/RemoteCaretModel;", "Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;", "markup", "Lcom/intellij/openapi/editor/ex/MarkupModelEx;", "findRemoteCaret", "Lcom/intellij/cwm/plugin/common/carets/RemoteCaret;", "offset", "", "initializeHighlighter", "", "h", "remoteCaretData", "Lcom/jetbrains/codeWithMe/model/RemoteCaretData;", "range", "Lcom/intellij/openapi/util/TextRange;", "showRemoteCaret", "showFromLocalCaret", "Companion", "intellij.cwm.plugin.common"})
public final class RemoteCaretHighlighterService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final SingleEdtTaskScheduler tooltipAlarm;
    public static final long REMOTE_CARET_INITIAL_TOOLTIP_DELAY = 1000L;

    public RemoteCaretHighlighterService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.tooltipAlarm = SingleEdtTaskScheduler.Companion.createSingleEdtTaskScheduler$default((SingleEdtTaskScheduler.Companion)SingleEdtTaskScheduler.Companion, null, (int)1, null);
    }

    @NotNull
    public final RangeHighlighter addRemoteCaret(@NotNull Lifetime lifetime, @NotNull Editor editor, @NotNull RemoteCaretModel remoteCaretModel) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)remoteCaretModel, (String)"remoteCaretModel");
        MarkupModel markupModel = DocumentMarkupModel.forDocument((Document)editor.getDocument(), (Project)editor.getProject(), (boolean)true);
        Intrinsics.checkNotNull((Object)markupModel, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.MarkupModelEx");
        MarkupModelEx markup = (MarkupModelEx)markupModel;
        RangeHighlighterEx highlighter = this.addRemoteCaret(markup, lifetime, remoteCaretModel);
        CWMUserFocusHost cWMUserFocusHost = CWMUserFocusHost.Companion.getInstance(this.project);
        Document document = editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getDocument(...)");
        cWMUserFocusHost.serverNotify(document, ClientId.Companion.getCurrent());
        return (RangeHighlighter)highlighter;
    }

    private final RangeHighlighterEx addRemoteCaret(MarkupModelEx markup, Lifetime lifetime, RemoteCaretModel remoteCaretModel) {
        boolean bl;
        boolean bl2 = bl = remoteCaretModel.getRemoteCaretData().getLead() != null || remoteCaretModel.getRemoteCaretData().isSetManually();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        RangeHighlighterEx rangeHighlighterEx = markup.addRangeHighlighterAndChangeAttributes(null, remoteCaretModel.getSelectionStartOffset(), remoteCaretModel.getSelectionEndOffset(), 5999, HighlighterTargetArea.EXACT_RANGE, false, arg_0 -> RemoteCaretHighlighterService.addRemoteCaret$lambda$1(arg_0 -> RemoteCaretHighlighterService.addRemoteCaret$lambda$0(this, remoteCaretModel, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighterEx, (String)"addRangeHighlighterAndChangeAttributes(...)");
        RangeHighlighterEx highlighter = rangeHighlighterEx;
        if (new RemoteCaretHighlighterRenderer(remoteCaretModel.getRemoteCaretData()).shouldShow()) {
            this.showRemoteCaret(remoteCaretModel.getRemoteCaretData(), highlighter);
        }
        lifetime.onTermination(() -> RemoteCaretHighlighterService.addRemoteCaret$lambda$2(highlighter));
        return highlighter;
    }

    @Nullable
    public final RemoteCaret findRemoteCaret(int offset, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        MarkupModelEx markupModelEx = (MarkupModelEx)DocumentMarkupModel.forDocument((Document)editor.getDocument(), (Project)editor.getProject(), (boolean)false);
        if (markupModelEx == null) {
            return null;
        }
        MarkupModelEx markupModel = markupModelEx;
        Ref.ObjectRef h = new Ref.ObjectRef();
        markupModel.processRangeHighlightersOverlappingWith(offset, offset, arg_0 -> RemoteCaretHighlighterService.findRemoteCaret$lambda$4(arg_0 -> RemoteCaretHighlighterService.findRemoteCaret$lambda$3(h, arg_0), arg_0));
        RangeHighlighterEx highlighter = (RangeHighlighterEx)h.element;
        if (highlighter == null) {
            return null;
        }
        CustomHighlighterRenderer customHighlighterRenderer = highlighter.getCustomRenderer();
        Intrinsics.checkNotNull((Object)customHighlighterRenderer, (String)"null cannot be cast to non-null type com.intellij.cwm.plugin.common.carets.RemoteCaretHighlighterRenderer");
        RemoteCaretHighlighterRenderer renderer = (RemoteCaretHighlighterRenderer)customHighlighterRenderer;
        return new RemoteCaret(editor, (RangeHighlighter)highlighter, renderer.getRemoteCaretData());
    }

    public final void initializeHighlighter(@NotNull RangeHighlighterEx h, @NotNull RemoteCaretData remoteCaretData, @NotNull TextRange range) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)h, (String)"h");
        Intrinsics.checkNotNullParameter((Object)remoteCaretData, (String)"remoteCaretData");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        boolean bl2 = bl = remoteCaretData.getLead() != null || remoteCaretData.isSetManually();
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        RdUserModel rdUserModel = remoteCaretData.getLead();
        if (Intrinsics.areEqual((Object)(rdUserModel != null ? UserManagerKt.getClientId(rdUserModel) : null), (Object)ClientId.Companion.getLocalId()) && !remoteCaretData.isSetManually()) {
            this.showFromLocalCaret(h, remoteCaretData);
            return;
        }
        RemoteCaretHighlighterRenderer renderer = new RemoteCaretHighlighterRenderer(remoteCaretData);
        if (range.getStartOffset() == range.getEndOffset()) {
            RangeMarkerImpl rangeMarkerImpl = h instanceof RangeMarkerImpl ? (RangeMarkerImpl)h : null;
            if (rangeMarkerImpl != null) {
                rangeMarkerImpl.setStickingToRight(true);
            }
        }
        h.setCustomRenderer((CustomHighlighterRenderer)renderer);
        if (renderer.shouldShow()) {
            TextAttributesKey key = CodeWithMeColors.INSTANCE.getSelectionAttributesKey(remoteCaretData.getUser());
            h.setTextAttributesKey(key);
        }
    }

    public final void showRemoteCaret(@NotNull RemoteCaretData remoteCaretData, @NotNull RangeHighlighterEx h) {
        Intrinsics.checkNotNullParameter((Object)remoteCaretData, (String)"remoteCaretData");
        Intrinsics.checkNotNullParameter((Object)h, (String)"h");
        if (!remoteCaretData.isSetManually()) {
            this.tooltipAlarm.cancelAndRequest(1000L, () -> RemoteCaretHighlighterService.showRemoteCaret$lambda$5(this, h, remoteCaretData));
        }
    }

    private final void showFromLocalCaret(RangeHighlighterEx h, RemoteCaretData remoteCaretData) {
        Editor editor = FileEditorManager.getInstance((Project)this.project).getSelectedTextEditor();
        if (editor == null) {
            return;
        }
        Editor editor2 = editor;
        if (!Intrinsics.areEqual((Object)h.getDocument(), (Object)editor2.getDocument())) {
            return;
        }
        CaretModel caretModel = editor2.getCaretModel();
        Intrinsics.checkNotNull((Object)caretModel, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.impl.CaretModelImpl");
        Disposable disposable = Disposer.newDisposable((Disposable)((Disposable)((CaretModelImpl)caretModel)));
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        Disposable listenerDisposable = disposable;
        LifetimeDefinition highlighterLifetime = LifetimeDisposableExKt.defineNestedLifetime((Disposable)listenerDisposable);
        MarkupModel markupModel = DocumentMarkupModel.forDocument((Document)editor2.getDocument(), (Project)editor2.getProject(), (boolean)true);
        Intrinsics.checkNotNull((Object)markupModel, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.MarkupModelEx");
        MarkupModelEx markup = (MarkupModelEx)markupModel;
        markup.addMarkupModelListener(listenerDisposable, new MarkupModelListener(h, highlighterLifetime, listenerDisposable){
            final /* synthetic */ RangeHighlighterEx $h;
            final /* synthetic */ LifetimeDefinition $highlighterLifetime;
            final /* synthetic */ Disposable $listenerDisposable;
            {
                this.$h = $h;
                this.$highlighterLifetime = $highlighterLifetime;
                this.$listenerDisposable = $listenerDisposable;
            }

            public void afterRemoved(RangeHighlighterEx highlighter) {
                Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
                if (Intrinsics.areEqual((Object)highlighter, (Object)this.$h)) {
                    LifetimeDefinition.terminate$default((LifetimeDefinition)this.$highlighterLifetime, (boolean)false, (int)1, null);
                    Disposer.dispose((Disposable)this.$listenerDisposable);
                }
            }
        });
        IPropertyView caretData = RemoteCaretHighlighterServiceKt.createViewableCarets(editor2, listenerDisposable, arg_0 -> RemoteCaretHighlighterService.showFromLocalCaret$lambda$6(remoteCaretData, arg_0));
        caretData.view((Lifetime)highlighterLifetime, (arg_0, arg_1) -> RemoteCaretHighlighterService.showFromLocalCaret$lambda$7(this, editor2, arg_0, arg_1));
    }

    private static final Unit addRemoteCaret$lambda$0(RemoteCaretHighlighterService this$0, RemoteCaretModel $remoteCaretModel, RangeHighlighterEx it) {
        Intrinsics.checkNotNull((Object)it);
        this$0.initializeHighlighter(it, $remoteCaretModel.getRemoteCaretData(), new TextRange($remoteCaretModel.getSelectionStartOffset(), $remoteCaretModel.getSelectionEndOffset()));
        return Unit.INSTANCE;
    }

    private static final void addRemoteCaret$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit addRemoteCaret$lambda$2(RangeHighlighterEx $highlighter) {
        $highlighter.dispose();
        return Unit.INSTANCE;
    }

    private static final boolean findRemoteCaret$lambda$3(Ref.ObjectRef $h, RangeHighlighterEx it) {
        CustomHighlighterRenderer renderer = it.getCustomRenderer();
        if (renderer instanceof RemoteCaretHighlighterRenderer && ((RemoteCaretHighlighterRenderer)renderer).shouldShow()) {
            $h.element = it;
            return false;
        }
        return true;
    }

    private static final boolean findRemoteCaret$lambda$4(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void showRemoteCaret$lambda$5(RemoteCaretHighlighterService this$0, RangeHighlighterEx $h, RemoteCaretData $remoteCaretData) {
        Editor editor = FileEditorManager.getInstance((Project)this$0.project).getSelectedTextEditor();
        if (editor == null) {
            return;
        }
        Editor editor2 = editor;
        if (!Intrinsics.areEqual((Object)$h.getDocument(), (Object)editor2.getDocument())) {
            return;
        }
        RemoteCaret remoteCaret = new RemoteCaret(editor2, (RangeHighlighter)$h, $remoteCaretData);
        RemoteCaretTooltipManager.Companion.getInstance().showUserTooltip(editor2, remoteCaret, 2000);
    }

    private static final RemoteCaretModel showFromLocalCaret$lambda$6(RemoteCaretData $remoteCaretData, Caret it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return RemoteCaretHighlighterServiceKt.createRemoteCaretModel(it, RemoteCaretData.copy$default((RemoteCaretData)$remoteCaretData, null, (boolean)false, null, (boolean)true, (int)0, (boolean)false, (int)55, null));
    }

    private static final Unit showFromLocalCaret$lambda$7(RemoteCaretHighlighterService this$0, Editor $editor, Lifetime lt, List models) {
        Intrinsics.checkNotNullParameter((Object)lt, (String)"lt");
        Intrinsics.checkNotNullParameter((Object)models, (String)"models");
        for (RemoteCaretModel model : models) {
            MarkupModel markupModel = $editor.getMarkupModel();
            Intrinsics.checkNotNull((Object)markupModel, (String)"null cannot be cast to non-null type com.intellij.openapi.editor.ex.MarkupModelEx");
            this$0.addRemoteCaret((MarkupModelEx)markupModel, lt, model);
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/intellij/cwm/plugin/common/carets/RemoteCaretHighlighterService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/cwm/plugin/common/carets/RemoteCaretHighlighterService;", "project", "Lcom/intellij/openapi/project/Project;", "REMOTE_CARET_INITIAL_TOOLTIP_DELAY", "", "intellij.cwm.plugin.common"})
    @SourceDebugExtension(value={"SMAP\nRemoteCaretHighlighterService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteCaretHighlighterService.kt\ncom/intellij/cwm/plugin/common/carets/RemoteCaretHighlighterService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,236:1\n30#2,2:237\n*S KotlinDebug\n*F\n+ 1 RemoteCaretHighlighterService.kt\ncom/intellij/cwm/plugin/common/carets/RemoteCaretHighlighterService$Companion\n*L\n41#1:237,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final RemoteCaretHighlighterService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<RemoteCaretHighlighterService> serviceClass$iv = RemoteCaretHighlighterService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (RemoteCaretHighlighterService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

