/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.packaging.conda;

import com.intellij.execution.ExecutionException;
import com.jetbrains.python.PySdkBundle;
import com.jetbrains.python.packaging.PyExecutionException;
import com.jetbrains.python.sdk.flavors.PyCondaRunKt;
import com.jetbrains.python.venvReader.VirtualEnvReader;
import java.io.File;
import java.nio.file.Path;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0005\u00a8\u0006\t"}, d2={"Lcom/jetbrains/python/packaging/conda/CondaEnvCreator;", "", "<init>", "()V", "createVirtualEnv", "", "condaExecutable", "destinationDir", "version", "intellij.python.community.impl"})
public final class CondaEnvCreator {
    @NotNull
    public static final CondaEnvCreator INSTANCE = new CondaEnvCreator();

    private CondaEnvCreator() {
    }

    @NotNull
    public final String createVirtualEnv(@Nullable String condaExecutable, @NotNull String destinationDir, @NotNull String version2) throws ExecutionException {
        Intrinsics.checkNotNullParameter((Object)destinationDir, (String)"destinationDir");
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        if (condaExecutable == null) {
            String string = PySdkBundle.message("python.sdk.conda.dialog.cannot.find.conda", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            throw new PyExecutionException(string, null, 2, null);
        }
        Object[] objectArray = new String[]{"create", "-p", destinationDir, "-y", "python=" + version2};
        List parameters = CollectionsKt.listOf((Object[])objectArray);
        PyCondaRunKt.runConda(condaExecutable, (List<String>)parameters);
        VirtualEnvReader virtualEnvReader = VirtualEnvReader.Companion.getInstance();
        Path path2 = Path.of(destinationDir, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"of(...)");
        Path binary = virtualEnvReader.findPythonInPythonRoot(path2);
        String binaryFallback = destinationDir + File.separator + "bin" + File.separator + "python";
        Object object = binary;
        if (object == null || (object = object.toString()) == null) {
            object = binaryFallback;
        }
        return object;
    }
}

