/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.jupyter.editor.outputs.webOutputs.jcef;

import com.intellij.ide.actions.RevealFileAction;
import com.intellij.jupyter.core.fus.JupyterFeatureCollectorManager;
import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.BaseProjectDirectories;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.VirtualDirectoryImpl;
import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.cef.browser.CefBrowser;
import org.cef.callback.CefBeforeDownloadCallback;
import org.cef.callback.CefDownloadItem;
import org.cef.callback.CefDownloadItemCallback;
import org.cef.handler.CefDownloadHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J,\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\"\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0017"}, d2={"Lcom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/jcef/JupyterCefDownloadHandler;", "Lorg/cef/handler/CefDownloadHandler;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "onBeforeDownload", "", "browser", "Lorg/cef/browser/CefBrowser;", "downloadItem", "Lorg/cef/callback/CefDownloadItem;", "suggestedName", "", "callback", "Lorg/cef/callback/CefBeforeDownloadCallback;", "onDownloadUpdated", "Lorg/cef/callback/CefDownloadItemCallback;", "notifyFinish", "name", "path", "intellij.jupyter.core"})
@SourceDebugExtension(value={"SMAP\nJupyterCefDownloadHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JupyterCefDownloadHandler.kt\ncom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/jcef/JupyterCefDownloadHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,60:1\n295#2,2:61\n1#3:63\n*S KotlinDebug\n*F\n+ 1 JupyterCefDownloadHandler.kt\ncom/intellij/jupyter/core/jupyter/editor/outputs/webOutputs/jcef/JupyterCefDownloadHandler\n*L\n31#1:61,2\n*E\n"})
public final class JupyterCefDownloadHandler
implements CefDownloadHandler {
    @NotNull
    private final Project project;

    public JupyterCefDownloadHandler(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public void onBeforeDownload(@NotNull CefBrowser browser, @NotNull CefDownloadItem downloadItem, @Nullable String suggestedName, @Nullable CefBeforeDownloadCallback callback2) {
        block4: {
            Object object;
            Object v0;
            block3: {
                Intrinsics.checkNotNullParameter((Object)browser, (String)"browser");
                Intrinsics.checkNotNullParameter((Object)downloadItem, (String)"downloadItem");
                Iterable $this$firstOrNull$iv = BaseProjectDirectories.Companion.getBaseDirectories(this.project);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    VirtualFile it = (VirtualFile)element$iv;
                    boolean bl = false;
                    if (!(it instanceof VirtualDirectoryImpl)) continue;
                    v0 = element$iv;
                    break block3;
                }
                v0 = null;
            }
            if ((object = (VirtualFile)v0) == null || (object = object.getCanonicalPath()) == null) {
                String string = FileUtil.getTempDirectory();
                object = string;
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTempDirectory(...)");
            }
            Object rootDir = object;
            String string = suggestedName;
            if (string == null) {
                string = "";
            }
            String name = string;
            Integer n = StringsKt.lastIndexOf$default((CharSequence)name, (char)'.', (int)0, (boolean)false, (int)6, null);
            int it = ((Number)n).intValue();
            boolean bl = false;
            Object object2 = it != -1 ? n : null;
            int prefixIndex = object2 != null ? ((Integer)object2).intValue() : name.length();
            String prefix = StringsKt.take((String)name, (int)prefixIndex);
            String suffix = StringsKt.takeLast((String)name, (int)(name.length() - prefixIndex));
            File file = FileUtil.createTempFile((File)new File((String)rootDir), (String)prefix, (String)suffix);
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"createTempFile(...)");
            File tempFile = file;
            CefBeforeDownloadCallback cefBeforeDownloadCallback = callback2;
            if (cefBeforeDownloadCallback == null) break block4;
            cefBeforeDownloadCallback.Continue(tempFile.getAbsolutePath(), false);
        }
    }

    public void onDownloadUpdated(@NotNull CefBrowser browser, @NotNull CefDownloadItem downloadItem, @Nullable CefDownloadItemCallback callback2) {
        Intrinsics.checkNotNullParameter((Object)browser, (String)"browser");
        Intrinsics.checkNotNullParameter((Object)downloadItem, (String)"downloadItem");
        if (downloadItem.isComplete()) {
            JupyterFeatureCollectorManager.Companion.getInstance().collectFileDownLoadFromCef(downloadItem.getTotalBytes());
            String fullPath = downloadItem.getFullPath();
            String name = new File(fullPath).getName();
            Intrinsics.checkNotNull((Object)name);
            Intrinsics.checkNotNull((Object)fullPath);
            this.notifyFinish(name, fullPath);
        }
    }

    private final void notifyFinish(String name, String path) {
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("Jupyter");
        Object[] objectArray = new Object[]{name};
        String string = JupyterBundle.message("notification.download.file.is.finished", objectArray);
        MessageType messageType = MessageType.INFO;
        Intrinsics.checkNotNullExpressionValue((Object)messageType, (String)"INFO");
        notificationGroup.createNotification(string, messageType).setDisplayId("download.file.is.finished").addAction((AnAction)NotificationAction.createSimple((String)RevealFileAction.getActionName(), () -> JupyterCefDownloadHandler.notifyFinish$lambda$2(path))).notify(this.project);
    }

    private static final void notifyFinish$lambda$2(String $path) {
        RevealFileAction.openFile((Path)Path.of($path, new String[0]));
    }
}

