/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_nl extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "Arabisch";
        final String metaValue_hy = "Armeens";
        final String metaValue_ban = "Balinees";
        final String metaValue_bax = "Bamoun";
        final String metaValue_bn = "Bengaals";
        final String metaValue_zbl = "Blissymbolen";
        final String metaValue_bug = "Buginees";
        final String metaValue_ccp = "Chakma";
        final String metaValue_chr = "Cherokee";
        final String metaValue_cop = "Koptisch";
        final String metaValue_ka = "Georgisch";
        final String metaValue_got = "Gothisch";
        final String metaValue_el = "Grieks";
        final String metaValue_gu = "Gujarati";
        final String metaValue_he = "Hebreeuws";
        final String metaValue_jv = "Javaans";
        final String metaValue_ja = "Japans";
        final String metaValue_km = "Khmer";
        final String metaValue_kn = "Kannada";
        final String metaValue_ko = "Koreaans";
        final String metaValue_kpe = "Kpelle";
        final String metaValue_lo = "Laotiaans";
        final String metaValue_men = "Mende";
        final String metaValue_ml = "Malayalam";
        final String metaValue_mn = "Mongools";
        final String metaValue_mni = "Meitei";
        final String metaValue_my = "Birmaans";
        final String metaValue_new = "Newari";
        final String metaValue_nqo = "N’Ko";
        final String metaValue_or = "Odia";
        final String metaValue_osa = "Osage";
        final String metaValue_phn = "Foenicisch";
        final String metaValue_saz = "Saurashtra";
        final String metaValue_sd = "Sindhi";
        final String metaValue_si = "Singalees";
        final String metaValue_sog = "Sogdisch";
        final String metaValue_su = "Soendanees";
        final String metaValue_ta = "Tamil";
        final String metaValue_te = "Telugu";
        final String metaValue_tl = "Tagalog";
        final String metaValue_bo = "Tibetaans";
        final String metaValue_vai = "Vai";
        final String metaValue_peo = "Oudperzisch";
        final String metaValue_ii = "Yi";
        final String metaValue_ssy = "Saho";
        final Object[][] data = new Object[][] {
            { "001", "wereld" },
            { "002", "Afrika" },
            { "003", "Noord-Amerika" },
            { "005", "Zuid-Amerika" },
            { "009", "Oceanië" },
            { "011", "West-Afrika" },
            { "013", "Midden-Amerika" },
            { "014", "Oost-Afrika" },
            { "015", "Noord-Afrika" },
            { "017", "Centraal-Afrika" },
            { "018", "Zuidelijk Afrika" },
            { "019", "Amerika" },
            { "021", "Noordelijk Amerika" },
            { "029", "Caribisch gebied" },
            { "030", "Oost-Azië" },
            { "034", "Zuid-Azië" },
            { "035", "Zuidoost-Azië" },
            { "039", "Zuid-Europa" },
            { "053", "Australazië" },
            { "054", "Melanesië" },
            { "057", "Micronesische regio" },
            { "061", "Polynesië" },
            { "142", "Azië" },
            { "143", "Centraal-Azië" },
            { "145", "West-Azië" },
            { "150", "Europa" },
            { "151", "Oost-Europa" },
            { "154", "Noord-Europa" },
            { "155", "West-Europa" },
            { "202", "Sub-Saharaans Afrika" },
            { "419", "Latijns-Amerika" },
            { "AC", "Ascension" },
            { "AD", "Andorra" },
            { "AE", "Verenigde Arabische Emiraten" },
            { "AF", "Afghanistan" },
            { "AG", "Antigua en Barbuda" },
            { "AI", "Anguilla" },
            { "AL", "Albanië" },
            { "AM", "Armenië" },
            { "AO", "Angola" },
            { "AQ", "Antarctica" },
            { "AR", "Argentinië" },
            { "AS", "Amerikaans-Samoa" },
            { "AT", "Oostenrijk" },
            { "AU", "Australië" },
            { "AW", "Aruba" },
            { "AX", "Åland" },
            { "AZ", "Azerbeidzjan" },
            { "BA", "Bosnië en Herzegovina" },
            { "BB", "Barbados" },
            { "BD", "Bangladesh" },
            { "BE", "België" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgarije" },
            { "BH", "Bahrein" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Saint-Barthélemy" },
            { "BM", "Bermuda" },
            { "BN", "Brunei" },
            { "BO", "Bolivia" },
            { "BQ", "Caribisch Nederland" },
            { "BR", "Brazilië" },
            { "BS", "Bahama’s" },
            { "BT", "Bhutan" },
            { "BV", "Bouveteiland" },
            { "BW", "Botswana" },
            { "BY", "Belarus" },
            { "BZ", "Belize" },
            { "CA", "Canada" },
            { "CC", "Cocoseilanden" },
            { "CD", "Congo-Kinshasa" },
            { "CF", "Centraal-Afrikaanse Republiek" },
            { "CG", "Congo-Brazzaville" },
            { "CH", "Zwitserland" },
            { "CI", "Ivoorkust" },
            { "CK", "Cookeilanden" },
            { "CL", "Chili" },
            { "CM", "Kameroen" },
            { "CN", "China" },
            { "CO", "Colombia" },
            { "CP", "Clipperton" },
            { "CQ", "Sark" },
            { "CR", "Costa Rica" },
            { "CU", "Cuba" },
            { "CV", "Kaapverdië" },
            { "CW", "Curaçao" },
            { "CX", "Christmaseiland" },
            { "CY", "Cyprus" },
            { "CZ", "Tsjechië" },
            { "DE", "Duitsland" },
            { "DG", "Diego Garcia" },
            { "DJ", "Djibouti" },
            { "DK", "Denemarken" },
            { "DM", "Dominica" },
            { "DO", "Dominicaanse Republiek" },
            { "DZ", "Algerije" },
            { "EA", "Ceuta en Melilla" },
            { "EC", "Ecuador" },
            { "EE", "Estland" },
            { "EG", "Egypte" },
            { "EH", "Westelijke Sahara" },
            { "ER", "Eritrea" },
            { "ES", "Spanje" },
            { "ET", "Ethiopië" },
            { "EU", "Europese Unie" },
            { "EZ", "eurozone" },
            { "FI", "Finland" },
            { "FJ", "Fiji" },
            { "FK", "Falklandeilanden" },
            { "FM", "Micronesia" },
            { "FO", "Faeröer" },
            { "FR", "Frankrijk" },
            { "GA", "Gabon" },
            { "GB", "Verenigd Koninkrijk" },
            { "GD", "Grenada" },
            { "GE", "Georgië" },
            { "GF", "Frans-Guyana" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "GI", "Gibraltar" },
            { "GL", "Groenland" },
            { "GM", "Gambia" },
            { "GN", "Guinee" },
            { "GP", "Guadeloupe" },
            { "GQ", "Equatoriaal-Guinea" },
            { "GR", "Griekenland" },
            { "GS", "Zuid-Georgia en Zuidelijke Sandwicheilanden" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Guinee-Bissau" },
            { "GY", "Guyana" },
            { "HK", "Hongkong SAR van China" },
            { "HM", "Heard en McDonaldeilanden" },
            { "HN", "Honduras" },
            { "HR", "Kroatië" },
            { "HT", "Haïti" },
            { "HU", "Hongarije" },
            { "IC", "Canarische Eilanden" },
            { "ID", "Indonesië" },
            { "IE", "Ierland" },
            { "IL", "Israël" },
            { "IM", "Isle of Man" },
            { "IN", "India" },
            { "IO", "Brits Indische Oceaanterritorium" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", "IJsland" },
            { "IT", "Italië" },
            { "JE", "Jersey" },
            { "JM", "Jamaica" },
            { "JO", "Jordanië" },
            { "JP", "Japan" },
            { "KE", "Kenia" },
            { "KG", "Kirgizië" },
            { "KH", "Cambodja" },
            { "KI", "Kiribati" },
            { "KM", "Comoren" },
            { "KN", "Saint Kitts en Nevis" },
            { "KP", "Noord-Korea" },
            { "KR", "Zuid-Korea" },
            { "KW", "Koeweit" },
            { "KY", "Kaaimaneilanden" },
            { "KZ", "Kazachstan" },
            { "LA", "Laos" },
            { "LB", "Libanon" },
            { "LC", "Saint Lucia" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "LR", "Liberia" },
            { "LS", "Lesotho" },
            { "LT", "Litouwen" },
            { "LU", "Luxemburg" },
            { "LV", "Letland" },
            { "LY", "Libië" },
            { "MA", "Marokko" },
            { "MC", "Monaco" },
            { "MD", "Moldavië" },
            { "ME", "Montenegro" },
            { "MF", "Saint-Martin" },
            { "MG", "Madagaskar" },
            { "MH", "Marshalleilanden" },
            { "MK", "Noord-Macedonië" },
            { "ML", "Mali" },
            { "MM", "Myanmar (Birma)" },
            { "MN", "Mongolië" },
            { "MO", "Macau SAR van China" },
            { "MP", "Noordelijke Marianen" },
            { "MQ", "Martinique" },
            { "MR", "Mauritanië" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Mauritius" },
            { "MV", "Maldiven" },
            { "MW", "Malawi" },
            { "MX", "Mexico" },
            { "MY", "Maleisië" },
            { "MZ", "Mozambique" },
            { "NA", "Namibië" },
            { "NC", "Nieuw-Caledonië" },
            { "NE", "Niger" },
            { "NF", "Norfolk" },
            { "NG", "Nigeria" },
            { "NI", "Nicaragua" },
            { "NL", "Nederland" },
            { "NO", "Noorwegen" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Nieuw-Zeeland" },
            { "OM", "Oman" },
            { "PA", "Panama" },
            { "PE", "Peru" },
            { "PF", "Frans-Polynesië" },
            { "PG", "Papoea-Nieuw-Guinea" },
            { "PH", "Filipijnen" },
            { "PK", "Pakistan" },
            { "PL", "Polen" },
            { "PM", "Saint-Pierre en Miquelon" },
            { "PN", "Pitcairneilanden" },
            { "PR", "Puerto Rico" },
            { "PS", "Palestijnse gebieden" },
            { "PT", "Portugal" },
            { "PW", "Palau" },
            { "PY", "Paraguay" },
            { "QA", "Qatar" },
            { "QO", "overig Oceanië" },
            { "RE", "Réunion" },
            { "RO", "Roemenië" },
            { "RS", "Servië" },
            { "RU", "Rusland" },
            { "RW", "Rwanda" },
            { "SA", "Saoedi-Arabië" },
            { "SB", "Salomonseilanden" },
            { "SC", "Seychellen" },
            { "SD", "Soedan" },
            { "SE", "Zweden" },
            { "SG", "Singapore" },
            { "SH", "Sint-Helena" },
            { "SI", "Slovenië" },
            { "SJ", "Spitsbergen en Jan Mayen" },
            { "SK", "Slowakije" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalië" },
            { "SR", "Suriname" },
            { "SS", "Zuid-Soedan" },
            { "ST", "Sao Tomé en Principe" },
            { "SV", "El Salvador" },
            { "SX", "Sint-Maarten" },
            { "SY", "Syrië" },
            { "SZ", "Eswatini" },
            { "TA", "Tristan da Cunha" },
            { "TC", "Turks- en Caicoseilanden" },
            { "TD", "Tsjaad" },
            { "TF", "Franse Gebieden in de zuidelijke Indische Oceaan" },
            { "TG", "Togo" },
            { "TH", "Thailand" },
            { "TJ", "Tadzjikistan" },
            { "TK", "Tokelau" },
            { "TL", "Oost-Timor" },
            { "TM", "Turkmenistan" },
            { "TN", "Tunesië" },
            { "TO", "Tonga" },
            { "TR", "Turkije" },
            { "TT", "Trinidad en Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "TZ", "Tanzania" },
            { "UA", "Oekraïne" },
            { "UG", "Oeganda" },
            { "UM", "Kleine afgelegen eilanden van de Verenigde Staten" },
            { "UN", "Verenigde Naties" },
            { "US", "Verenigde Staten" },
            { "UY", "Uruguay" },
            { "UZ", "Oezbekistan" },
            { "VA", "Vaticaanstad" },
            { "VC", "Saint Vincent en de Grenadines" },
            { "VE", "Venezuela" },
            { "VG", "Britse Maagdeneilanden" },
            { "VI", "Amerikaanse Maagdeneilanden" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis en Futuna" },
            { "WS", "Samoa" },
            { "XA", "Pseudo-Accenten" },
            { "XB", "Pseudo-Bidi" },
            { "XK", "Kosovo" },
            { "YE", "Jemen" },
            { "YT", "Mayotte" },
            { "ZA", "Zuid-Afrika" },
            { "ZM", "Zambia" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "onbekend gebied" },
            { "aa", "Afar" },
            { "ab", "Abchazisch" },
            { "ae", "Avestisch" },
            { "af", "Afrikaans" },
            { "ak", "Akan" },
            { "am", "Amhaars" },
            { "an", "Aragonees" },
            { "ar", metaValue_ar },
            { "as", "Assamees" },
            { "av", "Avarisch" },
            { "ay", "Aymara" },
            { "az", "Azerbeidzjaans" },
            { "ba", "Basjkiers" },
            { "be", "Belarussisch" },
            { "bg", "Bulgaars" },
            { "bi", "Bislama" },
            { "bm", "Bambara" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "Bretons" },
            { "bs", "Bosnisch" },
            { "ca", "Catalaans" },
            { "ce", "Tsjetsjeens" },
            { "ch", "Chamorro" },
            { "co", "Corsicaans" },
            { "cr", "Cree" },
            { "cs", "Tsjechisch" },
            { "cu", "Kerkslavisch" },
            { "cv", "Tsjoevasjisch" },
            { "cy", "Welsh" },
            { "da", "Deens" },
            { "de", "Duits" },
            { "dv", "Divehi" },
            { "dz", "Dzongkha" },
            { "ee", "Ewe" },
            { "el", metaValue_el },
            { "en", "Engels" },
            { "eo", "Esperanto" },
            { "es", "Spaans" },
            { "et", "Estisch" },
            { "eu", "Baskisch" },
            { "fa", "Perzisch" },
            { "ff", "Fulah" },
            { "fi", "Fins" },
            { "fj", "Fijisch" },
            { "fo", "Faeröers" },
            { "fr", "Frans" },
            { "fy", "Fries" },
            { "ga", "Iers" },
            { "gd", "Schots-Gaelisch" },
            { "gl", "Galicisch" },
            { "gn", "Guaraní" },
            { "gu", metaValue_gu },
            { "gv", "Manx" },
            { "ha", "Hausa" },
            { "he", metaValue_he },
            { "hi", "Hindi" },
            { "ho", "Hiri Motu" },
            { "hr", "Kroatisch" },
            { "ht", "Haïtiaans Creools" },
            { "hu", "Hongaars" },
            { "hy", metaValue_hy },
            { "hz", "Herero" },
            { "ia", "Interlingua" },
            { "id", "Indonesisch" },
            { "ie", "Interlingue" },
            { "ig", "Igbo" },
            { "ii", metaValue_ii },
            { "ik", "Inupiaq" },
            { "io", "Ido" },
            { "is", "IJslands" },
            { "it", "Italiaans" },
            { "iu", "Inuktitut" },
            { "ja", metaValue_ja },
            { "jv", metaValue_jv },
            { "ka", metaValue_ka },
            { "kg", "Kongo" },
            { "ki", "Gikuyu" },
            { "kj", "Kuanyama" },
            { "kk", "Kazachs" },
            { "kl", "Groenlands" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "Kanuri" },
            { "ks", "Kasjmiri" },
            { "ku", "Koerdisch" },
            { "kv", "Komi" },
            { "kw", "Cornish" },
            { "ky", "Kirgizisch" },
            { "la", "Latijn" },
            { "lb", "Luxemburgs" },
            { "lg", "Luganda" },
            { "li", "Limburgs" },
            { "ln", "Lingala" },
            { "lo", metaValue_lo },
            { "lt", "Litouws" },
            { "lu", "Luba-Katanga" },
            { "lv", "Lets" },
            { "mg", "Malagassisch" },
            { "mh", "Marshallees" },
            { "mi", "Maori" },
            { "mk", "Macedonisch" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "Marathi" },
            { "ms", "Maleis" },
            { "mt", "Maltees" },
            { "my", metaValue_my },
            { "na", "Nauruaans" },
            { "nb", "Noors - Bokmål" },
            { "nd", "Noord-Ndebele" },
            { "ne", "Nepalees" },
            { "ng", "Ndonga" },
            { "nl", "Nederlands" },
            { "nn", "Noors - Nynorsk" },
            { "no", "Noors" },
            { "nr", "Zuid-Ndbele" },
            { "nv", "Navajo" },
            { "ny", "Nyanja" },
            { "oc", "Occitaans" },
            { "oj", "Ojibwa" },
            { "om", "Afaan Oromo" },
            { "or", metaValue_or },
            { "os", "Ossetisch" },
            { "pa", "Punjabi" },
            { "pi", "Pali" },
            { "pl", "Pools" },
            { "ps", "Pasjtoe" },
            { "pt", "Portugees" },
            { "qu", "Quechua" },
            { "rm", "Reto-Romaans" },
            { "rn", "Kirundi" },
            { "ro", "Roemeens" },
            { "ru", "Russisch" },
            { "rw", "Kinyarwanda" },
            { "sa", "Sanskriet" },
            { "sc", "Sardijns" },
            { "sd", metaValue_sd },
            { "se", "Noord-Samisch" },
            { "sg", "Sango" },
            { "sh", "Servo-Kroatisch" },
            { "si", metaValue_si },
            { "sk", "Slowaaks" },
            { "sl", "Sloveens" },
            { "sm", "Samoaans" },
            { "sn", "Shona" },
            { "so", "Somalisch" },
            { "sq", "Albanees" },
            { "sr", "Servisch" },
            { "ss", "Swazi" },
            { "st", "Zuid-Sotho" },
            { "su", metaValue_su },
            { "sv", "Zweeds" },
            { "sw", "Swahili" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "Tadzjieks" },
            { "th", "Thai" },
            { "ti", "Tigrinya" },
            { "tk", "Turkmeens" },
            { "tl", metaValue_tl },
            { "tn", "Tswana" },
            { "to", "Tongaans" },
            { "tr", "Turks" },
            { "ts", "Tsonga" },
            { "tt", "Tataars" },
            { "tw", "Twi" },
            { "ty", "Tahitiaans" },
            { "ug", "Oeigoers" },
            { "uk", "Oekraïens" },
            { "ur", "Urdu" },
            { "uz", "Oezbeeks" },
            { "ve", "Venda" },
            { "vi", "Vietnamees" },
            { "vo", "Volapük" },
            { "wa", "Waals" },
            { "wo", "Wolof" },
            { "xh", "Xhosa" },
            { "yi", "Jiddisch" },
            { "yo", "Yoruba" },
            { "za", "Zhuang" },
            { "zh", "Chinees" },
            { "zu", "Zoeloe" },
            { "ace", "Atjehs" },
            { "ach", "Akoli" },
            { "ada", "Adangme" },
            { "ady", "Adygees" },
            { "aeb", "Tunesisch Arabisch" },
            { "afh", "Afrihili" },
            { "agq", "Aghem" },
            { "ain", "Aino" },
            { "akk", "Akkadisch" },
            { "akz", "Alabama" },
            { "ale", "Aleoetisch" },
            { "aln", "Gegisch" },
            { "alt", "Zuid-Altaïsch" },
            { "ang", "Oudengels" },
            { "ann", "Obolo" },
            { "anp", "Angika" },
            { "apc", "Levantijns-Arabisch" },
            { "arc", "Aramees" },
            { "arn", "Mapudungun" },
            { "aro", "Araona" },
            { "arp", "Arapaho" },
            { "arq", "Algerijns Arabisch" },
            { "ars", "Nadjdi-Arabisch" },
            { "arw", "Arawak" },
            { "ary", "Marokkaans Arabisch" },
            { "arz", "Egyptisch Arabisch" },
            { "asa", "Asu" },
            { "ase", "Amerikaanse Gebarentaal" },
            { "ast", "Asturisch" },
            { "atj", "Atikamekw" },
            { "avk", "Kotava" },
            { "awa", "Awadhi" },
            { "bal", "Beloetsji" },
            { "ban", metaValue_ban },
            { "bar", "Beiers" },
            { "bas", "Basa" },
            { "bax", metaValue_bax },
            { "bbc", "Batak Toba" },
            { "bbj", "Ghomala’" },
            { "bej", "Beja" },
            { "bem", "Bemba" },
            { "bew", "Bataviaans" },
            { "bez", "Bena" },
            { "bfd", "Bafut" },
            { "bfq", "Badaga" },
            { "bgc", "Haryanvi" },
            { "bgn", "Westers Beloetsji" },
            { "bho", "Bhojpuri" },
            { "bik", "Bikol" },
            { "bin", "Bini" },
            { "bjn", "Banjar" },
            { "bkm", "Kom" },
            { "bla", "Siksika" },
            { "blo", "Anii" },
            { "bpy", "Bishnupriya" },
            { "bqi", "Bakhtiari" },
            { "bra", "Braj" },
            { "brh", "Brahui" },
            { "brx", "Bodo" },
            { "bss", "Akoose" },
            { "bua", "Boerjatisch" },
            { "bug", metaValue_bug },
            { "bum", "Bulu" },
            { "byn", "Blin" },
            { "byv", "Medumba" },
            { "cad", "Caddo" },
            { "car", "Caribisch" },
            { "cay", "Cayuga" },
            { "cch", "Atsam" },
            { "ccp", metaValue_ccp },
            { "ceb", "Cebuano" },
            { "cgg", "Chiga" },
            { "chb", "Chibcha" },
            { "chg", "Chagatai" },
            { "chk", "Chuukees" },
            { "chm", "Mari" },
            { "chn", "Chinook Jargon" },
            { "cho", "Choctaw" },
            { "chp", "Chipewyan" },
            { "chr", metaValue_chr },
            { "chy", "Cheyenne" },
            { "ckb", "Soranî" },
            { "clc", "Chilcotin" },
            { "cop", metaValue_cop },
            { "cps", "Capiznon" },
            { "crg", "Michif" },
            { "crh", "Krim-Tataars" },
            { "crj", "Zuidoost-Cree" },
            { "crk", "Plains Cree" },
            { "crl", "Noordoost-Cree" },
            { "crm", "Moose Cree" },
            { "crr", "Carolina Algonkisch" },
            { "crs", "Seychellencreools" },
            { "csb", "Kasjoebisch" },
            { "csw", "Swampy Cree" },
            { "dak", "Dakota" },
            { "dar", "Dargwa" },
            { "dav", "Taita" },
            { "del", "Delaware" },
            { "den", "Slavey" },
            { "dgr", "Dogrib" },
            { "din", "Dinka" },
            { "dje", "Zarma" },
            { "doi", "Dogri" },
            { "dsb", "Nedersorbisch" },
            { "dtp", "Dusun" },
            { "dua", "Duala" },
            { "dum", "Middelnederlands" },
            { "dyo", "Jola-Fonyi" },
            { "dyu", "Dyula" },
            { "dzg", "Dazaga" },
            { "ebu", "Embu" },
            { "efi", "Efik" },
            { "egl", "Emiliano" },
            { "egy", "Oudegyptisch" },
            { "eka", "Ekajuk" },
            { "elx", "Elamitisch" },
            { "enm", "Middelengels" },
            { "esu", "Yupik" },
            { "ewo", "Ewondo" },
            { "ext", "Extremeens" },
            { "fan", "Fang" },
            { "fat", "Fanti" },
            { "fil", "Filipijns" },
            { "fit", "Tornedal-Fins" },
            { "fon", "Fon" },
            { "frc", "Cajun-Frans" },
            { "frm", "Middelfrans" },
            { "fro", "Oudfrans" },
            { "frp", "Arpitaans" },
            { "frr", "Noord-Fries" },
            { "frs", "Oost-Fries" },
            { "fur", "Friulisch" },
            { "gaa", "Ga" },
            { "gag", "Gagaoezisch" },
            { "gan", "Ganyu" },
            { "gay", "Gayo" },
            { "gba", "Gbaya" },
            { "gbz", "Zoroastrisch Dari" },
            { "gez", "Ge’ez" },
            { "gil", "Gilbertees" },
            { "glk", "Gilaki" },
            { "gmh", "Middelhoogduits" },
            { "goh", "Oudhoogduits" },
            { "gon", "Gondi" },
            { "gor", "Gorontalo" },
            { "got", metaValue_got },
            { "grb", "Grebo" },
            { "grc", "Oudgrieks" },
            { "gsw", "Zwitserduits" },
            { "guc", "Wayuu" },
            { "gur", "Gurune" },
            { "guz", "Gusii" },
            { "gwi", "Gwichʼin" },
            { "hai", "Haida" },
            { "hak", "Hakka" },
            { "haw", "Hawaïaans" },
            { "hax", "Zuid-Haida" },
            { "hif", "Fijisch Hindi" },
            { "hil", "Hiligaynon" },
            { "hit", "Hettitisch" },
            { "hmn", "Hmong" },
            { "hsb", "Oppersorbisch" },
            { "hsn", "Xiangyu" },
            { "hup", "Hupa" },
            { "hur", "Halkomelem" },
            { "iba", "Iban" },
            { "ibb", "Ibibio" },
            { "ikt", "Westelijk Canadees Inuktitut" },
            { "ilo", "Iloko" },
            { "inh", "Ingoesjetisch" },
            { "izh", "Ingrisch" },
            { "jam", "Jamaicaans Creools" },
            { "jbo", "Lojban" },
            { "jgo", "Ngomba" },
            { "jmc", "Machame" },
            { "jpr", "Judeo-Perzisch" },
            { "jrb", "Judeo-Arabisch" },
            { "jut", "Jutlands" },
            { "kaa", "Karakalpaks" },
            { "kab", "Kabylisch" },
            { "kac", "Kachin" },
            { "kaj", "Jju" },
            { "kam", "Kamba" },
            { "kaw", "Kawi" },
            { "kbd", "Kabardisch" },
            { "kbl", "Kanembu" },
            { "kcg", "Tyap" },
            { "kde", "Makonde" },
            { "kea", "Kaapverdisch Creools" },
            { "ken", "Kenyang" },
            { "kfo", "Koro" },
            { "kgp", "Kaingang" },
            { "kha", "Khasi" },
            { "kho", "Khotanees" },
            { "khq", "Koyra Chiini" },
            { "khw", "Khowar" },
            { "kiu", "Kirmanckî" },
            { "kkj", "Kako" },
            { "kln", "Kalenjin" },
            { "kmb", "Kimbundu" },
            { "koi", "Komi-Permjaaks" },
            { "kok", "Konkani" },
            { "kos", "Kosraeaans" },
            { "kpe", metaValue_kpe },
            { "krc", "Karatsjaj-Balkarisch" },
            { "kri", "Krio" },
            { "krj", "Kinaray-a" },
            { "krl", "Karelisch" },
            { "kru", "Kurukh" },
            { "ksb", "Shambala" },
            { "ksf", "Bafia" },
            { "ksh", "Kölsch" },
            { "kum", "Koemuks" },
            { "kut", "Kutenai" },
            { "kwk", "Kwakʼwala" },
            { "kxv", "Kuvi" },
            { "lad", "Ladino" },
            { "lag", "Langi" },
            { "lah", "Lahnda" },
            { "lam", "Lamba" },
            { "lez", "Lezgisch" },
            { "lfn", "Lingua Franca Nova" },
            { "lij", "Ligurisch" },
            { "lil", "Lillooet" },
            { "liv", "Lijfs" },
            { "lkt", "Lakota" },
            { "lmo", "Lombardisch" },
            { "lol", "Mongo" },
            { "lou", "Louisiana-Creools" },
            { "loz", "Lozi" },
            { "lrc", "Noordelijk Luri" },
            { "lsm", "Saamia" },
            { "ltg", "Letgaals" },
            { "lua", "Luba-Lulua" },
            { "lui", "Luiseno" },
            { "lun", "Lunda" },
            { "luo", "Luo" },
            { "lus", "Mizo" },
            { "luy", "Luyia" },
            { "lzh", "Klassiek Chinees" },
            { "lzz", "Lazisch" },
            { "mad", "Madoerees" },
            { "maf", "Mafa" },
            { "mag", "Magahi" },
            { "mai", "Maithili" },
            { "mak", "Makassaars" },
            { "man", "Mandingo" },
            { "mas", "Maa" },
            { "mde", "Maba" },
            { "mdf", "Moksja" },
            { "mdr", "Mandar" },
            { "men", metaValue_men },
            { "mer", "Meru" },
            { "mfe", "Morisyen" },
            { "mga", "Middeliers" },
            { "mgh", "Makhuwa-Meetto" },
            { "mgo", "Meta’" },
            { "mic", "Mi’kmaq" },
            { "min", "Minangkabau" },
            { "mnc", "Mantsjoe" },
            { "mni", metaValue_mni },
            { "moe", "Innu-aimun" },
            { "moh", "Mohawk" },
            { "mos", "Mossi" },
            { "mrj", "West-Mari" },
            { "mua", "Mundang" },
            { "mul", "meerdere talen" },
            { "mus", "Creek" },
            { "mwl", "Mirandees" },
            { "mwr", "Marwari" },
            { "mwv", "Mentawai" },
            { "mye", "Myene" },
            { "myv", "Erzja" },
            { "mzn", "Mazanderani" },
            { "nan", "Minnanyu" },
            { "nap", "Napolitaans" },
            { "naq", "Nama" },
            { "nds", "Nedersaksisch" },
            { "new", metaValue_new },
            { "nia", "Nias" },
            { "niu", "Niueaans" },
            { "njo", "Ao Naga" },
            { "nmg", "Ngumba" },
            { "nnh", "Ngiemboon" },
            { "nog", "Nogai" },
            { "non", "Oudnoors" },
            { "nov", "Novial" },
            { "nqo", metaValue_nqo },
            { "nso", "Noord-Sotho" },
            { "nus", "Nuer" },
            { "nwc", "Klassiek Nepalbhasa" },
            { "nym", "Nyamwezi" },
            { "nyn", "Nyankole" },
            { "nyo", "Nyoro" },
            { "nzi", "Nzima" },
            { "ojb", "Noordwest-Ojibwe" },
            { "ojc", "Centraal Ojibwa" },
            { "ojs", "Oji-Cree" },
            { "ojw", "West-Ojibwe" },
            { "oka", "Okanagan" },
            { "osa", metaValue_osa },
            { "ota", "Ottomaans-Turks" },
            { "pag", "Pangasinan" },
            { "pal", "Pahlavi" },
            { "pam", "Pampanga" },
            { "pap", "Papiaments" },
            { "pau", "Palaus" },
            { "pcd", "Picardisch" },
            { "pcm", "Nigeriaans Pidgin" },
            { "pdc", "Pennsylvania-Duits" },
            { "pdt", "Plautdietsch" },
            { "peo", metaValue_peo },
            { "pfl", "Paltsisch" },
            { "phn", metaValue_phn },
            { "pis", "Pijin" },
            { "pms", "Piëmontees" },
            { "pnt", "Pontisch" },
            { "pon", "Pohnpeiaans" },
            { "pqm", "Maliseet-Passamaquoddy" },
            { "prg", "Oudpruisisch" },
            { "pro", "Oudprovençaals" },
            { "quc", "K’iche’" },
            { "qug", "Kichwa" },
            { "raj", "Rajasthani" },
            { "rap", "Rapanui" },
            { "rar", "Rarotongan" },
            { "rgn", "Romagnol" },
            { "rhg", "Rohingya" },
            { "rif", "Riffijns" },
            { "rof", "Rombo" },
            { "rom", "Romani" },
            { "rtm", "Rotumaans" },
            { "rue", "Roetheens" },
            { "rug", "Roviana" },
            { "rup", "Aroemeens" },
            { "rwk", "Rwa" },
            { "sad", "Sandawe" },
            { "sah", "Jakoets" },
            { "sam", "Samaritaans-Aramees" },
            { "saq", "Samburu" },
            { "sas", "Sasak" },
            { "sat", "Santali" },
            { "saz", metaValue_saz },
            { "sba", "Ngambay" },
            { "sbp", "Sangu" },
            { "scn", "Siciliaans" },
            { "sco", "Schots" },
            { "sdc", "Sassarees" },
            { "sdh", "Pahlavani" },
            { "see", "Seneca" },
            { "seh", "Sena" },
            { "sei", "Seri" },
            { "sel", "Selkoeps" },
            { "ses", "Koyraboro Senni" },
            { "sga", "Oudiers" },
            { "sgs", "Samogitisch" },
            { "shi", "Tashelhiyt" },
            { "shn", "Shan" },
            { "shu", "Tsjadisch Arabisch" },
            { "sid", "Sidamo" },
            { "slh", "Zuid-Lushootseed" },
            { "sli", "Silezisch Duits" },
            { "sly", "Selayar" },
            { "sma", "Zuid-Samisch" },
            { "smj", "Lule-Samisch" },
            { "smn", "Inari-Samisch" },
            { "sms", "Skolt-Samisch" },
            { "snk", "Soninke" },
            { "sog", metaValue_sog },
            { "srn", "Sranantongo" },
            { "srr", "Serer" },
            { "ssy", metaValue_ssy },
            { "stq", "Saterfries" },
            { "str", "Straits Salish" },
            { "suk", "Sukuma" },
            { "sus", "Soesoe" },
            { "sux", "Soemerisch" },
            { "swb", "Shimaore" },
            { "syc", "Klassiek Syrisch" },
            { "syr", "Syrisch" },
            { "szl", "Silezisch" },
            { "tce", "Zuid-Tutchone" },
            { "tcy", "Tulu" },
            { "tem", "Timne" },
            { "teo", "Teso" },
            { "ter", "Tereno" },
            { "tet", "Tetun" },
            { "tgx", "Tagish" },
            { "tht", "Tahltan" },
            { "tig", "Tigre" },
            { "tiv", "Tiv" },
            { "tkl", "Tokelaus" },
            { "tkr", "Tsakhur" },
            { "tlh", "Klingon" },
            { "tli", "Tlingit" },
            { "tly", "Talysh" },
            { "tmh", "Tamashek" },
            { "tog", "Nyasa Tonga" },
            { "tok", "Toki Pona" },
            { "tpi", "Tok Pisin" },
            { "tru", "Turoyo" },
            { "trv", "Taroko" },
            { "tsd", "Tsakonisch" },
            { "tsi", "Tsimshian" },
            { "ttm", "Noord-Tutchone" },
            { "ttt", "Moslim Tat" },
            { "tum", "Toemboeka" },
            { "tvl", "Tuvaluaans" },
            { "twq", "Tasawaq" },
            { "tyv", "Toevaans" },
            { "tzm", "Tamazight (Centraal-Marokko)" },
            { "udm", "Oedmoerts" },
            { "uga", "Oegaritisch" },
            { "umb", "Umbundu" },
            { "und", "onbekende taal" },
            { "vai", metaValue_vai },
            { "vec", "Venetiaans" },
            { "vep", "Wepsisch" },
            { "vls", "West-Vlaams" },
            { "vmf", "Opperfrankisch" },
            { "vmw", "Makhuwa" },
            { "vot", "Votisch" },
            { "vro", "Võro" },
            { "vun", "Vunjo" },
            { "wae", "Walser" },
            { "wal", "Wolaytta" },
            { "war", "Waray" },
            { "was", "Washo" },
            { "wbp", "Warlpiri" },
            { "wuu", "Wuyu" },
            { "xal", "Kalmuks" },
            { "xmf", "Mingreels" },
            { "xnr", "Kangri" },
            { "xog", "Soga" },
            { "yao", "Yao" },
            { "yap", "Yapees" },
            { "yav", "Yangben" },
            { "ybb", "Yemba" },
            { "yrl", "Nheengatu" },
            { "yue", "Kantonees" },
            { "zap", "Zapotec" },
            { "zbl", metaValue_zbl },
            { "zea", "Zeeuws" },
            { "zen", "Zenaga" },
            { "zgh", "Standaard Marokkaanse Tamazight" },
            { "zun", "Zuni" },
            { "zxx", "geen linguïstische inhoud" },
            { "zza", "Zaza" },
            { "Adlm", "Adlam" },
            { "Afak", "Defaka" },
            { "Aghb", "Kaukasisch Albanees" },
            { "Arab", metaValue_ar },
            { "Aran", "Nastaliq" },
            { "Armi", "Keizerlijk Aramees" },
            { "Armn", metaValue_hy },
            { "Avst", "Avestaans" },
            { "Bali", metaValue_ban },
            { "Bamu", metaValue_bax },
            { "Bass", "Bassa Vah" },
            { "Batk", "Batak" },
            { "Beng", metaValue_bn },
            { "Bhks", "Bhaiksuki" },
            { "Blis", metaValue_zbl },
            { "Bopo", "Bopomofo" },
            { "Brah", "Brahmi" },
            { "Brai", "braille" },
            { "Bugi", metaValue_bug },
            { "Buhd", "Buhid" },
            { "Cakm", metaValue_ccp },
            { "Cans", "Verenigde Canadese Aboriginal-symbolen" },
            { "Cari", "Carisch" },
            { "Cher", metaValue_chr },
            { "Chrs", "Chorasmisch" },
            { "Cirt", "Cirth" },
            { "Copt", metaValue_cop },
            { "Cpmn", "Cypro-Minoïsch" },
            { "Cprt", "Cyprisch" },
            { "Cyrl", "Cyrillisch" },
            { "Cyrs", "Oudkerkslavisch Cyrillisch" },
            { "Deva", "Devanagari" },
            { "Diak", "Dives Akuru" },
            { "Dogr", "Dogra" },
            { "Dsrt", "Deseret" },
            { "Dupl", "Duployan snelschrift" },
            { "Egyd", "Egyptisch demotisch" },
            { "Egyh", "Egyptisch hiëratisch" },
            { "Egyp", "Egyptische hiërogliefen" },
            { "Elba", "Elbasan" },
            { "Elym", "Elymaisch" },
            { "Ethi", "Ethiopisch" },
            { "Geok", "Georgisch Khutsuri" },
            { "Geor", metaValue_ka },
            { "Glag", "Glagolitisch" },
            { "Gong", "Gunjala Gondi" },
            { "Gonm", "Masaram Gondi" },
            { "Goth", metaValue_got },
            { "Gran", "Grantha" },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "Gurmukhi" },
            { "Hanb", "Han met Bopomofo" },
            { "Hang", "Hangul" },
            { "Hani", "Han" },
            { "Hano", "Hanunoo" },
            { "Hans", "vereenvoudigd" },
            { "Hant", "traditioneel" },
            { "Hatr", "Hatran" },
            { "Hebr", metaValue_he },
            { "Hira", "Hiragana" },
            { "Hluw", "Anatolische hiërogliefen" },
            { "Hmng", "Pahawh Hmong" },
            { "Hmnp", "Nyiakeng Puachue Hmong" },
            { "Hrkt", "Katakana of Hiragana" },
            { "Hung", "Oudhongaars" },
            { "Inds", "Indus" },
            { "Ital", "Oud-italisch" },
            { "Java", metaValue_jv },
            { "Jpan", metaValue_ja },
            { "Jurc", "Jurchen" },
            { "Kali", "Kayah Li" },
            { "Kana", "Katakana" },
            { "Kawi", "Kawi-taal" },
            { "Khar", "Kharoshthi" },
            { "Khmr", metaValue_km },
            { "Khoj", "Khojki" },
            { "Kits", "Kitaans kleinschrift" },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Kpel", metaValue_kpe },
            { "Kthi", "Kaithi" },
            { "Lana", "Lanna" },
            { "Laoo", metaValue_lo },
            { "Latf", "Gotisch Latijns" },
            { "Latg", "Gaelisch Latijns" },
            { "Latn", "Latijns" },
            { "Lepc", "Lepcha" },
            { "Limb", "Limbu" },
            { "Lina", "Lineair A" },
            { "Linb", "Lineair B" },
            { "Lisu", "Fraser" },
            { "Loma", "Loma" },
            { "Lyci", "Lycisch" },
            { "Lydi", "Lydisch" },
            { "Mahj", "Mahajani" },
            { "Maka", "Makasar" },
            { "Mand", "Mandaeans" },
            { "Mani", "Manicheaans" },
            { "Marc", "Marchen" },
            { "Maya", "Mayahiërogliefen" },
            { "Medf", "Medefaidrin" },
            { "Mend", metaValue_men },
            { "Merc", "Meroitisch cursief" },
            { "Mero", "Meroïtisch" },
            { "Mlym", metaValue_ml },
            { "Mong", metaValue_mn },
            { "Moon", "Moon" },
            { "Mroo", "Mro" },
            { "Mtei", metaValue_mni },
            { "Mult", "Multani" },
            { "Mymr", metaValue_my },
            { "Nagm", "Nag Mundari" },
            { "Nand", "Nandinagari" },
            { "Narb", "Oud Noord-Arabisch" },
            { "Nbat", "Nabateaans" },
            { "Newa", metaValue_new },
            { "Nkgb", "Naxi Geba" },
            { "Nkoo", metaValue_nqo },
            { "Nshu", "Nüshu" },
            { "Ogam", "Ogham" },
            { "Olck", "Ol Chiki" },
            { "Orkh", "Orkhon" },
            { "Orya", metaValue_or },
            { "Osge", metaValue_osa },
            { "Osma", "Osmanya" },
            { "Ougr", "Oud Oeigoers" },
            { "Palm", "Palmyreens" },
            { "Pauc", "Pau Cin Hau" },
            { "Perm", "Oudpermisch" },
            { "Phag", "Phags-pa" },
            { "Phli", "Inscriptioneel Pahlavi" },
            { "Phlp", "Psalmen Pahlavi" },
            { "Phlv", "Boek Pahlavi" },
            { "Phnx", metaValue_phn },
            { "Plrd", "Pollard-fonetisch" },
            { "Prti", "Inscriptioneel Parthisch" },
            { "Qaag", "Zawgyi" },
            { "Rjng", "Rejang" },
            { "Rohg", "Hanifi Rohingya" },
            { "Roro", "Rongorongo" },
            { "Runr", "Runic" },
            { "Samr", "Samaritaans" },
            { "Sara", "Sarati" },
            { "Sarb", "Oud Zuid-Arabisch" },
            { "Saur", metaValue_saz },
            { "Sgnw", "SignWriting" },
            { "Shaw", "Shavian" },
            { "Shrd", "Sharada" },
            { "Sidd", "Siddham" },
            { "Sind", metaValue_sd },
            { "Sinh", metaValue_si },
            { "Sogd", metaValue_sog },
            { "Sogo", "Oud Sogdisch" },
            { "Sora", "Sora Sompeng" },
            { "Soyo", "Soyombo" },
            { "Sund", metaValue_su },
            { "Sylo", "Syloti Nagri" },
            { "Syrc", "Syriac" },
            { "Syre", "Estrangelo Aramees" },
            { "Syrj", "West-Aramees" },
            { "Syrn", "Oost-Aramees" },
            { "Tagb", "Tagbanwa" },
            { "Takr", "Takri" },
            { "Tale", "Tai Le" },
            { "Talu", "Nieuw Tai Lue" },
            { "Taml", metaValue_ta },
            { "Tang", "Tangut" },
            { "Tavt", "Tai Viet" },
            { "Telu", metaValue_te },
            { "Teng", "Tengwar" },
            { "Tfng", "Tifinagh" },
            { "Tglg", metaValue_tl },
            { "Thaa", "Thaana" },
            { "Tibt", metaValue_bo },
            { "Tirh", "Tirhuta" },
            { "Tnsa", "Tangsa" },
            { "Toto", "Totoschrift" },
            { "Ugar", "Ugaritisch" },
            { "Vaii", metaValue_vai },
            { "Visp", "Zichtbare spraak" },
            { "Vith", "Vithkuqi" },
            { "Wara", "Varang Kshiti" },
            { "Wcho", "Wancho" },
            { "Wole", "Woleai" },
            { "Xpeo", metaValue_peo },
            { "Xsux", "Sumero-Akkadian Cuneiform" },
            { "Yezi", "Jezidi" },
            { "Yiii", metaValue_ii },
            { "Zanb", "vierkant Zanabazar" },
            { "Zinh", "Overgeërfd" },
            { "Zmth", "wiskundige notatie" },
            { "Zsye", "emoji" },
            { "Zsym", "symbolen" },
            { "Zxxx", "ongeschreven" },
            { "Zyyy", "algemeen" },
            { "Zzzz", "onbekend schriftsysteem" },
            { "fa_AF", "Dari" },
            { "nl_BE", "Vlaams" },
            { "%%1901", "Traditionele Duitse spelling" },
            { "%%1994", "Gestandaardiseerde Resiaanse spelling" },
            { "%%1996", "Duitse spelling van 1996" },
            { "ar_001", "modern standaard Arabisch" },
            { "key.ca", "kalender" },
            { "key.cf", "valutanotatie" },
            { "key.co", "sorteervolgorde" },
            { "key.cu", "valuta" },
            { "key.hc", "uursysteem (12 of 24)" },
            { "key.lb", "stijl regelafbreking" },
            { "key.ms", "maatsysteem" },
            { "key.nu", "cijfers" },
            { "key.tz", "Tijdzone" },
            { "key.va", "Landvariant" },
            { "nds_NL", "Nederduits" },
            { "%%ALUKU", "Aloekoe-dialect" },
            { "%%BARLA", "Barlavento-dialectgroep van Kabuverdianu" },
            { "%%BISKE", "San Giorgio/Bila-dialect" },
            { "%%BOONT", "Boontling" },
            { "%%CORNU", "Cornu" },
            { "%%GALLO", "Gallo" },
            { "%%JAUER", "Jauer" },
            { "%%KKCOR", "Algemene spelling" },
            { "%%KSCOR", "Standaardspelling" },
            { "%%LIPAW", "Het Lipovaz-dialect van het Resiaans" },
            { "%%NEDIS", "Natisone-dialect" },
            { "%%NJIVA", "Gniva/Njiva-dialect" },
            { "%%NULIK", "Modern Volapük" },
            { "%%OSOJS", "Oseacco/Osojane-dialect" },
            { "%%PEANO", "Latijn zonder flexie" },
            { "%%POSIX", "Computer" },
            { "%%PUTER", "Puter" },
            { "%%RIGIK", "Klassiek Volapük" },
            { "%%ROZAJ", "Resiaans" },
            { "%%RUMGR", "Rumgr" },
            { "%%SAAHO", metaValue_ssy },
            { "%%SOLBA", "Stolvizza/Solbica-dialect" },
            { "%%SOTAV", "Sotavento-dialectgroep van Kabuverdianu" },
            { "%%UCCOR", "Eenvormige spelling" },
            { "%%AO1990", "Portugese spellingsovereenkomst van 1990" },
            { "%%ARANES", "Aranees" },
            { "%%ASANTE", "Asante" },
            { "%%AUVERN", "Auvern" },
            { "%%CISAUP", "Cisaup" },
            { "%%CREISS", "Creiss" },
            { "%%DAJNKO", "Dajnko-alfabet" },
            { "%%EKAVSK", "Servisch met Ekaviaanse uitspraak" },
            { "%%FONIPA", "Internationaal Fonetisch Alfabet" },
            { "%%FONUPA", "Oeralisch Fonetisch Alfabet" },
            { "%%GASCON", "Gascon" },
            { "%%GRITAL", "Grital" },
            { "%%NDYUKA", "Ndyuka-dialect" },
            { "%%NICARD", "Nicard" },
            { "%%PAMAKA", "Pamaka" },
            { "%%PINYIN", "Pinyin" },
            { "%%SCOUSE", "Liverpools (Scouse)" },
            { "%%SIMPLE", "Simpel" },
            { "%%TARASK", "Taraskievica-spelling" },
            { "%%UCRCOR", "Eenvormig herziene spelling" },
            { "%%ULSTER", "Ulster" },
            { "%%UNIFON", "Unifon fonetisch alfabet" },
            { "%%ABL1943", "Spellingsformulering van 1943" },
            { "%%AKUAPEM", "Akuapem" },
            { "%%ALALC97", "Romanisering ALA-LC, editie 1997" },
            { "%%AREVELA", "Oost-Armeens" },
            { "%%AREVMDA", "West-Armeens" },
            { "%%ARKAIKA", "Archaïsch Esperanto" },
            { "%%BALANKA", "Balanka-dialect van Anii" },
            { "%%BAUDDHA", "Bauddha" },
            { "%%BOHORIC", "Bohorič-alfabet" },
            { "%%EMODENG", "Vroegmodern Engels" },
            { "%%FONNAPA", "Fonnapa" },
            { "%%GRCLASS", "Grclass" },
            { "%%GRMISTR", "Grmistr" },
            { "%%HEPBURN", "Hepburn-romanisering" },
            { "%%ITIHASA", "Episch Sanskriet" },
            { "%%LAUKIKA", "Laukika" },
            { "%%LEMOSIN", "Lemosin" },
            { "%%METELKO", "Metelko-alfabet" },
            { "%%MONOTON", "Monotonaal" },
            { "%%PAHAWH2", "Pahawh2" },
            { "%%PAHAWH3", "Pahawh3" },
            { "%%PAHAWH4", "Pahawh4" },
            { "%%POLYTON", "Polytonaal" },
            { "%%PROVENC", "Provenc" },
            { "%%REVISED", "Gewijzigde spelling" },
            { "%%SURSILV", "Sursilvan" },
            { "%%SUTSILV", "Sutsilvan" },
            { "%%VAIDIKA", "Vaidika" },
            { "%%1606NICT", "Laat Middelfrans tot 1606" },
            { "%%1694ACAD", "Vroeg modern Frans" },
            { "%%1959ACAD", "Academisch" },
            { "%%BAKU1926", "Eenvormig Turkse Latijnse alfabet" },
            { "%%BASICENG", "Standaard Engels" },
            { "%%BISCAYAN", "Biskajaans" },
            { "%%BORNHOLM", "Bornholms" },
            { "%%COLB1945", "Portugese-Braziliaanse spellingsverdrag van 1945" },
            { "%%FONKIRSH", "Fonkirsh" },
            { "%%FONXSAMP", "Transcriptie volgens X-SAMPA" },
            { "%%HOGNORSK", "Hoognoors" },
            { "%%HSISTEMO", "H-sistemo" },
            { "%%IJEKAVSK", "Servisch met Ijekaviaanse uitspraak" },
            { "%%IVANCHOV", "Ivanchov" },
            { "%%JYUTPING", "Jyutping" },
            { "%%KOCIEWIE", "Kociewie" },
            { "%%LENGADOC", "Lengadoc" },
            { "%%LUNA1918", "Russische spelling van 1917" },
            { "%%NEWFOUND", "Newfound" },
            { "%%OXENDICT", "Spelling volgens het Oxford English Dictionary" },
            { "%%PETR1708", "Petr1708" },
            { "%%SCOTLAND", "Schots standaard-Engels" },
            { "%%SPANGLIS", "Spanglis" },
            { "%%SURMIRAN", "Surmiran" },
            { "%%SYNNEJYL", "Zuid-Jutlands" },
            { "%%TONGYONG", "Tongyong" },
            { "%%TUNUMIIT", "Tunumiisiut" },
            { "%%VALENCIA", "Valenciaans" },
            { "%%VALLADER", "Vallader" },
            { "%%VECDRUKA", "Vecā druka" },
            { "%%VIVARAUP", "Vivaraup" },
            { "%%WADEGILE", "Wade-Giles-romanisering" },
            { "%%XSISTEMO", "X-sistemo" },
            { "type.ca.roc", "Kalender van de Chinese Republiek" },
            { "type.co.eor", "Europese sorteerregels" },
            { "type.hc.h11", "12-uursysteem (0-11)" },
            { "type.hc.h12", "12-uursysteem (1-12)" },
            { "type.hc.h23", "24-uursysteem (0-23)" },
            { "type.hc.h24", "24-uursysteem (1-24)" },
            { "type.m0.bgn", "BGN" },
            { "type.nu.ahom", "Ahom cijfers" },
            { "type.nu.arab", "Arabisch-Indische cijfers" },
            { "type.nu.armn", "Armeense cijfers" },
            { "type.nu.bali", "Balinese cijfers" },
            { "type.nu.beng", "Bengaalse cijfers" },
            { "type.nu.brah", "Brahmi cijfers" },
            { "type.nu.cakm", "Chakma cijfers" },
            { "type.nu.cham", "Cham cijfers" },
            { "type.nu.cyrl", "Cyrillische cijfers" },
            { "type.nu.deva", "Devanagari cijfers" },
            { "type.nu.diak", "Dives Akuru cijfers" },
            { "type.nu.ethi", "Ethiopische cijfers" },
            { "type.nu.geor", "Georgische cijfers" },
            { "type.nu.gong", "Gunjala Gondi cijfers" },
            { "type.nu.gonm", "Masaram Gondi cijfers" },
            { "type.nu.grek", "Griekse cijfers" },
            { "type.nu.gujr", "Gujarati cijfers" },
            { "type.nu.guru", "Gurmukhi cijfers" },
            { "type.nu.hans", "vereenvoudigd Chinese cijfers" },
            { "type.nu.hant", "traditioneel Chinese cijfers" },
            { "type.nu.hebr", "Hebreeuwse cijfers" },
            { "type.nu.hmng", "Pahawh Hmong cijfers" },
            { "type.nu.hmnp", "Nyiakeng Puachue Hmong cijfers" },
            { "type.nu.java", "Javaanse cijfers" },
            { "type.nu.jpan", "Japanse cijfers" },
            { "type.nu.kali", "Kayah Li cijfers" },
            { "type.nu.kawi", "kawi cijfers" },
            { "type.nu.khmr", "Khmer cijfers" },
            { "type.nu.knda", "Kannada cijfers" },
            { "type.nu.lana", "Tai Tham Hora cijfers" },
            { "type.nu.laoo", "Laotiaanse cijfers" },
            { "type.nu.latn", "Westerse cijfers" },
            { "type.nu.lepc", "Lepcha cijfers" },
            { "type.nu.limb", "Limbu cijfers" },
            { "type.nu.mlym", "Malayalam cijfers" },
            { "type.nu.modi", "Modi cijfers" },
            { "type.nu.mong", "Mongoolse cijfers" },
            { "type.nu.mroo", "Mro cijfers" },
            { "type.nu.mtei", "Meetei Mayek cijfers" },
            { "type.nu.mymr", "Myanmarese cijfers" },
            { "type.nu.nagm", "Nag Mundari cijfers" },
            { "type.nu.nkoo", "N’Ko cijfers" },
            { "type.nu.olck", "Ol Chiki cijfers" },
            { "type.nu.orya", "Odia cijfers" },
            { "type.nu.osma", "Osmanya cijfers" },
            { "type.nu.rohg", "Hanifi Rohingya cijfers" },
            { "type.nu.saur", "Saurashtra cijfers" },
            { "type.nu.shrd", "Sharada cijfers" },
            { "type.nu.sind", "Khudawadi cijfers" },
            { "type.nu.sinh", "Sinhala Lith cijfers" },
            { "type.nu.sora", "Sora Sompeng cijfers" },
            { "type.nu.sund", "Sundanese cijfers" },
            { "type.nu.takr", "Takri cijfers" },
            { "type.nu.talu", "nieuwe Tai Lue cijfers" },
            { "type.nu.taml", "traditionele Tamil cijfers" },
            { "type.nu.telu", "Telugu cijfers" },
            { "type.nu.thai", "Thaise cijfers" },
            { "type.nu.tibt", "Tibetaanse cijfers" },
            { "type.nu.tirh", "Tirhuta cijfers" },
            { "type.nu.tnsa", "Tangsa cijfers" },
            { "type.nu.vaii", "Vai cijfers" },
            { "type.nu.wara", "Warang Citi cijfers" },
            { "type.nu.wcho", "Wancho cijfers" },
            { "type.ca.dangi", "Dangi-kalender" },
            { "type.co.ducet", "standaard Unicode-sorteervolgorde" },
            { "type.co.emoji", "emojisorteervolgorde" },
            { "type.lb.loose", "losse stijl regelafbreking" },
            { "type.nu.roman", "Romeinse cijfers" },
            { "type.ca.coptic", "Koptische kalender" },
            { "type.ca.hebrew", "Hebreeuwse kalender" },
            { "type.ca.indian", "Indiase nationale kalender" },
            { "type.co.compat", "vorige sorteervolgorde, voor compatibiliteit" },
            { "type.co.pinyin", "Pinyinsorteervolgorde" },
            { "type.co.search", "algemeen zoeken" },
            { "type.co.stroke", "Streeksorteervolgorde" },
            { "type.co.unihan", "Sorteervolgorde radicalen/strepen" },
            { "type.co.zhuyin", "Zhuyinvolgorde" },
            { "type.d0.fwidth", "Volledige breedte" },
            { "type.d0.hwidth", "Halve breedte" },
            { "type.lb.normal", "normale stijl regelafbreking" },
            { "type.lb.strict", "strikte stijl regelafbreking" },
            { "type.m0.ungegn", "UNGEGN" },
            { "type.ms.metric", "metriek stelsel" },
            { "type.nu.native", "Binnenlandse cijfers" },
            { "type.ca.chinese", "Chinese kalender" },
            { "type.ca.islamic", "Islamitische kalender" },
            { "type.ca.iso8601", "ISO-8601-kalender" },
            { "type.ca.persian", "Perzische kalender" },
            { "type.cf.account", "financiële valutanotatie" },
            { "type.co.big5han", "Traditioneel-Chinese sorteervolgorde - Big5" },
            { "type.d0.npinyin", "Numeriek" },
            { "type.nu.arabext", "uitgebreide Arabisch-Indische cijfers" },
            { "type.nu.armnlow", "kleine Armeense cijfers" },
            { "type.nu.finance", "Financiële cijfers" },
            { "type.nu.greklow", "kleine Griekse cijfers" },
            { "type.nu.hanidec", "Chinese decimale getallen" },
            { "type.nu.hansfin", "vereenvoudigd Chinese financiële cijfers" },
            { "type.nu.hantfin", "traditioneel Chinese financiële cijfers" },
            { "type.nu.jpanfin", "Japanse financiële cijfers" },
            { "type.nu.mathdbl", "wiskundige cijfers met dubbele lijn" },
            { "type.nu.tamldec", "Tamil cijfers" },
            { "type.ca.buddhist", "Boeddhistische kalender" },
            { "type.ca.ethiopic", "Ethiopische kalender" },
            { "type.ca.japanese", "Japanse kalender" },
            { "type.cf.standard", "standaard valutanotatie" },
            { "type.co.phonetic", "Fonetische sorteervolgorde" },
            { "type.co.searchjl", "Zoeken op eerste Hangul-medeklinker" },
            { "type.co.standard", "standaard sorteervolgorde" },
            { "type.ms.uksystem", "Brits imperiaal stelsel" },
            { "type.ms.ussystem", "Amerikaans imperiaal stelsel" },
            { "type.nu.fullwide", "cijfers met volledige breedte" },
            { "type.nu.lanatham", "Tai Tham Tham cijfers" },
            { "type.nu.mathbold", "vette wiskundige cijfers" },
            { "type.nu.mathmono", "niet-proportionele wiskundige cijfers" },
            { "type.nu.mathsanb", "schreefloze vette wiskundige cijfers" },
            { "type.nu.mathsans", "schreefloze wiskundige cijfers" },
            { "type.nu.mymrshan", "Myanmarese Shan cijfers" },
            { "type.nu.mymrtlng", "Myanmar Tai Laing cijfers" },
            { "type.nu.romanlow", "kleine Romeinse cijfers" },
            { "type.ca.gregorian", "Gregoriaanse kalender" },
            { "type.co.gb2312han", "Vereenvoudigd-Chinese sorteervolgorde - GB2312" },
            { "type.co.phonebook", "Telefoonboeksorteervolgorde" },
            { "type.co.dictionary", "Woordenboeksorteervolgorde" },
            { "type.co.traditional", "Traditionele sorteervolgorde" },
            { "type.nu.traditional", "Traditionele cijfers" },
            { "type.ca.islamic-rgsa", "Islamitische kalender (Saudi–Arabië)" },
            { "type.ca.islamic-tbla", "Islamitische kalender (epoche)" },
            { "type.ca.islamic-civil", "Islamitische kalender (cyclisch)" },
            { "type.ca.islamic-umalqura", "Islamitische kalender (Umm al-Qura)" },
            { "type.ca.ethiopic-amete-alem", "Ethiopische Amete Alem-kalender" },
        };
        return data;
    }
}
