//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
#[cfg(feature = "objc2-core-foundation")]
use objc2_core_foundation::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsstreampropertykey?language=objc)
// NS_TYPED_EXTENSIBLE_ENUM
#[cfg(feature = "NSString")]
pub type NSStreamPropertyKey = NSString;

/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsstreamstatus?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSStreamStatus(pub NSUInteger);
impl NSStreamStatus {
    #[doc(alias = "NSStreamStatusNotOpen")]
    pub const NotOpen: Self = Self(0);
    #[doc(alias = "NSStreamStatusOpening")]
    pub const Opening: Self = Self(1);
    #[doc(alias = "NSStreamStatusOpen")]
    pub const Open: Self = Self(2);
    #[doc(alias = "NSStreamStatusReading")]
    pub const Reading: Self = Self(3);
    #[doc(alias = "NSStreamStatusWriting")]
    pub const Writing: Self = Self(4);
    #[doc(alias = "NSStreamStatusAtEnd")]
    pub const AtEnd: Self = Self(5);
    #[doc(alias = "NSStreamStatusClosed")]
    pub const Closed: Self = Self(6);
    #[doc(alias = "NSStreamStatusError")]
    pub const Error: Self = Self(7);
}

unsafe impl Encode for NSStreamStatus {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSStreamStatus {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsstreamevent?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSStreamEvent(pub NSUInteger);
bitflags::bitflags! {
    impl NSStreamEvent: NSUInteger {
        #[doc(alias = "NSStreamEventNone")]
        const None = 0;
        #[doc(alias = "NSStreamEventOpenCompleted")]
        const OpenCompleted = 1<<0;
        #[doc(alias = "NSStreamEventHasBytesAvailable")]
        const HasBytesAvailable = 1<<1;
        #[doc(alias = "NSStreamEventHasSpaceAvailable")]
        const HasSpaceAvailable = 1<<2;
        #[doc(alias = "NSStreamEventErrorOccurred")]
        const ErrorOccurred = 1<<3;
        #[doc(alias = "NSStreamEventEndEncountered")]
        const EndEncountered = 1<<4;
    }
}

unsafe impl Encode for NSStreamEvent {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSStreamEvent {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsstream?language=objc)
    #[unsafe(super(NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSStream;
);

extern_conformance!(
    unsafe impl NSObjectProtocol for NSStream {}
);

impl NSStream {
    extern_methods!(
        #[unsafe(method(open))]
        #[unsafe(method_family = none)]
        pub fn open(&self);

        #[unsafe(method(close))]
        #[unsafe(method_family = none)]
        pub fn close(&self);

        /// # Safety
        ///
        /// This is not retained internally, you must ensure the object is still alive.
        #[unsafe(method(delegate))]
        #[unsafe(method_family = none)]
        pub unsafe fn delegate(&self) -> Option<Retained<ProtocolObject<dyn NSStreamDelegate>>>;

        /// Setter for [`delegate`][Self::delegate].
        ///
        /// # Safety
        ///
        /// This is unretained, you must ensure the object is kept alive while in use.
        #[unsafe(method(setDelegate:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDelegate(&self, delegate: Option<&ProtocolObject<dyn NSStreamDelegate>>);

        #[cfg(feature = "NSString")]
        #[unsafe(method(propertyForKey:))]
        #[unsafe(method_family = none)]
        pub fn propertyForKey(&self, key: &NSStreamPropertyKey) -> Option<Retained<AnyObject>>;

        #[cfg(feature = "NSString")]
        /// # Safety
        ///
        /// `property` should be of the correct type.
        #[unsafe(method(setProperty:forKey:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setProperty_forKey(
            &self,
            property: Option<&AnyObject>,
            key: &NSStreamPropertyKey,
        ) -> bool;

        #[cfg(all(feature = "NSObjCRuntime", feature = "NSRunLoop", feature = "NSString"))]
        /// # Safety
        ///
        /// `a_run_loop` possibly has additional threading requirements.
        #[unsafe(method(scheduleInRunLoop:forMode:))]
        #[unsafe(method_family = none)]
        pub unsafe fn scheduleInRunLoop_forMode(
            &self,
            a_run_loop: &NSRunLoop,
            mode: &NSRunLoopMode,
        );

        #[cfg(all(feature = "NSObjCRuntime", feature = "NSRunLoop", feature = "NSString"))]
        /// # Safety
        ///
        /// `a_run_loop` possibly has additional threading requirements.
        #[unsafe(method(removeFromRunLoop:forMode:))]
        #[unsafe(method_family = none)]
        pub unsafe fn removeFromRunLoop_forMode(
            &self,
            a_run_loop: &NSRunLoop,
            mode: &NSRunLoopMode,
        );

        #[unsafe(method(streamStatus))]
        #[unsafe(method_family = none)]
        pub fn streamStatus(&self) -> NSStreamStatus;

        #[cfg(feature = "NSError")]
        #[unsafe(method(streamError))]
        #[unsafe(method_family = none)]
        pub fn streamError(&self) -> Option<Retained<NSError>>;
    );
}

/// Methods declared on superclass `NSObject`.
impl NSStream {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new() -> Retained<Self>;
    );
}

impl DefaultRetained for NSStream {
    #[inline]
    fn default_retained() -> Retained<Self> {
        Self::new()
    }
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsinputstream?language=objc)
    #[unsafe(super(NSStream, NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSInputStream;
);

#[cfg(feature = "objc2-core-foundation")]
impl AsRef<NSInputStream> for CFReadStream {
    #[inline]
    fn as_ref(&self) -> &NSInputStream {
        unsafe { &*((self as *const Self).cast()) }
    }
}

#[cfg(feature = "objc2-core-foundation")]
impl AsRef<CFReadStream> for NSInputStream {
    #[inline]
    fn as_ref(&self) -> &CFReadStream {
        unsafe { &*((self as *const Self).cast()) }
    }
}

extern_conformance!(
    unsafe impl NSObjectProtocol for NSInputStream {}
);

impl NSInputStream {
    extern_methods!(
        /// # Safety
        ///
        /// `buffer` must be a valid pointer.
        #[unsafe(method(read:maxLength:))]
        #[unsafe(method_family = none)]
        pub unsafe fn read_maxLength(&self, buffer: NonNull<u8>, len: NSUInteger) -> NSInteger;

        /// # Safety
        ///
        /// - `buffer` must be a valid pointer.
        /// - `len` must be a valid pointer.
        #[unsafe(method(getBuffer:length:))]
        #[unsafe(method_family = none)]
        pub unsafe fn getBuffer_length(
            &self,
            buffer: NonNull<*mut u8>,
            len: NonNull<NSUInteger>,
        ) -> bool;

        #[unsafe(method(hasBytesAvailable))]
        #[unsafe(method_family = none)]
        pub fn hasBytesAvailable(&self) -> bool;

        #[cfg(feature = "NSData")]
        #[unsafe(method(initWithData:))]
        #[unsafe(method_family = init)]
        pub fn initWithData(this: Allocated<Self>, data: &NSData) -> Retained<Self>;

        #[cfg(feature = "NSURL")]
        #[unsafe(method(initWithURL:))]
        #[unsafe(method_family = init)]
        pub fn initWithURL(this: Allocated<Self>, url: &NSURL) -> Option<Retained<Self>>;
    );
}

/// Methods declared on superclass `NSObject`.
impl NSInputStream {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new() -> Retained<Self>;
    );
}

impl DefaultRetained for NSInputStream {
    #[inline]
    fn default_retained() -> Retained<Self> {
        Self::new()
    }
}

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsoutputstream?language=objc)
    #[unsafe(super(NSStream, NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct NSOutputStream;
);

#[cfg(feature = "objc2-core-foundation")]
impl AsRef<NSOutputStream> for CFWriteStream {
    #[inline]
    fn as_ref(&self) -> &NSOutputStream {
        unsafe { &*((self as *const Self).cast()) }
    }
}

#[cfg(feature = "objc2-core-foundation")]
impl AsRef<CFWriteStream> for NSOutputStream {
    #[inline]
    fn as_ref(&self) -> &CFWriteStream {
        unsafe { &*((self as *const Self).cast()) }
    }
}

extern_conformance!(
    unsafe impl NSObjectProtocol for NSOutputStream {}
);

impl NSOutputStream {
    extern_methods!(
        /// # Safety
        ///
        /// `buffer` must be a valid pointer.
        #[unsafe(method(write:maxLength:))]
        #[unsafe(method_family = none)]
        pub unsafe fn write_maxLength(&self, buffer: NonNull<u8>, len: NSUInteger) -> NSInteger;

        #[unsafe(method(hasSpaceAvailable))]
        #[unsafe(method_family = none)]
        pub fn hasSpaceAvailable(&self) -> bool;

        #[unsafe(method(initToMemory))]
        #[unsafe(method_family = init)]
        pub fn initToMemory(this: Allocated<Self>) -> Retained<Self>;

        /// # Safety
        ///
        /// `buffer` must be a valid pointer.
        #[unsafe(method(initToBuffer:capacity:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initToBuffer_capacity(
            this: Allocated<Self>,
            buffer: NonNull<u8>,
            capacity: NSUInteger,
        ) -> Retained<Self>;

        #[cfg(feature = "NSURL")]
        #[unsafe(method(initWithURL:append:))]
        #[unsafe(method_family = init)]
        pub fn initWithURL_append(
            this: Allocated<Self>,
            url: &NSURL,
            should_append: bool,
        ) -> Option<Retained<Self>>;
    );
}

/// Methods declared on superclass `NSObject`.
impl NSOutputStream {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub fn init(this: Allocated<Self>) -> Retained<Self>;

        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub fn new() -> Retained<Self>;
    );
}

impl DefaultRetained for NSOutputStream {
    #[inline]
    fn default_retained() -> Retained<Self> {
        Self::new()
    }
}

/// NSSocketStreamCreationExtensions.
impl NSStream {
    extern_methods!(
        #[cfg(feature = "NSString")]
        #[deprecated = "Use nw_connection_t in Network framework instead"]
        #[unsafe(method(getStreamsToHostWithName:port:inputStream:outputStream:))]
        #[unsafe(method_family = none)]
        pub fn getStreamsToHostWithName_port_inputStream_outputStream(
            hostname: &NSString,
            port: NSInteger,
            input_stream: Option<&mut Option<Retained<NSInputStream>>>,
            output_stream: Option<&mut Option<Retained<NSOutputStream>>>,
        );

        #[cfg(feature = "NSHost")]
        #[deprecated = "Use nw_connection_t in Network framework instead"]
        #[unsafe(method(getStreamsToHost:port:inputStream:outputStream:))]
        #[unsafe(method_family = none)]
        pub fn getStreamsToHost_port_inputStream_outputStream(
            host: &NSHost,
            port: NSInteger,
            input_stream: Option<&mut Option<Retained<NSInputStream>>>,
            output_stream: Option<&mut Option<Retained<NSOutputStream>>>,
        );
    );
}

/// NSStreamBoundPairCreationExtensions.
impl NSStream {
    extern_methods!(
        #[unsafe(method(getBoundStreamsWithBufferSize:inputStream:outputStream:))]
        #[unsafe(method_family = none)]
        pub fn getBoundStreamsWithBufferSize_inputStream_outputStream(
            buffer_size: NSUInteger,
            input_stream: Option<&mut Option<Retained<NSInputStream>>>,
            output_stream: Option<&mut Option<Retained<NSOutputStream>>>,
        );
    );
}

/// NSInputStreamExtensions.
impl NSInputStream {
    extern_methods!(
        #[cfg(feature = "NSString")]
        #[unsafe(method(initWithFileAtPath:))]
        #[unsafe(method_family = init)]
        pub fn initWithFileAtPath(this: Allocated<Self>, path: &NSString)
            -> Option<Retained<Self>>;

        #[cfg(feature = "NSData")]
        #[unsafe(method(inputStreamWithData:))]
        #[unsafe(method_family = none)]
        pub fn inputStreamWithData(data: &NSData) -> Option<Retained<Self>>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(inputStreamWithFileAtPath:))]
        #[unsafe(method_family = none)]
        pub fn inputStreamWithFileAtPath(path: &NSString) -> Option<Retained<Self>>;

        #[cfg(feature = "NSURL")]
        #[unsafe(method(inputStreamWithURL:))]
        #[unsafe(method_family = none)]
        pub fn inputStreamWithURL(url: &NSURL) -> Option<Retained<Self>>;
    );
}

/// NSOutputStreamExtensions.
impl NSOutputStream {
    extern_methods!(
        #[cfg(feature = "NSString")]
        #[unsafe(method(initToFileAtPath:append:))]
        #[unsafe(method_family = init)]
        pub fn initToFileAtPath_append(
            this: Allocated<Self>,
            path: &NSString,
            should_append: bool,
        ) -> Option<Retained<Self>>;

        #[unsafe(method(outputStreamToMemory))]
        #[unsafe(method_family = none)]
        pub fn outputStreamToMemory() -> Retained<Self>;

        /// # Safety
        ///
        /// `buffer` must be a valid pointer.
        #[unsafe(method(outputStreamToBuffer:capacity:))]
        #[unsafe(method_family = none)]
        pub unsafe fn outputStreamToBuffer_capacity(
            buffer: NonNull<u8>,
            capacity: NSUInteger,
        ) -> Retained<Self>;

        #[cfg(feature = "NSString")]
        #[unsafe(method(outputStreamToFileAtPath:append:))]
        #[unsafe(method_family = none)]
        pub fn outputStreamToFileAtPath_append(
            path: &NSString,
            should_append: bool,
        ) -> Retained<Self>;

        #[cfg(feature = "NSURL")]
        #[unsafe(method(outputStreamWithURL:append:))]
        #[unsafe(method_family = none)]
        pub fn outputStreamWithURL_append(
            url: &NSURL,
            should_append: bool,
        ) -> Option<Retained<Self>>;
    );
}

extern_protocol!(
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsstreamdelegate?language=objc)
    pub unsafe trait NSStreamDelegate: NSObjectProtocol {
        #[optional]
        #[unsafe(method(stream:handleEvent:))]
        #[unsafe(method_family = none)]
        fn stream_handleEvent(&self, a_stream: &NSStream, event_code: NSStreamEvent);
    }
);

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsstreamsocketsecuritylevelkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSStreamSocketSecurityLevelKey: &'static NSStreamPropertyKey;
}

/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsstreamsocketsecuritylevel?language=objc)
// NS_TYPED_ENUM
#[cfg(feature = "NSString")]
pub type NSStreamSocketSecurityLevel = NSString;

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsstreamsocketsecuritylevelnone?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSStreamSocketSecurityLevelNone: &'static NSStreamSocketSecurityLevel;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsstreamsocketsecuritylevelsslv2?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSStreamSocketSecurityLevelSSLv2: &'static NSStreamSocketSecurityLevel;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsstreamsocketsecuritylevelsslv3?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSStreamSocketSecurityLevelSSLv3: &'static NSStreamSocketSecurityLevel;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsstreamsocketsecurityleveltlsv1?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSStreamSocketSecurityLevelTLSv1: &'static NSStreamSocketSecurityLevel;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsstreamsocketsecuritylevelnegotiatedssl?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSStreamSocketSecurityLevelNegotiatedSSL: &'static NSStreamSocketSecurityLevel;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsstreamsocksproxyconfigurationkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSStreamSOCKSProxyConfigurationKey: &'static NSStreamPropertyKey;
}

/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsstreamsocksproxyconfiguration?language=objc)
// NS_TYPED_ENUM
#[cfg(feature = "NSString")]
pub type NSStreamSOCKSProxyConfiguration = NSString;

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsstreamsocksproxyhostkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSStreamSOCKSProxyHostKey: &'static NSStreamSOCKSProxyConfiguration;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsstreamsocksproxyportkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSStreamSOCKSProxyPortKey: &'static NSStreamSOCKSProxyConfiguration;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsstreamsocksproxyversionkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSStreamSOCKSProxyVersionKey: &'static NSStreamSOCKSProxyConfiguration;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsstreamsocksproxyuserkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSStreamSOCKSProxyUserKey: &'static NSStreamSOCKSProxyConfiguration;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsstreamsocksproxypasswordkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSStreamSOCKSProxyPasswordKey: &'static NSStreamSOCKSProxyConfiguration;
}

/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsstreamsocksproxyversion?language=objc)
// NS_TYPED_ENUM
#[cfg(feature = "NSString")]
pub type NSStreamSOCKSProxyVersion = NSString;

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsstreamsocksproxyversion4?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSStreamSOCKSProxyVersion4: &'static NSStreamSOCKSProxyVersion;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsstreamsocksproxyversion5?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSStreamSOCKSProxyVersion5: &'static NSStreamSOCKSProxyVersion;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsstreamdatawrittentomemorystreamkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSStreamDataWrittenToMemoryStreamKey: &'static NSStreamPropertyKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsstreamfilecurrentoffsetkey?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSStreamFileCurrentOffsetKey: &'static NSStreamPropertyKey;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsstreamsocketsslerrordomain?language=objc)
    #[cfg(all(feature = "NSError", feature = "NSString"))]
    pub static NSStreamSocketSSLErrorDomain: &'static NSErrorDomain;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsstreamsockserrordomain?language=objc)
    #[cfg(all(feature = "NSError", feature = "NSString"))]
    pub static NSStreamSOCKSErrorDomain: &'static NSErrorDomain;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsstreamnetworkservicetype?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSStreamNetworkServiceType: &'static NSStreamPropertyKey;
}

/// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsstreamnetworkservicetypevalue?language=objc)
// NS_TYPED_ENUM
#[cfg(feature = "NSString")]
pub type NSStreamNetworkServiceTypeValue = NSString;

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsstreamnetworkservicetypevoip?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSStreamNetworkServiceTypeVoIP: &'static NSStreamNetworkServiceTypeValue;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsstreamnetworkservicetypevideo?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSStreamNetworkServiceTypeVideo: &'static NSStreamNetworkServiceTypeValue;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsstreamnetworkservicetypebackground?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSStreamNetworkServiceTypeBackground: &'static NSStreamNetworkServiceTypeValue;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsstreamnetworkservicetypevoice?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSStreamNetworkServiceTypeVoice: &'static NSStreamNetworkServiceTypeValue;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/foundation/nsstreamnetworkservicetypecallsignaling?language=objc)
    #[cfg(feature = "NSString")]
    pub static NSStreamNetworkServiceTypeCallSignaling: &'static NSStreamNetworkServiceTypeValue;
}
