// Package serviceworker provides the Chrome DevTools Protocol
// commands, types, and events for the ServiceWorker domain.
//
// Generated by the cdproto-gen command.
package serviceworker

// Code generated by cdproto-gen. DO NOT EDIT.

import (
	"context"

	"github.com/chromedp/cdproto/cdp"
)

// DeliverPushMessageParams [no description].
type DeliverPushMessageParams struct {
	Origin         string         `json:"origin"`
	RegistrationID RegistrationID `json:"registrationId"`
	Data           string         `json:"data"`
}

// DeliverPushMessage [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/ServiceWorker#method-deliverPushMessage
//
// parameters:
//
//	origin
//	registrationID
//	data
func DeliverPushMessage(origin string, registrationID RegistrationID, data string) *DeliverPushMessageParams {
	return &DeliverPushMessageParams{
		Origin:         origin,
		RegistrationID: registrationID,
		Data:           data,
	}
}

// Do executes ServiceWorker.deliverPushMessage against the provided context.
func (p *DeliverPushMessageParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandDeliverPushMessage, p, nil)
}

// DisableParams [no description].
type DisableParams struct{}

// Disable [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/ServiceWorker#method-disable
func Disable() *DisableParams {
	return &DisableParams{}
}

// Do executes ServiceWorker.disable against the provided context.
func (p *DisableParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandDisable, nil, nil)
}

// DispatchSyncEventParams [no description].
type DispatchSyncEventParams struct {
	Origin         string         `json:"origin"`
	RegistrationID RegistrationID `json:"registrationId"`
	Tag            string         `json:"tag"`
	LastChance     bool           `json:"lastChance"`
}

// DispatchSyncEvent [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/ServiceWorker#method-dispatchSyncEvent
//
// parameters:
//
//	origin
//	registrationID
//	tag
//	lastChance
func DispatchSyncEvent(origin string, registrationID RegistrationID, tag string, lastChance bool) *DispatchSyncEventParams {
	return &DispatchSyncEventParams{
		Origin:         origin,
		RegistrationID: registrationID,
		Tag:            tag,
		LastChance:     lastChance,
	}
}

// Do executes ServiceWorker.dispatchSyncEvent against the provided context.
func (p *DispatchSyncEventParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandDispatchSyncEvent, p, nil)
}

// DispatchPeriodicSyncEventParams [no description].
type DispatchPeriodicSyncEventParams struct {
	Origin         string         `json:"origin"`
	RegistrationID RegistrationID `json:"registrationId"`
	Tag            string         `json:"tag"`
}

// DispatchPeriodicSyncEvent [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/ServiceWorker#method-dispatchPeriodicSyncEvent
//
// parameters:
//
//	origin
//	registrationID
//	tag
func DispatchPeriodicSyncEvent(origin string, registrationID RegistrationID, tag string) *DispatchPeriodicSyncEventParams {
	return &DispatchPeriodicSyncEventParams{
		Origin:         origin,
		RegistrationID: registrationID,
		Tag:            tag,
	}
}

// Do executes ServiceWorker.dispatchPeriodicSyncEvent against the provided context.
func (p *DispatchPeriodicSyncEventParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandDispatchPeriodicSyncEvent, p, nil)
}

// EnableParams [no description].
type EnableParams struct{}

// Enable [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/ServiceWorker#method-enable
func Enable() *EnableParams {
	return &EnableParams{}
}

// Do executes ServiceWorker.enable against the provided context.
func (p *EnableParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandEnable, nil, nil)
}

// SetForceUpdateOnPageLoadParams [no description].
type SetForceUpdateOnPageLoadParams struct {
	ForceUpdateOnPageLoad bool `json:"forceUpdateOnPageLoad"`
}

// SetForceUpdateOnPageLoad [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/ServiceWorker#method-setForceUpdateOnPageLoad
//
// parameters:
//
//	forceUpdateOnPageLoad
func SetForceUpdateOnPageLoad(forceUpdateOnPageLoad bool) *SetForceUpdateOnPageLoadParams {
	return &SetForceUpdateOnPageLoadParams{
		ForceUpdateOnPageLoad: forceUpdateOnPageLoad,
	}
}

// Do executes ServiceWorker.setForceUpdateOnPageLoad against the provided context.
func (p *SetForceUpdateOnPageLoadParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandSetForceUpdateOnPageLoad, p, nil)
}

// SkipWaitingParams [no description].
type SkipWaitingParams struct {
	ScopeURL string `json:"scopeURL"`
}

// SkipWaiting [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/ServiceWorker#method-skipWaiting
//
// parameters:
//
//	scopeURL
func SkipWaiting(scopeURL string) *SkipWaitingParams {
	return &SkipWaitingParams{
		ScopeURL: scopeURL,
	}
}

// Do executes ServiceWorker.skipWaiting against the provided context.
func (p *SkipWaitingParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandSkipWaiting, p, nil)
}

// StartWorkerParams [no description].
type StartWorkerParams struct {
	ScopeURL string `json:"scopeURL"`
}

// StartWorker [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/ServiceWorker#method-startWorker
//
// parameters:
//
//	scopeURL
func StartWorker(scopeURL string) *StartWorkerParams {
	return &StartWorkerParams{
		ScopeURL: scopeURL,
	}
}

// Do executes ServiceWorker.startWorker against the provided context.
func (p *StartWorkerParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandStartWorker, p, nil)
}

// StopAllWorkersParams [no description].
type StopAllWorkersParams struct{}

// StopAllWorkers [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/ServiceWorker#method-stopAllWorkers
func StopAllWorkers() *StopAllWorkersParams {
	return &StopAllWorkersParams{}
}

// Do executes ServiceWorker.stopAllWorkers against the provided context.
func (p *StopAllWorkersParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandStopAllWorkers, nil, nil)
}

// StopWorkerParams [no description].
type StopWorkerParams struct {
	VersionID string `json:"versionId"`
}

// StopWorker [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/ServiceWorker#method-stopWorker
//
// parameters:
//
//	versionID
func StopWorker(versionID string) *StopWorkerParams {
	return &StopWorkerParams{
		VersionID: versionID,
	}
}

// Do executes ServiceWorker.stopWorker against the provided context.
func (p *StopWorkerParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandStopWorker, p, nil)
}

// UnregisterParams [no description].
type UnregisterParams struct {
	ScopeURL string `json:"scopeURL"`
}

// Unregister [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/ServiceWorker#method-unregister
//
// parameters:
//
//	scopeURL
func Unregister(scopeURL string) *UnregisterParams {
	return &UnregisterParams{
		ScopeURL: scopeURL,
	}
}

// Do executes ServiceWorker.unregister against the provided context.
func (p *UnregisterParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandUnregister, p, nil)
}

// UpdateRegistrationParams [no description].
type UpdateRegistrationParams struct {
	ScopeURL string `json:"scopeURL"`
}

// UpdateRegistration [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/ServiceWorker#method-updateRegistration
//
// parameters:
//
//	scopeURL
func UpdateRegistration(scopeURL string) *UpdateRegistrationParams {
	return &UpdateRegistrationParams{
		ScopeURL: scopeURL,
	}
}

// Do executes ServiceWorker.updateRegistration against the provided context.
func (p *UpdateRegistrationParams) Do(ctx context.Context) (err error) {
	return cdp.Execute(ctx, CommandUpdateRegistration, p, nil)
}

// Command names.
const (
	CommandDeliverPushMessage        = "ServiceWorker.deliverPushMessage"
	CommandDisable                   = "ServiceWorker.disable"
	CommandDispatchSyncEvent         = "ServiceWorker.dispatchSyncEvent"
	CommandDispatchPeriodicSyncEvent = "ServiceWorker.dispatchPeriodicSyncEvent"
	CommandEnable                    = "ServiceWorker.enable"
	CommandSetForceUpdateOnPageLoad  = "ServiceWorker.setForceUpdateOnPageLoad"
	CommandSkipWaiting               = "ServiceWorker.skipWaiting"
	CommandStartWorker               = "ServiceWorker.startWorker"
	CommandStopAllWorkers            = "ServiceWorker.stopAllWorkers"
	CommandStopWorker                = "ServiceWorker.stopWorker"
	CommandUnregister                = "ServiceWorker.unregister"
	CommandUpdateRegistration        = "ServiceWorker.updateRegistration"
)
