/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1alpha1

// StorageVersionMigrationStatusApplyConfiguration represents a declarative configuration of the StorageVersionMigrationStatus type for use
// with apply.
type StorageVersionMigrationStatusApplyConfiguration struct {
	Conditions      []MigrationConditionApplyConfiguration `json:"conditions,omitempty"`
	ResourceVersion *string                                `json:"resourceVersion,omitempty"`
}

// StorageVersionMigrationStatusApplyConfiguration constructs a declarative configuration of the StorageVersionMigrationStatus type for use with
// apply.
func StorageVersionMigrationStatus() *StorageVersionMigrationStatusApplyConfiguration {
	return &StorageVersionMigrationStatusApplyConfiguration{}
}

// WithConditions adds the given value to the Conditions field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Conditions field.
func (b *StorageVersionMigrationStatusApplyConfiguration) WithConditions(values ...*MigrationConditionApplyConfiguration) *StorageVersionMigrationStatusApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithConditions")
		}
		b.Conditions = append(b.Conditions, *values[i])
	}
	return b
}

// WithResourceVersion sets the ResourceVersion field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ResourceVersion field is set to the value of the last call.
func (b *StorageVersionMigrationStatusApplyConfiguration) WithResourceVersion(value string) *StorageVersionMigrationStatusApplyConfiguration {
	b.ResourceVersion = &value
	return b
}
