---
title: matryer
---

`matryer` mocks are derived from the project at https://github.com/matryer/moq. These mocks create a struct that has a function field for each method, which you can declare in your test code.

## Description

=== "Interface"

    ```go
    package test

    type Requester interface {
        Get(path string) (string, error)
    }
    ```


=== "Example Usage"

    ```go
    func TestRequesterMoq(t *testing.T) {
        m := &MoqRequester{
            GetFunc: func(path string) (string, error) {
                fmt.Printf("Go path: %s\n", path)
                return path + "/foo", nil
            },
        }
        result, err := m.Get("/path")
        assert.NoError(t, err)
        assert.Equal(t, "/path/foo", result)
    }
    ```

=== "`.mockery.yml`"

    ```yaml
    template: matryer
    packages:
        github.com/vektra/mockery/v3/pkg/fixtures:
            config:
                dir: "{{.InterfaceDir}}"
                filename: "mocks_moq.go"
                pkgname: "test"
                structname: "Moq{{.InterfaceName}}"
            interfaces:
                Requester:
    ```

=== "`mocks_matryer.go`"

    ```go
    // Code generated by mockery; DO NOT EDIT.
    // github.com/vektra/mockery

    package test

    import (
        "sync"
    )

    // Ensure, that MoqRequester does implement Requester.
    // If this is not the case, regenerate this file with moq.
    var _ Requester = &MoqRequester{}

    // MoqRequester is a mock implementation of Requester.
    //
    //	func TestSomethingThatUsesRequester(t *testing.T) {
    //
    //		// make and configure a mocked Requester
    //		mockedRequester := &MoqRequester{
    //			GetFunc: func(path string) (string, error) {
    //				panic("mock out the Get method")
    //			},
    //		}
    //
    //		// use mockedRequester in code that requires Requester
    //		// and then make assertions.
    //
    //	}
    type MoqRequester struct {
        // GetFunc mocks the Get method.
        GetFunc func(path string) (string, error)

        // calls tracks calls to the methods.
        calls struct {
            // Get holds details about calls to the Get method.
            Get []struct {
                // Path is the path argument value.
                Path string
            }
        }
        lockGet sync.RWMutex
    }

    // Get calls GetFunc.
    func (mock *MoqRequester) Get(path string) (string, error) {
       // ...
    }

    // GetCalls gets all the calls that were made to Get.
    // Check the length with:
    //
    //	len(mockedRequester.GetCalls())
    func (mock *MoqRequester) GetCalls() []struct {
        Path string
    } {
        // ...
    }

    ```


matryer-style mocks are far simpler, and probably more intuitive, than testify-style mocks. All that's needed is to define the function that will be run when the mock's method is called.

## `template-data`

`moq` accepts the following `#!yaml template-data:` keys:

| key | type | description |
|-----|------|-------------|
| `boilerplate-file`  | `#!yaml string` | Specify a path to a file that contains comments you want displayed at the top of all generated mock files. This is commonly used to display license headers at the top of your source code. |
| `mock-build-tags` | `#!yaml string` | Set the build tags of the generated mocks. Read more about the [format](https://pkg.go.dev/cmd/go#hdr-Build_constraints). |
| `skip-ensure` | `#!yaml bool` | Suppress mock implementation check, avoid import cycle if mocks generated outside of the tested package. |
| `stub-impl` | `#!yaml bool` | Return zero values when no mock implementation is provided, do not panic. |
| `with-resets` | `#!yaml bool` | Generates methods that allow resetting calls made to the mocks. |


### Schema

```json
--8<-- "internal/mock_matryer.templ.schema.json"
```